/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contractlock.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.FileRpcService;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.SaleContractHeadDTO;
import com.els.modules.contract.enumerate.ContractStatusEnum;
import com.els.modules.contractlock.entity.ElsClSignContract;
import com.els.modules.contractlock.entity.ElsClSigners;
import com.els.modules.contractlock.enumerate.CLBusTypeEnum;
import com.els.modules.contractlock.enumerate.CLConstant;
import com.els.modules.contractlock.enumerate.CLContractStatusEnum;
import com.els.modules.contractlock.enumerate.CLFirstSealEnum;
import com.els.modules.contractlock.enumerate.CLSignTypeEnum;
import com.els.modules.contractlock.enumerate.ClContractSignStatusEmun;
import com.els.modules.contractlock.enumerate.ClSignerStatusEmun;
import com.els.modules.contractlock.mapper.ElsClContractMapper;
import com.els.modules.contractlock.service.ElsClContractService;
import com.els.modules.contractlock.service.ElsClSignersService;
import com.els.modules.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.contractlock.vo.ClCallback;
import com.els.modules.contractlock.vo.ClContractVO;
import com.els.modules.contractlock.vo.ClCreateContractVO;
import com.els.modules.contractlock.vo.ClDocumentContractVO;
import com.els.modules.esign.enumerate.EsignStatusEmun;
import com.els.modules.esign.enumerate.SignerVindicateStatusEnum;
import com.els.modules.esign.rpc.service.EsignInvokeContractRpcService;
import com.els.modules.esign.rpc.service.EsignInvokeOrderRpcService;
import com.els.modules.esign.service.EsignOperationService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.enumerate.EsignFinalStatusEnum;
import com.els.modules.order.api.enumerate.OrderEsignStatusEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsClContractServiceImpl
extends BaseServiceImpl<ElsClContractMapper, ElsClSignContract>
implements ElsClContractService {
    private static final Logger log = LoggerFactory.getLogger(ElsClContractServiceImpl.class);
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private ElsClSignersService elsClSignersService;
    @Autowired
    private EsignOperationService operationService;
    @Autowired
    private FileRpcService fileRpcService;
    private static final String BIZ_PATH = "files";
    private static final String STR_FORMAT = "yyyyMMdd";
    @Autowired
    private EsignInvokeContractRpcService contractRpcService;
    @Autowired
    private EsignInvokeOrderRpcService orderRpcService;

    @Override
    public void add(ElsClSignContract elsClSignContract) {
        this.insert(elsClSignContract);
    }

    private void insert(ElsClSignContract elsClSignContract) {
        elsClSignContract.setCreateTime(new Date());
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        elsClSignContract.setCreateBy(currentUser);
        elsClSignContract.setElsAccount(TenantContext.getTenant());
        elsClSignContract.setSignStatus("0");
        elsClSignContract.setPurchaseSignStatus(ClSignerStatusEmun.NO_SIGNERS_SET.getValue());
        elsClSignContract.setSaleSignStatus(ClSignerStatusEmun.NO_SIGNERS_SET.getValue());
        elsClSignContract.setBusAccount("100000");
        elsClSignContract.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
        this.handleBusType(elsClSignContract, CLBusTypeEnum.ADD);
        ((ElsClContractMapper)this.baseMapper).insert((Object)elsClSignContract);
    }

    private void handleContractStatus(ElsClSignContract elsClSignContract, CLBusTypeEnum type) {
        PurchaseContractHeadDTO contractHead = this.contractRpcService.getPurchaseContractById(elsClSignContract.getRelationId());
        if (contractHead != null) {
            if ("1".equals(contractHead.getStartSign()) && CLBusTypeEnum.isAdd(type)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            if (CLBusTypeEnum.isAdd(type)) {
                contractHead.setStartSign("1");
                contractHead.setSignType("contractLock");
            }
            if (CLBusTypeEnum.isFINISH(type)) {
                contractHead.setContractStatus(ContractStatusEnum.ARCHIVED.getValue());
                contractHead.setEndSign(elsClSignContract.getSignStatus());
            }
            if (CLBusTypeEnum.isReturn(type)) {
                contractHead.setStartSign("0");
            }
            if (CLBusTypeEnum.isRevoke(type)) {
                contractHead.setEndSign(elsClSignContract.getSignStatus());
            }
            this.contractRpcService.updatePurchaseEntityById(contractHead);
            SaleContractHeadDTO saleContractHead = this.contractRpcService.getSaleContractById(contractHead.getRelationId());
            if (saleContractHead != null) {
                if (CLBusTypeEnum.isAdd(type)) {
                    saleContractHead.setStartSign("1");
                }
                if (CLBusTypeEnum.isFINISH(type)) {
                    saleContractHead.setContractStatus(contractHead.getContractStatus());
                    saleContractHead.setEndSign(contractHead.getEndSign());
                }
                if (CLBusTypeEnum.isReturn(type)) {
                    saleContractHead.setEndSign(contractHead.getEndSign());
                }
                this.contractRpcService.updateSaleEntityById(saleContractHead);
            }
        }
    }

    private void handleOrderStatus(ElsClSignContract elsClSignContract, CLBusTypeEnum type) {
        PurchaseOrderHeadDTO purchaseOrderHeadDTO = this.orderRpcService.getPurchaseOrderById(elsClSignContract.getRelationId());
        if (purchaseOrderHeadDTO != null) {
            if (CLBusTypeEnum.isAdd(type) && (OrderEsignStatusEnum.START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus()) || OrderEsignStatusEnum.CHANGED_START_END.getValue().equals(purchaseOrderHeadDTO.getEsignStartStatus()))) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rtFIhARPWWqKCJPeWQLhARvsmA_dae99d52", (String)"\u8be5\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u7535\u5b50\u7b7e\u7ae0-\u6d41\u7a0b\u53d1\u8d77\u7ba1\u7406\u4e2d\u67e5\u770b"));
            }
            if (CLBusTypeEnum.isAdd(type)) {
                purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.START_END.getValue() : OrderEsignStatusEnum.CHANGED_START_END.getValue());
                purchaseOrderHeadDTO.setSignType("contractLock");
            }
            if (CLBusTypeEnum.isReturn(type)) {
                purchaseOrderHeadDTO.setEsignStartStatus("1".equals(purchaseOrderHeadDTO.getOrderVersion()) ? OrderEsignStatusEnum.NO_START.getValue() : OrderEsignStatusEnum.CHANGED_NO_START.getValue());
            }
        }
        if (CLBusTypeEnum.isFINISH(type)) {
            purchaseOrderHeadDTO.setEsignFinalStatus(EsignFinalStatusEnum.FINAL.getValue());
            this.orderRpcService.updateSaleOrderByRelationId(purchaseOrderHeadDTO);
        }
        this.orderRpcService.updatePurchaseOrderById(purchaseOrderHeadDTO);
    }

    private void handleBusType(ElsClSignContract elsClSignContract, CLBusTypeEnum type) {
        switch (elsClSignContract.getBusType()) {
            case "contract": {
                this.handleContractStatus(elsClSignContract, type);
                break;
            }
            case "order": {
                this.handleOrderStatus(elsClSignContract, type);
                break;
            }
        }
    }

    @Override
    public void edit(ElsClSignContract elsClSignContract) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        elsClSignContract.setUpdateBy(currentUser);
        elsClSignContract.setUpdateTime(new Date());
        int count = ((ElsClContractMapper)this.baseMapper).updateById((Object)elsClSignContract);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsClContractMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsClContractMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void saveMain(ClContractVO req) {
        this.insert(req);
        List<ElsClSigners> signers = req.getSigners();
        if (CollUtil.isNotEmpty(signers)) {
            this.initSigner(signers, req);
            this.elsClSignersService.saveBatch(signers);
            req.setSigners(signers);
        }
    }

    @Override
    public void editMain(ClContractVO req) {
        if (CollUtil.isNotEmpty(req.getPurchaseSigners())) {
            req.setSignerVindicateStatus(SignerVindicateStatusEnum.SALE_NO_MAINTENANCE.getValue());
        }
        if (CollUtil.isNotEmpty(req.getSaleSigners())) {
            req.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
        }
        this.edit(req);
        if (CollUtil.isNotEmpty(req.getPurchaseSigners()) || CollUtil.isNotEmpty(req.getSaleSigners())) {
            List<ElsClSigners> signers = this.initUpdateSigner(req.getPurchaseSigners(), req.getSaleSigners(), req);
            this.elsClSignersService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsClSigners::getHeadId, (Object)req.getId())).notIn(BaseEntity::getId, (Collection)signers.stream().map(x -> x.getId()).collect(Collectors.toList())));
            ArrayList inserts = Lists.newArrayList();
            ArrayList updates = Lists.newArrayList();
            signers.forEach(x -> {
                if (StrUtil.isNotBlank((CharSequence)x.getId())) {
                    updates.add(x);
                } else {
                    x.setCreateTime(new Date());
                    LoginUser sysUser = SysUtil.getLoginUser();
                    String currentUser = sysUser.getSubAccount();
                    x.setCreateBy(currentUser);
                    x.setElsAccount(TenantContext.getTenant());
                    x.setSignStatus("0");
                    x.setBusAccount("100000");
                    inserts.add(x);
                }
            });
            if (CollUtil.isNotEmpty((Collection)inserts)) {
                this.elsClSignersService.saveBatch(inserts);
            }
            if (CollUtil.isNotEmpty((Collection)updates)) {
                this.elsClSignersService.updateBatchById(updates);
            }
        }
    }

    @Override
    public ClContractVO createDraft(String id) {
        ClContractVO dbVo = this.getMainById(id);
        dbVo.setCompanyId(dbVo.getPurchaseSigners().get(0).getCompanyId());
        ClCreateContractVO createParams = this.buildCreateDraftParams(dbVo);
        Result<?> response = this.getIPassResponse(createParams, "create-contract-draft");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            dbVo.setContractId(jsonObject.getString("id"));
            dbVo.setContractStatus(jsonObject.getString("status"));
            JSONArray jsonArray = jsonObject.getJSONArray("signatories");
            List result = jsonArray.toJavaList(ClCreateContractVO.Signatories.class);
            List<ElsClSigners> dbSigners = dbVo.getSigners();
            Map<Integer, ElsClSigners> signatoriesMap = dbSigners.stream().collect(Collectors.toMap(x -> x.getSerialNo(), y -> y));
            ArrayList updateSigners = Lists.newArrayList();
            result.forEach(x -> {
                ElsClSigners elsClSigners = (ElsClSigners)((Object)((Object)signatoriesMap.get(x.getSerialNo())));
                elsClSigners.setSignatoryId(x.getId());
                elsClSigners.setSignStatus(x.getStatus());
                updateSigners.add(elsClSigners);
            });
            this.elsClSignersService.updateBatchById(updateSigners);
            dbVo.setContractStatus(CLContractStatusEnum.DRAFT.getValue());
            dbVo.setUploaded("0");
            this.edit(dbVo);
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
        return null;
    }

    private ClCreateContractVO buildCreateDraftParams(ClContractVO db) {
        ClCreateContractVO req = new ClCreateContractVO();
        req.setCompanyId(db.getCompanyId());
        req.setCallBackUrl(this.address + "/els/contractLock/elsClContract/noToken/callback/contract");
        ClCreateContractVO.Receiver create = new ClCreateContractVO.Receiver();
        create.setContact(db.getCreateContact());
        create.setContactType(db.getCreateContactType());
        req.getBody().setSubject(db.getSubject());
        ArrayList signatories = Lists.newArrayList();
        List<ElsClSigners> dbSigners = db.getSigners();
        Assert.isTrue((boolean)CollUtil.isNotEmpty(dbSigners), (String)I18nUtil.translate((String)"i18n_alert_PWLxOLV_9c982296", (String)"\u7b7e\u7f72\u4eba\u4e0d\u80fd\u4e3a\u7a7a"));
        dbSigners.forEach(row -> {
            ClCreateContractVO.Signatories toParams = new ClCreateContractVO.Signatories();
            toParams.setTenantType(row.getTenantType());
            ClCreateContractVO.Receiver receiver = new ClCreateContractVO.Receiver();
            receiver.setContact(row.getSignatoryContact());
            receiver.setContactType(row.getSignatoryContactType());
            toParams.setSerialNo(row.getSerialNo());
            if (CLSignTypeEnum.COMPANY.getValue().equals(row.getTenantType())) {
                toParams.setTenantName(row.getCompanyName());
                toParams.setReceiver(receiver);
            } else {
                toParams.setTenantName(row.getSignatoryName());
                toParams.setReceiver(receiver);
            }
            ClCreateContractVO.Actions actions = new ClCreateContractVO.Actions();
            actions.setType(row.getTenantType());
            actions.setSealId(row.getSealId());
            if (StrUtil.isNotBlank((CharSequence)row.getSealIds())) {
                List<String> seals = Arrays.asList(row.getSealIds().split(","));
                actions.setSealIds(seals.stream().map(x -> Long.valueOf(x)).distinct().collect(Collectors.toList()));
            }
            if (db.getCompanyId().equals(row.getCompanyId())) {
                actions.setOperators(Arrays.asList(receiver));
            }
            toParams.setActions(Arrays.asList(actions));
            signatories.add(toParams);
        });
        req.getBody().setSignatories(signatories);
        return req;
    }

    @Override
    public ClContractVO getMainById(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClContractVO vo = new ClContractVO();
        BeanUtil.copyProperties((Object)((Object)contract), (Object)((Object)vo), (String[])new String[0]);
        List<ElsClSigners> signers = this.elsClSignersService.listByHeadId(id);
        vo.setSigners(signers);
        if (CollUtil.isNotEmpty(signers)) {
            List<ElsClSigners> purchaseSigners = signers.stream().filter(x -> CLFirstSealEnum.PURCHASE.getCode().equals(x.getRoleType())).collect(Collectors.toList());
            List<ElsClSigners> saleSigners = signers.stream().filter(x -> CLFirstSealEnum.SALE.getCode().equals(x.getRoleType())).collect(Collectors.toList());
            vo.setPurchaseSigners(purchaseSigners);
            vo.setSaleSigners(saleSigners);
        }
        return vo;
    }

    private String getBusUrl(ElsClSignContract contract, ClContractVO req, HttpServletRequest request) {
        String cookie = request.getHeader("cookie");
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        File file = this.operationService.getFileById(contract.getRelationId(), contract.getBusType(), contract.getBusNumber(), "1", req.getReportUrl(), req.getToken(), cookie);
        String documentLocation = File.separator + BIZ_PATH + File.separator + TenantContext.getTenant() + File.separator + nowDay + File.separator + file.getName();
        if (documentLocation.contains("\\")) {
            documentLocation = documentLocation.replace("\\", "/");
        }
        if (documentLocation.startsWith("\\")) {
            documentLocation.replace("\\", "");
        }
        if (documentLocation.startsWith("/")) {
            documentLocation = documentLocation.substring(1);
        }
        String fileResult = this.fileRpcService.uploadFiles(FileUtil.readBytes((File)file), documentLocation, file.getName(), "oss");
        log.info("\u5951\u7ea6\u9501\u6587\u6863result:[{}]", (Object)fileResult);
        String url = this.fileRpcService.getRealPath(documentLocation, "oss", false);
        log.info("\u5951\u7ea6\u9501\u6587\u6863url:[{}]", (Object)url);
        return url;
    }

    @Override
    public ClContractVO uploadFileToContractLock(ClContractVO req, HttpServletRequest request, HttpServletResponse response) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)req)));
        Assert.notNull((Object)((Object)contract), (String)"contract is null");
        Assert.notNull((Object)contract.getContractId(), (String)I18nUtil.translate((String)"i18n_alert_VWcInetx_b478644a", (String)"\u8bf7\u5148\u521b\u5efa\u5408\u540c\u8349\u7a3f"));
        String url = contract.getLocalFilePath();
        if (StrUtil.isEmpty((CharSequence)url)) {
            url = this.getBusUrl(contract, req, request);
        }
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
        body.setFile(url);
        body.setTitle(contract.getSubject());
        body.setFileSuffix(url.substring(url.lastIndexOf(".") + 1));
        body.setContractId(contract.getContractId());
        documentContractVO.setBody(body);
        Result<?> result = this.getIPassResponse(documentContractVO, "upload-contract-document");
        if (result.isSuccess()) {
            JSONObject jsonObject = (JSONObject)result.getResult();
            contract.setLocalFilePath(url);
            if (StrUtil.isEmpty((CharSequence)contract.getDocumentName())) {
                contract.setDocumentName(contract.getSubject());
            }
            if (!contract.getDocumentName().contains(body.getFileSuffix())) {
                contract.setDocumentName(Optional.ofNullable(contract.getDocumentName()).orElse(contract.getSubject()) + "." + body.getFileSuffix());
            }
            contract.setUploaded("1");
            contract.setDocumentId(jsonObject.getString("documentId"));
            this.edit(contract);
        } else {
            Assert.isTrue((boolean)false, (String)result.getMessage());
        }
        return null;
    }

    @Override
    public String browsePage(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body base = new ClDocumentContractVO.Body();
        base.setContractId(contract.getContractId());
        documentContractVO.setBase(base);
        Result<?> response = this.getIPassResponse(documentContractVO, "get-contract-page");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            return jsonObject.getString("pageUrl");
        }
        Assert.isTrue((boolean)false, (String)response.getMessage());
        return null;
    }

    @Override
    public void initiate(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
        body.setContractId(contract.getContractId());
        body.setDocumentId(contract.getDocumentId());
        documentContractVO.setBody(body);
        Result<?> response = this.getIPassResponse(documentContractVO, "initiate-contract-document");
        if (response.isSuccess()) {
            contract.setContractStatus(CLContractStatusEnum.SIGNING.getValue());
            contract.setLaunch("1");
            this.edit(contract);
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
    }

    @Override
    public String getSignPage(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
        body.setContractId(contract.getContractId());
        documentContractVO.setBase(body);
        Result<?> response = this.getIPassResponse(documentContractVO, "get-sign-short-url");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            return jsonObject.getString("shorturl");
        }
        Assert.isTrue((boolean)false, (String)response.getMessage());
        return null;
    }

    private ElsClSignContract getByRelationId(String id) {
        return (ElsClSignContract)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsClSignContract::getRelationId, (Object)id)).eq(BaseEntity::getDeleted, (Object)"0")));
    }

    @Override
    public ElsClSignContract downloadArchive(String id, String relationId) {
        ElsClSignContract contract = null;
        if (StrUtil.isNotBlank((CharSequence)id)) {
            contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        } else if (StrUtil.isNotBlank((CharSequence)relationId)) {
            contract = this.getByRelationId(relationId);
        }
        Assert.notNull((Object)((Object)contract), (String)I18nUtil.translate((String)"i18n_alert_QLIH_338001e0", (String)"\u6d41\u7a0b\u5f02\u5e38"));
        return contract;
    }

    private ElsClSignContract getByContractId(String id) {
        return ((ElsClContractMapper)this.baseMapper).selectByRequestId(id);
    }

    @Override
    public void handleCallBackContract(ClCallback.Contract contract) {
        ElsClSigners signers;
        ElsClSignContract dbContract = this.getByContractId(contract.getContractId());
        if (StrUtil.isNotBlank((CharSequence)contract.getTenantId()) && ObjectUtil.isNotNull((Object)((Object)(signers = this.elsClSignersService.selectByTenantIdAndContractId(contract.getTenantId(), dbContract.getContractId()))))) {
            signers.setSignStatus(contract.getContractStatus());
            if (CLConstant.CONTRACT_SUCCESS_STATS.contains(contract.getCallbackType()) || CLContractStatusEnum.COMPLETE.getValue().equals(contract.getContractStatus())) {
                if (CLFirstSealEnum.PURCHASE.getCode().equals(signers.getRoleType())) {
                    dbContract.setPurchaseSignStatus(ClSignerStatusEmun.SUCCESS.getValue());
                } else {
                    dbContract.setSignStatus(ClSignerStatusEmun.SUCCESS.getValue());
                }
            }
            this.elsClSignersService.updateById((Object)signers);
        }
        if (ObjectUtil.isNotNull((Object)((Object)dbContract)) && !CLContractStatusEnum.COMPLETE.getValue().equals(dbContract.getContractStatus())) {
            dbContract.setContractStatus(contract.getContractStatus());
            if (CLContractStatusEnum.COMPLETE.getValue().equals(contract.getContractStatus())) {
                dbContract.setSignStatus(ClContractSignStatusEmun.FINISHED.getValue());
                dbContract.setPurchaseSignStatus(ClSignerStatusEmun.SUCCESS.getValue());
                dbContract.setSaleSignStatus(ClSignerStatusEmun.SUCCESS.getValue());
                dbContract.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
                this.handleBusType(dbContract, CLBusTypeEnum.FINISH);
                if ("1".equals(dbContract.getAutoArchiving())) {
                    TenantContext.setTenant((String)dbContract.getElsAccount());
                    try {
                        this.handelArchive(dbContract);
                    }
                    catch (Exception e) {
                        log.error("contract[{}]handelArchive error{}", (Object)dbContract.getId(), (Object)e);
                    }
                }
            }
            this.updateById((Object)dbContract);
        }
    }

    @Override
    public Result<?> flowQuery(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body base = new ClDocumentContractVO.Body();
        base.setContractId(contract.getContractId());
        documentContractVO.setBase(base);
        Result<?> result = this.getIPassResponse(documentContractVO, "query-contract-document");
        JSONObject respone = (JSONObject)result.getResult();
        String status = respone.getString("status");
        return Result.ok((String)CLContractStatusEnum.getDesc(status));
    }

    @Override
    public void sendBack(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)contract), (String)I18nUtil.translate((String)"i18n_field_neLV_27784384", (String)"\u5408\u540c\u4e3a\u7a7a"));
        if (!EsignStatusEmun.UNDONE.getValue().equals(contract.getSignStatus())) {
            Assert.isTrue((!"1".equals(contract.getLaunch()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PWQLIhAWShYM_a3d2ed05", (String)"\u7b7e\u7f72\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u9000\u56de"));
        }
        if (CLContractStatusEnum.DRAFT.getValue().equals(contract.getContractStatus()) || CLContractStatusEnum.RECALLED.getValue().equals(contract.getContractStatus())) {
            ClDocumentContractVO vo = new ClDocumentContractVO();
            vo.setCompanyId(contract.getCompanyId());
            ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
            body.setContractId(contract.getContractId());
            vo.setBody(body);
            Result<?> result = this.getIPassResponse(vo, "revoke-contract");
            Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        }
        this.handleBusType(contract, CLBusTypeEnum.RETURN);
        contract.setSendBack("1");
        this.updateById((Object)contract);
    }

    @Override
    public void backout(String id, String reason) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)contract), (String)I18nUtil.translate((String)"i18n_field_neLV_27784384", (String)"\u5408\u540c\u4e3a\u7a7a"));
        Assert.isTrue((!"1".equals(contract.getSignStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_PWQLIyW_5e495400", (String)"\u7b7e\u7f72\u6d41\u7a0b\u5df2\u7ed3\u675f"));
        ClDocumentContractVO vo = new ClDocumentContractVO();
        vo.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body body = new ClDocumentContractVO.Body();
        body.setContractId(contract.getContractId());
        body.setReason(reason);
        vo.setBody(body);
        Result<?> result = this.getIPassResponse(vo, "revoke-contract");
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        contract.setContractStatus(CLContractStatusEnum.RECALLED.getValue());
        contract.setSignStatus(EsignStatusEmun.UNDONE.getValue());
        contract.setPurchaseSignStatus(ClSignerStatusEmun.UNDONE.getValue());
        contract.setSaleSignStatus(ClSignerStatusEmun.UNDONE.getValue());
        contract.setReason(reason);
        this.handleBusType(contract, CLBusTypeEnum.REVOKE);
        this.updateById((Object)contract);
    }

    @Override
    public void send(ClContractVO req, HttpServletRequest request, HttpServletResponse response) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)req.getId())));
        try {
            contract.setLocalFilePath(this.getBusUrl(contract, req, request));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6url\u5f02\u5e38", (Throwable)e);
        }
        contract.setSendStatus("1");
        this.updateById((Object)contract);
    }

    private void handelArchive(ElsClSignContract contract) {
        ClDocumentContractVO documentContractVO = new ClDocumentContractVO();
        documentContractVO.setCompanyId(contract.getCompanyId());
        ClDocumentContractVO.Body base = new ClDocumentContractVO.Body();
        base.setDocumentId(contract.getDocumentId());
        base.setFileName(contract.getDocumentName());
        documentContractVO.setBase(base);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)documentContractVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-contract-document-file"));
        if (object.getBoolean("success").booleanValue()) {
            JSONObject result = object.getJSONObject("data");
            if (StrUtil.isNotBlank((CharSequence)result.getString("filePath"))) {
                contract.setRemoteFilePath(result.getString("filePath"));
                contract.setArchiving("1");
                this.updateById((Object)contract);
            }
        } else {
            Assert.isTrue((boolean)false, (String)object.getString("messsage"));
        }
    }

    @Override
    public void archive(String id) {
        ElsClSignContract contract = (ElsClSignContract)((Object)this.getById((Serializable)((Object)id)));
        this.handelArchive(contract);
    }

    private void initSigner(List<ElsClSigners> list, ElsClSignContract contract) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        List purchaseSigners = list.stream().filter(x -> CLFirstSealEnum.PURCHASE.getCode().equals(x.getRoleType())).collect(Collectors.toList());
        List saleSigners = list.stream().filter(x -> CLFirstSealEnum.SALE.getCode().equals(x.getRoleType())).collect(Collectors.toList());
        list = Lists.newArrayList();
        if (CLFirstSealEnum.PURCHASE.getValue().equals(contract.getFirstSeal())) {
            list.addAll(purchaseSigners);
            list.addAll(saleSigners);
        } else {
            list.addAll(saleSigners);
            list.addAll(purchaseSigners);
        }
        Integer serialNo = 0;
        for (ElsClSigners row : list) {
            row.setHeadId(contract.getId());
            row.setBusAccount(TenantContext.getTenant());
            if (StrUtil.isBlank((CharSequence)row.getElsAccount())) {
                row.setElsAccount(TenantContext.getTenant());
            }
            Integer n = serialNo;
            Integer n2 = serialNo = Integer.valueOf(serialNo + 1);
            row.setSerialNo(n);
            row.setCreateTime(new Date());
            row.setCreateBy(currentUser);
        }
    }

    private List<ElsClSigners> initUpdateSigner(List<ElsClSigners> purchaseSigners, List<ElsClSigners> saleSigners, ElsClSignContract contract) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        ArrayList list = Lists.newArrayList();
        if (CLFirstSealEnum.PURCHASE.getValue().equals(contract.getFirstSeal())) {
            list.addAll(purchaseSigners);
            list.addAll(saleSigners);
        } else {
            list.addAll(saleSigners);
            list.addAll(purchaseSigners);
        }
        Integer serialNo = 0;
        for (ElsClSigners row : list) {
            row.setHeadId(contract.getId());
            row.setBusAccount(TenantContext.getTenant());
            if (StrUtil.isBlank((CharSequence)row.getElsAccount())) {
                row.setElsAccount(TenantContext.getTenant());
            }
            Integer n = serialNo;
            Integer n2 = serialNo = Integer.valueOf(serialNo + 1);
            row.setSerialNo(n);
            row.setHeadId(contract.getId());
            row.setUpdateTime(new Date());
            row.setUpdateBy(currentUser);
            row.setBusAccount("100000");
        }
        return list;
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }
}

