/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.listener;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.base.api.dto.MqMessagePersistenceDTO;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.service.PermissionService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class RebuildSaleMenuListener {
    private static final Logger log = LoggerFactory.getLogger(RebuildSaleMenuListener.class);
    @Resource
    private PermissionService permissionServiceImpl;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @StreamListener(value="inputReBuildSaleMenu")
    public void receive(String msgBody) {
        try {
            if (StringUtils.isBlank((CharSequence)msgBody)) {
                return;
            }
            JSONObject body = JSONObject.parseObject((String)msgBody);
            log.info(":::\u63a5\u53d7\u5230\u6765\u81ea\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u6743\u9650\uff0c\u66f4\u6539\u9500\u552e\u6743\u9650\u7684\u6570\u636e\u4fe1\u606f:{}", (Object)body);
            MqMessagePersistenceDTO dto = new MqMessagePersistenceDTO();
            dto.setBusinessType("permission");
            dto.setOptType("changePermission");
            dto.setErrorTimes(Integer.valueOf(0));
            dto.setSuccessFlag("-1");
            dto.setMessageData(msgBody);
            this.invokeBaseRpcService.save(dto);
        }
        catch (Exception e) {
            log.error(":::MQ\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355\u5f02\u5e38:{},error:{}", (Object)msgBody, (Object)e.getMessage());
            throw e;
        }
    }

    @Scheduled(cron="0/20 * * * * ?")
    public void dealChangePermissionScheduled() {
        List<MqMessagePersistenceDTO> dtos = this.invokeBaseRpcService.listToJob("permission", "changePermission");
        for (MqMessagePersistenceDTO dto : dtos) {
            JSONObject body = JSONObject.parseObject((String)dto.getMessageData());
            try {
                this.permissionServiceImpl.rebuildSaleMenuByMsg(body);
                dto.setSuccessFlag("1");
                dto.setUpdateTime(new Date());
            }
            catch (Exception e) {
                log.error(":::\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355\u5f02\u5e38:{},error:{}", (Object)e.getMessage());
                Integer errorTimes = (Integer)ObjectUtil.defaultIfNull((Object)dto.getErrorTimes(), (Object)0);
                if (errorTimes >= 2) {
                    dto.setSuccessFlag("0");
                } else {
                    dto.setErrorTimes(Integer.valueOf(errorTimes + 1));
                }
                dto.setUpdateTime(new Date());
            }
        }
        this.invokeBaseRpcService.updateList(dtos);
    }

    @Scheduled(cron="0 0 2 ? * *")
    public void deleteChangePermissionScheduled() {
        this.invokeBaseRpcService.deleteLog(null);
    }
}

