/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterprise.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.entity.ElsEnterpriseInfoRecord;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoRecordMapper;
import com.els.modules.enterprise.rpc.service.EnterpriseInvokeBaseRpcService;
import com.els.modules.enterprise.rpc.service.EnterpriseInvokeSupplierRpcService;
import com.els.modules.enterprise.service.ElsEnterpriseInfoRelationService;
import com.els.modules.enterprise.service.ElsEnterpriseInfoService;
import com.els.modules.enterprise.vo.EnterpriseInfoVo;
import com.els.modules.supplier.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.supplier.api.dto.SupplierAddressInfoDTO;
import com.els.modules.supplier.api.dto.SupplierBankInfoDTO;
import com.els.modules.supplier.api.dto.SupplierContactsInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataAndEnterpriseInfoDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.CompanyService;
import com.els.modules.system.service.ElsSubAccountService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ElsEnterpriseInfoServiceImpl
extends ServiceImpl<ElsEnterpriseInfoMapper, ElsEnterpriseInfo>
implements ElsEnterpriseInfoService,
CompanyService {
    @Resource
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Resource
    private EnterpriseInvokeSupplierRpcService invokeSupplierRpcService;
    @Resource
    private ElsEnterpriseInfoRecordMapper elsEnterpriseInfoRecordMapper;
    @Autowired
    @Lazy
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private EnterpriseInvokeBaseRpcService enterpriseInvokeBaseRpcService;
    @Autowired
    private ElsEnterpriseInfoRelationService elsEnterpriseInfoRelationService;
    @Autowired
    private RedisUtil redisUtil;
    private final String INFOCHANGE_KEY = "supplier:supplierinfochange:";

    @Override
    public void saveElsEnterpriseInfo(ElsEnterpriseInfo elsEnterpriseInfo) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).insert((Object)elsEnterpriseInfo);
    }

    @Override
    public void updateElsEnterpriseInfo(ElsEnterpriseInfo elsEnterpriseInfo) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).updateById((Object)elsEnterpriseInfo);
    }

    @Override
    public void delElsEnterpriseInfo(String id) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsEnterpriseInfo(List<String> idList) {
        ((ElsEnterpriseInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsEnterpriseInfo getByElsAccount(String elsAccount) {
        return this.elsEnterpriseInfoMapper.getByElsAccount(elsAccount);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void update(EnterpriseInfoVo enterpriseInfoVo) {
        List<SupplierMasterDataDTO> datas;
        ArrayList<SupplierContactsInfoDTO> insertItems;
        boolean supplierInfoChangExistUnconfirmed = this.invokeSupplierRpcService.isSupplierInfoChangExistUnconfirmed(enterpriseInfoVo.getElsAccount());
        if (supplierInfoChangExistUnconfirmed) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKLMLjAEVHAHtW_4bc76bf5", (String)"\u5b58\u5728\u672a\u5b8c\u6210\u4f01\u4e1a\u4fe1\u606f\u53d8\u66f4\u5355\uff01"));
        }
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTONew = new ElsEnterpriseInfoDTO();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVo), (Object)elsEnterpriseInfoDTONew);
        List<SupplierContactsInfoDTO> contactsInfoNew = enterpriseInfoVo.getSupplierContactsInfoList();
        List<SupplierAddressInfoDTO> addressInfoNew = enterpriseInfoVo.getSupplierAddressInfoList();
        List<SupplierBankInfoDTO> bankInfoNew = enterpriseInfoVo.getSupplierBankInfoList();
        ElsEnterpriseInfo elsEnterpriseInfoOld = this.getByElsAccount(enterpriseInfoVo.getElsAccount());
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTOOld = new ElsEnterpriseInfoDTO();
        BeanUtils.copyProperties((Object)((Object)elsEnterpriseInfoOld), (Object)elsEnterpriseInfoDTOOld);
        List<SupplierContactsInfoDTO> contactsInfoOld = this.invokeSupplierRpcService.getContactsDataOnlyAccount(enterpriseInfoVo.getElsAccount());
        List<SupplierAddressInfoDTO> addressInfoOld = this.invokeSupplierRpcService.getAddressDataOnlyAccount(enterpriseInfoVo.getElsAccount());
        List<SupplierBankInfoDTO> bankInfoOld = this.invokeSupplierRpcService.getBankDataOnlyAccount(enterpriseInfoVo.getElsAccount());
        EnterpriseInfoVo oldEnterpriseInfoVo = new EnterpriseInfoVo();
        BeanUtils.copyProperties((Object)((Object)elsEnterpriseInfoOld), (Object)((Object)oldEnterpriseInfoVo));
        oldEnterpriseInfoVo.setSupplierContactsInfoList(contactsInfoOld);
        oldEnterpriseInfoVo.setSupplierAddressInfoList(addressInfoOld);
        oldEnterpriseInfoVo.setSupplierBankInfoList(bankInfoOld);
        boolean supplierInfoChangExistInfoUpdate = this.invokeSupplierRpcService.isSupplierInfoChangExistInfoUpdate(enterpriseInfoVo, oldEnterpriseInfoVo);
        if (supplierInfoChangExistInfoUpdate) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_sMKmWLIiucrjVHW_7dae2e32", (String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u68c0\u6d4b\u5230\u4fee\u6539\u7684\u4fe1\u606f\uff01"));
        }
        List<SupplierMasterDataAndEnterpriseInfoDTO> purchaseList = this.invokeSupplierRpcService.selectPurchaseByToElsAccount(enterpriseInfoVo.getElsAccount());
        for (SupplierMasterDataAndEnterpriseInfoDTO infoDTO : purchaseList) {
            infoDTO.setSupplierInfoChangeAttachmentJson(JSONObject.toJSONString(enterpriseInfoVo.getSupplierInfoChangeAttachmentList()));
            infoDTO.setElsEnterpriseInfoOld(elsEnterpriseInfoDTOOld);
            infoDTO.setSupplierContactsInfoListOld(contactsInfoOld);
            infoDTO.setSupplierAddressInfoListOld(addressInfoOld);
            infoDTO.setSupplierBankInfoListOld(bankInfoOld);
            infoDTO.setElsEnterpriseInfoNew(elsEnterpriseInfoDTONew);
            infoDTO.setSupplierContactsInfoListNew(contactsInfoNew);
            infoDTO.setSupplierAddressInfoListNew(addressInfoNew);
            infoDTO.setSupplierBankInfoListNew(bankInfoNew);
        }
        if (!purchaseList.isEmpty() && purchaseList.size() > 0) {
            this.invokeSupplierRpcService.insertPurchaseInfoChang(purchaseList);
            Object purchaseInfoChangIds = this.redisUtil.get("supplier:supplierinfochange:purchaseIds");
            if (purchaseInfoChangIds != null) {
                enterpriseInfoVo.setSupplierInfoChangeIds(purchaseInfoChangIds.toString());
            }
            this.redisUtil.del(new String[]{"supplier:supplierinfochange:purchaseIds"});
        }
        ElsEnterpriseInfo elsEnterpriseInfo = new ElsEnterpriseInfo();
        BeanUtils.copyProperties((Object)((Object)enterpriseInfoVo), (Object)((Object)elsEnterpriseInfo));
        EnterpriseInfoVo infoRecord = this.insertInfoRecord(enterpriseInfoVo, elsEnterpriseInfoOld, contactsInfoOld, addressInfoOld, bankInfoOld);
        this.updateById((Object)elsEnterpriseInfo);
        if (contactsInfoNew != null) {
            this.invokeSupplierRpcService.deleteContactsByElsAccount(enterpriseInfoVo.getElsAccount());
            insertItems = new ArrayList<SupplierContactsInfoDTO>();
            for (SupplierContactsInfoDTO supplierContactsInfoDTO : contactsInfoNew) {
                supplierContactsInfoDTO.setId(null);
                supplierContactsInfoDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierContactsInfoDTO.setCreateTime(new Date());
                insertItems.add(supplierContactsInfoDTO);
            }
            if (!insertItems.isEmpty()) {
                this.invokeSupplierRpcService.insertContactsBatchSomeColumn(insertItems);
            }
        }
        if (bankInfoNew != null) {
            this.invokeSupplierRpcService.deleteBankByElsAccount(enterpriseInfoVo.getElsAccount());
            insertItems = new ArrayList();
            for (SupplierBankInfoDTO supplierBankInfoDTO : bankInfoNew) {
                supplierBankInfoDTO.setId(null);
                supplierBankInfoDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierBankInfoDTO.setCreateTime(new Date());
                insertItems.add((SupplierContactsInfoDTO)supplierBankInfoDTO);
            }
            if (!insertItems.isEmpty()) {
                this.invokeSupplierRpcService.insertBankBatchSomeColumn(insertItems);
            }
        }
        if (addressInfoNew != null) {
            this.invokeSupplierRpcService.deleteAddressByElsAccount(enterpriseInfoVo.getElsAccount());
            insertItems = new ArrayList();
            for (SupplierAddressInfoDTO supplierAddressInfoDTO : addressInfoNew) {
                supplierAddressInfoDTO.setId(null);
                supplierAddressInfoDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                supplierAddressInfoDTO.setCreateTime(new Date());
                insertItems.add((SupplierContactsInfoDTO)supplierAddressInfoDTO);
            }
            if (!insertItems.isEmpty()) {
                this.invokeSupplierRpcService.insertAddressBatchSomeColumn(insertItems);
            }
        }
        if ((datas = this.invokeSupplierRpcService.listByToElsAccount(enterpriseInfoVo.getElsAccount())) != null && datas.size() > 0) {
            for (SupplierMasterDataDTO supplierMasterDataDTO : datas) {
                if (!supplierMasterDataDTO.getSupplierName().equals(elsEnterpriseInfo.getName())) {
                    supplierMasterDataDTO.setSupplierName(elsEnterpriseInfo.getName());
                    this.invokeSupplierRpcService.updateById(supplierMasterDataDTO);
                }
                if ("2".equals(supplierMasterDataDTO.getSupplierStatus())) {
                    MsgParamsVO msgParamsVO = this.parameterAssemble(supplierMasterDataDTO.getElsAccount(), StringUtils.isNotBlank((CharSequence)supplierMasterDataDTO.getPrincipal()) ? supplierMasterDataDTO.getPrincipal().split("_")[0] : "1001", infoRecord, enterpriseInfoVo);
                    MqUtil.sendBusMsg((String)supplierMasterDataDTO.getElsAccount(), (String)"SupplierInfoChange", (String)"confirm", (MsgParamsVO)msgParamsVO);
                }
                supplierMasterDataDTO.setEnterpriseInfoRecordId(infoRecord.getElsEnterpriseInfoRecordId());
                this.invokeSupplierRpcService.updateById(supplierMasterDataDTO);
            }
        }
    }

    @Override
    public List<ElsEnterpriseInfo> selectWithoutElsAccountByElsAccountList(List<String> elsAccountList) {
        return ((ElsEnterpriseInfoMapper)this.baseMapper).selectWithoutElsAccountByElsAccountList(elsAccountList);
    }

    private MsgParamsVO parameterAssemble(String elsAccount, String subAccount, EnterpriseInfoVo infoRecord, EnterpriseInfoVo infoVo) {
        String id;
        List<TemplateConfigHeadDTO> enterpriseList;
        MsgParamsVO msgObj = new MsgParamsVO();
        LoginUser user = SysUtil.getLoginUser();
        ElsSubAccountDTO sendObj = (ElsSubAccountDTO)SysUtil.copyProperties((Object)user, ElsSubAccountDTO.class);
        msgObj.setSendObj(sendObj);
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        ElsSubAccount subAccountInfo = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        ElsSubAccountDTO accountDTO = (ElsSubAccountDTO)SysUtil.copyProperties((Object)((Object)subAccountInfo), ElsSubAccountDTO.class);
        accountList.add(accountDTO);
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        receiverMap.put(elsAccount, accountList);
        msgObj.setReceiverMap(receiverMap);
        Result result = Result.ok((Object)((Object)infoRecord));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        JSONObject oldObject = (JSONObject)result.getResult();
        result = Result.ok((Object)((Object)infoVo));
        dictAspect.parseDictText((Object)result);
        JSONObject newObject = (JSONObject)result.getResult();
        Set properties = newObject.keySet();
        List<TemplateHeadDTO> headList = this.enterpriseInvokeBaseRpcService.getDefaultTemplateByType("enterprise");
        HashMap enterpriseColumn = new HashMap();
        if (!headList.isEmpty() && (enterpriseList = this.enterpriseInvokeBaseRpcService.selectByMainId(id = headList.get(0).getId())) != null && enterpriseList.size() > 0) {
            for (TemplateConfigHeadDTO templateConfigHeadDTO : enterpriseList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("label", templateConfigHeadDTO.getFieldLabel());
                map.put("type", templateConfigHeadDTO.getFieldType());
                enterpriseColumn.put(templateConfigHeadDTO.getFieldName(), map);
            }
        }
        JSONObject data = new JSONObject();
        data.put("supplierAddressInfoList", (Object)new JSONArray());
        data.put("supplierBankInfoList", (Object)new JSONArray());
        data.put("supplierCertificatedInfoList", (Object)new JSONArray());
        data.put("supplierContactsInfoList", (Object)new JSONArray());
        data.put("supplierAddressInfoListOld", (Object)new JSONArray());
        data.put("supplierBankInfoListOld", (Object)new JSONArray());
        data.put("supplierCertificatedInfoListOld", (Object)new JSONArray());
        data.put("supplierContactsInfoListOld", (Object)new JSONArray());
        JSONArray array = new JSONArray();
        SimpleDateFormat dateStr = new SimpleDateFormat("yyyy-MM-dd");
        for (String string : properties) {
            String newValue = StringUtils.isNotBlank((CharSequence)newObject.getString(string + "_dictText")) ? newObject.getString(string + "_dictText") : newObject.getString(string);
            if (!StringUtils.isNotBlank((CharSequence)newValue)) continue;
            try {
                JSONArray oldArray;
                JSONArray tabArray = JSONObject.parseArray((String)newObject.getString(string));
                if (tabArray != null) {
                    for (Object object1 : tabArray) {
                        JSONObject jsonObject = JSONObject.parseObject((String)object1.toString());
                        Set keys = jsonObject.keySet();
                        for (String key : keys) {
                            if (!StringUtils.isNotBlank((CharSequence)jsonObject.getString(key + "_dictText"))) continue;
                            jsonObject.put(key, (Object)jsonObject.getString(key + "_dictText"));
                        }
                    }
                }
                if ((oldArray = JSONObject.parseArray((String)oldObject.getString(string))) != null) {
                    Object object1;
                    object1 = oldArray.iterator();
                    while (object1.hasNext()) {
                        Object object12 = object1.next();
                        JSONObject jsonObject = JSONObject.parseObject((String)object12.toString());
                        Set keys = jsonObject.keySet();
                        for (String key : keys) {
                            if (!StringUtils.isNotBlank((CharSequence)jsonObject.getString(key + "_dictText"))) continue;
                            jsonObject.put(key, (Object)jsonObject.getString(key + "_dictText"));
                        }
                    }
                }
                if ("supplierAddressInfoList".equals(string)) {
                    data.put("supplierAddressInfoList", (Object)tabArray);
                    data.put("supplierAddressInfoListOld", (Object)oldArray);
                }
                if ("supplierBankInfoList".equals(string)) {
                    data.put("supplierBankInfoList", (Object)tabArray);
                    data.put("supplierBankInfoListOld", (Object)oldArray);
                }
                if ("supplierCertificatedInfoList".equals(string)) {
                    data.put("supplierCertificatedInfoList", (Object)tabArray);
                    data.put("supplierCertificatedInfoListOld", (Object)oldArray);
                }
                if (!"supplierContactsInfoList".equals(string)) continue;
                data.put("supplierContactsInfoList", (Object)tabArray);
                data.put("supplierContactsInfoListOld", (Object)oldArray);
            }
            catch (Exception e) {
                Map map;
                String oldValue = StringUtils.isNotBlank((CharSequence)oldObject.getString(string + "_dictText")) ? oldObject.getString(string + "_dictText") : oldObject.getString(string);
                if (newValue.equals(oldValue) || "updateTime".equals(string) || "createTime".equals(string) || (map = (Map)enterpriseColumn.get(string)) == null) continue;
                JSONObject object = new JSONObject();
                if ("date".equals(map.get("type"))) {
                    Long newTime = null;
                    Long oldTime = null;
                    try {
                        newTime = dateStr.parse(newValue).getTime();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (StringUtils.isNotBlank((CharSequence)oldValue)) {
                        try {
                            oldTime = dateStr.parse(oldValue).getTime();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (oldTime == null || oldTime.equals(newTime)) continue;
                        object.put("column", map.get("label"));
                        object.put("old", (Object)dateStr.format(new Date(oldTime)));
                        object.put("new", (Object)dateStr.format(new Date(newTime)));
                        array.add((Object)object);
                        continue;
                    }
                    object.put("column", map.get("label"));
                    object.put("old", (Object)"");
                    object.put("new", (Object)dateStr.format(newTime));
                    array.add((Object)object);
                    continue;
                }
                object.put("column", map.get("label"));
                object.put("old", (Object)oldValue);
                object.put("new", (Object)newValue);
                array.add((Object)object);
            }
        }
        data.put("enterpriseInfoList", (Object)array);
        Map map = (Map)JSON.parse((String)data.toString());
        map.put("userName", subAccountInfo.getRealname());
        map.put("elsAccount", infoVo.getElsAccount());
        map.put("name", infoVo.getName());
        map.put("modifyPerson", "sale");
        msgObj.setParams((Object)map);
        return msgObj;
    }

    public EnterpriseInfoVo insertInfoRecord(EnterpriseInfoVo enterpriseInfoVo, ElsEnterpriseInfo elsEnterpriseOldInfo, List<SupplierContactsInfoDTO> contactsInfo, List<SupplierAddressInfoDTO> addressInfo, List<SupplierBankInfoDTO> bankInfo) {
        if (elsEnterpriseOldInfo != null) {
            EnterpriseInfoVo enterpriseInfoOldVo = new EnterpriseInfoVo();
            BeanUtils.copyProperties((Object)((Object)elsEnterpriseOldInfo), (Object)((Object)enterpriseInfoOldVo));
            enterpriseInfoOldVo.setSupplierContactsInfoList(contactsInfo);
            enterpriseInfoOldVo.setSupplierAddressInfoList(addressInfo);
            enterpriseInfoOldVo.setSupplierBankInfoList(bankInfo);
            int version = this.elsEnterpriseInfoRecordMapper.getMaxVersionByAccount(enterpriseInfoVo.getElsAccount());
            ElsEnterpriseInfoRecord infoRecord = new ElsEnterpriseInfoRecord();
            infoRecord.setElsAccount(enterpriseInfoVo.getElsAccount());
            infoRecord.setVersion(version);
            infoRecord.setInfo(JSONObject.toJSONString((Object)((Object)enterpriseInfoOldVo)));
            this.elsEnterpriseInfoRecordMapper.insert((Object)infoRecord);
            enterpriseInfoOldVo.setElsEnterpriseInfoRecordId(infoRecord.getId());
            return enterpriseInfoOldVo;
        }
        return null;
    }

    @Override
    public Map<String, String> getCompanyName(String elsAccount) {
        HashMap<String, String> map = new HashMap<String, String>();
        ElsEnterpriseInfo info = this.elsEnterpriseInfoMapper.getByElsAccount(elsAccount);
        if (info != null) {
            map.put("fullName", info.getName());
            map.put("shortName", info.getAlias());
        }
        return map;
    }
}

