/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.config;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.google.common.collect.Maps;
import java.util.Map;

public class PermissionI18LocalCacheInit {
    private static final Map<String, String> userLanguageCache = Maps.newHashMap();

    public static String translate(String i18nKey, String defaultValue) {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        String elsAccount = CharSequenceUtil.emptyToDefault((CharSequence)TenantContext.getTenant(), (String)"100000");
        String key = elsAccount + "_" + language + "_" + i18nKey;
        try {
            String value = userLanguageCache.get(key);
            if (CharSequenceUtil.isNotEmpty((CharSequence)value)) {
                return value;
            }
            value = I18nUtil.translate((String)i18nKey, (String)defaultValue);
            userLanguageCache.put(key, value);
            return value;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

