/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.modules.justauth.JustAuthUtil;
import com.els.modules.justauth.cache.CustomRedisStateCache;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.justauth.service.JustAuthConfigService;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.model.ThirdLoginModel;
import com.els.modules.system.service.ThirdAccountService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.AuthRequestBuilder;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/ThirdAccountBind"})
@Api(tags={"\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a"})
public class ThirdAccountBindController {
    private static final Logger log = LoggerFactory.getLogger(ThirdAccountBindController.class);
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private CustomRedisStateCache redisStateCache;
    @Autowired
    private JustAuthConfigService justAuthConfigService;
    @Autowired
    private StaticConfig staticConfig;
    private static final String STATE_KEY = "sys:thirdLogin:state:";
    private static final String ACCOUNT_KEY = "sys:thirdLogin:account:";

    private AuthRequest getAuthRequest(String elsAccount, String source, String type, Boolean flag) {
        log.info("getAuthRequest,elsAccount:{},source:{},type:{},flag:{}", new Object[]{elsAccount, source, type, flag});
        JustAuthConfig config = this.justAuthConfigService.getOneConfig(elsAccount, JustAuthUtil.getAuthConfigType(source));
        if (config == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nICUixMKW_52a77674", (String)"\u7b2c\u4e09\u65b9\u51ed\u8bc1\u4e0d\u5b58\u5728\uff01"));
        }
        source = JustAuthUtil.getAuthType(config.getAuthType(), config.getCreateAppType());
        String uri = "/user/qcLogin";
        if ("mobile".equals(type)) {
            uri = "/mobile";
        }
        if (flag.booleanValue()) {
            source = JustAuthUtil.getAuthType(source);
        }
        String redirectUri = (String)this.staticConfig.getConfig().get("service.address") + uri + "?type%3D" + source.toLowerCase();
        AuthConfig build = AuthConfig.builder().clientId(config.getClientId()).clientSecret(config.getClientSecret()).agentId(config.getAgentId()).redirectUri(redirectUri).build();
        if (CharSequenceUtil.isNotBlank((CharSequence)config.getUsertype())) {
            build.setUsertype(config.getUsertype());
        }
        return AuthRequestBuilder.builder().source(source.toLowerCase()).authConfig(build).authStateCache((AuthStateCache)this.redisStateCache).build();
    }

    @GetMapping(value={"/getBindList"})
    public Result<?> getBindList() throws IOException {
        LoginUser loginUser = SysUtil.getLoginUser();
        List accountList = this.thirdAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)loginUser.getElsAccount())).eq((Object)"user_id", (Object)loginUser.getId()));
        Result result = new Result();
        return Result.ok((Object)accountList);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a-\u89e3\u7ed1", operateType=4)
    @RequestMapping(value={"/unBindOpt"}, method={RequestMethod.GET})
    public Result<?> unBindOpt(@RequestParam(name="thirdType") String thirdType, @RequestParam(name="busAccount") String busAccount) {
        LoginUser loginUser = SysUtil.getLoginUser();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(ThirdAccount::getUserId, (Object)loginUser.getId())).eq(ThirdAccount::getThirdType, (Object)thirdType)).eq(ThirdAccount::getBusAccount, (Object)busAccount);
        this.thirdAccountService.remove((Wrapper)wrapper);
        return Result.ok((String)I18nUtil.translate((String)"i18n_title_operationSuccess", (String)"\u64cd\u4f5c\u6210\u529f!"));
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a-\u52a0\u8f7d\u4e8c\u7ef4\u7801")
    @GetMapping(value={"/render/{busAccount}/{source}"})
    public Result<Object> render(@PathVariable(value="busAccount") String busAccount, @PathVariable(value="source") String source, HttpServletResponse response) throws IOException {
        log.info("\u7b2c\u4e09\u65b9\u7ed1\u5b9a\u8fdb\u5165render\uff1a" + source);
        AuthRequest authRequest = this.getAuthRequest(busAccount, source, "pc", false);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        this.redisUtil.set(STATE_KEY + state, (Object)SysUtil.getLoginUser(), 1800L);
        this.redisUtil.set(ACCOUNT_KEY + state, (Object)busAccount, 1800L);
        log.info("\u7b2c\u4e09\u65b9\u7ed1\u5b9a\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        Result result = new Result();
        JSONObject object = new JSONObject();
        authorizeUrl = authorizeUrl.replace("qcLogin", "QcCodeBinding");
        object.put("url", (Object)authorizeUrl);
        return Result.ok((Object)object);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u7ed1\u5b9a-\u8fdb\u5165callback")
    @GetMapping(value={"/{source}/callback"})
    public Result<?> loginThird(@PathVariable(value="source") String source, AuthCallback callback) {
        log.info("\u7b2c\u4e09\u65b9\u7ed1\u5b9a\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)callback));
        Result result = new Result();
        try {
            String busAccount = (String)this.redisUtil.get(ACCOUNT_KEY + callback.getState());
            log.info("ThirdSource:{},busAccount:{},callback", new Object[]{source, busAccount, callback});
            AuthRequest authRequest = this.getAuthRequest(busAccount, source.toUpperCase(), "pc", false);
            AuthResponse response = authRequest.login(callback);
            log.info(JSONObject.toJSONString((Object)response));
            if (response.getCode() == 2000) {
                JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
                String username = data.getString("username");
                String avatar = data.getString("avatar");
                String uuid = data.getString("uuid");
                ThirdLoginModel tlm = new ThirdLoginModel(JustAuthUtil.getAuthConfigType(source.toUpperCase()), uuid, username, avatar);
                LoginUser loginUser = (LoginUser)this.redisUtil.get(STATE_KEY + callback.getState());
                if (loginUser != null) {
                    this.saveThirdUser(tlm, loginUser.getId(), busAccount);
                    return Result.ok((String)I18nUtil.translate((String)"i18n_title_operationSuccess", (String)"\u64cd\u4f5c\u6210\u529f!"));
                }
            } else {
                result.setSuccess(false);
                result.setMessage("\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458:" + response.getMsg());
            }
        }
        catch (Exception e) {
            log.error("loginThird_callback_failed:", (Throwable)e);
            throw e;
        }
        return result;
    }

    private ThirdAccount saveThirdUser(ThirdLoginModel tlm, String id, String busAccount) {
        ThirdAccount user = new ThirdAccount();
        user.setId(IdWorker.getIdStr());
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        user.setUserId(id);
        user.setStatus(1);
        user.setThirdType(tlm.getSource());
        user.setAvatar(tlm.getAvatar());
        user.setRealname(tlm.getUsername());
        user.setThirdUserUuid(tlm.getUuid());
        user.setBusAccount(busAccount);
        this.thirdAccountService.saveThirdUser(user);
        return user;
    }
}

