/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contractlock.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contractlock.entity.SaleCLCompanyInfo;
import com.els.modules.contractlock.entity.SaleClPersonalInfo;
import com.els.modules.contractlock.enumerate.CLAuthResultEnum;
import com.els.modules.contractlock.enumerate.CLCertificationStatusEnum;
import com.els.modules.contractlock.mapper.SaleCLCompanyInfoMapper;
import com.els.modules.contractlock.service.SaleCLCompanyInfoService;
import com.els.modules.contractlock.service.SaleClPersonalInfoService;
import com.els.modules.contractlock.util.ClResultAnalysisUtil;
import com.els.modules.contractlock.vo.ClCallback;
import com.els.modules.contractlock.vo.ClCompanyCertificationVO;
import com.els.modules.contractlock.vo.ClCompanyStaffVO;
import com.els.modules.contractlock.vo.ClQueryCertificationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleCLCompanyInfoServiceImpl
extends BaseServiceImpl<SaleCLCompanyInfoMapper, SaleCLCompanyInfo>
implements SaleCLCompanyInfoService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleClPersonalInfoService personalInfoService;

    @Override
    public void add(SaleCLCompanyInfo saleCLCompanyInfo) {
        Assert.isTrue((this.count((Wrapper)Wrappers.lambdaQuery().eq(SaleCLCompanyInfo::getCompanyName, (Object)saleCLCompanyInfo.getCompanyName())) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_rRCIOMKWxqVBcI_9ebb70f", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        saleCLCompanyInfo.setCreateAccount(TenantContext.getTenant());
        ((SaleCLCompanyInfoMapper)this.baseMapper).insert((Object)saleCLCompanyInfo);
        this.getCertificationInfo(saleCLCompanyInfo.getId());
    }

    @Override
    public void edit(SaleCLCompanyInfo saleCLCompanyInfo) {
        Assert.isTrue((this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleCLCompanyInfo::getCompanyName, (Object)saleCLCompanyInfo.getCompanyName())).ne(BaseEntity::getId, (Object)saleCLCompanyInfo.getId())) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_rRCIOMKWxqVBcI_9ebb70f", (String)"\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u521b\u5efa"));
        int count = ((SaleCLCompanyInfoMapper)this.baseMapper).updateById((Object)saleCLCompanyInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.getCertificationInfo(saleCLCompanyInfo.getId());
    }

    @Override
    public void delete(String id) {
        ((SaleCLCompanyInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleCLCompanyInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    public void saveInfo(SaleCLCompanyInfo req) {
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        if (StrUtil.isBlank((CharSequence)req.getElsAccount())) {
            req.setElsAccount(TenantContext.getTenant());
        }
        req.setCreateTime(new Date());
        req.setCreateBy(currentUser);
        ((SaleCLCompanyInfoMapper)this.baseMapper).insert((Object)req);
    }

    public void updateInfo(SaleCLCompanyInfo req) {
        req.setUpdateTime(new Date());
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        req.setUpdateBy(currentUser);
        ((SaleCLCompanyInfoMapper)this.baseMapper).updateById((Object)req);
    }

    public void handleDb(SaleCLCompanyInfo req) {
        if (StringUtils.isBlank((CharSequence)req.getId())) {
            req.setCreateAccount(TenantContext.getTenant());
            this.saveInfo(req);
        } else {
            this.updateInfo(req);
        }
    }

    @Override
    public SaleCLCompanyInfo submitCertification(SaleCLCompanyInfo req) {
        Result<?> response = null;
        if (StringUtils.isBlank((CharSequence)req.getCompanyId())) {
            ClCompanyCertificationVO certificationInfo = (ClCompanyCertificationVO)SysUtil.copyProperties((Object)((Object)req), ClCompanyCertificationVO.class);
            certificationInfo.setApplicantInfo(new ClCompanyCertificationVO.ApplicantInfo(req.getApplyUserName(), req.getApplyContact(), req.getApplyContactType()));
            certificationInfo.setCallbackUrl(this.address + "/els/contractLock/saleCLCompanyInfo/noToken/callback/authCompany");
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)certificationInfo)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("get-auth-company"));
            response = ClResultAnalysisUtil.analysisResult(object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                req.setCertificationPageUrl(jsonObject.getString("pageUrl"));
                req.setRequestId(jsonObject.getString("requestId"));
                req.setCertificationStatus(CLCertificationStatusEnum.UNDER_CERTIFICATION.getValue());
                this.handleDb(req);
            } else {
                Assert.isTrue((boolean)false, (String)response.getMessage());
            }
        }
        return req;
    }

    private void insertAdmin(SaleCLCompanyInfo company) {
        TenantContext.setTenant((String)company.getElsAccount());
        List list = this.personalInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleClPersonalInfo::getCompanyId, (Object)company.getCompanyId())).eq(SaleClPersonalInfo::getApplyContact, (Object)company.getApplyContact())).eq(SaleClPersonalInfo::getApplyUserName, (Object)company.getApplyUserName())).eq(BaseEntity::getDeleted, (Object)"0"));
        if (CollUtil.isNotEmpty((Collection)list)) {
            list.forEach(x -> {
                x.setRoleStr("ADMIN");
                x.setRealName("1");
                this.personalInfoService.updateById(x);
            });
        } else {
            SaleClPersonalInfo saleClPersonalInfo = new SaleClPersonalInfo();
            saleClPersonalInfo.setRoleStr("ADMIN");
            BeanUtil.copyProperties((Object)((Object)company), (Object)((Object)saleClPersonalInfo), (String[])new String[0]);
            saleClPersonalInfo.setCreateTime(new Date());
            saleClPersonalInfo.setId(null);
            saleClPersonalInfo.setAuthPageUrl(null);
            saleClPersonalInfo.setRealName("1");
            this.personalInfoService.save((Object)saleClPersonalInfo);
        }
    }

    @Override
    public void getCertificationInfo(String id) {
        SaleCLCompanyInfo info = (SaleCLCompanyInfo)((Object)this.getById((Serializable)((Object)id)));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBody(new ClQueryCertificationVO.Param(info.getCompanyName()));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "query-auth-company");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            Integer status = jsonObject.getInteger("status");
            if (ObjectUtil.isNotEmpty((Object)status)) {
                info.setCertificationStatus(status);
                if (status.equals(CLCertificationStatusEnum.PASSED.getValue())) {
                    clQueryCertificationVO = new ClQueryCertificationVO();
                    clQueryCertificationVO.setBase(new ClQueryCertificationVO.Param(info.getCompanyName()));
                    response = this.getIPassResponse(clQueryCertificationVO, "query-info-company");
                    jsonObject = (JSONObject)response.getResult();
                    info.setCompanyId(jsonObject.getString("id"));
                    this.insertAdmin(info);
                }
                info.setCertificationStartTime(new Date());
                this.updateById((Object)info);
            }
        } else {
            Assert.isTrue((boolean)false, (String)response.getMessage());
        }
    }

    @Override
    public SaleCLCompanyInfo getAuthPage(String id) {
        SaleCLCompanyInfo info = (SaleCLCompanyInfo)((Object)this.getById((Serializable)((Object)id)));
        ClQueryCertificationVO clQueryCertificationVO = new ClQueryCertificationVO();
        clQueryCertificationVO.setBody(new ClQueryCertificationVO.Param(info.getCompanyId(), new ClCompanyCertificationVO.ApplicantInfo(info.getApplyUserName(), info.getApplyContact(), info.getApplyContactType())));
        Result<?> response = this.getIPassResponse(clQueryCertificationVO, "get-auth-page");
        if (response.isSuccess()) {
            JSONObject jsonObject = (JSONObject)response.getResult();
            info.setAuthPageUrl(jsonObject.getString("pageUrl"));
            this.updateInfo(info);
            return info;
        }
        Assert.isTrue((boolean)false, (String)response.getMessage());
        return null;
    }

    @Override
    public void addStaff(SaleClPersonalInfo saleCLCompanyInfo) {
        ClCompanyStaffVO staffReq = new ClCompanyStaffVO();
        staffReq.setCompanyId(saleCLCompanyInfo.getCompanyId());
        ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
        body.setUser(new ClCompanyCertificationVO.ApplicantInfo(saleCLCompanyInfo.getApplyUserName(), saleCLCompanyInfo.getApplyContact(), saleCLCompanyInfo.getApplyContactType()));
        staffReq.setBody(body);
        Result<?> result = this.getIPassResponse(staffReq, "add-staff-company-personal");
        if (result.isSuccess()) {
            JSONObject jsonObject = (JSONObject)result.getResult();
            saleCLCompanyInfo.setAccountId(jsonObject.getString("id"));
            saleCLCompanyInfo.setRealName(jsonObject.getBoolean("realName") != false ? "1" : "0");
            if (StrUtil.isNotBlank((CharSequence)saleCLCompanyInfo.getId())) {
                this.personalInfoService.edit(saleCLCompanyInfo);
            } else {
                SaleCLCompanyInfo companyInfo = this.getByCompanyId(saleCLCompanyInfo.getCompanyId());
                saleCLCompanyInfo.setCreateTime(new Date());
                saleCLCompanyInfo.setElsAccount(companyInfo.getElsAccount());
                saleCLCompanyInfo.setCompanyId(companyInfo.getCompanyId());
                saleCLCompanyInfo.setCompanyName(companyInfo.getCompanyName());
                this.personalInfoService.add(saleCLCompanyInfo);
            }
        } else {
            Assert.isTrue((boolean)false, (String)result.getMessage());
        }
    }

    @Override
    public SaleCLCompanyInfo getByCompanyId(String id) {
        return (SaleCLCompanyInfo)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleCLCompanyInfo::getCompanyId, (Object)id)));
    }

    @Override
    public void removeStaff(SaleClPersonalInfo saleClPersonalInfo) {
        ClCompanyStaffVO staffReq = new ClCompanyStaffVO();
        staffReq.setCompanyId(saleClPersonalInfo.getCompanyId());
        ClCompanyStaffVO.Body body = new ClCompanyStaffVO.Body();
        body.setContact(saleClPersonalInfo.getApplyContact());
        body.setContactType(saleClPersonalInfo.getApplyContactType());
        staffReq.setBody(body);
        Result<?> result = this.getIPassResponse(staffReq, "remove-staff-company-personal");
        if (result.isSuccess()) {
            this.personalInfoService.delete(saleClPersonalInfo.getId());
        } else {
            Assert.isTrue((boolean)false, (String)result.getMessage());
        }
    }

    @Override
    public void handleCallBackAuth(String contents) {
        ClCallback.CompanyAuth companyAuth = (ClCallback.CompanyAuth)JSON.parseObject((String)contents, ClCallback.CompanyAuth.class);
        SaleCLCompanyInfo dbInfo = this.selectByRequestId(companyAuth.getRequestId());
        if (ObjectUtil.isNotNull((Object)((Object)dbInfo))) {
            dbInfo.setCertificationStatus(CLAuthResultEnum.getSrmStatusByValue(companyAuth.getStatus()));
            dbInfo.setCompanyId(companyAuth.getCompanyId());
            dbInfo.setUpdateTime(new Date());
            this.updateById((Object)dbInfo);
            if (CLAuthResultEnum.PASSED.getValue().equals(companyAuth.getStatus())) {
                this.insertAdmin(dbInfo);
            }
        }
    }

    private SaleCLCompanyInfo selectByRequestId(String requestId) {
        return ((SaleCLCompanyInfoMapper)this.baseMapper).selectByRequestId(requestId);
    }

    private Result<?> getIPassResponse(Object req, String iPassCode) {
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString((Object)req)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(iPassCode));
        return ClResultAnalysisUtil.analysisResult(object);
    }
}

