/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.modules.esign.entity.ElsSigners;
import com.els.modules.esign.mapper.ElsSignersMapper;
import com.els.modules.esign.service.ElsSignersService;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.vo.EsignKeyWordVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsSignersServiceImpl
extends BaseServiceImpl<ElsSignersMapper, ElsSigners>
implements ElsSignersService {
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Autowired
    private ElsSignersMapper elsSignersMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public List<ElsSigners> selectByMainId(String mainId) {
        return this.elsSignersMapper.selectByMainId(mainId);
    }

    @Override
    public Result<?> keyWordToAera(ElsSigners signers) {
        Result<?> response = null;
        if (StringUtils.isNotBlank((CharSequence)signers.getSignWord())) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("fileId", (Object)signers.getFilesId());
            bascis.put("keywords", (Object)signers.getSignWord());
            requestJSON.put("base", (Object)bascis);
            JSONObject resultObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("search-keyword-position"));
            response = EsignResultAnalysisUtil.analysisResult(resultObject);
            if (response.isSuccess()) {
                JSONArray array = (JSONArray)response.getResult();
                if (array.size() == 0) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_WWWWWWWWRIJddLILuFDLR_1656636", (String)"\u3010[$(0)]\u3011\u5173\u952e\u5b57\u641c\u7d22\u672a\u5b9a\u4f4d\u5230\u5177\u4f53\u4f4d\u7f6e", (String[])new String[]{signers.getSignWord()}));
                }
                ArrayList<EsignKeyWordVO> keyWordVOs = new ArrayList<EsignKeyWordVO>();
                for (Object object : array) {
                    JSONObject objectJsonObject = JSONObject.parseObject((String)object.toString());
                    JSONArray positionList = JSONArray.parseArray((String)objectJsonObject.getString("positionList"));
                    for (Object object2 : positionList) {
                        JSONObject jsonObject = JSONObject.parseObject((String)object2.toString());
                        int pageNo = jsonObject.getIntValue("pageIndex");
                        JSONArray coordinateList = JSONArray.parseArray((String)jsonObject.getString("coordinateList"));
                        for (Object object3 : coordinateList) {
                            JSONObject vaule = JSONObject.parseObject((String)object3.toString());
                            String posx = vaule.getString("posx");
                            String posy = vaule.getString("posy");
                            keyWordVOs.add(new EsignKeyWordVO(pageNo, posx, posy));
                        }
                    }
                }
                JSONObject result = new JSONObject();
                result.put("current", (Object)1);
                result.put("pages", (Object)1);
                result.put("records", keyWordVOs);
                result.put("size", (Object)100);
                result.put("total", (Object)keyWordVOs.size());
                return Result.ok((Object)result);
            }
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_ddKmW_bcfbb540", (String)"\u641c\u7d22\u5931\u8d25:") + response.getMessage()));
        }
        return null;
    }
}

