/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.log.Log;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AbstractAuthWeChatEnterpriseRequest;
import me.zhyd.oauth.utils.AuthChecker;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthWeChatEnterpriseThirdQrcodeRequest
extends AbstractAuthWeChatEnterpriseRequest {
    private static final Logger log = LoggerFactory.getLogger(AuthWeChatEnterpriseThirdQrcodeRequest.class);

    public AuthWeChatEnterpriseThirdQrcodeRequest(AuthConfig config) {
        super(config, (AuthSource)AuthDefaultSource.WECHAT_ENTERPRISE_QRCODE_THIRD);
    }

    public AuthWeChatEnterpriseThirdQrcodeRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, (AuthSource)AuthDefaultSource.WECHAT_ENTERPRISE_QRCODE_THIRD, authStateCache);
    }

    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl((String)this.source.authorize()).queryParam("appid", (Object)this.config.getClientId()).queryParam("redirect_uri", (Object)this.config.getRedirectUri()).queryParam("state", (Object)this.getRealState(state)).queryParam("usertype", (Object)this.config.getUsertype()).build();
    }

    public AuthResponse login(AuthCallback authCallback) {
        try {
            if (!this.config.isIgnoreCheckState()) {
                AuthChecker.checkState((String)authCallback.getState(), (AuthSource)this.source, (AuthStateCache)this.authStateCache);
            }
            AuthToken authToken = this.getAccessToken(authCallback);
            log.error(":::AuthWeChatEnterpriseThirdQrcodeRequest authToken:{}", (Object)authToken.getAccessToken());
            AuthUser user = this.getUserInfo(authToken);
            return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data((Object)user).build();
        }
        catch (Exception var4) {
            Log.error((String)"Failed to login with oauth authorization.", (Throwable)var4);
            return this.responseError(var4);
        }
    }

    protected AuthToken getAccessToken(AuthCallback authCallback) {
        try {
            String response = this.doGetAuthorizationCode(this.accessTokenUrl());
            JSONObject object = this.checkResponse(response);
            AuthToken authToken = AuthToken.builder().accessToken(object.getString("provider_access_token")).expireIn(object.getIntValue("expires_in")).build();
            authToken.setCode(authCallback.getAuth_code());
            return authToken;
        }
        catch (Exception var5) {
            throw new AuthException("\u4f01\u4e1a\u5fae\u4fe1\u83b7\u53d6token\u5931\u8d25", (Throwable)var5);
        }
    }

    protected String doGetAuthorizationCode(String code) {
        JSONObject data = new JSONObject();
        data.put("corpid", (Object)this.config.getClientId());
        data.put("provider_secret", (Object)this.config.getClientSecret());
        return new HttpUtils(this.config.getHttpConfig()).post(this.accessTokenUrl(code), data.toJSONString()).getBody();
    }

    protected String accessTokenUrl() {
        return UrlBuilder.fromBaseUrl((String)this.source.accessToken()).build();
    }

    protected AuthUser getUserInfo(AuthToken authToken) {
        JSONObject response = this.checkResponse(this.doGetUserInfo(authToken));
        return AuthUser.builder().rawUserInfo(response).build();
    }

    protected String doGetUserInfo(AuthToken authToken) {
        JSONObject data = new JSONObject();
        data.put("auth_code", (Object)authToken.getCode());
        log.info(":::\u4e34\u65f6\u6388\u6388\u6743\u7801 doGetUserInfo auth_code:{}", (Object)authToken.getAccessCode());
        return new HttpUtils(this.config.getHttpConfig()).post(this.userInfoUrl(authToken), data.toJSONString()).getBody();
    }

    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl((String)this.source.userInfo()).queryParam("access_token", (Object)authToken.getAccessToken()).build();
    }

    private JSONObject checkResponse(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"errcode") && object.getIntValue("errcode") != 0) {
            throw new AuthException(object.getString("errmsg"), this.source);
        }
        return object;
    }
}

