/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.config;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PermissionI18LocalCacheInit {
    private static final Map<LocalCacheKey, String> userLanguageCache = Maps.newConcurrentMap();

    public static String translate(String i18nKey, String defaultValue) {
        if (StrUtil.isBlank((CharSequence)i18nKey)) {
            return defaultValue;
        }
        String val = "";
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        String elsAccount = CharSequenceUtil.emptyToDefault((CharSequence)TenantContext.getTenant(), (String)"100000");
        LocalCacheKey key = new LocalCacheKey(elsAccount, language, i18nKey);
        try {
            val = userLanguageCache.get(key);
            if (CharSequenceUtil.isEmpty((CharSequence)val)) {
                val = I18nUtil.translate((String)i18nKey, (String)defaultValue);
                userLanguageCache.put(key, val);
            }
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (CharSequenceUtil.isEmpty((CharSequence)val)) {
            val = defaultValue;
        }
        return val;
    }

    public static void removeBykey(String i18nKey) {
        if (StrUtil.isBlank((CharSequence)i18nKey)) {
            return;
        }
        String elsAccount = CharSequenceUtil.emptyToDefault((CharSequence)TenantContext.getTenant(), (String)"100000");
        List<LocalCacheKey> removeKeys = userLanguageCache.keySet().parallelStream().filter(x -> i18nKey.equals(x.getI18nKey()) && elsAccount.equals(x.getElsAccount())).collect(Collectors.toList());
        removeKeys.forEach(userLanguageCache::remove);
    }

    public static void removeBykeys(List<String> i18nKeys) {
        if (CollectionUtil.isEmpty(i18nKeys)) {
            return;
        }
        String elsAccount = CharSequenceUtil.emptyToDefault((CharSequence)TenantContext.getTenant(), (String)"100000");
        List<LocalCacheKey> removeKeys = userLanguageCache.keySet().parallelStream().filter(x -> i18nKeys.contains(x.getI18nKey()) && elsAccount.equals(x.getElsAccount())).collect(Collectors.toList());
        removeKeys.forEach(userLanguageCache::remove);
    }

    public static void removeByElsAccount(String elsAccount) {
        if (StrUtil.isBlank((CharSequence)elsAccount)) {
            return;
        }
        List<LocalCacheKey> removeKeys = userLanguageCache.keySet().parallelStream().filter(x -> elsAccount.equals(x.getElsAccount())).collect(Collectors.toList());
        removeKeys.forEach(userLanguageCache::remove);
    }

    static class LocalCacheKey {
        String elsAccount;
        String language;
        String i18nKey;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalCacheKey key = (LocalCacheKey)o;
            return Objects.equals(this.elsAccount, key.elsAccount) && Objects.equals(this.language, key.language) && Objects.equals(this.i18nKey, key.i18nKey);
        }

        public int hashCode() {
            return Objects.hash(this.elsAccount, this.language, this.i18nKey);
        }

        public String getElsAccount() {
            return this.elsAccount;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }

        public void setElsAccount(String elsAccount) {
            this.elsAccount = elsAccount;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public void setI18nKey(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        public String toString() {
            return "PermissionI18LocalCacheInit.LocalCacheKey(elsAccount=" + this.getElsAccount() + ", language=" + this.getLanguage() + ", i18nKey=" + this.getI18nKey() + ")";
        }

        public LocalCacheKey(String elsAccount, String language, String i18nKey) {
            this.elsAccount = elsAccount;
            this.language = language;
            this.i18nKey = i18nKey;
        }

        public LocalCacheKey() {
        }
    }
}

