/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.esign.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.modules.base.api.service.FileRpcService;
import com.els.modules.esign.entity.PurchaseEsign;
import com.els.modules.esign.entity.PurchaseEsignAttachment;
import com.els.modules.esign.entity.PurchaseEsignSigners;
import com.els.modules.esign.entity.SaleEsign;
import com.els.modules.esign.entity.SaleEsignAttachment;
import com.els.modules.esign.enumerate.EsignSignerStatusEmun;
import com.els.modules.esign.enumerate.EsignStatusEmun;
import com.els.modules.esign.mapper.PurchaseEsignAttachmentMapper;
import com.els.modules.esign.mapper.PurchaseEsignMapper;
import com.els.modules.esign.mapper.PurchaseEsignSignersMapper;
import com.els.modules.esign.service.PurchaseEsignService;
import com.els.modules.esign.service.SaleEsignService;
import com.els.modules.esign.util.EsignFileEncryptUtil;
import com.els.modules.esign.util.EsignResultAnalysisUtil;
import com.els.modules.esign.util.FileHelper;
import com.els.modules.esign.vo.CreateFlowOneStep;
import com.els.modules.esign.vo.EsignAttachmentVO;
import com.els.modules.esign.vo.EsignAttachmentsVO;
import com.els.modules.esign.vo.EsignCopiersVO;
import com.els.modules.esign.vo.EsignDocsVO;
import com.els.modules.esign.vo.EsignFlowInfoVO;
import com.els.modules.esign.vo.EsignSignerVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEsignServiceImpl
extends BaseServiceImpl<PurchaseEsignMapper, PurchaseEsign>
implements PurchaseEsignService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEsignServiceImpl.class);
    private static final Integer A_SIGNED = 2;
    private static final Integer LOSE = 3;
    private static final Integer REFUSAL = 4;
    private static final String SIGN_FLOW_UPDATE = "SIGN_FLOW_UPDATE";
    private static final String SIGN_FLOW_FINISH = "SIGN_FLOW_FINISH";
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    private String address = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.address");
    @Autowired
    private PurchaseEsignMapper purchaseEsignMapper;
    @Autowired
    private PurchaseEsignSignersMapper purchaseEsignSignersMapper;
    @Autowired
    private PurchaseEsignAttachmentMapper purchaseEsignAttachmentMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleEsignService saleEsignService;
    @Autowired
    private FileRpcService fileRpcService;
    @Value(value="${els.storage.type}")
    private String storeType;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEsign purchaseEsign, List<PurchaseEsignSigners> purchaseEsignSignersList, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        purchaseEsign.setEsignNumber(this.invokeBaseRpcService.getNextCode("srmEsignNumber", (Object)purchaseEsign));
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseEsign.setElsAccount(loginUser.getElsAccount());
        purchaseEsign.setBusAccount("100000");
        purchaseEsign.setPurchaseName(loginUser.getEnterpriseName());
        this.purchaseEsignMapper.insert((Object)purchaseEsign);
        this.insertData(purchaseEsign, purchaseEsignSignersList, purchaseEsignAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEsign purchaseEsign, List<PurchaseEsignSigners> purchaseEsignSignersList, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        if (purchaseEsignSignersList != null && purchaseEsignSignersList.size() > 0) {
            purchaseEsign.setMaintenanceSignatory("1");
        }
        this.purchaseEsignMapper.updateById((Object)purchaseEsign);
        this.purchaseEsignSignersMapper.deleteByMainId(purchaseEsign.getId());
        this.purchaseEsignAttachmentMapper.deleteByMainId(purchaseEsign.getId());
        this.insertData(purchaseEsign, purchaseEsignSignersList, purchaseEsignAttachmentList);
    }

    private void insertData(PurchaseEsign purchaseEsign, List<PurchaseEsignSigners> purchaseEsignSignersList, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        if (purchaseEsignSignersList != null) {
            for (PurchaseEsignSigners purchaseEsignSigners : purchaseEsignSignersList) {
                purchaseEsignSigners.setHeadId(purchaseEsign.getId());
                SysUtil.setSysParam((BaseEntity)purchaseEsignSigners, (BaseEntity)purchaseEsign);
            }
            if (!purchaseEsignSignersList.isEmpty()) {
                this.purchaseEsignSignersMapper.insertBatchSomeColumn(purchaseEsignSignersList);
            }
        }
        if (purchaseEsignAttachmentList != null) {
            for (PurchaseEsignAttachment purchaseEsignAttachment : purchaseEsignAttachmentList) {
                purchaseEsignAttachment.setHeadId(purchaseEsign.getId());
                SysUtil.setSysParam((BaseEntity)purchaseEsignAttachment, (BaseEntity)purchaseEsign);
            }
            if (!purchaseEsignAttachmentList.isEmpty()) {
                this.purchaseEsignAttachmentMapper.insertBatchSomeColumn(purchaseEsignAttachmentList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseEsignSignersMapper.deleteByMainId(id);
        this.purchaseEsignAttachmentMapper.deleteByMainId(id);
        this.purchaseEsignMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseEsignSignersMapper.deleteByMainId(serializable.toString());
            this.purchaseEsignAttachmentMapper.deleteByMainId(serializable.toString());
            this.purchaseEsignMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void uploadToEsign(PurchaseEsign purchaseEsign, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        String path = null;
        InputStream inputStream = null;
        byte[] fileBytes = null;
        try {
            try {
                for (PurchaseEsignAttachment purchaseEsignAttachment : purchaseEsignAttachmentList) {
                    path = String.valueOf(this.uploadpath) + purchaseEsignAttachment.getFilePath();
                    File file = new File(path);
                    boolean flag = false;
                    if (!file.exists()) {
                        String filePath = this.fileRpcService.getRealPath(purchaseEsignAttachment.getFilePath(), this.storeType, false);
                        log.info("filePath is [{}]", (Object)filePath);
                        fileBytes = EsignFileEncryptUtil.getFileByUrl(filePath);
                        flag = true;
                    }
                    if (!file.exists() && !flag) continue;
                    log.info("flag is [{}]", (Object)flag);
                    inputStream = flag ? new ByteArrayInputStream(fileBytes) : new BufferedInputStream(new FileInputStream(file));
                    byte[] bytes = EsignFileEncryptUtil.getFileMD5Bytes1282(inputStream);
                    String contentMD5 = EsignFileEncryptUtil.getStringContentMD5(bytes);
                    int fileSize = bytes.length;
                    EsignAttachmentVO attachmentVO = null;
                    int lastIndexOf = path.lastIndexOf("/");
                    attachmentVO = path.endsWith(".pdf") ? new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), fileSize, null) : new EsignAttachmentVO(contentMD5, path.substring(lastIndexOf + 1), fileSize, "application/octet-stream");
                    JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)attachmentVO)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("upload-file"));
                    Result<?> responseResult = EsignResultAnalysisUtil.analysisResult(object);
                    if (!responseResult.isSuccess()) continue;
                    JSONObject jsonObject = (JSONObject)responseResult.getResult();
                    String uploadUrl = jsonObject.getString("uploadUrl");
                    String fileId = jsonObject.getString("fileId");
                    purchaseEsignAttachment.setFileId(fileId);
                    purchaseEsignAttachment.setUploadFileName(String.valueOf(purchaseEsignAttachment.getFileName().substring(0, purchaseEsignAttachment.getFileName().indexOf(".") - 1)) + ".pdf");
                    try {
                        if (flag) {
                            FileHelper.streamUploadFile(fileBytes, path, uploadUrl, attachmentVO.getContentMd5());
                        } else {
                            FileHelper.streamUpload(path, uploadUrl, attachmentVO.getContentMd5());
                        }
                        purchaseEsignAttachment.setUploaded("1");
                        this.purchaseEsignAttachmentMapper.updateById((Object)purchaseEsignAttachment);
                        if (!"1".equals(purchaseEsignAttachment.getEsignType())) continue;
                        purchaseEsign.setUploaded("1");
                    }
                    catch (Exception e) {
                        log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e381", (Throwable)e);
                        throw new ELSBootException(String.valueOf(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a")) + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e382", (Throwable)e);
                throw new ELSBootException(String.valueOf(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a")) + e.getMessage());
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
        this.updateById((Object)purchaseEsign);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void launchOneStepEsign(PurchaseEsign purchaseEsign, List<PurchaseEsignSigners> purchaseEsignSignersList, List<PurchaseEsignAttachment> purchaseEsignAttachmentList) {
        purchaseEsign.setLaunch("1");
        if ("1".equals(purchaseEsign.getAutoInitiate())) {
            purchaseEsign.setInitiate("1");
        }
        this.updateMain(purchaseEsign, purchaseEsignSignersList, purchaseEsignAttachmentList);
        PurchaseEsignSigners mainSinger = null;
        CreateFlowOneStep oneStep = new CreateFlowOneStep();
        ArrayList<EsignCopiersVO> copiersVOs = new ArrayList<EsignCopiersVO>();
        for (PurchaseEsignSigners esignSigners : purchaseEsignSignersList) {
            if ("1".equals(esignSigners.getPersonType())) {
                copiersVOs.add(new EsignCopiersVO(esignSigners));
                continue;
            }
            mainSinger = esignSigners;
        }
        oneStep.setCopiers(copiersVOs);
        ArrayList<EsignDocsVO> docs = new ArrayList<EsignDocsVO>();
        ArrayList<EsignAttachmentsVO> attachments = new ArrayList<EsignAttachmentsVO>();
        for (PurchaseEsignAttachment attachment : purchaseEsignAttachmentList) {
            if (!"1".equals(attachment.getUploaded())) continue;
            if ("1".equals(attachment.getEsignType())) {
                docs.add(new EsignDocsVO(attachment));
                continue;
            }
            attachments.add(new EsignAttachmentsVO(attachment));
        }
        oneStep.setAttachments(attachments);
        oneStep.setDocs(docs);
        String notifyUrl = "";
        notifyUrl = this.address.endsWith("/") ? String.valueOf(this.address) + "els/esign/purchaseEsign/noToken/callback" : String.valueOf(this.address) + "/" + "els/esign/purchaseEsign/noToken/callback";
        EsignFlowInfoVO flowInfo = new EsignFlowInfoVO(purchaseEsign, mainSinger, notifyUrl);
        oneStep.setFlowInfo(flowInfo);
        ArrayList<EsignSignerVO> signers = new ArrayList<EsignSignerVO>();
        signers.add(new EsignSignerVO(mainSinger, docs, 1L));
        oneStep.setSigners(signers);
        JSONObject object = this.invokeBaseRpcService.callIPaasInterface(JSONObject.parseObject((String)JSONObject.toJSONString((Object)oneStep)), this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("one-step-flow-start"));
        Result<?> response = EsignResultAnalysisUtil.analysisResult(object);
        if (!response.isSuccess()) {
            throw new ELSBootException(String.valueOf(I18nUtil.translate((String)"i18n_alert_IxPWhAKmW_f40249c7", (String)"\u4e00\u6b65\u7b7e\u7f72\u53d1\u8d77\u5931\u8d25:")) + response.getMessage());
        }
        JSONObject jsonObject = (JSONObject)response.getResult();
        purchaseEsign.setFlowId(jsonObject.getString("flowId"));
        purchaseEsign.setLaunch("1");
        purchaseEsign.setEsignStatus(EsignStatusEmun.UNFINISHED.getValue());
        if ("1".equals(purchaseEsign.getAutoInitiate())) {
            purchaseEsign.setInitiate("1");
        }
        this.updateById((Object)purchaseEsign);
        for (PurchaseEsignSigners esignSigners : purchaseEsignSignersList) {
            esignSigners.setFlowId(purchaseEsign.getFlowId());
            this.purchaseEsignSignersMapper.updateById((Object)esignSigners);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void callback(JSONObject object) {
        if (SIGN_FLOW_UPDATE.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            wrapper.eq((Object)"account_id", (Object)object.getString("accountId"));
            wrapper.eq((Object)"person_type", (Object)"0");
            PurchaseEsignSigners esignSigners = (PurchaseEsignSigners)((Object)this.purchaseEsignSignersMapper.selectOne((Wrapper)wrapper));
            if (esignSigners != null) {
                if (A_SIGNED.equals(object.getInteger("signResult"))) {
                    esignSigners.setEsignStatus(EsignSignerStatusEmun.A_SIGNED.getValue());
                } else if (LOSE.equals(object.getInteger("signResult"))) {
                    esignSigners.setEsignStatus(EsignSignerStatusEmun.LOSE.getValue());
                    esignSigners.setReason(object.getString("resultDescription"));
                } else if (REFUSAL.equals(object.getInteger("signResult"))) {
                    esignSigners.setEsignStatus(EsignSignerStatusEmun.REFUSAL.getValue());
                    esignSigners.setReason(object.getString("resultDescription"));
                }
                this.purchaseEsignSignersMapper.updateById((Object)esignSigners);
            }
        } else if (SIGN_FLOW_FINISH.equals(object.getString("action"))) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"flow_id", (Object)object.getString("flowId"));
            PurchaseEsign esign = (PurchaseEsign)((Object)this.purchaseEsignMapper.selectOne((Wrapper)wrapper));
            if (esign != null) {
                esign.setEsignStatus(object.getString("flowStatus"));
                if (EsignStatusEmun.UNDONE.getValue().equals(object.getString("flowStatus"))) {
                    esign.setLaunch("0");
                }
                esign.setReason(object.getString("statusDescription"));
                if (EsignStatusEmun.FINISHED.getValue().equals(esign.getEsignStatus())) {
                    if ("1".equals(esign.getAutoArchiving())) {
                        esign.setArchiving("1");
                    }
                    List<PurchaseEsignAttachment> attachments = this.purchaseEsignAttachmentMapper.selectByMainId(esign.getId());
                    JSONObject requestJSON = new JSONObject();
                    JSONObject bascis = new JSONObject();
                    bascis.put("flowId", (Object)esign.getFlowId());
                    requestJSON.put("base", (Object)bascis);
                    requestJSON.put("currentAccount", (Object)esign.getElsAccount());
                    JSONObject resultObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-file-download"));
                    Result<?> response = EsignResultAnalysisUtil.analysisResult(resultObject);
                    if (response.isSuccess()) {
                        JSONObject jsonObject = (JSONObject)response.getResult();
                        JSONArray array = jsonObject.getJSONArray("docs");
                        for (Object object2 : array) {
                            JSONObject doc = JSONObject.parseObject((String)object2.toString());
                            String filePath = doc.getString("fileUrl");
                            String fileName = doc.getString("fileName");
                            String fileId = doc.getString("fileId");
                            String savePath = this.downloadFile(filePath, fileName, esign.getElsAccount());
                            if (savePath.contains("\\")) {
                                savePath = savePath.replace("\\", "/");
                            }
                            for (PurchaseEsignAttachment attachment : attachments) {
                                if (!fileId.equals(attachment.getFileId()) || !"1".equals(attachment.getEsignType())) continue;
                                attachment.setEsignFilePath(savePath);
                                this.purchaseEsignAttachmentMapper.updateById((Object)attachment);
                            }
                        }
                    }
                    if ("1".equals(esign.getAutoSend())) {
                        SaleEsign saleEsign = new SaleEsign();
                        BeanUtils.copyProperties((Object)((Object)esign), (Object)((Object)saleEsign));
                        saleEsign.setElsAccount(esign.getToElsAccount());
                        saleEsign.setToElsAccount(esign.getElsAccount());
                        saleEsign.setRelationId(esign.getId());
                        ArrayList<SaleEsignAttachment> saleEsignAttachments = new ArrayList<SaleEsignAttachment>();
                        for (PurchaseEsignAttachment purchaseEsignAttachment : attachments) {
                            SaleEsignAttachment attachment = new SaleEsignAttachment();
                            BeanUtils.copyProperties((Object)((Object)purchaseEsignAttachment), (Object)((Object)attachment));
                            attachment.setElsAccount(saleEsign.getElsAccount());
                            attachment.setId(null);
                            attachment.setHeadId(null);
                            saleEsignAttachments.add(attachment);
                        }
                        this.saleEsignService.saveMain(saleEsign, saleEsignAttachments);
                        esign.setRelationId(saleEsign.getId());
                        esign.setSendStatus("1");
                        ArrayList<String> receiveAccount = new ArrayList<String>();
                        receiveAccount.add(esign.getToElsAccount());
                        super.sendMsg(esign.getElsAccount(), receiveAccount, (Object)esign, "", "esign", "publish");
                    }
                }
                this.updateById((Object)esign);
            }
        }
    }

    public String downloadFile(String filePath, String fileName, String elsAccount) {
        String nowDay;
        block19: {
            InputStream inputStream = null;
            OutputStream os = null;
            LocalDateTime time = LocalDateTime.now();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
            nowDay = dtf.format(time);
            try {
                try {
                    int len;
                    URL url = new URL(filePath);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setReadTimeout(3000);
                    connection.setRequestProperty("User-Agent", "Mozilla/4.e ( compatible;MSIE 5.0; windows NT; DigExt)");
                    inputStream = connection.getInputStream();
                    File file = new File(String.valueOf(this.uploadpath) + File.separator + "esign" + File.separator + elsAccount + File.separator + nowDay);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    byte[] bs = new byte[1024];
                    fileName = String.valueOf(File.separator) + System.currentTimeMillis() + "_" + fileName;
                    os = new FileOutputStream(String.valueOf(file.getPath()) + fileName);
                    while ((len = inputStream.read(bs)) != -1) {
                        os.write(bs, 0, len);
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (os != null) {
                            os.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException2) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        os.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (os != null) {
                    os.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return String.valueOf(File.separator) + "esign" + File.separator + elsAccount + File.separator + nowDay + fileName;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void send(String id) {
        ArrayList<SaleEsignAttachment> saleEsignAttachments;
        SaleEsign saleEsign;
        PurchaseEsign esign = (PurchaseEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            saleEsign = new SaleEsign();
            BeanUtils.copyProperties((Object)((Object)esign), (Object)((Object)saleEsign));
            saleEsign.setElsAccount(esign.getToElsAccount());
            saleEsign.setToElsAccount(esign.getElsAccount());
            saleEsign.setRelationId(esign.getId());
            List<PurchaseEsignAttachment> attachments = this.purchaseEsignAttachmentMapper.selectByMainId(esign.getId());
            saleEsignAttachments = new ArrayList<SaleEsignAttachment>();
            for (PurchaseEsignAttachment purchaseEsignAttachment : attachments) {
                SaleEsignAttachment attachment = new SaleEsignAttachment();
                BeanUtils.copyProperties((Object)((Object)purchaseEsignAttachment), (Object)((Object)attachment));
                attachment.setElsAccount(saleEsign.getElsAccount());
                attachment.setId(null);
                attachment.setHeadId(null);
                saleEsignAttachments.add(attachment);
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tFxMK_c4afc444", (String)"\u5355\u636e\u4e0d\u5b58\u5728"));
        }
        this.saleEsignService.saveMain(saleEsign, saleEsignAttachments);
        esign.setRelationId(saleEsign.getId());
        esign.setSendStatus("1");
        this.updateById((Object)esign);
        ArrayList<String> receiveAccount = new ArrayList<String>();
        receiveAccount.add(esign.getToElsAccount());
        super.sendMsg(esign.getElsAccount(), receiveAccount, (Object)esign, "", "esign", "publish");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrReject(PurchaseEsign esign, String operate) {
        if ("confirm".equals(operate)) {
            esign.setReturnFileConfirm("1");
        }
        if ("reject".equals(operate)) {
            esign.setReject("1");
        }
        SaleEsign saleEsign = (SaleEsign)((Object)this.saleEsignService.getById((Serializable)((Object)esign.getRelationId())));
        saleEsign.setReturnFileConfirm(esign.getReturnFileConfirm());
        saleEsign.setReject(esign.getReject());
        saleEsign.setRejectReason(esign.getRejectReason());
        this.saleEsignService.updateById((Object)saleEsign);
        this.updateById((Object)esign);
        ArrayList<String> receiveAccount = new ArrayList<String>();
        receiveAccount.add(esign.getToElsAccount());
        if ("confirm".equals(operate)) {
            super.sendMsg(esign.getElsAccount(), receiveAccount, (Object)esign, "", "esign", "confirm");
        } else {
            super.sendMsg(esign.getElsAccount(), receiveAccount, (Object)esign, "", "esign", "refund");
        }
    }

    @Override
    public Result<?> flowQuery(String id) {
        PurchaseEsign esign = (PurchaseEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("query-esign-flow"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(String.valueOf(I18nUtil.translate((String)"i18n_alert_PWQLmhKmW_8344aceb", (String)"\u7b7e\u7f72\u6d41\u7a0b\u67e5\u8be2\u5931\u8d25:")) + response.getMessage()));
            }
            JSONObject data = (JSONObject)response.getResult();
            String status = data.getString("flowStatus");
            if (EsignStatusEmun.FINISHED.getValue().equals(status)) {
                esign.setEsignStatus(EsignStatusEmun.FINISHED.getValue());
                if ("1".equals(esign.getAutoArchiving())) {
                    esign.setArchiving("1");
                }
                ((PurchaseEsignMapper)this.baseMapper).updateById((Object)esign);
            }
            return Result.ok((Object)response.getResult());
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
    }

    @Override
    public Result<?> signFileDownload(String id) {
        PurchaseEsign esign = (PurchaseEsign)((Object)this.getById((Serializable)((Object)id)));
        if (esign != null) {
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            bascis.put("flowId", (Object)esign.getFlowId());
            requestJSON.put("base", (Object)bascis);
            JSONObject jsonObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("flow-file-download"));
            Result<?> response = EsignResultAnalysisUtil.analysisResult(jsonObject);
            if (!response.isSuccess()) {
                return Result.error((String)(String.valueOf(I18nUtil.translate((String)"i18n_alert_QLQAIKKySMKmW_255987a8", (String)"\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u94fe\u63a5\u83b7\u53d6\u5931\u8d25:")) + response.getMessage()));
            }
            JSONObject object = (JSONObject)response.getResult();
            return Result.ok((Object)object.getJSONArray("docs"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
    }
}

