/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.system.wp.WechatEnterpriseApiUtil;
import com.els.common.system.wp.WechatEnterpriseProperties;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.justauth.entity.JustAuthConfig;
import com.els.modules.justauth.service.JustAuthConfigService;
import com.els.modules.system.util.QRCodeUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"JustAuth\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/account/justAuthConfig"})
public class JustAuthConfigController
extends BaseController<JustAuthConfig, JustAuthConfigService> {
    @Autowired
    private JustAuthConfigService justAuthConfigService;
    @Autowired
    private WechatEnterpriseApiUtil wechatEnterpriseApiUtil;
    @Autowired
    private WechatEnterpriseProperties wpProperties;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(JustAuthConfig justAuthConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)justAuthConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        IPage pageList = this.justAuthConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/companyList"})
    public Result<?> queryCompanyPageList(JustAuthConfig authConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)authConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<JustAuthConfig> pageList = this.justAuthConfigService.findPageList((Page<JustAuthConfig>)page, (QueryWrapper<JustAuthConfig>)queryWrapper);
        return Result.ok(pageList);
    }

    @SrmValidated
    @AutoLog(value="JustAuth\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"justAuthConfig#JustAuthConfig:add"})
    public Result<?> add(@RequestBody JustAuthConfig justAuthConfig) {
        this.justAuthConfigService.saveJustAuth(justAuthConfig);
        return Result.ok((Object)((Object)justAuthConfig));
    }

    @SrmValidated
    @AutoLog(value="JustAuth\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"justAuthConfig#JustAuthConfig:edit"})
    public Result<?> edit(@RequestBody JustAuthConfig justAuthConfig) {
        String authType = justAuthConfig.getAuthType();
        this.justAuthConfigService.updateJustAuth(justAuthConfig);
        ThirdTokenUtil.cleanToken((String)authType, (String)justAuthConfig.getElsAccount());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="JustAuth\u914d\u7f6e-\u4f01\u4e1a\u7ea7\u7f16\u8f91")
    @ApiOperation(value="\u4f01\u4e1a\u7ea7\u7f16\u8f91", notes="\u4f01\u4e1a\u7ea7\u7f16\u8f91")
    @PostMapping(value={"/companyEdit"})
    @RequiresPermissions(value={"justAuthConfig#JustAuthConfig:companyEdit"})
    public Result<?> companyEdit(@RequestBody JustAuthConfig justAuthConfig) {
        this.justAuthConfigService.companyEdit(justAuthConfig);
        ThirdTokenUtil.cleanToken((String)justAuthConfig.getAuthType(), (String)justAuthConfig.getElsAccount());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="JustAuth\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"justAuthConfig#JustAuthConfig:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.justAuthConfigService.removeById((Serializable)((Object)id));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u7b2c\u4e09\u65b9\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u7b2c\u4e09\u65b9\u5217\u8868")
    @GetMapping(value={"/getBindList"})
    public Result<?> getBindList() {
        return Result.ok(this.justAuthConfigService.findBindList(this.getTenantId(), SysUtil.getLoginUser().getId()));
    }

    @RequiresPermissions(value={"justAuthConfig#JustAuthConfig:getCustomizedAuthQCode"})
    @GetMapping(value={"/getCustomizedAuthQCode"})
    public Result<?> getCustomizedAuthUrlCode() throws Exception {
        JustAuthConfig wechatMp = this.justAuthConfigService.getOneConfig("100000", "WECHAT_ENTERPRISE_DEVELOP", "templateConfig");
        if (null == wechatMp) {
            throw new ELSBootException("\u4e0d\u5b58\u5728\u5fae\u4fe1\u4f01\u4e1a\u4ee3\u5f00\u53d1\u5e94\u7528\u914d\u7f6e");
        }
        String qrCode = QRCodeUtil.createQRCode(this.wechatEnterpriseApiUtil.getCustomizedAuthUrl(wechatMp.getClientId(), wechatMp.getClientSecret(), "123456", (List)Lists.newArrayList((Object[])wechatMp.getSuiteId().split(","))));
        return Result.ok((String)qrCode);
    }
}

