/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.listener.schedule;

import cn.hutool.core.date.DateUtil;
import com.els.modules.system.listener.schedule.DynamicCronTaskRegistrar;
import com.els.modules.system.listener.schedule.model.DynamicSchedulingRunnable;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionScheduledBuilder {
    private static final Logger log = LoggerFactory.getLogger(PermissionScheduledBuilder.class);
    @Resource(name="dynamicCronTaskRegistrar")
    private DynamicCronTaskRegistrar dynamicCronTaskRegistrar;
    private final String serviceImpl;
    private final String method;

    public PermissionScheduledBuilder(String serviceImpl, String method) {
        this.serviceImpl = serviceImpl;
        this.method = method;
    }

    public DynamicSchedulingRunnable buildScheduled(Integer timespanSecond, Integer delayedSecond) {
        DynamicSchedulingRunnable task = new DynamicSchedulingRunnable(this.serviceImpl, this.method, timespanSecond);
        this.removeDynamicSchedulingRunnable(timespanSecond);
        this.removeDynamicSchedulingRunnable(delayedSecond);
        this.dynamicCronTaskRegistrar.addCronTaskDate(task, (Date)DateUtil.offsetSecond((Date)new Date(), (int)timespanSecond));
        this.dynamicCronTaskRegistrar.addCronTaskDate(task, (Date)DateUtil.offsetSecond((Date)new Date(), (int)delayedSecond));
        return task;
    }

    public void removeDynamicSchedulingRunnable(Integer delayedSecond) {
        DynamicSchedulingRunnable task = new DynamicSchedulingRunnable(this.serviceImpl, this.method, delayedSecond);
        this.dynamicCronTaskRegistrar.removeCronTask(task);
    }
}

