/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.trace.TraceIdHolder;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.MD5Util;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.enumerate.MenuAttributeEnum;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.MqMessagePersistenceDTO;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.CompanyPermissionMapper;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.RolePermissionMapper;
import com.els.modules.system.model.TreeModel;
import com.els.modules.system.rocketMq.OutputReBuildSaleMenuSource;
import com.els.modules.system.rocketMq.util.InitReportDataMqUtil;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.rpc.service.InvokeSupplierRpcService;
import com.els.modules.system.service.CompanyPermissionService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.AccountRoleVO;
import com.els.modules.system.vo.I18KeyValueVo;
import com.els.modules.system.vo.PermissionVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PermissionServiceImpl
extends ServiceImpl<PermissionMapper, Permission>
implements PermissionService {
    private static final Logger log = LoggerFactory.getLogger(PermissionServiceImpl.class);
    @Resource
    private PermissionMapper permissionMapper;
    @Resource
    private RolePermissionService rolePermissionService;
    @Resource
    private ElsSubAccountMapper elsSubAccountMapper;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private CompanyPermissionService companyPermissionService;
    @Resource
    private InvokeSupplierRpcService invokeSupplierRpcService;
    @Resource
    private CompanyPermissionMapper companyPermissionMapper;
    @Resource
    private RolePermissionMapper rolePermissionMapper;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<TreeModel> queryListByParentId(String parentId) {
        return this.permissionMapper.queryListByParentId(parentId);
    }

    @Override
    @SrmTransaction
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void deletePermission(String id) throws ELSBootException {
        int count;
        Permission sysPermission = (Permission)this.getById((Serializable)((Object)id));
        if (sysPermission == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYuntVH_24eb9383", (String)"\u672a\u627e\u5230\u83dc\u5355\u4fe1\u606f"));
        }
        String pid = sysPermission.getParentId();
        if (ConvertUtils.isNotEmpty((Object)pid) && (count = this.count((Wrapper)new QueryWrapper().lambda().eq(Permission::getParentId, (Object)pid))) == 1) {
            this.permissionMapper.setMenuLeaf(pid, 1);
        }
        this.permissionMapper.deleteById((Serializable)((Object)id));
        this.removeChildrenBy(sysPermission.getId());
    }

    public void removeChildrenBy(String parentId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(Permission::getParentId, (Object)parentId);
        List permissionList = this.list((Wrapper)query);
        if (permissionList != null && permissionList.size() > 0) {
            String id = "";
            int num = 0;
            this.remove((Wrapper)query);
            int len = permissionList.size();
            for (int i = 0; i < len; ++i) {
                id = ((Permission)permissionList.get(i)).getId();
                num = this.count((Wrapper)new LambdaQueryWrapper().eq(Permission::getParentId, (Object)id));
                if (num <= 0) continue;
                this.removeChildrenBy(id);
            }
        }
    }

    @Override
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void addPermission(Permission sysPermission) throws ELSBootException {
        String pid;
        if (CommonConstant.MENU_TYPE_0.equals(sysPermission.getMenuType())) {
            sysPermission.setParentId(null);
        }
        if (!MenuAttributeEnum.SALE.getCode().equals(sysPermission.getMenuAttribute())) {
            sysPermission.setPurchasePermissionId("");
        }
        if (ConvertUtils.isNotEmpty((Object)(pid = sysPermission.getParentId()))) {
            this.permissionMapper.setMenuLeaf(pid, 0);
        }
        sysPermission.setCreateTime(new Date());
        sysPermission.setDeleted(CommonConstant.DEL_FLAG_0);
        sysPermission.setLeaf(true);
        this.save(sysPermission);
    }

    @Override
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void editPermission(Permission sysPermission) throws ELSBootException {
        int count;
        Permission p = (Permission)this.getById((Serializable)((Object)sysPermission.getId()));
        if (!p.getName().equals(sysPermission.getName().trim())) {
            sysPermission.setNameI18nKey(this.invokeBaseRpcService.checkAndAdd(sysPermission.getName(), "menu"));
        }
        sysPermission.setUpdateTime(new Date());
        if (CommonConstant.MENU_TYPE_0.equals(sysPermission.getMenuType())) {
            sysPermission.setParentId("");
        }
        if ((count = this.count((Wrapper)new QueryWrapper().lambda().eq(Permission::getParentId, (Object)sysPermission.getId()))) == 0) {
            sysPermission.setLeaf(true);
        }
        if (!MenuAttributeEnum.SALE.getCode().equals(sysPermission.getMenuAttribute())) {
            sysPermission.setPurchasePermissionId("");
        }
        this.updateById(sysPermission);
        String pid = sysPermission.getParentId();
        if (ConvertUtils.isNotEmpty((Object)pid) && !pid.equals(p.getParentId()) || ConvertUtils.isEmpty((Object)pid) && ConvertUtils.isNotEmpty((Object)p.getParentId())) {
            this.permissionMapper.setMenuLeaf(pid, 0);
            int cc = this.count((Wrapper)new QueryWrapper().lambda().eq(Permission::getParentId, (Object)p.getParentId()));
            if (cc == 0 && ConvertUtils.isNotEmpty((Object)p.getParentId())) {
                this.permissionMapper.setMenuLeaf(p.getParentId(), 1);
            }
        }
    }

    @Override
    public List<PermissionVO> queryByAccount(String elsAccount, String subAccount, Integer mobile) {
        String adminFlag = AdminFlagUtil.getAdminFlag();
        String deployWay = SysUtil.getDeployWay();
        if ("cloud".equals(deployWay)) {
            if ("1".equals(adminFlag)) {
                return ((PermissionMapper)this.baseMapper).getCompanyMenuList(elsAccount);
            }
            return this.permissionMapper.queryByAccount(elsAccount, subAccount, mobile);
        }
        if ("1".equals(adminFlag)) {
            String purchaseAccount = SysUtil.getPurchaseAccount();
            List<PermissionVO> list = ((PermissionMapper)this.baseMapper).getLocalCompanyMenuList(elsAccount);
            if (elsAccount.equals(purchaseAccount)) {
                return list.stream().filter(o -> !"2".equals(o.getMenuAttribute())).collect(Collectors.toList());
            }
            List<PermissionVO> authList = ((PermissionMapper)this.baseMapper).queryLocalByGroup(purchaseAccount, elsAccount);
            if (!authList.isEmpty()) {
                return authList;
            }
            return list.stream().filter(o -> "2".equals(o.getMenuAttribute()) || "3".equals(o.getMenuAttribute())).collect(Collectors.toList());
        }
        return this.permissionMapper.queryLocalByAccount(elsAccount, subAccount);
    }

    public List<PermissionVO> queryPermissionI18ByAccount() {
        List<I18KeyValueVo> list = ((PermissionMapper)this.baseMapper).selectWithoutElsAccountToLoadPermissionI18();
        return null;
    }

    @Override
    public List<String> getCompanyMenuIdList(String elsAccount) {
        return this.permissionMapper.getCompanyMenuIdList(elsAccount);
    }

    @Override
    public AccountRoleVO checkAccountRole(String elsAccount, String subAccount, Integer mobile) {
        List<String> permissionVOList = this.permissionMapper.selectWithoutElsAccountToCheckAccountRole(elsAccount, subAccount, mobile);
        return new AccountRoleVO(permissionVOList.contains(MenuAttributeEnum.SALE.getCode()), permissionVOList.contains(MenuAttributeEnum.PURCHASE.getCode()));
    }

    @Override
    public List<PermissionVO> queryByUser(String username) {
        return this.permissionMapper.queryAllByUser(username);
    }

    @Override
    @Cacheable(value={"sys:cache:permission:datarules"})
    public List<String> queryPermissionUrlWithStar() {
        return ((PermissionMapper)this.baseMapper).queryPermissionUrlWithStar();
    }

    @Override
    public List<PermissionVO> getCompanyMenuList(String elsAccount) {
        String deployWay = SysUtil.getDeployWay();
        if ("cloud".equals(deployWay)) {
            return ((PermissionMapper)this.baseMapper).getCompanyMenuList(elsAccount);
        }
        String purchaseAccount = SysUtil.getPurchaseAccount();
        List<PermissionVO> list = ((PermissionMapper)this.baseMapper).getLocalCompanyMenuList(elsAccount);
        if (elsAccount.equals(purchaseAccount)) {
            return list.stream().filter(o -> !"2".equals(o.getMenuAttribute())).collect(Collectors.toList());
        }
        List<PermissionVO> authList = ((PermissionMapper)this.baseMapper).queryLocalByGroup(purchaseAccount, elsAccount);
        if (!authList.isEmpty()) {
            return authList;
        }
        return list.stream().filter(o -> "2".equals(o.getMenuAttribute()) || "3".equals(o.getMenuAttribute())).collect(Collectors.toList());
    }

    @Override
    public void editCompanyPermission(Permission permission) {
        LoginUser sysUser = SysUtil.getLoginUser();
        permission.setUpdateBy(sysUser.getSubAccount());
        permission.setUpdateTime(new Date());
        ((PermissionMapper)this.baseMapper).updateCompanyMeun(permission);
    }

    @Override
    public void saveCompanyPermission(String elsAccount, String permissionIds, String lastPermissionIds) {
        ArrayList delete;
        List<Object> add = this.getDiff(lastPermissionIds, permissionIds);
        Date currentDate = new Date();
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        if (add != null && add.size() > 0) {
            ArrayList<CompanyPermission> list = new ArrayList<CompanyPermission>();
            ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
            TenantContext.setTenant((String)elsAccount);
            Role role = (Role)this.roleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"role_code", (Object)"companyAdmin"));
            for (String p : add) {
                if (!ConvertUtils.isNotEmpty((Object)p)) continue;
                CompanyPermission permission = new CompanyPermission();
                permission.setId(IdWorker.getIdStr());
                permission.setPermissionId(p);
                permission.setElsAccount(elsAccount);
                permission.setCreateTime(currentDate);
                permission.setUpdateTime(currentDate);
                permission.setCreateBy(currentUser);
                permission.setUpdateBy(currentUser);
                list.add(permission);
                if (role == null) continue;
                RolePermission rolePermission = new RolePermission();
                rolePermission.setId(IdWorker.getIdStr());
                rolePermission.setPermissionId(p);
                rolePermission.setRoleId(role.getId());
                rolePermissionList.add(rolePermission);
            }
            if (!list.isEmpty()) {
                this.permissionMapper.insertCompanyMeunBatch(list);
            }
            if (!rolePermissionList.isEmpty()) {
                this.rolePermissionService.saveBatch(rolePermissionList);
            }
        }
        if (CollUtil.isNotEmpty(delete = this.getDiff(permissionIds, lastPermissionIds))) {
            this.permissionMapper.deleteCompanyMeunByAccountAndPermissionIds(delete, elsAccount);
            this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).in(RolePermission::getPermissionId, (Collection)delete));
        }
        if (CollectionUtils.isEmpty(add)) {
            add = Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(delete)) {
            delete = Lists.newArrayList();
        }
        List<String> elsAccountAddList = this.permissionMapper.selectWithoutElsAccountToLoadExistCommAndPurchasePermissionId("100000", elsAccount);
        add.addAll(elsAccountAddList);
        add.removeAll(delete);
        add = add.stream().distinct().collect(Collectors.toList());
        this.rebuildSaleMenu(Collections.singletonList(elsAccount), add, delete, "modify", null, null);
        this.shareReportMenuData(elsAccount);
    }

    @Override
    public void saveCompanyPermissionList(List<String> elsAccountList, String permissionIds, String lastPermissionIds) {
        List companyPermissionListInit = ((LambdaQueryChainWrapper)this.companyPermissionService.lambdaQuery().in(CompanyPermission::getElsAccount, elsAccountList)).list();
        Map<String, List<String>> oldMenuMap = null;
        oldMenuMap = companyPermissionListInit.stream().collect(Collectors.groupingBy(CompanyPermission::getElsAccount, Collectors.mapping(CompanyPermission::getPermissionId, Collectors.toList())));
        List permissionIdList = Arrays.asList(permissionIds.split(",")).stream().map(block -> block.trim()).collect(Collectors.toList());
        List itemList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(Permission::getId, permissionIdList)).list();
        if (itemList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LEiFPzEntWtkKm_c8db08d1", (String)"\u672a\u914d\u9009\u62e9\u8981\u5206\u914d\u83dc\u5355\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        ArrayList<CompanyPermission> companyPermissionList = new ArrayList<CompanyPermission>();
        Date currentTime = new Date();
        for (String elsAccount : elsAccountList) {
            Object ro2;
            companyPermissionList.clear();
            for (Permission permission : itemList) {
                CompanyPermission companyPermission = new CompanyPermission();
                companyPermission.setId(IdWorker.getIdStr());
                companyPermission.setElsAccount(elsAccount);
                companyPermission.setPermissionId(permission.getId());
                companyPermission.setCreateTime(currentTime);
                companyPermissionList.add(companyPermission);
            }
            this.permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
            this.permissionMapper.insertCompanyMeunBatch(companyPermissionList);
            TenantContext.setTenant((String)elsAccount);
            List roleList = this.roleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"role_code", (Object)"companyAdmin")).or()).eq((Object)"role_code", (Object)"tuanduijuese");
            }));
            if (roleList.isEmpty()) {
                Role saveRole = new Role();
                saveRole.setId(IdWorker.getIdStr());
                saveRole.setElsAccount(elsAccount);
                saveRole.setRoleCode("companyAdmin");
                saveRole.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
                this.roleService.save(saveRole);
                Role saveRoleTuanDui = new Role();
                saveRoleTuanDui.setId(IdWorker.getIdStr());
                saveRoleTuanDui.setElsAccount(elsAccount);
                saveRoleTuanDui.setRoleCode("tuanduijuese");
                saveRoleTuanDui.setRoleName("\u56e2\u961f\u89d2\u8272");
                this.roleService.save(saveRoleTuanDui);
                roleList.add(saveRoleTuanDui);
            } else {
                for (Object ro2 : roleList) {
                    this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).eq(RolePermission::getRoleId, (Object)((Role)ro2).getId()));
                }
            }
            ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
            ro2 = itemList.iterator();
            while (ro2.hasNext()) {
                Permission permission = (Permission)ro2.next();
                for (Role ro3 : roleList) {
                    if (ro3.getRoleCode().equals("tuanduijuese") && "1369892937609248769,e8af452d8948ea49d37c934f5100ae6a".contains(permission.getId())) continue;
                    RolePermission rolePermission = new RolePermission();
                    rolePermission.setId(IdWorker.getIdStr());
                    rolePermission.setElsAccount(elsAccount);
                    rolePermission.setRoleId(ro3.getId());
                    rolePermission.setPermissionId(permission.getId());
                    rolePermissionList.add(rolePermission);
                }
            }
            this.rolePermissionService.saveBatch(rolePermissionList);
            ElsSubAccount subAccount = this.elsSubAccountMapper.getUserByAccount(elsAccount + "_" + "1001");
            if (subAccount == null) continue;
            String userId = subAccount.getId();
            Optional<Role> oRole = roleList.stream().filter(item -> "companyAdmin".equals(item.getRoleCode())).findFirst();
            Role role = null;
            if (!oRole.isPresent()) continue;
            role = oRole.get();
            List list = this.userRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).eq((Object)"role_id", (Object)role.getId()));
            if (!list.isEmpty()) continue;
            UserRole userRole = new UserRole();
            userRole.setId(IdWorker.getIdStr());
            userRole.setUserId(userId);
            userRole.setRoleId(role.getId());
            this.userRoleService.save(userRole);
        }
        this.shareReportMenuDataByRole(elsAccountList, itemList);
        if (CollUtil.isNotEmpty(oldMenuMap)) {
            this.rebuildSaleMenu(elsAccountList, null, null, "init", oldMenuMap, itemList.stream().map(Permission::getId).distinct().collect(Collectors.toList()));
        }
    }

    private void rebuildSaleMenu(List<String> elsAccountList, List<String> add, List<String> delete, String type, Map<String, List<String>> oldMenuMap, List<String> newMenuList) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("elsAccount", elsAccountList);
        jsonObject.put("add", add);
        jsonObject.put("delete", delete);
        jsonObject.put("type", (Object)type);
        jsonObject.put("oldMenuMap", oldMenuMap);
        jsonObject.put("newMenuList", newMenuList);
        jsonObject.put("traceId", (Object)("JOBAUTHORIZE" + TraceIdHolder.get()));
        ((OutputReBuildSaleMenuSource)SpringContextUtils.getBean(OutputReBuildSaleMenuSource.class)).outputReBuildSaleMenu().send(MessageBuilder.withPayload((Object)JSON.toJSONString((Object)jsonObject)).setHeader("KEYS", (Object)IdWorker.getIdStr()).build());
    }

    private List<String> getDiffPermissionId(List<String> newPermissionList, List<String> oldPermissionList) {
        if (CollUtil.isEmpty(oldPermissionList)) {
            return newPermissionList;
        }
        if (CollUtil.isEmpty(newPermissionList)) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList(newPermissionList);
        list.removeAll(oldPermissionList);
        return list;
    }

    private List<MqMessagePersistenceDTO> reBuildInitSaleMenu(JSONObject body) {
        List elsAccountList = body.getJSONArray("elsAccount").toJavaList(String.class);
        log.info(":::\u521d\u59cb\u5316\u91c7\u8d2d\u83dc\u5355,\u66f4\u6539\u5bf9\u5e94\u9500\u552e\u83dc\u5355:{}", (Object)elsAccountList);
        List newMenuListId = body.getJSONArray("newMenuList").toJavaList(String.class);
        JSONObject oldMenuMap = body.getJSONObject("oldMenuMap");
        String traceId = body.getString("traceId");
        elsAccountList.forEach(x -> oldMenuMap.putIfAbsent(x, Collections.emptyList()));
        ArrayList<MqMessagePersistenceDTO> all = new ArrayList<MqMessagePersistenceDTO>();
        for (String elsAccount : oldMenuMap.keySet()) {
            List oldMenuList = oldMenuMap.getJSONArray(elsAccount).toJavaList(String.class);
            List<MqMessagePersistenceDTO> messagePersistenceDTOList = this.buildSaleMenu(elsAccount, this.getDiffPermissionId(newMenuListId, oldMenuList), this.getDiffPermissionId(oldMenuList, newMenuListId), traceId);
            all.addAll(messagePersistenceDTOList);
        }
        return all;
    }

    private List<MqMessagePersistenceDTO> reBuildModifySaleMenu(JSONObject body) {
        List elsAccountList = body.getJSONArray("elsAccount").toJavaList(String.class);
        log.info(":::\u66f4\u6539\u5355\u4e2a\u91c7\u8d2d\u83dc\u5355,\u66f4\u6539\u5bf9\u5e94\u9500\u552e\u83dc\u5355:{}", (Object)elsAccountList);
        JSONArray add = body.getJSONArray("add");
        JSONArray delete = body.getJSONArray("delete");
        String traceId = body.getString("traceId");
        ArrayList addList = null == add ? Lists.newArrayList() : add.toJavaList(String.class);
        ArrayList deleteList = null == delete ? Lists.newArrayList() : delete.toJavaList(String.class);
        String elsAccount = (String)elsAccountList.get(0);
        return this.buildSaleMenu(elsAccount, addList, (List<String>)deleteList, traceId);
    }

    private List<MqMessagePersistenceDTO> buildSaleMenu(String elsAccount, List<String> addList, List<String> deleteList, String traceId) {
        List<String> toElsAccountList = this.invokeSupplierRpcService.listSupplierMasterData(elsAccount);
        toElsAccountList.remove(elsAccount);
        if (toElsAccountList.isEmpty()) {
            return Lists.newArrayList();
        }
        List list = Lists.partition(toElsAccountList, (int)20);
        ArrayList<MqMessagePersistenceDTO> messagePersistenceDTOList = new ArrayList<MqMessagePersistenceDTO>(list.size());
        for (List temList : list) {
            MqMessagePersistenceDTO dto = new MqMessagePersistenceDTO();
            JSONObject data = new JSONObject();
            data.put("toElsAccountList", (Object)temList);
            data.put("addList", addList);
            data.put("deleteList", deleteList);
            data.put("elsAccount", (Object)elsAccount);
            data.put("traceId", (Object)traceId);
            dto.setBusinessType("permission");
            dto.setOptType("changePermission");
            dto.setErrorTimes(Integer.valueOf(0));
            dto.setSuccessFlag("-1");
            dto.setMessageData(data.toJSONString());
            dto.setId(IdWorker.getIdStr());
            messagePersistenceDTOList.add(dto);
        }
        this.invokeBaseRpcService.batchSave(messagePersistenceDTOList);
        log.info(":::\u9500\u552e:{}\u91cd\u65b0\u6784\u5efa\u843d\u5e93\u6210\u529f...", (Object)elsAccount);
        return messagePersistenceDTOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void buildSaleMenu(List<String> toElsAccountList, String elsAccount, List<String> addList, List<String> deleteList) {
        if (CollUtil.isNotEmpty(deleteList)) {
            Map<String, Set<String>> salePurchaseMap = this.invokeSupplierRpcService.loadAllPurchaseBySale(toElsAccountList);
            List<String> deleteSaleMenuList = this.loadSalePermissionByPurchase(deleteList);
            log.info("\u7b2c\u4e8c\u6b65:\u83b7\u53d6\u5230\u9700\u8981\u6e05\u9664\u7684\u91c7\u8d2d\u83dc\u5355\uff0c\u6570\u91cf:{}", (Object)deleteSaleMenuList.size());
            if (!deleteSaleMenuList.isEmpty()) {
                ArrayList<Map<String, Object>> deleteMap = new ArrayList<Map<String, Object>>(toElsAccountList.size());
                for (String saleAccount : toElsAccountList) {
                    Set<String> purchaseAccountList = salePurchaseMap.get(saleAccount);
                    if (CollUtil.isEmpty(purchaseAccountList) || purchaseAccountList.size() == 1 && purchaseAccountList.contains(elsAccount)) {
                        HashMap<String, Object> map = new HashMap<String, Object>(2);
                        map.put("elsAccount", saleAccount);
                        map.put("permissionIds", deleteSaleMenuList);
                        deleteMap.add(map);
                        continue;
                    }
                    purchaseAccountList.remove(elsAccount);
                    List<String> existSaleIds = this.permissionMapper.selectWithoutElsAccountToLoadExistSalePermissionId(purchaseAccountList);
                    List<String> existCommIds = this.permissionMapper.selectWithoutElsAccountToLoadExistCommPermissionId(purchaseAccountList);
                    existSaleIds.addAll(existCommIds);
                    List<String> buttonIds = this.loadPermissionByParentIds(existSaleIds);
                    existSaleIds.addAll(buttonIds);
                    ArrayList temDeleteList = Lists.newArrayList(deleteSaleMenuList);
                    temDeleteList.removeAll(existSaleIds);
                    log.info("\u7b2c\u4e09\u6b65: \u8d26\u53f7{}\u9700\u8981\u5220\u9664\u7684\u83dc\u5355\u6743\u9650\uff0c\u5927\u5c0f:{},\u6570\u636e:{}", new Object[]{saleAccount, deleteSaleMenuList.size(), JSON.toJSONString(deleteSaleMenuList)});
                    if (temDeleteList.isEmpty()) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put("elsAccount", saleAccount);
                    map.put("permissionIds", temDeleteList);
                    deleteMap.add(map);
                }
                this.batchRemoveSalePermission(deleteMap);
            }
        }
        if (CollUtil.isNotEmpty(addList)) {
            List<String> addSaleMenuList = this.loadSalePermissionByPurchase(addList);
            log.info("\u7b2c\u56db\u6b65: \u9500\u552e\u9700\u8981\u65b0\u589e\u7684\u83dc\u5355\uff0c\u5927\u5c0f:{},\u6570\u636e:{}", (Object)addSaleMenuList.size(), (Object)JSON.toJSONString(addSaleMenuList));
            if (!addSaleMenuList.isEmpty()) {
                this.addSalePermission(toElsAccountList, addSaleMenuList);
            }
        }
        log.info(":::\u9500\u552e:{}\u91cd\u65b0\u6784\u5efa\u83dc\u5355\u5b8c\u6bd5...", toElsAccountList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<MqMessagePersistenceDTO> rebuildSaleMenuByMsg(JSONObject body) {
        log.info("::: \u51c6\u5907\u5f00\u59cb\u91cd\u65b0\u6784\u5efa\u9500\u552e\u83dc\u5355...");
        String type = body.getString("type");
        if ("init".equals(type)) {
            return this.reBuildInitSaleMenu(body);
        }
        return this.reBuildModifySaleMenu(body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadSalePermissionByPurchase(List<String> permissionId) {
        TenantContext.setTenant((String)"100000");
        try {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{Permission::getId, Permission::getMenuType, Permission::getMenuAttribute});
            ((LambdaQueryWrapper)wrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(Permission::getElsAccount, (Object)"100000")).in(Permission::getPurchasePermissionId, (Collection)permissionId)).in(Permission::getMenuType, (Collection)Lists.newArrayList((Object[])new Integer[]{0, 1}));
            })).or(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.eq(Permission::getMenuAttribute, (Object)MenuAttributeEnum.COMMON.getCode())).eq(Permission::getElsAccount, (Object)"100000")).in(Permission::getId, (Collection)permissionId);
            });
            List saleMenu = ((PermissionMapper)this.baseMapper).selectList((Wrapper)wrapper);
            List notButtonIds = saleMenu.stream().filter(x -> !ObjectUtil.equals((Object)2, (Object)x.getMenuType()) && !MenuAttributeEnum.PURCHASE.getCode().equals(x.getMenuAttribute())).map(Permission::getId).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(notButtonIds)) {
                LambdaQueryWrapper wrapper2 = Wrappers.lambdaQuery();
                ((LambdaQueryWrapper)wrapper2.in(Permission::getParentId, notButtonIds)).eq(Permission::getMenuType, (Object)2);
                List permissions = ((PermissionMapper)this.baseMapper).selectList((Wrapper)wrapper2);
                saleMenu.addAll(permissions);
            }
            List<String> list = saleMenu.stream().map(Permission::getId).distinct().collect(Collectors.toList());
            return list;
        }
        finally {
            TenantContext.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadPermissionByParentIds(List<String> parentIds) {
        if (CollUtil.isEmpty(parentIds)) {
            return Lists.newArrayList();
        }
        String tenant = TenantContext.getTenant();
        TenantContext.setTenant((String)"100000");
        try {
            LambdaQueryWrapper wrapper2 = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper2.in(Permission::getParentId, parentIds)).eq(Permission::getMenuType, (Object)2);
            List permissions = ((PermissionMapper)this.baseMapper).selectList((Wrapper)wrapper2);
            List<String> list = permissions.stream().map(Permission::getId).distinct().collect(Collectors.toList());
            return list;
        }
        finally {
            TenantContext.clear();
            if (CharSequenceUtil.isNotEmpty((CharSequence)tenant)) {
                TenantContext.setTenant((String)tenant);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadExistCompanyPermission(String account, List<String> addList) {
        TenantContext.setTenant((String)account);
        try {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{CompanyPermission::getPermissionId});
            ((LambdaQueryWrapper)wrapper.eq(CompanyPermission::getElsAccount, (Object)account)).in(CompanyPermission::getPermissionId, addList);
            List permissions = this.companyPermissionMapper.selectList((Wrapper)wrapper);
            List<String> list = permissions.stream().map(CompanyPermission::getPermissionId).distinct().collect(Collectors.toList());
            return list;
        }
        finally {
            TenantContext.clear();
        }
    }

    private void batchRemoveSalePermission(List<Map<String, Object>> deleteMap) {
        List partition = Lists.partition(deleteMap, (int)30);
        for (List list : partition) {
            this.permissionMapper.batchDeleteCompanyMeunByAccountAndPermissionIds(list);
            this.rolePermissionService.batchRemoveByMap(list);
        }
    }

    private void batchRemoveSalePermissionByIds(List<Map<String, Object>> deleteMap) {
        log.info(":::\u5220\u9664\u9500\u552e\u83dc\u5355\u6743\u9650:{}", JSON.toJSON(deleteMap));
        List partition = Lists.partition(deleteMap, (int)50);
        ArrayList comIds = Lists.newArrayList();
        ArrayList roleIds = Lists.newArrayList();
        for (List list : partition) {
            List<String> ids = this.permissionMapper.selectWithoutElsAccountToSelectCpId(list);
            comIds.addAll(ids);
            List<String> rIds = this.rolePermissionMapper.selectWithoutElsAccountToBatchSelectByMap(list);
            roleIds.addAll(rIds);
        }
        Lists.partition((List)comIds, (int)500).parallelStream().forEach(this.companyPermissionMapper::selectWithoutElsAccountDeleteBatchIds);
        Lists.partition((List)roleIds, (int)500).parallelStream().forEach(this.rolePermissionMapper::selectWithoutElsAccountDeleteBatchIds);
    }

    private void removeSalePermission(String account, List<String> deleteSaleMenuList) {
        this.permissionMapper.deleteCompanyMeunByAccountAndPermissionIds(deleteSaleMenuList, account);
        LambdaQueryWrapper deleteWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)deleteWrapper.eq(RolePermission::getElsAccount, (Object)account)).in(RolePermission::getPermissionId, deleteSaleMenuList);
        this.rolePermissionService.remove((Wrapper)deleteWrapper);
    }

    private void addSalePermission(List<String> toElsAccountList, List<String> addList) {
        Map<String, String> adminRoleMap = this.roleService.loadAdminRole(toElsAccountList);
        Date currentDate = new Date();
        ArrayList<CompanyPermission> temCpList = new ArrayList<CompanyPermission>();
        ArrayList<RolePermission> temRpList = new ArrayList<RolePermission>();
        for (String account : toElsAccountList) {
            if (CollUtil.isEmpty(addList)) continue;
            for (String permissionId : addList) {
                CompanyPermission permission = new CompanyPermission();
                permission.setId(IdWorker.getIdStr());
                permission.setPermissionId(permissionId);
                permission.setElsAccount(account);
                permission.setCreateTime(currentDate);
                permission.setUpdateTime(currentDate);
                permission.setCreateBy("admin");
                permission.setUpdateBy("admin");
                temCpList.add(permission);
                if (!adminRoleMap.containsKey(account)) continue;
                RolePermission rolePermission = new RolePermission();
                rolePermission.setId(IdWorker.getIdStr());
                rolePermission.setElsAccount(account);
                rolePermission.setPermissionId(permissionId);
                rolePermission.setRoleId(adminRoleMap.get(account));
                temRpList.add(rolePermission);
            }
        }
        Map deleteMap = temCpList.stream().collect(Collectors.groupingBy(CompanyPermission::getElsAccount, Collectors.mapping(CompanyPermission::getPermissionId, Collectors.toList())));
        deleteMap.forEach((elsAccount, list) -> {
            log.info("\u7b2c\u4e94\u6b65: \u518d\u4e00\u6b21\u6e05\u9664\u516c\u53f8\u83dc\u5355\uff0c\u8d26\u53f7:{},\u5927\u5c0f:{}", elsAccount, (Object)list.size());
            this.permissionMapper.deleteCompanyMeunByAccountAndPermissionIds((List<String>)list, (String)elsAccount);
        });
        if (!temCpList.isEmpty()) {
            log.info("\u7b2c\u516d\u6b65: \u4fdd\u5b58\u6240\u6709\u9500\u552e\u6570\u636e,\u5927\u5c0f:{}", (Object)temCpList.size());
            this.permissionMapper.insertCompanyMeunBatch(temCpList);
        }
        if (!temRpList.isEmpty()) {
            this.rolePermissionService.insertBatch(temRpList);
        }
        if (CollUtil.isNotEmpty(adminRoleMap)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{UserRole::getUserId});
            wrapper.in(UserRole::getRoleId, adminRoleMap.values());
            List userRoleList = this.userRoleService.list((Wrapper)wrapper);
            userRoleList.forEach(r -> this.redisUtil.del(new String[]{"shiro:cache:com.els.modules.shiro.authc.ShiroRealm.authorizationCache:" + r.getUserId()}));
        }
    }

    void shareReportMenuData(String elsAccount) {
        List<DictDTO> dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("srmReportDataMenu", "100000");
        List<DictDTO> dictDTOWorkList = this.invokeBaseRpcService.queryDictItemsByCode("srmWorkDataMenu", "100000");
        List collect = dictDTOList.stream().map(DictDTO::getText).distinct().collect(Collectors.toList());
        List permissions = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.rolePermissionService.lambdaQuery().eq(RolePermission::getElsAccount, (Object)elsAccount)).in(RolePermission::getPermissionId, collect)).list();
        List shareReportId = permissions.stream().map(RolePermission::getPermissionId).distinct().collect(Collectors.toList());
        List reportIdList = dictDTOList.stream().filter(item -> shareReportId.contains(item.getText())).map(DictDTO::getValue).collect(Collectors.toList());
        List workIdList = dictDTOWorkList.stream().filter(item -> shareReportId.contains(item.getText())).map(DictDTO::getValue).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(reportIdList)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("elsAccount", Arrays.asList(elsAccount));
            jsonObject.put("reportId", reportIdList);
            jsonObject.put("shareType", (Object)"report");
            InitReportDataMqUtil.sendInitMsg(jsonObject.toJSONString());
            log.info("\u53d1\u9001report\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + jsonObject.toJSONString());
        } else if (!CollectionUtils.isEmpty(workIdList)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("elsAccount", Arrays.asList(elsAccount));
            jsonObject.put("shareType", (Object)"work");
            InitReportDataMqUtil.sendInitMsg(jsonObject.toJSONString());
            log.info("\u53d1\u9001work\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + jsonObject.toJSONString());
        }
    }

    private List<String> getDiff(String main, String diff) {
        if (ConvertUtils.isEmpty((Object)diff)) {
            return null;
        }
        if (ConvertUtils.isEmpty((Object)main)) {
            return Arrays.asList(diff.split(","));
        }
        String[] mainArr = main.split(",");
        String[] diffArr = diff.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String string : mainArr) {
            map.put(string, 1);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String key : diffArr) {
            if (!ConvertUtils.isNotEmpty((Object)key) || map.containsKey(key)) continue;
            res.add(key);
        }
        return res;
    }

    @Override
    @SrmTransaction
    public void initAccountPermission(String elsAccount, String role) {
        String userId;
        List list;
        String currentElsAccount = TenantContext.getTenant();
        if (!"100000".equals(currentElsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APeyBjbWtkW_413583d2", (String)"\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        List itemList = null;
        itemList = "purchase".equals(role) ? this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"1", "3"})) : this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"2", "3"}));
        if (itemList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LERdRAcntWtkKmW_fb0e9fa1", (String)"\u672a\u914d\u7f6e\u76f8\u5173\u7c7b\u578b\u83dc\u5355\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        ArrayList<CompanyPermission> companyPermissionList = new ArrayList<CompanyPermission>();
        Date currentTime = new Date();
        for (Permission permission : itemList) {
            CompanyPermission companyPermission = new CompanyPermission();
            companyPermission.setId(IdWorker.getIdStr());
            companyPermission.setElsAccount(elsAccount);
            companyPermission.setPermissionId(permission.getId());
            companyPermission.setCreateTime(currentTime);
            companyPermissionList.add(companyPermission);
        }
        this.permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
        this.permissionMapper.insertCompanyMeunBatch(companyPermissionList);
        TenantContext.setTenant((String)elsAccount);
        List roleList = this.roleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"role_code", (Object)"companyAdmin"));
        if (roleList.isEmpty()) {
            Role saveRole = new Role();
            saveRole.setId(IdWorker.getIdStr());
            saveRole.setElsAccount(elsAccount);
            saveRole.setRoleCode("companyAdmin");
            saveRole.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
            this.roleService.save(saveRole);
            roleList.add(saveRole);
        } else {
            for (Object ro : roleList) {
                this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).eq(RolePermission::getRoleId, (Object)((Role)ro).getId()));
            }
        }
        ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
        for (Permission permission : itemList) {
            for (Role ro : roleList) {
                RolePermission rolePermission = new RolePermission();
                rolePermission.setId(IdWorker.getIdStr());
                rolePermission.setElsAccount(elsAccount);
                rolePermission.setRoleId(ro.getId());
                rolePermission.setPermissionId(permission.getId());
                rolePermissionList.add(rolePermission);
            }
        }
        this.rolePermissionService.saveBatch(rolePermissionList);
        ElsSubAccount subAccount = this.elsSubAccountMapper.getUserByAccount(elsAccount + "_" + "1001");
        if (subAccount != null && (list = this.userRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)(userId = subAccount.getId()))).eq((Object)"role_id", (Object)((Role)roleList.get(0)).getId()))).isEmpty()) {
            UserRole userRole = new UserRole();
            userRole.setId(IdWorker.getIdStr());
            userRole.setUserId(userId);
            userRole.setRoleId(((Role)roleList.get(0)).getId());
            this.userRoleService.save(userRole);
        }
    }

    @Override
    public void initAccountPermissionList(List<String> elsAccountList, String role) {
        String currentElsAccount = TenantContext.getTenant();
        if (!"100000".equals(currentElsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APeyBjbWtkW_413583d2", (String)"\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\uff01"));
        }
        Map<String, List<String>> oldMenuMap = null;
        List itemList = null;
        if ("purchase".equals(role)) {
            itemList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"1", "3"}));
            List<CompanyPermission> permissionList = this.companyPermissionMapper.selectWithoutElsAccountToListAccountOldMenu(elsAccountList);
            oldMenuMap = permissionList.stream().collect(Collectors.groupingBy(CompanyPermission::getElsAccount, Collectors.mapping(CompanyPermission::getPermissionId, Collectors.toList())));
        } else {
            itemList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)currentElsAccount)).in((Object)"menu_attribute", new Object[]{"2", "3"}));
        }
        if (itemList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LERdRAcntWtkKmW_fb0e9fa1", (String)"\u672a\u914d\u7f6e\u76f8\u5173\u7c7b\u578b\u83dc\u5355\uff0c\u64cd\u4f5c\u5931\u8d25\uff01"));
        }
        ArrayList<CompanyPermission> companyPermissionList = new ArrayList<CompanyPermission>();
        Date currentTime = new Date();
        for (String elsAccount : elsAccountList) {
            String userId;
            List list;
            Object ro2;
            companyPermissionList.clear();
            for (Permission permission : itemList) {
                CompanyPermission companyPermission = new CompanyPermission();
                companyPermission.setId(IdWorker.getIdStr());
                companyPermission.setElsAccount(elsAccount);
                companyPermission.setPermissionId(permission.getId());
                companyPermission.setCreateTime(currentTime);
                companyPermissionList.add(companyPermission);
            }
            this.permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
            this.permissionMapper.insertCompanyMeunBatch(companyPermissionList);
            TenantContext.setTenant((String)elsAccount);
            List roleList = this.roleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"role_code", (Object)"companyAdmin"));
            if (roleList.isEmpty()) {
                Role saveRole = new Role();
                saveRole.setId(IdWorker.getIdStr());
                saveRole.setElsAccount(elsAccount);
                saveRole.setRoleCode("companyAdmin");
                saveRole.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
                this.roleService.save(saveRole);
                roleList.add(saveRole);
            } else {
                for (Object ro2 : roleList) {
                    this.rolePermissionService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(RolePermission::getElsAccount, (Object)elsAccount)).eq(RolePermission::getRoleId, (Object)((Role)ro2).getId()));
                }
            }
            ArrayList<RolePermission> rolePermissionList = new ArrayList<RolePermission>();
            ro2 = itemList.iterator();
            while (ro2.hasNext()) {
                Permission permission = (Permission)ro2.next();
                for (Role ro3 : roleList) {
                    RolePermission rolePermission = new RolePermission();
                    rolePermission.setId(IdWorker.getIdStr());
                    rolePermission.setElsAccount(elsAccount);
                    rolePermission.setRoleId(ro3.getId());
                    rolePermission.setPermissionId(permission.getId());
                    rolePermissionList.add(rolePermission);
                }
            }
            this.rolePermissionService.saveBatch(rolePermissionList);
            ElsSubAccount subAccount = this.elsSubAccountMapper.getUserByAccount(elsAccount + "_" + "1001");
            if (subAccount == null || !(list = this.userRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)(userId = subAccount.getId()))).eq((Object)"role_id", (Object)((Role)roleList.get(0)).getId()))).isEmpty()) continue;
            UserRole userRole = new UserRole();
            userRole.setId(IdWorker.getIdStr());
            userRole.setUserId(userId);
            userRole.setRoleId(((Role)roleList.get(0)).getId());
            this.userRoleService.save(userRole);
        }
        if ("purchase".equals(role)) {
            this.shareReportMenuDataByRole(elsAccountList, itemList);
            if (CollUtil.isNotEmpty(oldMenuMap)) {
                this.rebuildSaleMenu(elsAccountList, null, null, "init", oldMenuMap, itemList.stream().map(Permission::getId).distinct().collect(Collectors.toList()));
            }
        }
    }

    void shareReportMenuDataByRole(List<String> elsAccountList, List<Permission> permissions) {
        String elsAccount = elsAccountList.get(0);
        List<DictDTO> dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("srmReportDataMenu", "100000");
        List<DictDTO> dictDTOWorkList = this.invokeBaseRpcService.queryDictItemsByCode("srmWorkDataMenu", "100000");
        List collect = dictDTOList.stream().map(DictDTO::getText).distinct().collect(Collectors.toList());
        List shareReportId = permissions.stream().map(Permission::getId).distinct().collect(Collectors.toList());
        List reportIdList = dictDTOList.stream().filter(item -> shareReportId.contains(item.getText())).map(DictDTO::getValue).collect(Collectors.toList());
        List workIdList = dictDTOWorkList.stream().filter(item -> shareReportId.contains(item.getText())).map(DictDTO::getValue).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(reportIdList)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("elsAccount", elsAccountList);
            jsonObject.put("reportId", reportIdList);
            jsonObject.put("shareType", (Object)"report");
            InitReportDataMqUtil.sendInitMsg(jsonObject.toJSONString());
            log.info("\u53d1\u9001report\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + jsonObject.toJSONString());
        } else if (!CollectionUtils.isEmpty(workIdList)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("elsAccount", elsAccountList);
            jsonObject.put("shareType", (Object)"work");
            InitReportDataMqUtil.sendInitMsg(jsonObject.toJSONString());
            log.info("\u53d1\u9001work\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + jsonObject.toJSONString());
        }
    }

    @Override
    public Set<String> getAllOptPermission() {
        List list = null;
        String deployWay = SysUtil.getDeployWay();
        if ("local".equals(deployWay)) {
            List<PermissionVO> permissionList;
            List<Object> dbList = null;
            dbList = !TenantContext.getTenant().equals(SysUtil.getPurchaseAccount()) ? ((permissionList = ((PermissionMapper)this.baseMapper).queryLocalByGroup(SysUtil.getPurchaseAccount(), TenantContext.getTenant())).isEmpty() ? ((PermissionMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"menu_attribute", new Object[]{"2", "3"})).eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0)) : new ArrayList<PermissionVO>(permissionList)) : ((PermissionMapper)this.baseMapper).selectList((Wrapper)new QueryWrapper().eq((Object)"is_deleted", (Object)CommonConstant.DEL_FLAG_0));
            list = dbList.stream().filter(per -> StrUtil.isNotBlank((CharSequence)per.getPerms())).map(Permission::getPerms).collect(Collectors.toList());
        } else {
            List<PermissionVO> permissionList = ((PermissionMapper)this.baseMapper).getCompanyMenuList(TenantContext.getTenant());
            list = permissionList.stream().filter(per -> StrUtil.isNotBlank((CharSequence)per.getPerms())).map(Permission::getPerms).collect(Collectors.toList());
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (String str : list) {
            if (StringUtils.isBlank((CharSequence)str)) continue;
            if (str.contains(";")) {
                List<String> itemList = Arrays.asList(str.split(";"));
                resultList.addAll(itemList);
                continue;
            }
            resultList.add(str);
        }
        return new HashSet<String>(resultList);
    }

    @Override
    public void insertCompanyMeunBatch(List<CompanyPermission> companyPermissions) {
        this.permissionMapper.insertCompanyMeunBatch(companyPermissions);
    }

    @Override
    public void addPermissionI18nKey() {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().and(p -> ((LambdaQueryWrapper)((LambdaQueryWrapper)p.isNull(Permission::getNameI18nKey)).or()).eq(Permission::getNameI18nKey, (Object)""))).eq(Permission::getElsAccount, (Object)"100000")).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List<String> collect = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            collect = list.parallelStream().map(o -> o.getName()).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(collect)) {
            Map<String, String> stringStringMap = this.invokeBaseRpcService.checkAndAdd(collect, "menu");
            list.forEach(item -> item.setNameI18nKey((String)stringStringMap.get(item.getName())));
            this.updateBatchById(list);
        }
    }

    @Override
    public JSONArray getMenuJsonArray(String elsAccount, String subAccount, Integer mobile) {
        List<PermissionVO> permissionVOList = this.permissionMapper.queryByAccount(elsAccount, subAccount, mobile);
        JSONArray menujsonArray = new JSONArray();
        this.getPermissionJsonArray(menujsonArray, permissionVOList, null);
        return menujsonArray;
    }

    private void getPermissionJsonArray(JSONArray jsonArray, List<PermissionVO> metaList, JSONObject parentJson) {
        for (Permission permission : metaList) {
            if (permission.getMenuType() == null) continue;
            String tempPid = permission.getParentId();
            permission.setName(I18nUtil.translate((String)permission.getNameI18nKey(), (String)permission.getName()));
            JSONObject json = this.getPermissionJsonObject(permission);
            if (json == null) continue;
            if (parentJson == null && ConvertUtils.isEmpty((Object)tempPid)) {
                jsonArray.add((Object)json);
                if (permission.isLeaf()) continue;
                this.getPermissionJsonArray(jsonArray, metaList, json);
                continue;
            }
            if (parentJson == null || !ConvertUtils.isNotEmpty((Object)tempPid) || !tempPid.equals(parentJson.getString("id"))) continue;
            if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
                JSONObject metaJson = parentJson.getJSONObject("meta");
                if (metaJson.containsKey((Object)"permissionList")) {
                    metaJson.getJSONArray("permissionList").add((Object)json);
                    continue;
                }
                JSONArray permissionList = new JSONArray();
                permissionList.add((Object)json);
                metaJson.put("permissionList", (Object)permissionList);
                continue;
            }
            if (!permission.getMenuType().equals(CommonConstant.MENU_TYPE_1) && !permission.getMenuType().equals(CommonConstant.MENU_TYPE_0)) continue;
            if (parentJson.containsKey((Object)"children")) {
                parentJson.getJSONArray("children").add((Object)json);
            } else {
                JSONArray children = new JSONArray();
                children.add((Object)json);
                parentJson.put("children", (Object)children);
            }
            if (permission.isLeaf()) continue;
            this.getPermissionJsonArray(jsonArray, metaList, json);
        }
    }

    private JSONObject getPermissionJsonObject(Permission permission) {
        JSONObject json = new JSONObject();
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
            return null;
        }
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_0) || permission.getMenuType().equals(CommonConstant.MENU_TYPE_1)) {
            json.put("id", (Object)permission.getId());
            if (permission.isRoute()) {
                json.put("route", (Object)"1");
            } else {
                json.put("route", (Object)"0");
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                json.put("path", (Object)MD5Util.md5Encode((String)permission.getUrl(), (String)"utf-8"));
            } else {
                json.put("path", (Object)permission.getUrl());
            }
            json.put("mobile", (Object)permission.isMobile());
            if (ConvertUtils.isNotEmpty((Object)permission.getComponentName())) {
                json.put("name", (Object)permission.getComponentName());
            } else {
                json.put("name", (Object)this.urlToRouteName(permission.getUrl()));
            }
            if (permission.isHidden()) {
                json.put("hidden", (Object)true);
            }
            if (permission.isAlwaysShow()) {
                json.put("alwaysShow", (Object)true);
            }
            json.put("component", (Object)permission.getComponent());
            JSONObject meta = new JSONObject();
            if (permission.isKeepAlive()) {
                meta.put("keepAlive", (Object)true);
            } else {
                meta.put("keepAlive", (Object)false);
            }
            if (permission.isInternalOrExternal()) {
                meta.put("internalOrExternal", (Object)true);
            } else {
                meta.put("internalOrExternal", (Object)false);
            }
            meta.put("title", (Object)permission.getName());
            if (ConvertUtils.isEmpty((Object)permission.getParentId())) {
                json.put("redirect", (Object)permission.getRedirect());
                if (ConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty((Object)permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            } else {
                if (ConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty((Object)permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                meta.put("url", (Object)permission.getUrl());
            }
            if (StrUtil.isNotBlank((CharSequence)permission.getHelpDocUrl())) {
                meta.put("helpDocUrl", (Object)permission.getHelpDocUrl());
            }
            json.put("meta", (Object)meta);
        }
        return json;
    }

    private boolean isWWWHttpUrl(String url) {
        return url != null && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("{{"));
    }

    private String urlToRouteName(String url) {
        if (ConvertUtils.isNotEmpty((Object)url)) {
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = url.replace("/", "-");
            url = url.replace(":", "@");
            return url;
        }
        return null;
    }
}

