/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.contractlock.enumerate.CLBusTypeEnum;
import com.els.modules.electronsign.contractlock.enumerate.ClSignerStatusEmun;
import com.els.modules.electronsign.enums.SrmSignatoryType;
import com.els.modules.electronsign.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.electronsign.esign.enumerate.EsignStatusEmun;
import com.els.modules.electronsign.esign.enumerate.SignerVindicateStatusEnum;
import com.els.modules.electronsign.esign.service.EsignOperationService;
import com.els.modules.electronsign.esign.util.FileHelper;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.FileDownloadRp;
import com.els.modules.electronsign.esignv3.dto.FileQueryRp;
import com.els.modules.electronsign.esignv3.dto.FileQueryRq;
import com.els.modules.electronsign.esignv3.dto.FileRp;
import com.els.modules.electronsign.esignv3.dto.FileRq;
import com.els.modules.electronsign.esignv3.dto.KeyWordRp;
import com.els.modules.electronsign.esignv3.dto.KeyWordRq;
import com.els.modules.electronsign.esignv3.dto.LaunchRp;
import com.els.modules.electronsign.esignv3.dto.LaunchRq;
import com.els.modules.electronsign.esignv3.dto.PersonalRq;
import com.els.modules.electronsign.esignv3.entity.ElsEsignV3Attachment;
import com.els.modules.electronsign.esignv3.entity.ElsEsignV3Flow;
import com.els.modules.electronsign.esignv3.entity.ElsEsignV3Signers;
import com.els.modules.electronsign.esignv3.enums.EsignV3SignerTypeEnum;
import com.els.modules.electronsign.esignv3.enums.FileUploadStatusEnum;
import com.els.modules.electronsign.esignv3.mapper.ElsEsignV3FlowMapper;
import com.els.modules.electronsign.esignv3.service.ElsEsignV3AttachmentService;
import com.els.modules.electronsign.esignv3.service.ElsEsignV3FlowService;
import com.els.modules.electronsign.esignv3.service.ElsEsignV3SignersService;
import com.els.modules.electronsign.esignv3.vo.ElsEsignV3VO;
import com.els.modules.electronsign.esignv3.vo.KeyWordVo;
import com.els.modules.electronsign.util.ESignUtil;
import com.els.modules.electronsign.util.IpassUtil;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.system.rpc.service.InvokeSupplierRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsEsignV3FlowServiceImpl
extends BaseServiceImpl<ElsEsignV3FlowMapper, ElsEsignV3Flow>
implements ElsEsignV3FlowService {
    private static final Logger log = LoggerFactory.getLogger(ElsEsignV3FlowServiceImpl.class);
    @Autowired
    private ElsEnterpriseInfoMapper elsEnterpriseInfoMapper;
    @Autowired
    private InvokeSupplierRpcService invokeSupplierRpcService;
    @Autowired
    private ESignUtil eSignUtil;
    @Autowired
    private EsignOperationService operationService;
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private ElsEsignV3SignersService signersService;
    @Autowired
    private EsignV3Properties esignV3Properties;
    @Autowired
    private ElsEsignV3AttachmentService esignV3AttachmentService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void add(ElsEsignV3Flow elsEsignV3Flow) {
        ((ElsEsignV3FlowMapper)this.baseMapper).insert((Object)elsEsignV3Flow);
    }

    @Override
    public void edit(ElsEsignV3Flow elsEsignV3Flow) {
        int count = ((ElsEsignV3FlowMapper)this.baseMapper).updateById((Object)elsEsignV3Flow);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsEsignV3FlowMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsEsignV3FlowMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void saveMain(ElsEsignV3VO flow) {
        SupplierMasterDataDTO supplierMasterDataDTO;
        ElsEnterpriseInfo enterpriseInfo;
        flow.setCreateTime(new Date());
        LoginUser sysUser = SysUtil.getLoginUser();
        String currentUser = sysUser.getSubAccount();
        flow.setCreateBy(currentUser);
        flow.setElsAccount(TenantContext.getTenant());
        if (StringUtils.isBlank((CharSequence)flow.getPurchaseName()) && (enterpriseInfo = this.elsEnterpriseInfoMapper.getByElsAccount(TenantContext.getTenant())) != null) {
            flow.setPurchaseName(enterpriseInfo.getName());
        }
        if (StringUtils.isBlank((CharSequence)flow.getSupplierName()) && (supplierMasterDataDTO = this.invokeSupplierRpcService.getToELsAccount(TenantContext.getTenant())) != null) {
            flow.setSupplierName(supplierMasterDataDTO.getSupplierName());
        }
        flow.setEsignStatus("0");
        flow.setPurchaseEsignStatus(ClSignerStatusEmun.NO_SIGNERS_SET.getValue());
        flow.setSaleEsignStatus(ClSignerStatusEmun.NO_SIGNERS_SET.getValue());
        flow.setBusAccount(sysUser.getElsAccount());
        flow.setSignerVindicateStatus(SignerVindicateStatusEnum.NO_MAINTENANCE.getValue());
        flow.setOnlineSealed(this.eSignUtil.getOnlineSealed(flow.getBusType(), flow.getToElsAccount()));
        flow.setFirstSeal("1".equals(flow.getOnlineSealed()) ? EsignRoleTypeEnum.SALE.getCode() : EsignRoleTypeEnum.PURCHASE.getCode());
        if (StrUtil.isBlank((CharSequence)flow.getNoticeType())) {
            flow.setNoticeType("1");
        }
        if (StrUtil.isBlank((CharSequence)flow.getAutoArchiving())) {
            flow.setAutoArchiving("1");
        }
        if (StrUtil.isBlank((CharSequence)flow.getAutoInitiate())) {
            flow.setAutoInitiate("1");
        }
        this.eSignUtil.handleBusType(flow.getBusType(), flow.getRelationId(), flow.getEsignStatus(), CLBusTypeEnum.ADD, "esignV3");
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)flow), ElsEsignV3Flow.class, (String[])new String[0]));
        ((ElsEsignV3FlowMapper)this.baseMapper).insert((Object)db);
        flow.setId(db.getId());
        if (CollUtil.isNotEmpty(flow.getPurchaseSignersList())) {
            this.handleEditSigner(flow.getPurchaseSignersList(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
        }
        if (CollUtil.isNotEmpty(flow.getSaleSignersList())) {
            this.handleEditSigner(flow.getSaleSignersList(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
        }
        if (CollUtil.isNotEmpty(flow.getPurchaseAttachments())) {
            this.handleEditAttachment(flow.getPurchaseAttachments(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
        }
    }

    private List<Pair<ElsEsignV3Attachment, File>> getFile(ElsEsignV3VO esign, String cookie) {
        if (CollUtil.isNotEmpty(esign.getSaleAttachments())) {
            ArrayList list = Lists.newArrayList();
            for (ElsEsignV3Attachment row : esign.getSaleAttachments()) {
                File file = IpassUtil.getFileFromUrl(row.getAbsoluteFilePath(), row.getId());
                list.add(new Pair((Object)row, (Object)file));
            }
            return list;
        }
        if (CollUtil.isNotEmpty(esign.getPurchaseAttachments())) {
            ArrayList list = Lists.newArrayList();
            for (ElsEsignV3Attachment row : esign.getPurchaseAttachments()) {
                File file = IpassUtil.getFileFromUrl(row.getAbsoluteFilePath(), row.getId());
                list.add(new Pair((Object)row, (Object)file));
            }
            return list;
        }
        File file = this.operationService.getFileById(esign.getRelationId(), esign.getBusType(), esign.getBusNumber(), Optional.ofNullable(esign.getBusVersion()).orElse("1"), esign.getReportUrl(), esign.getToken(), cookie);
        ElsEsignV3Attachment elsEsignV3Attachment = new ElsEsignV3Attachment();
        elsEsignV3Attachment.setBusinessType("esignV3");
        elsEsignV3Attachment.setAbsoluteFilePath(file.getAbsolutePath());
        elsEsignV3Attachment.setFileName(file.getName());
        elsEsignV3Attachment.setFilePath(file.getPath());
        elsEsignV3Attachment.setRelationId(esign.getId());
        elsEsignV3Attachment.setHeadId(esign.getId());
        elsEsignV3Attachment.setFileName(file.getName());
        elsEsignV3Attachment.setFileType("5");
        elsEsignV3Attachment.setSignType("1");
        elsEsignV3Attachment.setAccountType("0");
        elsEsignV3Attachment.setUploadTime(new Date());
        elsEsignV3Attachment.setUploadElsAccount(esign.getElsAccount());
        elsEsignV3Attachment.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
        elsEsignV3Attachment.setFileSize(String.valueOf(file.length()));
        elsEsignV3Attachment.setCreateBy(esign.getCreateBy());
        elsEsignV3Attachment.setCreateById(esign.getCreateById());
        this.esignV3AttachmentService.save((Object)elsEsignV3Attachment);
        return Arrays.asList(new Pair((Object)elsEsignV3Attachment, (Object)file));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void uploadFile(ElsEsignV3VO esign, HttpServletRequest request, HttpServletResponse response) {
        this.editMain(esign);
        String cookie = request.getHeader("cookie");
        List<Pair<ElsEsignV3Attachment, File>> files = this.getFile(esign, cookie);
        for (Pair<ElsEsignV3Attachment, File> pair : files) {
            File file = (File)pair.getValue();
            FileRq fileRq = new FileRq();
            fileRq.setFileName(file.getName());
            fileRq.setFileSize(file.length());
            fileRq.setContentType("application/pdf");
            String contentMD5 = IpassUtil.getFileContentMD5(IpassUtil.getFileMD5Bytes128(file));
            fileRq.setContentMd5(contentMD5);
            FileRp fileRp = this.ipassUtil.sendRequest(fileRq, "e3-flow-get-file-url", FileRp.class);
            esign.setFilesId(fileRp.getFileId());
            try {
                FileInputStream input = new FileInputStream(file);
                byte[] push = IoUtil.readBytes((InputStream)input);
                FileHelper.streamUploadBytes(push, fileRp.getFileUploadUrl(), contentMD5, "application/pdf");
            }
            catch (Exception e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_title_uploadError", (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a") + e.getMessage());
            }
            FileQueryRq fileQuery = new FileQueryRq();
            fileQuery.setFileId(fileRp.getFileId());
            FileQueryRp fileQueryRp = this.ipassUtil.sendBaseRequest(fileQuery, "e3-flow-query-file-status", FileQueryRp.class);
            if (!FileUploadStatusEnum.COMPLETED.getCode().equals(fileQueryRp.getFileStatus())) continue;
            esign.setUploaded("1");
            esign.setFilesName(fileQueryRp.getFileName());
            this.updateById(BeanUtil.copyProperties((Object)((Object)esign), ElsEsignV3Flow.class, (String[])new String[0]));
            ElsEsignV3Attachment attachment = (ElsEsignV3Attachment)((Object)pair.getKey());
            attachment.setFileId(fileRp.getFileId());
            attachment.setUploaded("1");
            this.esignV3AttachmentService.updateById((Object)attachment);
        }
    }

    @Override
    public void editMain(ElsEsignV3VO esignVO) {
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)esignVO), ElsEsignV3Flow.class, (String[])new String[0]));
        if (StrUtil.isNotBlank((CharSequence)esignVO.getId())) {
            if (CollUtil.isNotEmpty(esignVO.getPurchaseSignersList())) {
                this.handleEditSigner(esignVO.getPurchaseSignersList(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
                if (SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue().equals(db.getSignerVindicateStatus())) {
                    db.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
                }
                db.setPurchaseEsignStatus("0");
            }
            if (CollUtil.isNotEmpty(esignVO.getSaleSignersList())) {
                this.handleEditSigner(esignVO.getSaleSignersList(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
                db.setSaleEsignStatus("0");
            }
            if (CollUtil.isNotEmpty(esignVO.getPurchaseAttachments())) {
                this.handleEditAttachment(esignVO.getPurchaseAttachments(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
            }
            if (CollUtil.isNotEmpty(esignVO.getSaleAttachments())) {
                this.handleEditAttachment(esignVO.getSaleAttachments(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
                db.setSignFileUploaded("1");
                if ("0".equals(db.getOnlineSealed())) {
                    db.setSaleEsignStatus(ClSignerStatusEmun.SUCCESS.getValue());
                    if (CollUtil.isNotEmpty(esignVO.getPurchaseSignersList())) {
                        db.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
                    } else {
                        db.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
                    }
                }
            }
            this.updateById((Object)db);
        } else {
            this.saveMain(esignVO);
        }
    }

    @Override
    public ElsEsignV3VO getMainById(String id) {
        List<ElsEsignV3Attachment> attachments;
        ElsEsignV3VO vo = new ElsEsignV3VO();
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        BeanUtil.copyProperties((Object)((Object)db), (Object)((Object)vo), (String[])new String[0]);
        List<ElsEsignV3Signers> signers = this.signersService.getByHeadId(id);
        if (CollUtil.isNotEmpty(signers)) {
            vo.setPurchaseSignersList(signers.stream().filter(x -> EsignRoleTypeEnum.PURCHASE.getValue().equals(x.getRoleType())).collect(Collectors.toList()));
            vo.setSaleSignersList(signers.stream().filter(x -> EsignRoleTypeEnum.SALE.getValue().equals(x.getRoleType())).collect(Collectors.toList()));
        }
        if (CollUtil.isNotEmpty(attachments = this.esignV3AttachmentService.getByHeadId(id))) {
            vo.setPurchaseAttachments(attachments.stream().filter(x -> EsignRoleTypeEnum.PURCHASE.getValue().equals(x.getAccountType())).collect(Collectors.toList()));
            vo.setSaleAttachments(attachments.stream().filter(x -> EsignRoleTypeEnum.SALE.getValue().equals(x.getAccountType())).collect(Collectors.toList()));
        }
        return vo;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void createFlowOneStep(ElsEsignV3VO flowVo) {
        if (flowVo.getBusType().equals("multipleSign")) {
            this.editMain(flowVo);
        } else {
            flowVo = this.getMainById(flowVo.getId());
        }
        LaunchRq launchRq = this.buildLaunchRq(flowVo);
        LaunchRp res = this.ipassUtil.sendRequest(launchRq, "e3-flow-create", LaunchRp.class);
        flowVo.setFlowId(res.getSignFlowId());
        flowVo.setLaunch("1");
        if ("1".equals(flowVo.getAutoInitiate())) {
            flowVo.setInitiate("1");
        } else {
            flowVo.setInitiate("0");
        }
        flowVo.setEsignStatus(EsignStatusEmun.UNFINISHED.getValue());
        this.updateById((Object)flowVo);
    }

    @Override
    public void send(ElsEsignV3VO esignVO) {
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)esignVO), ElsEsignV3Flow.class, (String[])new String[0]));
        db.setSignerVindicateStatus(SignerVindicateStatusEnum.SALE_NO_MAINTENANCE.getValue());
        this.updateById((Object)db);
        if (CollUtil.isNotEmpty(esignVO.getPurchaseSignersList())) {
            this.handleEditSigner(esignVO.getPurchaseSignersList(), EsignRoleTypeEnum.PURCHASE.getValue(), db.getId());
            db.setPurchaseEsignStatus("0");
        }
        if (CollUtil.isNotEmpty(esignVO.getSaleSignersList())) {
            this.handleEditSigner(esignVO.getSaleSignersList(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
        }
    }

    @Override
    public void saleSend(ElsEsignV3VO esignVO) {
        ElsEsignV3Flow db = (ElsEsignV3Flow)((Object)BeanUtil.copyProperties((Object)((Object)esignVO), ElsEsignV3Flow.class, (String[])new String[0]));
        Assert.isTrue((boolean)CollUtil.isNotEmpty(esignVO.getSaleSignersList()), (String)I18nUtil.translate((String)"i18n_field_RCLLDPWLVH_725bf198", (String)"\u4f9b\u65b9\u672a\u7ef4\u62a4\u7b7e\u7f72\u4eba\u4fe1\u606f"));
        this.handleEditSigner(esignVO.getSaleSignersList(), EsignRoleTypeEnum.SALE.getValue(), db.getId());
        if (CollUtil.isEmpty(esignVO.getPurchaseSignersList())) {
            db.setSignerVindicateStatus(SignerVindicateStatusEnum.PURCHASE_NO_MAINTENANCE.getValue());
            db.setSaleEsignStatus("0");
        } else {
            db.setSignerVindicateStatus(SignerVindicateStatusEnum.MAINTENANCED.getValue());
            db.setPurchaseEsignStatus("0");
            db.setSaleEsignStatus("0");
        }
        this.updateById((Object)db);
    }

    @Override
    public void sendBack(String id) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)flow), (String)I18nUtil.translate((String)"i18n_field_neLV_27784384", (String)"\u5408\u540c\u4e3a\u7a7a"));
        if (!EsignStatusEmun.UNDONE.getValue().equals(flow.getEsignStatus())) {
            Assert.isTrue((!"1".equals(flow.getLaunch()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PWQLIhAWShYM_a3d2ed05", (String)"\u7b7e\u7f72\u6d41\u7a0b\u5df2\u53d1\u8d77\uff0c\u65e0\u6cd5\u9000\u56de"));
        }
        this.eSignUtil.handleBusType(flow.getBusType(), flow.getRelationId(), null, CLBusTypeEnum.RETURN, "esignV3");
        flow.setSendBack("1");
        this.updateById((Object)flow);
    }

    @Override
    public List<KeyWordVo> keyWordToAera(String filesId, String signWord, String elsAccount) {
        KeyWordRq keyWordRq = new KeyWordRq(filesId, signWord);
        KeyWordRp keyWordRp = this.ipassUtil.sendBaseAndChangeElsAccountRequest(keyWordRq, "e3-search-keyword-position", elsAccount, KeyWordRp.class);
        ArrayList keyWordVos = Lists.newArrayList();
        if (CollUtil.isNotEmpty(keyWordRp.getKeywordPositions())) {
            keyWordRp.getKeywordPositions().forEach(row -> {
                if (row.isSearchResult()) {
                    row.getPositions().forEach(v -> v.getCoordinates().forEach(b -> {
                        KeyWordVo keyWordVo = new KeyWordVo();
                        keyWordVo.setPage(v.getPageNum());
                        keyWordVo.setPositionX(b.getPositionX());
                        keyWordVo.setPositionY(b.getPositionY());
                        keyWordVos.add(keyWordVo);
                    }));
                }
            });
        }
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)keyWordVos), (String)I18nUtil.translate((String)"i18n_field_LYumRIJVH_dc2f9482", (String)"\u672a\u627e\u5230\u6b64\u5173\u952e\u5b57\u4fe1\u606f"));
        return keyWordVos;
    }

    @Override
    public FileQueryRp viewEsignFile(String id) {
        ElsEsignV3Flow esign = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)esign)), (String)I18nUtil.translate((String)"i18n_alert_rtFIqQGWtkSX_89985068", (String)"\u8be5\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u64cd\u4f5c\u65e0\u6548"));
        FileQueryRq fileQuery = new FileQueryRq();
        fileQuery.setFileId(esign.getFilesId());
        FileQueryRp fileQueryRp = this.ipassUtil.sendBaseAndChangeElsAccountRequest(fileQuery, "e3-flow-query-file-status", esign.getElsAccount(), FileQueryRp.class);
        if (FileUploadStatusEnum.COMPLETED.getCode().equals(fileQueryRp.getFileStatus())) {
            return fileQueryRp;
        }
        return null;
    }

    @Override
    public void callback(JSONObject jsonObject) {
        String action;
        switch (action = jsonObject.getString("action")) {
            case "SIGN_MISSON_COMPLETE": {
                CallBackDto.SignComplete signComplete = (CallBackDto.SignComplete)jsonObject.toJavaObject(CallBackDto.SignComplete.class);
                ElsEsignV3Signers signers = (ElsEsignV3Signers)((Object)this.signersService.getById((Serializable)((Object)signComplete.getCustomBizNum())));
                if (ObjectUtil.isNotEmpty((Object)((Object)signers))) {
                    signers.setEsignStatus(signComplete.getSignResult() - 1 + "");
                    this.signersService.updateById((Object)signers);
                }
                ElsEsignV3Flow elsEsignV3Flow = this.delayGet(signComplete.getSignFlowId());
                if (signers.getRoleType().equals(EsignRoleTypeEnum.PURCHASE.getValue())) {
                    elsEsignV3Flow.setPurchaseEsignStatus(signComplete.getSignResult() - 1 + "");
                    this.updateById((Object)elsEsignV3Flow);
                }
                if (!signers.getRoleType().equals(EsignRoleTypeEnum.SALE.getValue())) break;
                elsEsignV3Flow.setSaleEsignStatus(signComplete.getSignResult() - 1 + "");
                this.updateById((Object)elsEsignV3Flow);
                break;
            }
            case "SIGN_FLOW_COMPLETE": {
                CallBackDto.SignEndComplete signEndComplete = (CallBackDto.SignEndComplete)jsonObject.toJavaObject(CallBackDto.SignEndComplete.class);
                ElsEsignV3Flow elsEsignV3Flow2 = this.delayGet(signEndComplete.getSignFlowId());
                elsEsignV3Flow2.setPurchaseEsignStatus("1");
                elsEsignV3Flow2.setSaleEsignStatus("1");
                elsEsignV3Flow2.setEsignStatus(signEndComplete.getSignFlowStatus());
                this.updateById((Object)elsEsignV3Flow2);
                if (!EsignStatusEmun.FINISHED.getValue().equals(signEndComplete.getSignFlowStatus()) || !"1".equals(elsEsignV3Flow2.getAutoArchiving())) break;
                this.handleArchiving(elsEsignV3Flow2);
            }
        }
    }

    private ElsEsignV3Flow delayGet(String flowId) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Flow::getFlowId, (Object)flowId), false));
        if (ObjectUtil.isNotEmpty((Object)((Object)flow))) {
            return flow;
        }
        try {
            for (int i = 0; i <= 4; ++i) {
                log.info("\u7b49\u5f85\u6570\u636e\u6267\u884c,{}\u6b21", (Object)i);
                Thread.sleep(5000L);
                flow = (ElsEsignV3Flow)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Flow::getFlowId, (Object)flowId), false));
                if (!ObjectUtil.isNotEmpty((Object)((Object)flow))) continue;
                return flow;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public void handleArchiving(ElsEsignV3Flow flow) {
        flow.setArchiving("1");
        this.updateById((Object)flow);
        this.eSignUtil.handleBusType(flow.getBusType(), flow.getRelationId(), EsignStatusEmun.FINISHED.getValue(), CLBusTypeEnum.FINISH, "esignV3");
    }

    @Override
    public FileDownloadRp getFile(String flowId) {
        LaunchRp launchRp = new LaunchRp();
        launchRp.setSignFlowId(flowId);
        FileDownloadRp fileDownloadRp = this.ipassUtil.sendBaseRequest(launchRp, "e3-flow-file-get", FileDownloadRp.class);
        return fileDownloadRp;
    }

    @Override
    public String flowQuery(String id) {
        LaunchRp launchRp = new LaunchRp();
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        launchRp.setSignFlowId(flow.getFlowId());
        JSONObject jsonObject = this.ipassUtil.sendBaseRequest(launchRp, "e3-flow-query-detail", JSONObject.class);
        if (ObjectUtil.isNotEmpty((Object)jsonObject)) {
            return jsonObject.getString("signFlowDescription");
        }
        return null;
    }

    @Override
    public void revoke(String id, String reason) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        LaunchRp launchRp = new LaunchRp();
        launchRp.setSignFlowId(flow.getFlowId());
        JSONObject jsonObject = this.ipassUtil.sendBaseRequest(launchRp, "e3-flow-revoke", JSONObject.class);
        flow.setEsignStatus(EsignStatusEmun.UNDONE.getValue());
        flow.setReason(reason);
        this.updateById((Object)flow);
    }

    @Override
    public void startFlow(String id) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        LaunchRp launchRp = new LaunchRp();
        launchRp.setSignFlowId(flow.getFlowId());
        JSONObject jsonObject = this.ipassUtil.sendBaseRequest(launchRp, "e3-flow-start", JSONObject.class);
        flow.setInitiate("1");
        this.updateById((Object)flow);
    }

    @Override
    public void archiveFlow(String id) {
        this.handleArchiving((ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id))));
    }

    @Override
    public FileDownloadRp signFileDownload(String id) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getById((Serializable)((Object)id)));
        return this.getFile(flow.getFlowId());
    }

    @Override
    public FileDownloadRp signFileDownloadByRelationId(String id) {
        ElsEsignV3Flow flow = (ElsEsignV3Flow)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ElsEsignV3Flow::getRelationId, (Object)id)).eq(ElsEsignV3Flow::getArchiving, (Object)"1"), false));
        Assert.notNull((Object)((Object)flow), (String)I18nUtil.translate((String)"i18n_field_LSMuIdjPWQI_d1dc8b25", (String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7b7e\u7f72\u6587\u4ef6"));
        return this.getFile(flow.getFlowId());
    }

    @Override
    public ElsEsignV3VO multipleSave(ElsEsignV3VO flow) {
        if (StrUtil.isBlank((CharSequence)flow.getId())) {
            flow.setBusNumber(this.invokeBaseRpcService.getNextCode("srmEsignV3Number", (Object)flow));
            flow.setBusType("multipleSign");
            this.saveMain(flow);
        } else {
            this.editMain(flow);
        }
        return flow;
    }

    private LaunchRq buildLaunchRq(ElsEsignV3VO flowVo) {
        String filesId = flowVo.getFilesId();
        ArrayList docs = Lists.newArrayList();
        ArrayList attachments = Lists.newArrayList();
        if ("multipleSign".equals(flowVo.getBusType())) {
            String[] purchaseAttachments = flowVo.getPurchaseAttachments();
            purchaseAttachments.forEach(x -> {
                LaunchRq.Doc doc = new LaunchRq.Doc();
                doc.setFileId(x.getFileId());
                if ("1".equals(x.getSignType())) {
                    docs.add(doc);
                } else {
                    attachments.add(doc);
                }
            });
        } else {
            for (String fileId : filesId.split(",")) {
                LaunchRq.Doc doc = new LaunchRq.Doc();
                doc.setFileId(fileId);
                docs.add(doc);
            }
        }
        LaunchRq launchRq = LaunchRq.builder().docs(docs).attachments(attachments).signFlowConfig(this.buildSignFlowConfig(flowVo)).signers(this.buildSigners(flowVo, docs)).signFlowInitiator(this.buildFlowInitiator(flowVo)).build();
        return launchRq;
    }

    private LaunchRq.SignFlowInitiator buildFlowInitiator(ElsEsignV3VO flowVo) {
        LaunchRq.SignFlowInitiator signFlowInitiator = new LaunchRq.SignFlowInitiator();
        LaunchRq.SignFlowInitiator.OrgInitiator orgInitiator = new LaunchRq.SignFlowInitiator.OrgInitiator();
        orgInitiator.setOrgId(flowVo.getPurchaseSignersList().get(0).getOrgId());
        LaunchRq.SignFlowInitiator.Transactor transactor = new LaunchRq.SignFlowInitiator.Transactor();
        transactor.setPsnId(flowVo.getPurchaseSignersList().get(0).getPsnId());
        orgInitiator.setTransactor(transactor);
        signFlowInitiator.setOrgInitiator(orgInitiator);
        return signFlowInitiator;
    }

    public static void main(String[] args) {
        String s = "2_147_361.211";
        String[] a = s.split("_");
        System.out.println(a[0]);
        System.out.println(a[1]);
        System.out.println(a[2]);
    }

    private List<LaunchRq.Signers> buildSigners(ElsEsignV3VO flowVo, List<LaunchRq.Doc> docs) {
        ArrayList dbs = Lists.newArrayList();
        if (SrmSignatoryType.PURCHASE.getCode().equals(flowVo.getFirstSeal())) {
            dbs.addAll(flowVo.getPurchaseSignersList());
            dbs.addAll(flowVo.getSaleSignersList());
        } else {
            dbs.addAll(flowVo.getSaleSignersList());
            dbs.addAll(flowVo.getPurchaseSignersList());
        }
        ArrayList list = Lists.newArrayList();
        for (ElsEsignV3Signers signers : dbs) {
            LaunchRq.Signers toSigners = new LaunchRq.Signers();
            toSigners.setSignerType(Integer.valueOf(signers.getSignerType()));
            toSigners.setNoticeConfig(new LaunchRq.Signers.NoticeConfig());
            ArrayList signFields = Lists.newArrayList();
            for (LaunchRq.Doc doc : docs) {
                String fileId = doc.getFileId();
                LaunchRq.Signers.SignFields sf = new LaunchRq.Signers.SignFields();
                sf.setFileId(fileId);
                sf.setCustomBizNum(signers.getId());
                LaunchRq.Signers.SignFields.NormalSignFieldConfig normalSignFieldConfig = new LaunchRq.Signers.SignFields.NormalSignFieldConfig();
                if (ObjectUtil.isNotEmpty((Object)signers.getSignFieldStyle()) && !"0".equals(signers.getSignFieldStyle())) {
                    normalSignFieldConfig.setSignFieldStyle(Integer.valueOf(signers.getSignFieldStyle()));
                }
                if (flowVo.getBusType().equals("multipleSign") && !StrUtil.equals((CharSequence)fileId, (CharSequence)signers.getFilesId())) {
                    normalSignFieldConfig.setFreeMode(Boolean.TRUE);
                } else if (StrUtil.equals((CharSequence)"1", (CharSequence)signers.getAutoArchive()) || StrUtil.isNotBlank((CharSequence)signers.getSealIds()) || StrUtil.isNotBlank((CharSequence)signers.getSignArea())) {
                    normalSignFieldConfig.setFreeMode(Boolean.FALSE);
                    normalSignFieldConfig.setAutoSign(StrUtil.equals((CharSequence)"1", (CharSequence)signers.getAutoArchive()));
                    normalSignFieldConfig.setAssignedSealId(signers.getSealIds());
                    if (StrUtil.isNotBlank((CharSequence)signers.getSignArea())) {
                        LaunchRq.Signers.SignFields.NormalSignFieldConfig.SignFieldPosition signFieldPosition = new LaunchRq.Signers.SignFields.NormalSignFieldConfig.SignFieldPosition();
                        String[] area = signers.getSignArea().split("_");
                        signFieldPosition.setPositionPage(area[0]);
                        signFieldPosition.setPositionX(Float.valueOf(area[1]));
                        signFieldPosition.setPositionY(Float.valueOf(area[2]));
                        normalSignFieldConfig.setSignFieldPosition(signFieldPosition);
                    }
                } else {
                    normalSignFieldConfig.setFreeMode(Boolean.TRUE);
                }
                sf.setNormalSignFieldConfig(normalSignFieldConfig);
                signFields.add(sf);
            }
            switch (EsignV3SignerTypeEnum.getByValue(signers.getSignerType())) {
                case PSN: {
                    PersonalRq.PsnAuthConfig psnAuthConfig = new PersonalRq.PsnAuthConfig();
                    psnAuthConfig.setPsnId(signers.getPsnId());
                    toSigners.setPsnSignerInfo(psnAuthConfig);
                    break;
                }
                case ORG: {
                    LaunchRq.Signers.OrgSignerInfo orgSignerInfo = new LaunchRq.Signers.OrgSignerInfo();
                    PersonalRq.PsnAuthConfig tr = new PersonalRq.PsnAuthConfig();
                    tr.setPsnId(signers.getPsnId());
                    if (!StrUtil.equals((CharSequence)"1", (CharSequence)signers.getAutoArchive())) {
                        orgSignerInfo.setTransactorInfo(tr);
                        orgSignerInfo.setOrgId(signers.getOrgId());
                    }
                    toSigners.setOrgSignerInfo(orgSignerInfo);
                    break;
                }
            }
            toSigners.setSignFields(signFields);
            list.add(toSigners);
        }
        return list;
    }

    private LaunchRq.SignFlowConfig buildSignFlowConfig(ElsEsignV3VO flowVo) {
        LaunchRq.SignFlowConfig signFlowConfig = new LaunchRq.SignFlowConfig();
        signFlowConfig.setSignFlowTitle(flowVo.getBusinessScene());
        if (ObjectUtil.isNotEmpty((Object)flowVo.getCutOffTime())) {
            signFlowConfig.setSignFlowExpireTime(flowVo.getCutOffTime().getTime());
        }
        if (StrUtil.isNotBlank((CharSequence)flowVo.getAutoInitiate())) {
            signFlowConfig.setAutoStart("1".equals(flowVo.getAutoInitiate()));
        }
        if (StrUtil.isNotBlank((CharSequence)flowVo.getNoticeType())) {
            signFlowConfig.setNoticeConfig(LaunchRq.SignFlowConfig.NoticeConfig.builder().noticeTypes(flowVo.getNoticeType()).build());
        }
        signFlowConfig.setNotifyUrl(this.esignV3Properties.getCallBackUrl() + "/esignv3/elsEsignV3Flow/noToken/callback");
        return signFlowConfig;
    }

    private void handleEditSigner(List<ElsEsignV3Signers> signers, String roleType, String headId) {
        List oldPurchaseSigners = signers.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getId())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(oldPurchaseSigners)) {
            List ids = oldPurchaseSigners.stream().map(x -> x.getId()).collect(Collectors.toList());
            this.signersService.removeByIds(ids);
        }
        signers.forEach(p -> {
            p.setRoleType(roleType);
            p.setId(null);
            p.setHeadId(headId);
        });
        this.signersService.saveBatch(signers);
    }

    private void handleEditAttachment(List<ElsEsignV3Attachment> attachments, String roleType, String headId) {
        List oldAttachments = attachments.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getId())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(oldAttachments)) {
            List ids = oldAttachments.stream().map(x -> x.getId()).collect(Collectors.toList());
            this.esignV3AttachmentService.removeByIds(ids);
        }
        attachments.forEach(p -> {
            p.setAccountType(roleType);
            p.setId(null);
            p.setHeadId(headId);
        });
        this.esignV3AttachmentService.saveBatch(attachments);
    }
}

