/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.InterfaceApp;
import com.els.modules.system.entity.InterfaceAppPermission;
import com.els.modules.system.mapper.InterfaceAppPermissionMapper;
import com.els.modules.system.service.InterfaceAppPermissionService;
import com.els.modules.system.service.InterfaceAppService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class InterfaceAppPermissionServiceImpl
extends ServiceImpl<InterfaceAppPermissionMapper, InterfaceAppPermission>
implements InterfaceAppPermissionService {
    private static final String REDIS_KEY = "interface:appPermission:";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private InterfaceAppService interfaceAppService;

    @Override
    public void saveInterfaceAppPermission(InterfaceAppPermission interfaceAppPermission) {
        InterfaceApp app = (InterfaceApp)((Object)this.interfaceAppService.getById((Serializable)((Object)interfaceAppPermission.getAppId())));
        interfaceAppPermission.setElsAccount(app.getElsAccount());
        interfaceAppPermission.setId(null);
        ((InterfaceAppPermissionMapper)this.baseMapper).insert(interfaceAppPermission);
        String redisKey = REDIS_KEY + interfaceAppPermission.getAppId();
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public void updateInterfaceAppPermission(InterfaceAppPermission interfaceAppPermission) {
        ((InterfaceAppPermissionMapper)this.baseMapper).updateById(interfaceAppPermission);
    }

    @Override
    public void delInterfaceAppPermission(String id) {
        InterfaceAppPermission appPermission = (InterfaceAppPermission)((InterfaceAppPermissionMapper)this.baseMapper).selectById((Serializable)((Object)id));
        ((InterfaceAppPermissionMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        String redisKey = REDIS_KEY + appPermission.getAppId();
        this.redisUtil.del(new String[]{redisKey});
    }

    @Override
    public void delBatchInterfaceAppPermission(List<String> idList) {
        ((InterfaceAppPermissionMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Boolean checkAppPermission(String elsAccount, String appId, String interfaceCode) {
        String redisKey = REDIS_KEY + appId;
        List appPermissionList = (List)this.redisUtil.get(redisKey);
        if (appPermissionList == null) {
            List permissionList = ((InterfaceAppPermissionMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"app_id", (Object)appId));
            appPermissionList = permissionList.stream().map(InterfaceAppPermission::getInterfaceCode).collect(Collectors.toList());
            this.redisUtil.set(redisKey, appPermissionList, 7200L);
        }
        if (appPermissionList.contains(interfaceCode)) {
            return true;
        }
        return false;
    }

    @Override
    public void batchSavePermission(String appId, String elsAccount, List<InterfaceAppPermission> appPermissionList) {
        if (StrUtil.isBlank((CharSequence)appId)) {
            throw new ELSBootException("appId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        elsAccount = StringUtils.isBlank((CharSequence)elsAccount) ? "100000" : elsAccount;
        List dbAppPermissionList = ((InterfaceAppPermissionMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"app_id", (Object)appId));
        List interfaceCodeList = dbAppPermissionList.stream().map(InterfaceAppPermission::getInterfaceCode).collect(Collectors.toList());
        ArrayList<InterfaceAppPermission> insertList = new ArrayList<InterfaceAppPermission>();
        for (InterfaceAppPermission permission : appPermissionList) {
            if (interfaceCodeList.contains(permission.getInterfaceCode())) continue;
            InterfaceAppPermission appPermission = new InterfaceAppPermission();
            appPermission.setAppId(appId);
            appPermission.setElsAccount(elsAccount);
            appPermission.setInterfaceCode(permission.getInterfaceCode());
            insertList.add(appPermission);
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList, 2000);
            String redisKey = REDIS_KEY + appId;
            this.redisUtil.del(new String[]{redisKey});
        }
    }

    @Override
    public void batchDeletePermission(String appId, List<InterfaceAppPermission> appPermissionList) {
        if (StrUtil.isBlank((CharSequence)appId)) {
            throw new ELSBootException("appId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (InterfaceAppPermission permission : appPermissionList) {
            if (!StrUtil.isNotBlank((CharSequence)permission.getId())) continue;
            idList.add(permission.getId());
        }
        if (!idList.isEmpty()) {
            ((InterfaceAppPermissionMapper)this.baseMapper).deleteBatchIds(idList);
            String redisKey = REDIS_KEY + appId;
            this.redisUtil.del(new String[]{redisKey});
        }
    }
}

