/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.MD5Util;
import com.els.common.util.SysUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsCompanyLanguageDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.rpc.service.EnterpriseInvokeSupplierRpcService;
import com.els.modules.system.config.PermissionI18LocalCacheInit;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.model.PermissionTree;
import com.els.modules.system.model.TreeModel;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.service.CompanyPermissionService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.util.PermissionDataUtil;
import com.els.modules.system.vo.PermissionVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/permission"})
@Api(tags={"\u83dc\u5355\u7ba1\u7406"})
public class PermissionController {
    private static final Logger log = LoggerFactory.getLogger(PermissionController.class);
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private RolePermissionService rolePermissionService;
    @Resource
    private InvokeBaseRpcService baseDubboService;
    @Autowired
    private CompanyPermissionService companyPermissionService;
    @Resource
    private EnterpriseInvokeSupplierRpcService enterpriseInvokeSupplierRpcService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Value(value="${els.path.upload}")
    private String uploadPath;
    @Value(value="${els.config.service.address}")
    private String serviceAddress;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"permission#permission:list"})
    @PermissionDataView(businessType="permission")
    public Result<List<PermissionTree>> list() {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(Permission::getSortNo);
            List list = this.permissionService.list((Wrapper)query);
            ArrayList<PermissionVO> resultList = new ArrayList<PermissionVO>();
            for (Permission permission : list) {
                PermissionVO vo = new PermissionVO();
                BeanUtils.copyProperties((Object)permission, (Object)vo);
                resultList.add(vo);
            }
            ArrayList<PermissionTree> treeList = new ArrayList<PermissionTree>();
            this.getTreeList(treeList, resultList, null);
            result.setResult(treeList);
            result.setSuccess(true);
            log.info("======\u83b7\u53d6\u5168\u90e8\u83dc\u5355\u6570\u636e=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getCompanyMenuList"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"permission#permission:companyList"})
    public Result<List<PermissionTree>> getCompanyMenuList() {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            List<PermissionVO> list = this.permissionService.getCompanyMenuList(TenantContext.getTenant());
            ArrayList<PermissionTree> treeList = new ArrayList<PermissionTree>();
            this.getTreeList(treeList, list, null);
            result.setResult(treeList);
            result.setSuccess(true);
            log.info("======\u83b7\u53d6\u5168\u90e8\u83dc\u5355\u6570\u636e=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getUserPermission"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"permission#permission:get"})
    public void getUserPermissionByToken(HttpServletResponse response) throws IOException {
        Result result = new Result();
        try {
            List<PermissionVO> metaList = this.permissionService.queryByAccount(TenantContext.getTenant(), SysUtil.getLoginUser().getSubAccount(), 0);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            List allAuthList = this.permissionService.list((Wrapper)query);
            JSONObject json = new JSONObject();
            JSONArray menujsonArray = new JSONArray();
            this.getPermissionJsonArray(menujsonArray, metaList, null);
            JSONArray authjsonArray = new JSONArray();
            this.getAuthJsonArray(authjsonArray, metaList, allAuthList);
            JSONArray docArray = new JSONArray();
            this.getDocArray(docArray, metaList);
            JSONArray allauthjsonArray = new JSONArray();
            this.getAllAuthJsonArray(allauthjsonArray, allAuthList);
            json.put("menu", (Object)menujsonArray);
            json.put("auth", (Object)authjsonArray);
            json.put("allAuth", (Object)allauthjsonArray);
            json.put("doc", (Object)docArray);
            result.setResult((Object)json);
            result.success("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            result.error500("\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try (ServletOutputStream out = response.getOutputStream();){
            out.write(JSON.toJSONString((Object)result).getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (IOException e) {
            response.getOutputStream().write(JSON.toJSONString((Object)result).getBytes(StandardCharsets.UTF_8));
        }
    }

    @RequestMapping(value={"/getLanguages"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"permission#permission:get"})
    public Result<?> getLanguages() {
        Result result = new Result();
        try {
            List<String> supplierMasterDataBigB = this.enterpriseInvokeSupplierRpcService.getSupplierMasterDataBigB(TenantContext.getTenant());
            Map<Object, Object> hashMap = new HashMap<String, String>();
            supplierMasterDataBigB.add(TenantContext.getTenant());
            if (CollectionUtil.isNotEmpty(supplierMasterDataBigB)) {
                List<ElsCompanyLanguageDTO> authLanguage = this.baseRpcService.getAuthLanguage(supplierMasterDataBigB);
                if (CollectionUtil.isNotEmpty(authLanguage)) {
                    hashMap = this.baseRpcService.translateLanguage(authLanguage);
                } else {
                    hashMap.put("zh", "\u4e2d\u6587");
                    hashMap.put("en", "English");
                }
            } else {
                hashMap.put("zh", "\u4e2d\u6587");
                hashMap.put("en", "English");
            }
            result.setResult((Object)JSONObject.parseObject((String)JSON.toJSONString(hashMap)));
            result.success("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            result.error500("\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    JSONArray getDocArray(JSONArray docArray, List<PermissionVO> metaList) {
        for (PermissionVO vo : metaList) {
            if (StrUtil.isBlank((CharSequence)vo.getUrl())) continue;
            JSONObject object = new JSONObject();
            object.put("path", (Object)vo.getUrl());
            if (StrUtil.isBlank((CharSequence)vo.getHelpDesc())) {
                object.put("hasDoc", (Object)"0");
            } else {
                object.put("hasDoc", (Object)"1");
            }
            docArray.add((Object)object);
        }
        return docArray;
    }

    @SrmValidated
    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u6dfb\u52a0\u83dc\u5355", operateType=2)
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"permission#permission:list"})
    @PermissionDataOpt(businessType="permission", beanClass=PermissionService.class)
    public Result<Permission> add(@RequestBody Permission permission) {
        Result result = new Result();
        try {
            permission = PermissionDataUtil.intelligentProcessData(permission);
            if (StringUtils.isBlank((CharSequence)permission.getNameI18nKey()) && StringUtils.isNotBlank((CharSequence)permission.getName())) {
                permission.setNameI18nKey(this.baseDubboService.checkAndAdd(permission.getName(), "menu"));
            }
            this.permissionService.addPermission(permission);
            this.baseRpcService.putI18nToRedis(permission.getNameI18nKey());
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u7f16\u8f91\u83dc\u5355", operateType=3)
    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"permission#permission:list"})
    @PermissionDataOpt(businessType="permission", beanClass=PermissionService.class)
    public Result<Permission> edit(@RequestBody Permission permission) {
        String language = I18nUtil.getCurrentLanguage();
        if (!"zh".equals(language)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VKsQUOSOscrnt_60467f3f", (String)"\u8bf7\u5728\u4e2d\u6587\u8bed\u8a00\u73af\u5883\u4e2d\u4fee\u6539\u83dc\u5355"));
        }
        Result result = new Result();
        try {
            permission = PermissionDataUtil.intelligentProcessData(permission);
            if (StringUtils.isBlank((CharSequence)permission.getNameI18nKey()) && StringUtils.isNotBlank((CharSequence)permission.getName())) {
                permission.setNameI18nKey(this.baseDubboService.checkAndAdd(permission.getName(), "menu"));
            }
            Permission p = (Permission)this.permissionService.getById((Serializable)((Object)permission.getId()));
            String key = p.getNameI18nKey();
            this.permissionService.editPermission(permission);
            if (!key.equals(permission.getNameI18nKey())) {
                this.baseRpcService.translate();
                this.baseRpcService.putI18nToRedis(permission.getNameI18nKey());
            }
            PermissionI18LocalCacheInit.removeBykey(key);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @ApiOperation(value="\u56fd\u9645\u5316-\u6e05\u9664\u7f13\u5b58", notes="\u56fd\u9645\u5316-\u6e05\u9664\u7f13\u5b58")
    @GetMapping(value={"/delPerRedisData"})
    @RequiresPermissions(value={"i18n#I18n:delRedisData"})
    public Result<?> delRedisData() {
        String elsAccount = CharSequenceUtil.emptyToDefault((CharSequence)TenantContext.getTenant(), (String)"100000");
        PermissionI18LocalCacheInit.removeByElsAccount(elsAccount);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLRW_b20577c3", (String)"\u64cd\u4f5c\u6210\u529f\uff01"));
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u7f16\u8f91\u83dc\u5355", operateType=3)
    @RequestMapping(value={"/companyEdit"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"permission#permission:companyList"})
    public Result<Permission> companyEdit(@RequestBody PermissionVO permission) {
        String language = I18nUtil.getCurrentLanguage();
        if (!"zh".equals(language)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VKsQUOSOscrnt_60467f3f", (String)"\u8bf7\u5728\u4e2d\u6587\u8bed\u8a00\u73af\u5883\u4e2d\u4fee\u6539\u83dc\u5355"));
        }
        Result result = new Result();
        try {
            permission.setId(permission.getCompanyMeunId());
            if (StringUtils.isBlank((CharSequence)permission.getNameI18nKey()) && StringUtils.isNotBlank((CharSequence)permission.getName())) {
                permission.setNameI18nKey(this.baseDubboService.checkAndAdd(permission.getName(), "menu"));
            }
            this.permissionService.editCompanyPermission(permission);
            PermissionI18LocalCacheInit.removeBykey(permission.getNameI18nKey());
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u5220\u9664\u83dc\u5355", operateType=4)
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"permission#permission:list", "permission#permission:companyList"}, logical=Logical.OR)
    @PermissionDataOpt(businessType="permission", beanClass=PermissionService.class)
    public Result<Permission> delete(@RequestParam(name="id") String id) {
        Result result = new Result();
        try {
            this.permissionService.deletePermission(id);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500(e.getMessage());
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u6279\u91cf\u5220\u9664\u83dc\u5355", operateType=4)
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"permission#permission:list", "permission#permission:companyList"}, logical=Logical.OR)
    public Result<Permission> deleteBatch(@RequestParam(name="ids") String ids) {
        Result result = new Result();
        try {
            String[] arr;
            for (String id : arr = ids.split(",")) {
                if (!ConvertUtils.isNotEmpty((Object)id)) continue;
                this.permissionService.deletePermission(id);
            }
            result.success("\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequiresPermissions(value={"permission#permission:list", "permission#permission:companyList"}, logical=Logical.OR)
    @RequestMapping(value={"/queryTreeList"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> queryTreeList() {
        Result result = new Result();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            query.orderByAsc(Permission::getSortNo);
            List list = this.permissionService.list((Wrapper)query);
            for (Permission sysPer : list) {
                ids.add(sysPer.getId());
            }
            ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
            this.getTreeModelList(treeList, list, null);
            HashMap<String, ArrayList<Object>> resMap = new HashMap<String, ArrayList<Object>>();
            resMap.put("treeList", treeList);
            resMap.put("ids", ids);
            result.setResult(resMap);
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryRolePermission"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"role#Role:list", "elsSubAccount#ElsSubAccount:list"}, logical=Logical.OR)
    public Result<List<String>> queryRolePermission(@RequestParam(name="roleId") String roleId) {
        Result result = new Result();
        try {
            List list = this.rolePermissionService.list((Wrapper)new QueryWrapper().lambda().eq(RolePermission::getRoleId, (Object)roleId));
            result.setResult(list.stream().map(SysRolePermission -> String.valueOf(SysRolePermission.getPermissionId())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryCompanyPermission"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"tenant#tenant:list", "language#language:list", "role#Role:list", "elsSubAccount#ElsSubAccount:list", "permission#permission:list", "permission#permission:companyList"}, logical=Logical.OR)
    public Result<List<String>> queryCompanyPermission(@RequestParam(name="elsAccount") String elsAccount) {
        Result result = new Result();
        try {
            List<PermissionVO> permissionList = this.permissionService.getCompanyMenuList(elsAccount);
            result.setResult(permissionList.stream().map(vo -> String.valueOf(vo.getId())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u4fdd\u5b58\u89d2\u8272\u6388\u6743", operateType=3)
    @RequestMapping(value={"/saveRolePermission"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"role#Role:list", "elsSubAccount#ElsSubAccount:list"}, logical=Logical.OR)
    public Result<String> saveRolePermission(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            String roleId = json.getString("roleId");
            String permissionIds = json.getString("permissionIds");
            String lastPermissionIds = json.getString("lastpermissionIds");
            this.rolePermissionService.saveRolePermission(roleId, permissionIds, lastPermissionIds);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
            log.info("======\u89d2\u8272\u6388\u6743\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            result.error500("\u6388\u6743\u5931\u8d25\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u4fdd\u5b58\u4f01\u4e1a\u6388\u6743", operateType=3)
    @RequestMapping(value={"/saveCompanyPermission"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"tenant#tenant:list", "language#language:list", "role#Role:list", "elsSubAccount#ElsSubAccount:list", "permission#permission:list", "permission#permission:companyList"}, logical=Logical.OR)
    public Result<String> saveCompanyPermission(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            String elsAccount = json.getString("elsAccount");
            String permissionIds = json.getString("permissionIds");
            String lastPermissionIds = json.getString("lastpermissionIds");
            this.permissionService.saveCompanyPermission(elsAccount, permissionIds, lastPermissionIds);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
            log.info("======\u4f01\u4e1a\u6388\u6743\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            result.error500("\u6388\u6743\u5931\u8d25\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u4fdd\u5b58\u4f01\u4e1a\u6388\u6743", operateType=3)
    @RequiresPermissions(value={"tenant#tenant:list", "language#language:list", "role#Role:list", "elsSubAccount#ElsSubAccount:list", "permission#permission:list", "permission#permission:companyList"}, logical=Logical.OR)
    @RequestMapping(value={"/saveCompanyPermissionList"}, method={RequestMethod.POST})
    public Result<String> saveCompanyPermissionList(@RequestBody JSONObject json) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        try {
            JSONArray elsAccountList = json.getJSONArray("elsAccountList");
            List strings = elsAccountList.toJavaList(String.class);
            String permissionIds = json.getString("permissionIds");
            String lastPermissionIds = json.getString("lastpermissionIds");
            this.permissionService.saveCompanyPermissionList(strings, permissionIds, lastPermissionIds);
            result.success("\u4fdd\u5b58\u6210\u529f\uff01");
            log.info("======\u4f01\u4e1a\u6388\u6743\u6210\u529f=====\u8017\u65f6:" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            result.error500("\u6388\u6743\u5931\u8d25\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u7cfb\u7edf\u5e2e\u52a9\u8bf4\u660e", notes="\u901a\u8fc7id\u67e5\u8be2\u7cfb\u7edf\u5e2e\u52a9\u8bf4\u660e")
    @GetMapping(value={"/querySysById"})
    @RequiresPermissions(value={"help#help:query"})
    public Result<?> querySysById(@RequestParam(name="id") String id) {
        PermissionVO permissionVO = new PermissionVO();
        Permission permission = (Permission)this.permissionService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant()));
        BeanUtils.copyProperties((Object)permission, (Object)permissionVO);
        List<PurchaseAttachmentDTO> attachmentList = this.baseDubboService.getPurchaseAttachmentListByMainId(id);
        permissionVO.setPurchaseAttachmentList(attachmentList);
        return Result.ok((Object)permissionVO);
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u4fdd\u5b58\u7cfb\u7edf\u7ea7\u5e2e\u52a9\u8bf4\u660e")
    @ApiOperation(value="\u4fdd\u5b58\u7cfb\u7edf\u7ea7\u5e2e\u52a9\u8bf4\u660e", notes="\u4fdd\u5b58\u7cfb\u7edf\u7ea7\u5e2e\u52a9\u8bf4\u660e")
    @RequiresPermissions(value={"permission#permission:list", "permission#permission:companyList"})
    @RequestMapping(value={"/editSysHelpDesc"}, method={RequestMethod.POST})
    public Result<Permission> editSysHelpDesc(@RequestBody Permission permission) {
        Result result = new Result();
        try {
            Permission update = (Permission)this.permissionService.getById((Serializable)((Object)permission.getId()));
            update.setHelpDesc(permission.getHelpDesc());
            this.permissionService.updateById(update);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u5e2e\u52a9\u8bf4\u660e", notes="\u901a\u8fc7id\u67e5\u8be2\u4f01\u4e1a\u5e2e\u52a9\u8bf4\u660e")
    @GetMapping(value={"/queryCompanyById"})
    @RequiresPermissions(value={"help#help:query"})
    public Result<?> queryCompanyById(@RequestParam(name="companyMeunId") String companyMeunId) {
        PermissionVO permissionVO = new PermissionVO();
        CompanyPermission permission = (CompanyPermission)this.companyPermissionService.getById((Serializable)((Object)companyMeunId));
        BeanUtils.copyProperties((Object)permission, (Object)permissionVO);
        List<PurchaseAttachmentDTO> attachmentList = this.baseDubboService.getPurchaseAttachmentListByMainId(companyMeunId);
        permissionVO.setPurchaseAttachmentList(attachmentList);
        return Result.ok((Object)permissionVO);
    }

    @AutoLog(value="\u83dc\u5355\u7ba1\u7406-\u4fdd\u5b58\u4f01\u4e1a\u7ea7\u5e2e\u52a9\u8bf4\u660e")
    @ApiOperation(value="\u4fdd\u5b58\u4f01\u4e1a\u7ea7\u5e2e\u52a9\u8bf4\u660e", notes="\u4fdd\u5b58\u4f01\u4e1a\u7ea7\u5e2e\u52a9\u8bf4\u660e")
    @RequiresPermissions(value={"permission#permission:list", "permission#permission:companyList"}, logical=Logical.OR)
    @RequestMapping(value={"/editCompanyHelpDesc"}, method={RequestMethod.POST})
    public Result<Permission> editCompanyHelpDesc(@RequestBody PermissionVO permission) {
        Result result = new Result();
        try {
            CompanyPermission update = new CompanyPermission();
            update.setId(permission.getCompanyMeunId());
            update.setHelpDesc(permission.getHelpDesc());
            this.companyPermissionService.updateById(update);
            result.success("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @ApiOperation(value="\u83dc\u5355\u7ba1\u7406-\u901a\u8fc7URL\u67e5\u8be2\u5e2e\u52a9\u8bf4\u660e", notes="\u83dc\u5355\u7ba1\u7406-\u901a\u8fc7URL\u67e5\u8be2\u5e2e\u52a9\u8bf4\u660e")
    @GetMapping(value={"/queryByUrl"})
    @RequiresPermissions(value={"help#help:query"})
    public Result<?> queryByUrl(@RequestParam(name="url") String url) {
        String headId;
        List permissionList = this.permissionService.list((Wrapper)new QueryWrapper().likeLeft((Object)"url", (Object)url));
        if (permissionList.isEmpty()) {
            throw new ELSBootException("url " + I18nUtil.translate((String)"i18n_alert_WWWWIdjntxMKW_32c84775", (String)"\u5bf9\u5e94\u7684\u83dc\u5355\u4e0d\u5b58\u5728\uff01"));
        }
        Permission permission = (Permission)permissionList.get(0);
        CompanyPermission companyPermission = (CompanyPermission)this.companyPermissionService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"permission_id", (Object)permission.getId()));
        JSONObject object = new JSONObject();
        if (companyPermission != null && StrUtil.isNotBlank((CharSequence)companyPermission.getHelpDesc())) {
            object.put("helpDesc", (Object)companyPermission.getHelpDesc());
            headId = companyPermission.getId();
        } else {
            object.put("helpDesc", (Object)permission.getHelpDesc());
            headId = permission.getId();
        }
        List<PurchaseAttachmentDTO> attachmentList = this.baseDubboService.getPurchaseAttachmentListByMainId(headId);
        if (!attachmentList.isEmpty()) {
            List videoAttachmentList;
            List fileAttachmentList = attachmentList.stream().filter(item -> "helpCenter".equals(item.getBusinessType())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(fileAttachmentList)) {
                PurchaseAttachmentDTO attachmentDTO = (PurchaseAttachmentDTO)fileAttachmentList.get(0);
                String realPath = this.baseRpcService.getRealPath(attachmentDTO.getFilePath(), attachmentDTO.getSaveType(), true);
                object.put("filePath", (Object)realPath);
            }
            if (CollectionUtil.isNotEmpty(videoAttachmentList = attachmentList.stream().filter(item -> "helpCenterVideo".equals(item.getBusinessType())).collect(Collectors.toList()))) {
                PurchaseAttachmentDTO attachmentDTO = (PurchaseAttachmentDTO)videoAttachmentList.get(0);
                String realPath = this.baseRpcService.getRealPath(attachmentDTO.getFilePath(), attachmentDTO.getSaveType(), true);
                object.put("videoPath", (Object)realPath);
            }
        } else {
            attachmentList = this.baseDubboService.getPurchaseAttachmentListByMainId(permission.getId());
            if (!attachmentList.isEmpty()) {
                List videoAttachmentList;
                List fileAttachmentList = attachmentList.stream().filter(item -> "helpCenter".equals(item.getBusinessType())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(fileAttachmentList)) {
                    PurchaseAttachmentDTO attachmentDTO = (PurchaseAttachmentDTO)fileAttachmentList.get(0);
                    String realPath = this.baseRpcService.getRealPath(attachmentDTO.getFilePath(), attachmentDTO.getSaveType(), true);
                    object.put("filePath", (Object)realPath);
                }
                if (CollectionUtil.isNotEmpty(videoAttachmentList = attachmentList.stream().filter(item -> "helpCenterVideo".equals(item.getBusinessType())).collect(Collectors.toList()))) {
                    PurchaseAttachmentDTO attachmentDTO = (PurchaseAttachmentDTO)videoAttachmentList.get(0);
                    String realPath = this.baseRpcService.getRealPath(attachmentDTO.getFilePath(), attachmentDTO.getSaveType(), true);
                    object.put("videoPath", (Object)realPath);
                }
            }
        }
        return Result.ok((Object)object);
    }

    private void getTreeList(List<PermissionTree> treeList, List<PermissionVO> metaList, PermissionTree temp) {
        for (PermissionVO permission : metaList) {
            permission.setName(PermissionI18LocalCacheInit.translate(permission.getNameI18nKey(), permission.getName()));
            String tempPid = permission.getParentId();
            PermissionTree tree = new PermissionTree(permission);
            if (temp == null && ConvertUtils.isEmpty((Object)tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getId())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeList(treeList, metaList, tree);
        }
    }

    private void getTreeModelList(List<TreeModel> treeList, List<Permission> metaList, TreeModel temp) {
        for (Permission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission);
            if (temp == null && ConvertUtils.isEmpty((Object)tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }

    private void getAllAuthJsonArray(JSONArray jsonArray, List<Permission> allList) {
        for (Permission permission : allList) {
            if (StrUtil.isBlank((CharSequence)permission.getPerms())) continue;
            JSONObject json = new JSONObject();
            if (!"1".equals(permission.getStatus())) continue;
            if (permission.getPerms().contains(";")) {
                for (String str : permission.getPerms().split(";")) {
                    json = new JSONObject();
                    json.put("action", (Object)str);
                    json.put("type", (Object)permission.getPermsType());
                    json.put("status", (Object)permission.getStatus());
                    json.put("describe", (Object)permission.getName());
                    jsonArray.add((Object)json);
                }
                continue;
            }
            json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("type", (Object)permission.getPermsType());
            json.put("status", (Object)permission.getStatus());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private void getAuthJsonArray(JSONArray jsonArray, List<PermissionVO> metaList, List<Permission> allAuthList) {
        for (Permission permission : metaList) {
            JSONObject json;
            if (permission.getMenuType() == null || StrUtil.isBlank((CharSequence)permission.getPerms()) || !"1".equals(permission.getStatus())) continue;
            if (permission.getPerms().contains(";")) {
                for (String str : permission.getPerms().split(";")) {
                    json = new JSONObject();
                    json.put("action", (Object)str);
                    json.put("type", (Object)permission.getPermsType());
                    json.put("describe", (Object)permission.getName());
                    jsonArray.add((Object)json);
                }
                continue;
            }
            json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("type", (Object)permission.getPermsType());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private void getPermissionJsonArray(JSONArray jsonArray, List<PermissionVO> metaList, JSONObject parentJson) {
        for (Permission permission : metaList) {
            if (permission.getMenuType() == null) continue;
            String tempPid = permission.getParentId();
            permission.setName(PermissionI18LocalCacheInit.translate(permission.getNameI18nKey(), permission.getName()));
            JSONObject json = this.getPermissionJsonObject(permission);
            if (json == null) continue;
            if (parentJson == null && ConvertUtils.isEmpty((Object)tempPid)) {
                jsonArray.add((Object)json);
                if (permission.isLeaf()) continue;
                this.getPermissionJsonArray(jsonArray, metaList, json);
                continue;
            }
            if (parentJson == null || !ConvertUtils.isNotEmpty((Object)tempPid) || !tempPid.equals(parentJson.getString("id"))) continue;
            if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
                JSONObject metaJson = parentJson.getJSONObject("meta");
                if (metaJson.containsKey((Object)"permissionList")) {
                    metaJson.getJSONArray("permissionList").add((Object)json);
                    continue;
                }
                JSONArray permissionList = new JSONArray();
                permissionList.add((Object)json);
                metaJson.put("permissionList", (Object)permissionList);
                continue;
            }
            if (!permission.getMenuType().equals(CommonConstant.MENU_TYPE_1) && !permission.getMenuType().equals(CommonConstant.MENU_TYPE_0)) continue;
            if (parentJson.containsKey((Object)"children")) {
                parentJson.getJSONArray("children").add((Object)json);
            } else {
                JSONArray children = new JSONArray();
                children.add((Object)json);
                parentJson.put("children", (Object)children);
            }
            if (permission.isLeaf()) continue;
            this.getPermissionJsonArray(jsonArray, metaList, json);
        }
    }

    private JSONObject getPermissionJsonObject(Permission permission) {
        JSONObject json = new JSONObject();
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
            return null;
        }
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_0) || permission.getMenuType().equals(CommonConstant.MENU_TYPE_1)) {
            json.put("id", (Object)permission.getId());
            if (permission.isRoute()) {
                json.put("route", (Object)"1");
            } else {
                json.put("route", (Object)"0");
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                json.put("path", (Object)MD5Util.md5Encode((String)permission.getUrl(), (String)"utf-8"));
            } else {
                json.put("path", (Object)permission.getUrl());
            }
            json.put("mobile", (Object)permission.isMobile());
            if (ConvertUtils.isNotEmpty((Object)permission.getComponentName())) {
                json.put("name", (Object)permission.getComponentName());
            } else {
                json.put("name", (Object)this.urlToRouteName(permission.getUrl()));
            }
            if (permission.isHidden()) {
                json.put("hidden", (Object)true);
            }
            if (permission.isAlwaysShow()) {
                json.put("alwaysShow", (Object)true);
            }
            json.put("component", (Object)permission.getComponent());
            JSONObject meta = new JSONObject();
            if (permission.isKeepAlive()) {
                meta.put("keepAlive", (Object)true);
            } else {
                meta.put("keepAlive", (Object)false);
            }
            if (permission.isDefaultAudit()) {
                meta.put("defaultAudit", (Object)true);
            } else {
                meta.put("defaultAudit", (Object)false);
            }
            if (permission.isInternalOrExternal()) {
                meta.put("internalOrExternal", (Object)true);
            } else {
                meta.put("internalOrExternal", (Object)false);
            }
            meta.put("title", (Object)permission.getName());
            if (ConvertUtils.isEmpty((Object)permission.getParentId())) {
                json.put("redirect", (Object)permission.getRedirect());
                if (ConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty((Object)permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            } else {
                if (ConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty((Object)permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            }
            meta.put("pageBusinessType", (Object)permission.getPageBusinessType());
            meta.put("pageColumnsCode", (Object)permission.getPageColumnsCode());
            meta.put("pagePattern", (Object)permission.getPagePattern());
            meta.put("pageBusinessUrl", (Object)permission.getPageBusinessUrl());
            meta.put("pageAuditSubject", (Object)permission.getPageAuditSubject());
            if (this.isWWWHttpUrl(permission.getUrl())) {
                String url = permission.getUrl();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("elsAccount", TenantContext.getTenant());
                url = TemplateParseUtil.getTemplateText(null, (String)url, map);
                meta.put("url", (Object)url);
            }
            if (StrUtil.isNotBlank((CharSequence)permission.getHelpDocUrl())) {
                meta.put("helpDocUrl", (Object)permission.getHelpDocUrl());
            }
            json.put("meta", (Object)meta);
        }
        return json;
    }

    private boolean isWWWHttpUrl(String url) {
        return url != null && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("{{"));
    }

    private String urlToRouteName(String url) {
        if (ConvertUtils.isNotEmpty((Object)url)) {
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = url.replace("/", "-");
            url = url.replace(":", "@");
            return url;
        }
        return null;
    }
}

