/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterprise.open.api.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.service.SrmToIPaasRpcService;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.mapper.ElsEnterpriseInfoMapper;
import com.els.modules.enterprise.open.api.EnterpriseInfoOpenService;
import com.els.modules.enterprise.vo.CreateAccountDto;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.enumerate.SourceTypeEnum;
import com.els.modules.supplier.api.enumerate.SupplierStatusEnum;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.CompanyPermissionMapper;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.service.impl.RolePermissionServiceImpl;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="enterpriseInfoOpen")
public class EnterpriseInfoOpenServiceImpl
implements EnterpriseInfoOpenService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseInfoOpenServiceImpl.class);
    @Autowired
    private SrmToIPaasRpcService srmToIPaasService;
    @Resource
    private InvokeBaseRpcService coreInvokeBaseRpcService;
    @Autowired
    private ElsEnterpriseInfoMapper enterpriseInfoMapper;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private PersonalSettingService personalSettingService;
    @Autowired
    private AccountRpcService accountRpcService;
    @Autowired
    private ElsTenantService elsTenantService;
    @Autowired
    private ImGroupInvokeRpcService invokeRpcService;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private RolePermissionService rolePermissionService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CoreInvokeSupplierRpcService supplierMasterDataRpcService;
    private static final String DEFAULT_VALUE = "123456";
    public static final String ACCOUNT_PERMISSION = "sys:createAccount:permission:";

    @Override
    @Transactional
    public JSONObject createEnterpriseInfo(JSONObject json) {
        LambdaQueryWrapper queryWrapper;
        List enterpriseInfoList;
        CreateAccountDto accountDto = (CreateAccountDto)JSON.parseObject((String)JSON.toJSONString((Object)json), CreateAccountDto.class);
        log.info("CreateAccountUtil-->createAccount \u3010show\u3011 input param\uff1acompanyName\uff1a{} phoneNumber\uff1a{}", (Object)accountDto.getCompanyName(), (Object)accountDto.getPhoneNumber());
        if (!this.checkOutParam(accountDto)) {
            throw new RuntimeException("\u8bf7\u68c0\u67e5\u53c2\u6570\u5fc5\u586b\u9879\uff01");
        }
        String deployWay = SysUtil.getDeployWay();
        String els_account = "cloud".equals(deployWay) ? "100000" : SysUtil.getPurchaseAccount();
        ElsEnterpriseInfo elsEnterpriseInfo = null;
        String sourceType = SourceTypeEnum.BATCH_IMPORT.getValue();
        if ("purchase".equals(accountDto.getPermissionType())) {
            sourceType = SourceTypeEnum.BUSINESS_PROMOTION.getValue();
        }
        if (CollUtil.isNotEmpty((Collection)(enterpriseInfoList = this.enterpriseInfoMapper.selectList((Wrapper)(queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ElsEnterpriseInfo::getName, (Object)accountDto.getCompanyName())))))) {
            elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)enterpriseInfoList.get(0));
        } else {
            JSONObject result = this.srmToIPaasService.callIPaasInterface(EnterpriseInfoOpenServiceImpl.getIpaaSData(accountDto.getCompanyName(), sourceType, els_account), "valueAddedApplication", this.coreInvokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
            log.info("result info:{}", (Object)JSON.toJSONString((Object)result));
            if (result.getBoolean("success").booleanValue()) {
                elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)JSONObject.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfo.class));
                ElsEnterpriseInfo enterpriseInfo = this.enterpriseInfoMapper.getByElsAccount(elsEnterpriseInfo.getElsAccount());
                if (enterpriseInfo == null) {
                    elsEnterpriseInfo.setDeleted(0);
                    this.enterpriseInfoMapper.insert((Object)elsEnterpriseInfo);
                } else {
                    elsEnterpriseInfo.setId(enterpriseInfo.getId());
                    this.enterpriseInfoMapper.updateById((Object)elsEnterpriseInfo);
                }
            } else {
                throw new RuntimeException(result.getString("msg"));
            }
        }
        this.createAccount(elsEnterpriseInfo, "1001", accountDto);
        return JSON.parseObject((String)JSON.toJSONString((Object)((Object)elsEnterpriseInfo)));
    }

    private boolean checkOutParam(CreateAccountDto accountDto) {
        if (StringUtils.isBlank((CharSequence)accountDto.getCompanyName())) {
            return false;
        }
        boolean result = true;
        if ("sale".equals(accountDto.getPermissionType()) && StringUtils.isBlank((CharSequence)accountDto.getElsAccount())) {
            return false;
        }
        return result;
    }

    public static JSONObject getIpaaSData(String companyName, String sourceType, String elsAccount) {
        JSONObject data = new JSONObject();
        JSONObject base = new JSONObject();
        base.put("keyword", (Object)companyName);
        JSONObject body = new JSONObject();
        body.put("channel", (Object)sourceType);
        String auth = SourceTypeEnum.OPEN_REGISTER.getValue().equals(sourceType) ? "1" : "0";
        body.put("auth", (Object)auth);
        data.put("base", (Object)base);
        data.put("body", (Object)body);
        data.put("currentAccount", (Object)elsAccount);
        return data;
    }

    private JSONObject getIpaaSRelationData(String purchaserElsAccount, String providerElsAccount) {
        JSONObject data = new JSONObject();
        data.put("purchaserElsAccount", (Object)purchaserElsAccount);
        data.put("providerElsAccount", (Object)providerElsAccount);
        return data;
    }

    public void createAccount(ElsEnterpriseInfo elsEnterpriseInfo, String subAccount, CreateAccountDto accountDto) {
        String elsAccount = elsEnterpriseInfo.getElsAccount();
        ElsSubAccount account = new ElsSubAccount();
        account.setElsAccount(elsAccount);
        account.setSubAccount(subAccount);
        account.setRealname(StringUtils.isEmpty((CharSequence)accountDto.getSubName()) ? "\u7ba1\u7406\u5458" : accountDto.getSubName());
        if (!StringUtils.isEmpty((CharSequence)accountDto.getPhoneNumber())) {
            account.setPhone(accountDto.getPhoneNumber());
        }
        account.setStatus(1);
        account.setSalt(ConvertUtils.randomGen((int)8));
        String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + account.getSubAccount()), (String)DEFAULT_VALUE, (String)account.getSalt());
        account.setPassword(passwordEncode);
        account.setDeleted(CommonConstant.DEL_FLAG_0);
        account.setEmail(accountDto.getEmail());
        account.setAvatar(accountDto.getAvatar());
        account.setSourceType(accountDto.getSourceType());
        account.setSourceSystem(accountDto.getThirdType());
        Role role = this.createOrGetRole(accountDto, elsAccount);
        boolean exist = this.elsSubAccountService.createUserIfNotExist(account);
        if (!exist) {
            ((UserRoleService)SpringContextUtils.getBean(UserRoleService.class)).save(new UserRole(account.getId(), role.getId()));
            this.invokeRpcService.initGroup(account.getId());
        }
        List personalSettingList = this.accountRpcService.buildPersonalSetting(elsAccount, account.getSubAccount());
        LambdaQueryWrapper settingWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)settingWrapper.select(new SFunction[]{PersonalSetting::getReceiveType}).eq(PersonalSetting::getElsAccount, (Object)elsAccount)).eq(PersonalSetting::getSubAccount, (Object)account.getSubAccount())).groupBy(PersonalSetting::getReceiveType);
        List receiveTypeList = this.personalSettingService.list((Wrapper)settingWrapper);
        if (CollUtil.isNotEmpty((Collection)receiveTypeList)) {
            List receiveTypeStr = receiveTypeList.stream().map(PersonalSetting::getReceiveType).distinct().collect(Collectors.toList());
            personalSettingList = personalSettingList.stream().filter(p -> !receiveTypeStr.contains(p.getReceiveType())).collect(Collectors.toList());
        }
        ArrayList<PersonalSetting> psl = new ArrayList<PersonalSetting>();
        for (PersonalSettingDTO personalSettingDTO : personalSettingList) {
            PersonalSetting personalSet = new PersonalSetting();
            BeanUtils.copyProperties((Object)personalSettingDTO, (Object)personalSet);
            psl.add(personalSet);
        }
        this.personalSettingService.saveOrUpdateBatch(psl);
        this.elsTenantService.createIfNotExistElsTenant(elsAccount, accountDto.getCompanyName());
        String roleElsAccount = "100000";
        if ("1001".equals(subAccount) && !exist) {
            List<Object> list = new ArrayList();
            if ("sale".equals(accountDto.getPermissionType()) && StringUtils.isNotBlank((CharSequence)accountDto.getElsAccount())) {
                String redisKey;
                RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
                if (redisUtil.get(redisKey = ACCOUNT_PERMISSION + accountDto.getElsAccount()) == null && CharSequenceUtil.isNotBlank((CharSequence)accountDto.getElsAccount())) {
                    HashSet<String> accountSet = new HashSet<String>();
                    accountSet.add(accountDto.getElsAccount());
                    list = this.permissionMapper.selectWithoutElsAccountToLoadExistSalePermission(accountSet);
                    if (CollUtil.isNotEmpty(list)) {
                        Set<String> permissionIdList = list.stream().map(Permission::getId).collect(Collectors.toSet());
                        list.addAll(this.permissionMapper.selectWithoutElsAccountToLoadSaleButtonPermission(permissionIdList));
                    }
                    redisUtil.set(redisKey, (Object)JSON.toJSONString(list), 1800L);
                } else {
                    list = JSONArray.parseArray((String)redisUtil.get(redisKey).toString(), Permission.class);
                }
            } else {
                Role purchaseRole = this.roleService.getRoleByElsAccountAndSysCode(roleElsAccount, accountDto.getSourceType());
                if (null == purchaseRole) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRCLYuIdKy_3abd3e64", (String)"\u91c7\u8d2d\u65b9\u672a\u627e\u5230\u5bf9\u5e94\u89d2\u8272"));
                }
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(RolePermission::getRoleId, (Object)purchaseRole.getId());
                List list1 = this.rolePermissionService.list((Wrapper)wrapper);
                if (CollectionUtils.isEmpty((Collection)list1)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdKyXLERbW_db434ad9", (String)"\u5bf9\u5e94\u89d2\u8272\u5c1a\u672a\u914d\u7f6e\u6743\u9650"));
                }
                List permissionId = list1.stream().map(RolePermission::getPermissionId).collect(Collectors.toList());
                list = this.permissionMapper.selectBatchIds(permissionId);
            }
            if (list != null) {
                this.permissionMapper.deleteCompanyMeunByAccount(null, elsAccount);
                this.handleCompanyPermissionData(list, role, elsAccount);
            }
        } else if ("1001".equals(subAccount) && exist && "sale".equals(accountDto.getPermissionType())) {
            List salePurchaseData = this.supplierMasterDataRpcService.selectWithoutElsAccountToLoadAllPurchaseBySale(Arrays.asList(elsAccount));
            Set<String> accountSet = salePurchaseData.stream().map(BaseDTO::getElsAccount).collect(Collectors.toSet());
            if (CharSequenceUtil.isNotBlank((CharSequence)accountDto.getElsAccount())) {
                accountSet.add(accountDto.getElsAccount());
            }
            if (CollUtil.isNotEmpty(accountSet)) {
                Collection<String> permissionIdList;
                List<Permission> salePermissionList = this.permissionMapper.selectWithoutElsAccountToLoadExistSalePermission(accountSet);
                if (CollUtil.isNotEmpty(salePermissionList)) {
                    permissionIdList = salePermissionList.stream().map(Permission::getId).collect(Collectors.toSet());
                    salePermissionList.addAll(this.permissionMapper.selectWithoutElsAccountToLoadSaleButtonPermission((Set<String>)permissionIdList));
                }
                permissionIdList = ((CompanyPermissionMapper)SpringContextUtils.getBean(CompanyPermissionMapper.class)).selectWithoutElsAccountToListCompanyPermission(elsAccount);
                List<Permission> list = salePermissionList.stream().filter(permission -> !permissionIdList.contains(permission.getId())).collect(Collectors.toList());
                this.handleCompanyPermissionData(list, role, elsAccount);
            }
        }
        if ("sale".equals(accountDto.getPermissionType())) {
            this.createSupplierMasterData(accountDto, elsEnterpriseInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Role createOrGetRole(CreateAccountDto accountDto, String elsAccount) {
        String tenant = TenantContext.getTenant();
        try {
            TenantContext.setTenant((String)elsAccount);
            Role role = this.roleService.getRoleByElsAccountAndSysCode(elsAccount, "companyAdmin");
            if (role == null) {
                role = new Role();
                role.setElsAccount(elsAccount);
                role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
                role.setRoleCode("companyAdmin");
                if (StringUtils.isNotBlank((CharSequence)accountDto.getThirdType())) {
                    role.setDescription(accountDto.getThirdType());
                }
                this.roleMapper.insert(role);
            }
            Role role2 = role;
            return role2;
        }
        finally {
            TenantContext.clear();
            if (StrUtil.isNotBlank((CharSequence)tenant)) {
                TenantContext.setTenant((String)tenant);
            }
        }
    }

    private void createSupplierMasterData(CreateAccountDto accountDto, ElsEnterpriseInfo elsEnterpriseInfo) {
        SupplierMasterDataDTO supplierMasterDataDTO = new SupplierMasterDataDTO();
        supplierMasterDataDTO.setToElsAccount(elsEnterpriseInfo.getElsAccount());
        supplierMasterDataDTO.setSupplierName(elsEnterpriseInfo.getName());
        supplierMasterDataDTO.setPersonPhone(elsEnterpriseInfo.getPhone());
        supplierMasterDataDTO.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        supplierMasterDataDTO.setSourceType(SourceTypeEnum.GENERATION_REGISTER.getValue());
        supplierMasterDataDTO.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
        supplierMasterDataDTO.setElsAccount(accountDto.getElsAccount());
        this.supplierMasterDataRpcService.addExternalSupplierMasterData(supplierMasterDataDTO);
    }

    private void handleCompanyPermissionData(List<Permission> list, Role role, String elsAccount) {
        ArrayList<CompanyPermission> companyPermissions = new ArrayList<CompanyPermission>();
        for (Permission permission : list) {
            CompanyPermission companyPermission = new CompanyPermission();
            companyPermission.setId(IdWorker.getIdStr());
            companyPermission.setElsAccount(elsAccount);
            companyPermission.setPermissionId(permission.getId());
            companyPermission.setName(permission.getName());
            companyPermission.setSortNo(permission.getSortNo());
            companyPermission.setIcon(permission.getIcon());
            companyPermission.setIconColor(permission.getIconColor());
            companyPermission.setRuleFlag(permission.getRuleFlag());
            companyPermission.setStatus(permission.getStatus());
            companyPermission.setUpdateTime(new Date());
            companyPermissions.add(companyPermission);
        }
        if (CollUtil.isNotEmpty(companyPermissions)) {
            this.permissionMapper.insertCompanyMeunBatch(companyPermissions);
            ArrayList<RolePermission> RolePermissionList = new ArrayList<RolePermission>();
            for (CompanyPermission companyPermission : companyPermissions) {
                RolePermission rolePermission = new RolePermission();
                rolePermission.setElsAccount(elsAccount);
                rolePermission.setRoleId(role.getId());
                rolePermission.setPermissionId(companyPermission.getPermissionId());
                RolePermissionList.add(rolePermission);
            }
            RolePermissionServiceImpl rolePermissionServiceImpl = (RolePermissionServiceImpl)SpringUtil.getBean(RolePermissionServiceImpl.class);
            rolePermissionServiceImpl.saveBatch(RolePermissionList);
        }
    }
}

