/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.socket.utils.SocketUtil;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.vo.ElsSubAccountVO;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5728\u7ebf\u4eba\u6570\u7edf\u8ba1"})
@RestController
@RequestMapping(value={"/account/online"})
public class OnlineController
extends BaseController<ElsSubAccount, ElsSubAccountService> {
    @Resource
    private SocketUtil socketUtil;
    @Resource
    private ElsEnterpriseInfoRpcService enterpriseInfoRpcService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<?> queryPageList(ElsSubAccount user, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)user), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Set stringSet = this.socketUtil.getOnlineUserId();
        if (CollectionUtil.isEmpty((Collection)stringSet)) {
            return Result.ok((Object)new Page((long)pageNo.intValue(), (long)pageSize.intValue(), 0L));
        }
        ((QueryWrapper)queryWrapper.in((Object)"concat(els_account,'_',sub_account)", (Collection)stringSet)).lambda().select(new SFunction[]{BaseEntity::getId, ElsSubAccount::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname, ElsSubAccount::getAvatar, ElsSubAccount::getOrgCode});
        IPage pageList = ((ElsSubAccountService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        List accountList = pageList.getRecords().stream().map(ElsSubAccount::getElsAccount).distinct().collect(Collectors.toList());
        Map<String, String> orgMap = this.enterpriseInfoRpcService.queryByElsAccountList(accountList).stream().collect(Collectors.toMap(BaseDTO::getElsAccount, ElsEnterpriseInfoDTO::getName, (o1, o2) -> o2));
        Result result = new Result();
        String jsonString = JSON.toJSONString((Object)pageList);
        IPage page2 = (IPage)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<Page<ElsSubAccountVO>>(){}, (Feature[])new Feature[0]);
        for (ElsSubAccountVO elsSubAccount : page2.getRecords()) {
            String orDefault = orgMap.getOrDefault(elsSubAccount.getElsAccount(), "");
            elsSubAccount.setEnterpriseName(orDefault);
        }
        result.setSuccess(true);
        result.setResult((Object)page2);
        return result;
    }
}

