/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.CommonAPI;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.LicenseUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.PwVerifyUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.RsaEncryptUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.sms.api.dto.SmsDto;
import com.els.modules.sms.api.dto.SmsResult;
import com.els.modules.supplier.api.dto.SupplierInvitationCodeDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.SubaccountOrg;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.model.LoginModel;
import com.els.modules.system.rpc.service.InvokeSmsRpcService;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.modules.system.service.ElsPasswordPolicyService;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.SubaccountOrgService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.util.MobilePatternUtil;
import com.els.modules.system.vo.ElsPwComplexityAndMinLenVo;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.shiro.authc.JwtToken;
import com.j256.twofactorauth.TimeBasedOneTimePasswordUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account"})
@Api(tags={"\u7528\u6237\u767b\u5f55"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private CommonAPI sysBaseAPI;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsTenantService elsTenantService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Resource
    private com.els.modules.system.rpc.service.InvokeBaseRpcService baseRpcService;
    @Resource
    private InvokeSmsRpcService invokeSmsRpcService;
    @Autowired
    private ElsPasswordSecurityService pwSecurityService;
    @Resource
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;
    @Autowired
    private ElsPasswordPolicyService elsPasswordPolicyService;
    private String version = this.getClass().getPackage().getImplementationVersion();
    private static final String TEMP_TOKEN = "sys:login:tempToken:";
    private static final String TEMP_KEY = "sys:login:encrypted:";
    @Autowired
    private SubaccountOrgService subaccountOrgService;
    @Autowired
    private PersonalSettingService personalSettingService;
    private final String LOCK_PREFIX = "account_sms_mobile";
    private final long EXPIRE_TIME = 30000L;

    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public Result<?> login(@RequestBody LoginModel loginModel) {
        log.info(":::doLogin:{}", (Object)loginModel);
        Result<?> result = this.checkUser(loginModel);
        return result;
    }

    @RequestMapping(value={"/loginByToken"}, method={RequestMethod.GET})
    public Result<?> loginByToken(@RequestParam(name="token", required=true) String token) {
        String account = JwtUtil.getAccount((String)token);
        if (StrUtil.isBlank((CharSequence)account)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWmKNSW_eaed3a3f", (String)"token\u683c\u5f0f\u9519\u8bef\uff01"));
        }
        TenantContext.setTenant((String)account.split("_")[0]);
        ElsSubAccount subAccount = this.elsSubAccountService.getUserByAccount(account);
        String cacheToken = String.valueOf(this.redisUtil.get("sys:token:" + token));
        if (!ConvertUtils.isNotEmpty((Object)cacheToken)) {
            log.info("\u2014\u2014\u2014\u5f53\u524d\u8bed\u79cd\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + I18nUtil.getCurrentLanguage());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWWKXWVVVEHW_8bdef769", (String)"Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!"));
        }
        Result<JSONObject> result = new Result<JSONObject>();
        if (!"100000".equals(subAccount.getElsAccount()) && !(result = this.elsTenantService.checkTenantIsEffective(subAccount.getElsAccount())).isSuccess()) {
            return result;
        }
        this.userInfo(subAccount, result);
        MqUtil.sendLogMsg((String)subAccount.getElsAccount(), (String)("\u8d26\u53f7: " + subAccount.getElsAccount() + "_" + subAccount.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date())), (Integer)1, null);
        return result;
    }

    private String getRedisKey(String elsAccount, String subAccount, String tempToken) {
        StringBuilder builder = new StringBuilder(TEMP_TOKEN);
        builder.append(elsAccount).append(":").append(subAccount).append(":").append(tempToken);
        return builder.toString();
    }

    private Result<?> checkUser(LoginModel loginModel) {
        Result<JSONObject> result = new Result<JSONObject>();
        String password = loginModel.getPassword();
        String tempToken = loginModel.getTempToken();
        String loginType = loginModel.getLoginType();
        String keyId = loginModel.getKeyId();
        if (StrUtil.isNotBlank((CharSequence)keyId)) {
            if (!this.redisUtil.hasKey(TEMP_KEY + keyId)) {
                throw new ELSBootException("\u5f53\u524d\u9875\u9762\u4fe1\u606f\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01");
            }
            try {
                password = RsaEncryptUtil.decrypt((String)password, (String)((String)this.redisUtil.get(TEMP_KEY + keyId)));
            }
            catch (Exception e) {
                log.error("RsaEncryptUtil_decrypt_failed:", (Throwable)e);
            }
        }
        if (StrUtil.isBlank((CharSequence)loginType)) {
            loginType = "account";
        }
        ElsSubAccount user = null;
        if ("account".equals(loginType)) {
            user = this.elsSubAccountService.getUserByAccount(loginModel.getElsAccount().trim() + "_" + loginModel.getSubAccount().trim());
        } else if (StrUtil.isNotBlank((CharSequence)loginModel.getAccountId())) {
            user = (ElsSubAccount)((Object)this.elsSubAccountService.getById((Serializable)((Object)loginModel.getAccountId())));
        } else {
            if (StrUtil.isBlank((CharSequence)loginModel.getPhone())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ltyxOLV_f972269", (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            List<ElsSubAccountVO> accountList = this.elsSubAccountService.getUserListByPhone(loginModel.getPhone().trim());
            if (accountList.size() == 1) {
                user = (ElsSubAccount)((Object)this.elsSubAccountService.getById((Serializable)((Object)accountList.get(0).getId())));
            } else if (accountList.size() > 1) {
                JSONObject obj = new JSONObject();
                obj.put("returnType", (Object)"selectAccount");
                JSONArray array = new JSONArray();
                for (ElsSubAccountVO vo : accountList) {
                    JSONObject item2 = new JSONObject();
                    item2.put("accountId", (Object)vo.getId());
                    item2.put("elsAccount", (Object)vo.getElsAccount());
                    item2.put("subAccount", (Object)vo.getSubAccount());
                    item2.put("realname", (Object)vo.getRealname());
                    item2.put("enterpriseName", (Object)vo.getEnterpriseName());
                    array.add((Object)item2);
                }
                obj.put("accountList", (Object)array);
                return Result.ok((Object)obj);
            }
        }
        result = this.elsSubAccountService.checkUserIsEffective(user);
        if (!result.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)result.getMessage()));
        }
        TenantContext.setTenant((String)user.getElsAccount());
        if (StrUtil.isNotBlank((CharSequence)tempToken)) {
            if ("phone".equals(loginModel.getLoginType()) ? !this.redisUtil.hasKey(tempToken) : !this.redisUtil.hasKey(this.getRedisKey(user.getElsAccount(), user.getSubAccount(), tempToken))) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JKTokenIKXVvMEHEVVHcEHtk_21eb9230", (String)"\u4e34\u65f6Token\u5df2\u5931\u6548\uff0c\u8bf7\u8fd4\u56de\u767b\u5f55\u9875\u91cd\u65b0\u8fdb\u884c\u767b\u5f55\u64cd\u4f5c\uff01"));
            }
            this.checkMfa(loginModel, user);
        } else {
            List<ElsCompanySetDTO> list;
            Optional<ElsCompanySetDTO> optional;
            String mfaSwitch;
            this.pwSecurityService.verifyErrorLock(user.getElsAccount(), user.getSubAccount());
            if (!"100000".equals(user.getElsAccount()) && !(result = this.elsTenantService.checkTenantIsEffective(user.getElsAccount())).isSuccess()) {
                throw new ELSBootException(result.getMessage());
            }
            String userpassword = PasswordUtil.encrypt((String)(user.getElsAccount() + "_" + user.getSubAccount()), (String)password, (String)user.getSalt());
            String syspassword = user.getPassword();
            if (!syspassword.equals(userpassword)) {
                this.pwSecurityService.setUpLoginErrorNum(user.getElsAccount(), user.getSubAccount());
            }
            if (null != user.getAccountValidityDate()) {
                Date accountValidityDate = user.getAccountValidityDate();
                Date timeDate = new Date();
                if (timeDate.getTime() > accountValidityDate.getTime()) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LjeDIRjXAWWdVVKHRvjW_2e44c8f3", (String)"\u60a8\u7684\u8d26\u6237\u5df2\u8fc7\u6709\u6548\u671f\u9650\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
                }
            }
            if ("1".equals(mfaSwitch = (optional = (list = this.baseRpcService.getCompanySetList(user.getElsAccount())).stream().filter(item -> "mfaSwitch".equals(item.getItemCode())).findAny()).isPresent() ? optional.get().getDefaultValue() : "0")) {
                JSONObject obj = new JSONObject();
                obj.put("returnType", (Object)"mfaCheck");
                if (StrUtil.isBlank((CharSequence)user.getPhone())) {
                    obj.put("sms", (Object)"0");
                } else {
                    obj.put("sms", (Object)"1");
                    obj.put("phone", (Object)this.encrypt(user.getPhone()));
                }
                if (StrUtil.isBlank((CharSequence)user.getSecret())) {
                    obj.put("otp", (Object)"0");
                } else {
                    obj.put("otp", (Object)"1");
                }
                tempToken = IdWorker.get32UUID();
                obj.put("tempToken", (Object)tempToken);
                if ("phone".equals(loginModel.getLoginType())) {
                    this.redisUtil.set(tempToken, (Object)user.getPhone(), 600L);
                } else {
                    this.redisUtil.set(this.getRedisKey(user.getElsAccount().trim(), user.getSubAccount().trim(), tempToken), (Object)user.getPhone(), 600L);
                }
                if (StrUtil.isBlank((CharSequence)user.getPhone()) && StrUtil.isBlank((CharSequence)user.getSecret())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_reyLyIltyFLGROTPwZxmLiKmVKHRvj_a6a3b0f9", (String)"\u8be5\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\u4e14\u672a\u8bbe\u7f6eOTP\u5bc6\u94a5\uff0c\u4e8c\u6b21\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
                }
                return Result.ok((Object)obj);
            }
        }
        this.pwSecurityService.setRepeatLoginToken(user.getElsAccount(), user.getSubAccount());
        this.userInfo(user, result);
        if (StrUtil.isNotBlank((CharSequence)loginModel.getThirdUserUuid())) {
            this.bindUserId(user.getId(), user.getElsAccount(), loginModel.getThirdUserUuid());
        }
        MqUtil.sendLogMsg((String)user.getElsAccount(), (String)("\u8d26\u53f7: " + user.getElsAccount() + "_" + user.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date())), (Integer)1, null);
        this.redisUtil.del(new String[]{"shiro:cache:com.els.shiro.authc.ShiroRealm.authorizationCache:" + SysUtil.getLoginUser().getId()});
        return result;
    }

    private String encrypt(String terget) {
        if (StrUtil.isBlank((CharSequence)terget)) {
            return "";
        }
        return terget.replaceAll("(?<=\\S{3})\\S(?=\\S{4})", "*");
    }

    private void checkMfa(LoginModel loginModel, ElsSubAccount elsSubAccount) {
        String mfaType = loginModel.getMfaType();
        String captcha = loginModel.getCaptcha();
        if (StrUtil.isBlank((CharSequence)mfaType)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xmJOAcxOLV_532f9921", (String)"\u4e8c\u6b21\u6821\u9a8c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if ("sms".equals(mfaType)) {
            if (!captcha.equals(this.redisUtil.get("sys:sms:captcha:" + elsSubAccount.getPhone()))) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_OioNSSNIOKX_f9783afc", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u7ecf\u5931\u6548\uff01"));
            }
        } else {
            try {
                String code = TimeBasedOneTimePasswordUtil.generateCurrentNumberString((String)elsSubAccount.getSecret());
                if (!captcha.equals(code)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_OioNSSNIOKX_f9783afc", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u7ecf\u5931\u6548\uff01"));
                }
            }
            catch (GeneralSecurityException e) {
                log.error("TimeBasedOneTimePasswordUtil_generateCurrentNumberString_failed:", (Throwable)e);
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_OTPOiobLKmVKHRvj_7f13e7e6", (String)"OTP\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
            }
        }
    }

    private void bindUserId(String userId, String elsAccount, String thirdUserUuid) {
        ThirdAccount thirdAccount = (ThirdAccount)((Object)this.thirdAccountService.getById((Serializable)((Object)thirdUserUuid)));
        if (null == thirdAccount) {
            return;
        }
        thirdAccount.setUserId(userId);
        thirdAccount.setElsAccount(elsAccount);
        this.thirdAccountService.updateById((Object)thirdAccount);
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    public Result<Object> logout(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getHeader("X-Access-Token");
        if (ConvertUtils.isEmpty((Object)token)) {
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_YGEHLRW_16e62e1e", (String)"\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01"));
        }
        String account = JwtUtil.getAccount((String)token);
        LoginUser sysUser = this.sysBaseAPI.getUserByAccount(account);
        if (sysUser != null) {
            MqUtil.sendLogMsg((String)sysUser.getElsAccount(), (String)("\u8d26\u53f7: " + account + ",\u9000\u51fa\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date())), (Integer)4, null);
            log.info(" \u8d26\u53f7:  " + account + ",\u9000\u51fa\u6210\u529f\uff01 ");
            this.redisUtil.del(new String[]{"sys:token:" + token});
            this.redisUtil.del(new String[]{"sys:token:" + account});
            this.redisUtil.del(new String[]{"sys:token:repeat:" + token});
            this.redisUtil.del(new String[]{"shiro:cache:com.els.shiro.authc.ShiroRealm.authorizationCache:" + sysUser.getId()});
            this.redisUtil.del(new String[]{String.format("%s::%s", "sys:cache:user", account)});
            this.redisUtil.del(new String[]{"sys:token:role:" + token});
            SecurityUtils.getSubject().logout();
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_YGEHLRW_16e62e1e", (String)"\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01"));
    }

    @AutoLog(value="\u53d1\u9001\u767b\u5f55\u77ed\u4fe1\u9a8c\u8bc1\u7801\u63a5\u53e3", logType=1)
    @PostMapping(value={"/noToken/sendSms"})
    public Result<String> sendSms(@RequestBody LoginModel loginModel) {
        String tempToken = loginModel.getTempToken();
        String elsAccount = StringUtils.isNotBlank((CharSequence)loginModel.getElsAccount()) ? loginModel.getElsAccount().trim() : null;
        String subAccount = StringUtils.isNotBlank((CharSequence)loginModel.getSubAccount()) ? loginModel.getSubAccount().trim() : null;
        String redisKey = tempToken;
        redisKey = "phone".equals(loginModel.getLoginType()) ? tempToken : this.getRedisKey(elsAccount, subAccount, tempToken);
        if (!this.redisUtil.hasKey(redisKey)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JKTokenIKXVvMEHEVVHcEHtk_21eb9230", (String)"\u4e34\u65f6Token\u5df2\u5931\u6548\uff0c\u8bf7\u8fd4\u56de\u767b\u5f55\u9875\u91cd\u65b0\u8fdb\u884c\u767b\u5f55\u64cd\u4f5c\uff01"));
        }
        String phone = (String)this.redisUtil.get(redisKey);
        if (!phone.equals(loginModel.getPhone())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ltyWNNS_9658cfd1", (String)"\u624b\u673a\u53f7\u8f93\u5165\u9519\u8bef\uff01"));
        }
        SmsDto smsDto = new SmsDto();
        smsDto.setSmsmode("0");
        smsDto.setMobile(phone);
        Result result = new Result();
        SmsResult smsResult = this.invokeSmsRpcService.sendSms(smsDto);
        result.setSuccess(smsResult.isSuccess());
        result.setMessage(smsResult.getMessage());
        return result;
    }

    @AutoLog(value="\u53d1\u77ed\u4fe1\u77ed\u4fe1\u63a5\u53e3", logType=1)
    @PostMapping(value={"/sms"})
    public Result<String> sms(@RequestBody SmsDto smsDto) {
        if (CharSequenceUtil.isEmpty((CharSequence)smsDto.getMobile())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ltyoxOLVWVVVWNW_263247f8", (String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
        }
        if (!MobilePatternUtil.checkChineseMobile(smsDto.getMobile())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ltyomKNS_53ca8482", (String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef"));
        }
        if (this.redisUtil.hasKey("sys:sms:captcha:" + smsDto.getMobile())) {
            throw new ELSBootException("\u9a8c\u8bc1\u780110\u5206\u949f\u5185\uff0c\u4ecd\u7136\u6709\u6548\uff01");
        }
        if (this.redisUtil.hasKey("sys:sms:sendCount:" + smsDto.getMobile())) {
            Integer sendCount = (Integer)this.redisUtil.get("sys:sms:sendCount:" + smsDto.getMobile());
            if (sendCount == null) {
                sendCount = 0;
            }
            if (sendCount >= 20) {
                throw new ELSBootException("\u540c\u4e00\u4e2a\u624b\u673a\u53f7 24 \u5c0f\u65f6\u6700\u591a\u53ea\u80fd\u53d1 20 \u6761\u77ed\u4fe1");
            }
        }
        if (!this.redisUtil.tryGetDistributedLock("account_sms_mobile", smsDto.getMobile(), 30000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_iKhdOioWVxPVBtk_38fab5e5", (String)"\u6b63\u5728\u53d1\u9001\u9a8c\u8bc1\u7801\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c"));
        }
        try {
            ElsSubAccount sysUser;
            Result result = new Result();
            if (!"1".equals(smsDto.getSmsmode()) && !(result = this.elsSubAccountService.checkUserIsEffective(sysUser = this.elsSubAccountService.getUserByPhone(smsDto.getMobile()))).isSuccess()) {
                Result result2 = result;
                return result2;
            }
            SmsResult smsResult = this.invokeSmsRpcService.sendSms(smsDto);
            if (smsResult.isSuccess()) {
                if (this.redisUtil.hasKey("sys:sms:sendCount:" + smsDto.getMobile())) {
                    this.redisUtil.set("sys:sms:sendCount:" + smsDto.getMobile(), (Object)((Integer)this.redisUtil.get("sys:sms:sendCount:" + smsDto.getMobile()) + 1));
                } else {
                    this.redisUtil.set("sys:sms:sendCount:" + smsDto.getMobile(), (Object)1, 86400L);
                }
            }
            result.setSuccess(smsResult.isSuccess());
            result.setMessage(smsResult.getMessage());
            Result result3 = result;
            return result3;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("account_sms_mobile", smsDto.getMobile());
        }
    }

    private void buildCompanySet(List<ElsCompanySetDTO> list, String logo, String fullName, String shortName) {
        ElsCompanySetDTO elsCompanySetDTO1 = new ElsCompanySetDTO();
        elsCompanySetDTO1.setItemCode("companyShortName");
        elsCompanySetDTO1.setDefaultValue(shortName != null ? shortName : "");
        list.add(elsCompanySetDTO1);
        ElsCompanySetDTO elsCompanySetDTO2 = new ElsCompanySetDTO();
        elsCompanySetDTO2.setItemCode("companyLogo");
        elsCompanySetDTO2.setDefaultValue(logo != null ? logo : "");
        list.add(elsCompanySetDTO2);
        ElsCompanySetDTO elsCompanySetDTO3 = new ElsCompanySetDTO();
        elsCompanySetDTO3.setItemCode("companyName");
        elsCompanySetDTO3.setDefaultValue(fullName != null ? fullName : "");
        list.add(elsCompanySetDTO3);
    }

    private void setLogo(List<ElsCompanySetDTO> list, String elsAccount) {
        ElsTenant byElsAccount = this.elsTenantService.findByElsAccount(elsAccount);
        if ("cloud".equals(SysUtil.getDeployWay())) {
            if (byElsAccount != null && StrUtil.isNotBlank((CharSequence)byElsAccount.getCompanyLogo())) {
                this.buildCompanySet(list, byElsAccount.getCompanyLogo(), byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
            } else {
                ElsTenant platformTenant = this.elsTenantService.findByElsAccount("100000");
                if (platformTenant != null) {
                    this.buildCompanySet(list, platformTenant.getCompanyLogo(), byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
                } else {
                    this.buildCompanySet(list, null, byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
                }
            }
        } else {
            Map<String, String> map = this.elsSubAccountService.getLogoSetByElsAccount(SysUtil.getPurchaseAccount());
            String companyLogo = null;
            String companyName = byElsAccount.getCompanyName();
            String companyShortName = byElsAccount.getCompanyShortName();
            if (map != null && map.containsKey("enterprise_logo") && StrUtil.isNotBlank((CharSequence)map.get("enterprise_logo"))) {
                companyLogo = map.get("enterprise_logo");
            }
            if (map != null && map.containsKey("alias") && StrUtil.isNotBlank((CharSequence)map.get("alias"))) {
                companyShortName = map.get("alias");
            }
            if (map != null && map.containsKey("name") && StrUtil.isNotBlank((CharSequence)map.get("name"))) {
                companyName = map.get("name");
            }
            this.buildCompanySet(list, companyLogo, companyName, companyShortName);
        }
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result) {
        Optional<PersonalSetting> firstPersonalSetting;
        List<PersonalSetting> personalSettingList;
        ((LicenseUtil)SpringContextUtils.getBean(LicenseUtil.class)).check();
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign((String)(elsAccount + "_" + subAccount), (String)syspassword);
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 3600000L * (long)SysUtil.getExpireTimeBase() / 1000L);
        this.redisUtil.set("sys:token:" + elsAccount + "_" + subAccount, (Object)token);
        this.redisUtil.expire("sys:token:" + elsAccount + "_" + subAccount, 3600000L * (long)SysUtil.getExpireTimeBase() / 1000L);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, (Object)adminFlag, 172800L);
        List<ElsCompanySetDTO> list = this.baseRpcService.getCompanySetList(elsAccount);
        this.setLogo(list, elsAccount);
        JSONObject companySetObj = this.getObjBySet(list);
        ElsSubAccountVO elsSubAccountVO = new ElsSubAccountVO();
        BeanUtils.copyProperties((Object)((Object)sysUser), (Object)((Object)elsSubAccountVO));
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        elsSubAccountVO.setSerivceUrl((String)config.get("service.address"));
        String orgCode = elsSubAccountVO.getOrgCode();
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            List<String> orgCodeList = Arrays.asList(orgCode.split(","));
            Map<String, String> orgMap = this.systemInvokeOrganizationInfoRpcService.listDeptOrganization(orgCodeList);
            String org = orgCodeList.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
            elsSubAccountVO.setOrgCode_dictText(org);
        }
        if (CollUtil.isNotEmpty(personalSettingList = this.personalSettingService.querySettingBySubAccount(elsAccount, subAccount)) && (firstPersonalSetting = personalSettingList.stream().filter(o -> "NAV".equals(o.getReceiveType())).findFirst()).isPresent()) {
            elsSubAccountVO.setPreferenceNav(String.valueOf(firstPersonalSetting.get().getIsReceive()));
        }
        List<SubaccountOrg> subaccountOrgList = this.subaccountOrgService.selectByMainId(sysUser.getId());
        elsSubAccountVO.setPassword(null);
        elsSubAccountVO.setSalt(null);
        elsSubAccountVO.setSecret(null);
        elsSubAccountVO.setUserOrg(this.getUserOrg(subaccountOrgList));
        elsSubAccountVO.setUserCurreny(this.getCurreny(subaccountOrgList));
        elsSubAccountVO.setPurchaseAccount(SysUtil.getPurchaseAccount());
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)elsSubAccountVO);
        obj.put("companySet", (Object)companySetObj);
        obj.put("srmVersion", (Object)this.version);
        obj.put("userOrg", (Object)this.getUserOrg(subaccountOrgList));
        obj.put("userCurreny", (Object)this.getCurreny(subaccountOrgList));
        result.setResult((Object)obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        return result;
    }

    private JSONObject getUserOrg(List<SubaccountOrg> subaccountOrgList) {
        JSONObject object = new JSONObject();
        if (subaccountOrgList.isEmpty()) {
            return object;
        }
        Map<String, List<SubaccountOrg>> orgMap = subaccountOrgList.stream().collect(Collectors.groupingBy(SubaccountOrg::getOrgCategoryCode));
        for (String orgCategoryCode : orgMap.keySet()) {
            JSONArray orgCodeArray = new JSONArray();
            List<SubaccountOrg> list = orgMap.get(orgCategoryCode);
            object.put(orgCategoryCode, (Object)list.get(0).getOrgCode());
            for (SubaccountOrg org : list) {
                orgCodeArray.add((Object)org.getOrgCode());
            }
            object.put(orgCategoryCode + "List", (Object)orgCodeArray);
        }
        return object;
    }

    private JSONObject getCurreny(List<SubaccountOrg> subaccountOrgList) {
        JSONObject object = new JSONObject();
        if (subaccountOrgList.isEmpty()) {
            return object;
        }
        List<String> collect = subaccountOrgList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getOrgCategoryCode()) && StringUtils.isNotBlank((CharSequence)item.getOrgCode()) && "companyCode".equals(item.getOrgCategoryCode())).map(SubaccountOrg::getOrgCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return object;
        }
        List<PurchaseOrganizationInfoDTO> purchaseOrganizationInfoDTOS = this.systemInvokeOrganizationInfoRpcService.listByElsAccountAndCode(subaccountOrgList.get(0).getElsAccount(), collect);
        if (!CollectionUtils.isEmpty(purchaseOrganizationInfoDTOS)) {
            for (PurchaseOrganizationInfoDTO purchaseOrganizationInfoDTO : purchaseOrganizationInfoDTOS) {
                if (!StringUtils.isNotBlank((CharSequence)purchaseOrganizationInfoDTO.getChargeCurrency())) continue;
                object.put(purchaseOrganizationInfoDTO.getOrgCode(), (Object)purchaseOrganizationInfoDTO.getChargeCurrency());
            }
        }
        return object;
    }

    private JSONObject getObjBySet(List<ElsCompanySetDTO> list) {
        JSONObject result = new JSONObject();
        if (list != null) {
            for (ElsCompanySetDTO set : list) {
                result.put(set.getItemCode(), (Object)set.getDefaultValue());
            }
        }
        return result;
    }

    @GetMapping(value={"/noToken/getEncryptedKey"})
    public Result<?> getEncryptedKey() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        String keyId = IdWorker.getIdStr();
        Map keyMap = RsaEncryptUtil.genKeyPair();
        map.put("key", (String)keyMap.get("publicKey"));
        map.put("keyId", keyId);
        this.redisUtil.set(TEMP_KEY + keyId, keyMap.get("privateKey"), 86400L);
        return Result.ok(map);
    }

    @GetMapping(value={"/noToken/pwdRuleCheck"})
    public Result<?> pwdRuleCheck(@RequestParam(name="elsAccount", required=false) String elsAccount, @RequestParam(name="sourceType", required=false) String sourceType, @RequestParam(name="invitationCode", required=false) String invitationCode, @RequestParam(name="password", required=true) String password) throws Exception {
        ElsPwComplexityAndMinLenVo complexityAndMinLen;
        String deployWay = SysUtil.getDeployWay();
        String els_account = elsAccount;
        String pwdErrStr = "";
        if (StringUtils.isNotBlank((CharSequence)sourceType) && "0".equals(sourceType)) {
            String string = els_account = "cloud".equals(deployWay) ? "100000" : SysUtil.getPurchaseAccount();
        }
        if (StringUtils.isNotBlank((CharSequence)sourceType) && "1".equals(sourceType) && StringUtils.isNotBlank((CharSequence)invitationCode)) {
            InvokeBaseRpcService invokeBaseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
            SupplierInvitationCodeDTO codeDTO = invokeBaseRpcService.getSupplierInvitationCodeInfoByCode(invitationCode);
            if (codeDTO != null && StringUtils.isNotBlank((CharSequence)codeDTO.getElsAccount())) {
                els_account = codeDTO.getElsAccount();
            } else {
                String string = els_account = "cloud".equals(deployWay) ? "100000" : SysUtil.getPurchaseAccount();
            }
        }
        if ((complexityAndMinLen = this.elsPasswordPolicyService.getComplexityAndMinLen(els_account)) != null) {
            pwdErrStr = PwVerifyUtil.pwComplexityVerifyStr((String)complexityAndMinLen.getComplexity(), (int)complexityAndMinLen.getMinLength(), (String)password);
        }
        return Result.ok((String)pwdErrStr);
    }
}

