/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.easypoi.util;

import com.els.modules.easypoi.entity.ColEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExcelTreeUtil {
    public static int getTreeStep(List<ColEntity> list, String id, int step) {
        if ("".equals(id) || null == id) {
            return step;
        }
        for (ColEntity cc : list) {
            if (!id.equals(cc.getId())) continue;
            int temp = step + 1;
            return ExcelTreeUtil.getTreeStep(list, cc.getPid(), temp);
        }
        return step;
    }

    public static int getMaxStep(List<ColEntity> list) {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        for (ColEntity cc : list) {
            int treeStep = ExcelTreeUtil.getTreeStep(list, cc.getId(), 0);
            cc.setTreeStep(treeStep - 1);
            cc.setRow(treeStep - 1);
            nums.add(treeStep);
        }
        return (Integer)Collections.max(nums);
    }

    public static int getDownChildren(List<ColEntity> list, String did) {
        int sum = 0;
        for (ColEntity cc : list) {
            if (!did.equals(cc.getPid())) continue;
            ++sum;
            if (!ExcelTreeUtil.hasChild(list, cc)) continue;
            sum += ExcelTreeUtil.getDownChildren(list, cc.getId()) - 1;
        }
        return sum;
    }

    public static ColEntity getParentCol(List<ColEntity> list, String did) {
        for (ColEntity cc : list) {
            if (did != null && did.equals(cc.getId())) {
                return cc;
            }
            if (did != null || did != cc.getId()) continue;
            return cc;
        }
        return new ColEntity(){
            {
                this.setCol(0);
                this.setRow(0);
            }
        };
    }

    public static int getBrotherChilNum(List<ColEntity> list, ColEntity ColEntity2) {
        int sum = 0;
        for (ColEntity cc : list) {
            if (ColEntity2.getId().equals(cc.getId())) break;
            if (!ColEntity2.getPid().equals(cc.getPid())) continue;
            int temp = ExcelTreeUtil.getDownChildren(list, cc.getId());
            if (temp == 0 || temp == 1) {
                ++sum;
                continue;
            }
            sum += temp;
        }
        return sum;
    }

    public static String getStepParentId(List<ColEntity> list, String id, int step) {
        String f_id = null;
        for (ColEntity cc : list) {
            if (!id.equals(cc.getId())) continue;
            int cstep = ExcelTreeUtil.getTreeStep(list, cc.getId(), 0);
            if (step == cstep) {
                return id;
            }
            int fstep = ExcelTreeUtil.getTreeStep(list, cc.getPid(), 0);
            if (step == fstep) {
                f_id = cc.getPid();
                break;
            }
            ExcelTreeUtil.getStepParentId(list, cc.getPid(), step);
        }
        return f_id;
    }

    public static boolean hasChild(List<ColEntity> list, ColEntity node) {
        return ExcelTreeUtil.getChildList(list, node).size() > 0;
    }

    public static List<ColEntity> getChildList(List<ColEntity> list, ColEntity node) {
        ArrayList<ColEntity> nodeList = new ArrayList<ColEntity>();
        for (ColEntity n : list) {
            if (n.getPid() == null || !n.getPid().equals(node.getId())) continue;
            nodeList.add(n);
        }
        return nodeList;
    }

    public static List<ColEntity> buildByRecursive(List<ColEntity> treeNodes, String rootID) {
        ArrayList<ColEntity> trees = new ArrayList<ColEntity>();
        boolean flag = false;
        boolean sflag = false;
        for (ColEntity treeNode : treeNodes) {
            if (rootID == null && rootID == treeNode.getId()) {
                flag = true;
            }
            if (rootID != null && rootID.equals(treeNode.getId())) {
                flag = true;
            }
            if (!flag) continue;
            trees.add(ExcelTreeUtil.findChildren(treeNode, treeNodes));
            flag = false;
        }
        if (trees.size() <= 0) {
            for (ColEntity treeNode : treeNodes) {
                if (rootID == null && rootID == treeNode.getPid()) {
                    sflag = true;
                }
                if (rootID != null && rootID.equals(treeNode.getPid())) {
                    sflag = true;
                }
                if (!sflag) continue;
                trees.add(ExcelTreeUtil.findChildren(treeNode, treeNodes));
                sflag = false;
            }
        }
        return trees;
    }

    public static ColEntity findChildren(ColEntity treeNode, List<ColEntity> treeNodes) {
        for (ColEntity it : treeNodes) {
            if (!treeNode.getId().equals(it.getPid())) continue;
            if (treeNode.getCellList() == null) {
                treeNode.setCellList(new ArrayList<ColEntity>());
            }
            treeNode.getCellList().add(ExcelTreeUtil.findChildren(it, treeNodes));
        }
        return treeNode;
    }

    public static List<ColEntity> getTree(List<ColEntity> treeNodes, String rootID) {
        List<ColEntity> collect = treeNodes.stream().filter(t -> t.getPid().equals(rootID)).map(m -> {
            m.setCellList(ExcelTreeUtil.getChildren(m, treeNodes));
            return m;
        }).collect(Collectors.toList());
        return collect;
    }

    public static List<ColEntity> getChildren(ColEntity root, List<ColEntity> all) {
        List<ColEntity> children = all.stream().filter(t -> Objects.equals(t.getPid(), root.getId())).map(m -> {
            m.setCellList(ExcelTreeUtil.getChildren(m, all));
            return m;
        }).collect(Collectors.toList());
        return children;
    }

    public static int getDepth(ColEntity node) {
        if (node == null || node.getCellList().isEmpty()) {
            return 1;
        }
        int maxDepth = 1;
        for (ColEntity child : node.getCellList()) {
            int depth = ExcelTreeUtil.getDepth(child);
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth + 1;
    }
}

