/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.enumerate;

import com.els.modules.justauth.request.AuthCustomDingTalkAccountRequest;
import com.els.modules.justauth.request.AuthDingTalkAccountInRequest;
import com.els.modules.justauth.request.CustomAuthFeishuRequest;
import com.els.modules.justauth.request.CustomAuthWeChatEnterpriseRequest;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.request.AuthDefaultRequest;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CustomAuthSource implements AuthSource
{
    CUSTOM_DINGTALK{

        public String authorize() {
            return "https://oapi.dingtalk.com/connect/oauth2/sns_authorize";
        }

        public String accessToken() {
            throw new AuthException(AuthResponseStatus.UNSUPPORTED);
        }

        public String userInfo() {
            return "https://oapi.dingtalk.com/sns/getuserinfo_bycode";
        }

        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return AuthCustomDingTalkAccountRequest.class;
        }
    }
    ,
    CUSTOM_WECHAT_ENTERPRISE{

        public String authorize() {
            return "https://open.weixin.qq.com/connect/oauth2/authorize";
        }

        public String accessToken() {
            return "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
        }

        public String userInfo() {
            return "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo";
        }

        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return CustomAuthWeChatEnterpriseRequest.class;
        }
    }
    ,
    CUSTOM_FEISHU{

        public String authorize() {
            return "https://open.feishu.cn/open-apis/authen/v1/index";
        }

        public String accessToken() {
            return "https://open.feishu.cn/open-apis/authen/v1/access_token";
        }

        public String userInfo() {
            return "https://open.feishu.cn/open-apis/authen/v1/user_info";
        }

        public String refresh() {
            return "https://open.feishu.cn/open-apis/authen/v1/refresh_access_token";
        }

        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return CustomAuthFeishuRequest.class;
        }
    }
    ,
    DINGTALK_ACCOUNT_IN{

        public String authorize() {
            return "https://oapi.dingtalk.com/connect/oauth2/sns_authorize";
        }

        public String accessToken() {
            return AuthDefaultSource.DINGTALK_ACCOUNT.accessToken();
        }

        public String userInfo() {
            return "https://oapi.dingtalk.com/sns/getuserinfo_bycode";
        }

        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return AuthDingTalkAccountInRequest.class;
        }
    };

}

