/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.exception.ELSBootSignOutException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.PermissionDataUtil;
import com.els.common.util.PermissionFlagUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.SubAccountOrgRpcService;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.org.api.dto.BiOrganizationDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.vo.pojo.BiDictAssist;
import com.els.modules.system.vo.pojo.BiUser;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.shiro.authc.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/account/chatBi"})
public class ChatBiAccountHttpController
extends BaseController<ElsSubAccount, ElsSubAccountService> {
    private static final Logger log = LoggerFactory.getLogger(ChatBiAccountHttpController.class);
    @Autowired(required=false)
    private AccountRpcService accountBeanService;
    @Autowired(required=false)
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Autowired(required=false)
    private SubAccountOrgRpcService subAccountOrgBeanService;
    @Lazy
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Lazy
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Lazy
    @Resource
    private SystemInvokeOrganizationInfoRpcService invokeOrganizationInfoRpcService;
    @Resource
    private RedisUtil redisUtil;

    @RequestMapping(value={"/invoke/{methodCode}"}, method={RequestMethod.POST})
    public Result<?> invoke(@RequestBody JSONObject object, @PathVariable(value="methodCode") String methodCode) {
        if ("chatBiListAccount".equals(methodCode)) {
            LoginUserDTO user = (LoginUserDTO)object.toJavaObject(LoginUserDTO.class);
            return Result.ok(((ElsSubAccountService)this.service).chatBiListAccount(user));
        }
        if ("getPermissionSensitiveFieldList".equals(methodCode)) {
            String userId = object.getString("userId");
            String businessType = object.getString("businessType");
            return Result.ok((Object)this.accountBeanService.getPermissionSensitiveFieldList(userId, businessType));
        }
        if ("getPermissionByAccount".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getPermissionByAccount(elsAccount, subAccount));
        }
        if ("getUserOrg".equals(methodCode)) {
            String userId = object.getString("userId");
            return Result.ok((Object)this.subAccountOrgBeanService.getUserOrg(userId));
        }
        if ("getPermissionDataList".equals(methodCode)) {
            String userId = object.getString("userId");
            String businessType = object.getString("businessType");
            return Result.ok((Object)this.accountBeanService.getPermissionDataList(userId, businessType));
        }
        if ("getSubAccountOrgList".equals(methodCode)) {
            String userId = object.getString("userId");
            return Result.ok((Object)this.subAccountOrgBeanService.getSubAccountOrgList(userId));
        }
        if ("queryAllSubAccount".equals(methodCode)) {
            List elsAccountList = object.getJSONArray("elsAccount").toJavaList(String.class);
            return Result.ok((Object)this.accountBeanService.queryAllSubAccount(elsAccountList));
        }
        if ("getAccountListByLeader".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getAccountListByLeader(elsAccount, subAccount));
        }
        if ("getMenuJsonArray".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            Integer mobile = object.getInteger("mobile");
            return Result.ok((Object)this.accountBeanService.getMenuJsonArray(elsAccount, subAccount, mobile));
        }
        if ("getAccountList".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            List subAccount = object.getJSONArray("subAccounts").toJavaList(String.class);
            return Result.ok((Object)this.accountBeanService.getAccountList(elsAccount, subAccount));
        }
        if ("getAllOptPermission".equals(methodCode)) {
            return Result.ok((Object)this.accountBeanService.getAllOptPermission());
        }
        if ("getUserPermissionsSet".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getUserPermissionsSet(elsAccount, subAccount));
        }
        if ("getUserRolesSet".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getUserRolesSet(elsAccount, subAccount));
        }
        if ("getLoginUser".equals(methodCode)) {
            String account = object.getString("account");
            return Result.ok((Object)this.accountBeanService.getLoginUser(account));
        }
        if ("getAccount".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getAccount(elsAccount, subAccount));
        }
        return Result.error((String)"\u4e0d\u5b58\u5728\u7684\u63a5\u53e3\u65b9\u6cd5");
    }

    @RequestMapping(value={"/invokeMethod/{methodCode}"}, method={RequestMethod.POST})
    public Result<?> invokeMethod(@RequestBody JSONObject object, @PathVariable(value="methodCode") String methodCode) {
        String token = SpringContextUtils.getHttpServletRequest().getHeader("x-access-token");
        this.checkUserTokenIsEffect(token);
        if ("listUserNames".equals(methodCode)) {
            LoginUser loginUser = SysUtil.getLoginUser();
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.eq(ElsSubAccount::getElsAccount, (Object)loginUser.getElsAccount())).eq(ElsSubAccount::getSubAccount, (Object)loginUser.getSubAccount());
            List list = this.elsSubAccountService.list((Wrapper)wrapper);
            List result = list.stream().map(account -> account.getElsAccount() + "_" + account.getSubAccount() + "_" + account.getRealname()).collect(Collectors.toList());
            return Result.ok(result);
        }
        if ("listAllUser".equals(methodCode)) {
            LoginUser loginUser = SysUtil.getLoginUser();
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrapper.eq(ElsSubAccount::getElsAccount, (Object)loginUser.getElsAccount())).eq(ElsSubAccount::getSubAccount, (Object)loginUser.getSubAccount());
            List list = this.elsSubAccountService.list((Wrapper)wrapper);
            ArrayList<BiUser> result = new ArrayList<BiUser>();
            for (ElsSubAccount account2 : list) {
                BiUser item = new BiUser();
                item.setId(account2.getId());
                item.setElsAccount(account2.getElsAccount());
                item.setSubAccount(account2.getSubAccount());
                item.setName(account2.getRealname());
                item.setIsAdmin("");
                item.setDisplayName(account2.getElsAccount() + "_" + account2.getSubAccount() + "_" + account2.getRealname());
                item.setAppCode("srm");
                result.add(item);
            }
            return Result.ok(result);
        }
        if ("getUserAllOrgId".equals(methodCode)) {
            String userId = object.getString("userId");
            ElsSubAccount account3 = (ElsSubAccount)((Object)this.elsSubAccountService.getById((Serializable)((Object)userId)));
            if (null == account3) {
                throw new ELSBootException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
            String orgCode = account3.getOrgCode();
            if (CharSequenceUtil.isEmpty((CharSequence)orgCode)) {
                return Result.ok(new HashSet());
            }
            return Result.ok((Object)orgCode.split(","));
        }
        if ("getUserByOrg".equals(methodCode)) {
            String orgId = object.getString("orgId");
            String elsAccount = TenantContext.getTenant();
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.like(ElsSubAccount::getOrgCode, (Object)("%" + orgId + "%"));
            wrapper.eq(ElsSubAccount::getElsAccount, (Object)elsAccount);
            wrapper.isNotNull(ElsSubAccount::getOrgCode);
            List list = this.elsSubAccountService.list((Wrapper)wrapper);
            ArrayList<BiUser> result = new ArrayList<BiUser>();
            for (ElsSubAccount account4 : list) {
                BiUser item = new BiUser();
                item.setId(account4.getId());
                item.setElsAccount(account4.getElsAccount());
                item.setSubAccount(account4.getSubAccount());
                item.setName(account4.getRealname());
                item.setIsAdmin("");
                item.setDisplayName(account4.getElsAccount() + "_" + account4.getSubAccount() + "_" + account4.getRealname());
                item.setAppCode("srm");
                result.add(item);
            }
            return Result.ok(result);
        }
        if ("getOrganizationTree".equals(methodCode)) {
            List<BiOrganizationDTO> treeList = this.invokeOrganizationInfoRpcService.getDeptOrganizationTree(SysUtil.getLoginUser().getElsAccount());
            return Result.ok(treeList);
        }
        if ("listPermissionDataListUb".equals(methodCode)) {
            String userId = object.getString("userId");
            String businessType = object.getString("businessType");
            List permissionDataList = this.accountBeanService.getPermissionDataList(userId, businessType);
            return Result.ok((Object)permissionDataList);
        }
        if ("listBiPermissionSensitiveData".equals(methodCode)) {
            String userId = object.getString("userId");
            String businessType = object.getString("businessType");
            List permissionSensitiveFieldList = this.accountBeanService.getPermissionSensitiveFieldList(userId, businessType);
            return Result.ok((Object)permissionSensitiveFieldList);
        }
        if ("listDictByCode".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String dictCode = object.getString("dictCode");
            List dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode(dictCode, elsAccount);
            ArrayList<BiDictAssist> result = new ArrayList<BiDictAssist>();
            for (DictDTO dto : dictDTOS) {
                BiDictAssist assist = new BiDictAssist();
                assist.setDescription(dto.getDescription());
                assist.setDicCode(dto.getValue());
                assist.setDicText(dto.getText());
                assist.setTextI18nKey(dto.getTextI18nKey());
                assist.setFileName(dto.getText());
                result.add(assist);
            }
            return Result.ok(result);
        }
        if ("mapUserOrg".equals(methodCode)) {
            String userId = object.getString("userId");
            return Result.ok((Object)this.subAccountOrgBeanService.getUserOrg(userId));
        }
        if ("getAccountListByLeader".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            return Result.ok((Object)this.accountBeanService.getAccountListByLeader(elsAccount, subAccount));
        }
        return Result.error((String)"\u4e0d\u5b58\u5728\u7684\u63a5\u53e3\u65b9\u6cd5");
    }

    @PostMapping(value={"/noToken/invokeMethod/{methodCode}"})
    public Result<?> invokeMethodNoToken(@RequestBody JSONObject object, @PathVariable(value="methodCode") String methodCode) {
        if ("tokenCheck".equals(methodCode)) {
            String srmToken = object.getString("srmToken");
            LoginUser one = this.checkUserTokenIsEffect(srmToken);
            BiUser biUser = new BiUser();
            biUser.setId(one.getId());
            biUser.setSubAccount(one.getElsAccount());
            biUser.setSubAccount(one.getSubAccount());
            biUser.setName(one.getRealname());
            biUser.setDisplayName(one.getElsAccount() + "_" + one.getSubAccount() + "_" + one.getRealname());
            biUser.setIsAdmin("");
            String token = JwtUtil.sign((String)(one.getElsAccount() + "_" + one.getSubAccount()), (String)one.getPassword());
            this.redisUtil.set("sys:token:" + token, (Object)token);
            this.redisUtil.expire("sys:token:" + token, 3600000L * (long)SysUtil.getExpireTimeBase() / 1000L);
            biUser.setSrmToken(token);
            return Result.ok((Object)biUser);
        }
        if ("getCurrentUserByPassword".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            String password = object.getString("password");
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ElsSubAccount::getElsAccount, (Object)elsAccount)).eq(ElsSubAccount::getSubAccount, (Object)subAccount)).last("limit 1");
            ElsSubAccount one = (ElsSubAccount)((Object)this.elsSubAccountService.getOne((Wrapper)wrapper));
            if (null == one) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDRSwoNSW_d7a449f8", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
            }
            String userpassword = PasswordUtil.encrypt((String)(one.getElsAccount() + "_" + one.getSubAccount()), (String)password, (String)one.getSalt());
            String syspassword = one.getPassword();
            if (!syspassword.equals(userpassword)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDRSwoNSW_d7a449f8", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
            }
            BiUser biUser = new BiUser();
            biUser.setId(one.getId());
            biUser.setElsAccount(one.getElsAccount());
            biUser.setSubAccount(one.getSubAccount());
            biUser.setName(one.getRealname());
            biUser.setDisplayName(one.getElsAccount() + "_" + one.getSubAccount() + "_" + one.getRealname());
            biUser.setIsAdmin("1");
            String token = JwtUtil.sign((String)(one.getElsAccount() + "_" + one.getSubAccount()), (String)one.getPassword());
            this.redisUtil.set("sys:token:" + token, (Object)token);
            this.redisUtil.expire("sys:token:" + token, 3600000L * (long)SysUtil.getExpireTimeBase() / 1000L);
            biUser.setSrmToken(token);
            return Result.ok((Object)biUser);
        }
        if ("getCurrentUserByAccount".equals(methodCode)) {
            String elsAccount = object.getString("elsAccount");
            String subAccount = object.getString("subAccount");
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ElsSubAccount::getElsAccount, (Object)elsAccount)).eq(ElsSubAccount::getSubAccount, (Object)subAccount)).last("limit 1");
            ElsSubAccount one = (ElsSubAccount)((Object)this.elsSubAccountService.getOne((Wrapper)wrapper));
            if (null == one) {
                throw new ELSBootException("\u8d26\u53f7\u4e0d\u5b58\u5728");
            }
            BiUser biUser = new BiUser();
            biUser.setId(one.getId());
            biUser.setSubAccount(one.getElsAccount());
            biUser.setSubAccount(one.getSubAccount());
            biUser.setName(one.getRealname());
            biUser.setDisplayName(one.getElsAccount() + "_" + one.getSubAccount() + "_" + one.getRealname());
            biUser.setIsAdmin("1");
            return Result.ok((Object)biUser);
        }
        return Result.error((String)"\u4e0d\u5b58\u5728\u7684\u63a5\u53e3\u65b9\u6cd5");
    }

    public LoginUser checkUserTokenIsEffect(String token) throws AuthenticationException {
        String account = JwtUtil.getAccount((String)token);
        if (account == null) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_WWWWWuhSXW_88a8eac9", (String)"token\u975e\u6cd5\u65e0\u6548!"));
        }
        LoginUserDTO loginUser = this.accountBeanService.getLoginUser(account);
        if (loginUser == null) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_jDxMKW_782540b3", (String)"\u7528\u6237\u4e0d\u5b58\u5728!"));
        }
        if (loginUser.getStatus() == null || loginUser.getStatus() != 1) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_eyIqdIWVKHRvjW_42c9dc43", (String)"\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
        }
        if (!this.jwtTokenRefresh(token, account, loginUser.getPassword(), loginUser)) {
            throw new AuthenticationException(I18nUtil.translate((String)"i18n_alert_WWWWWKXWVVVEHW_8bdef769", (String)"Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!"));
        }
        String adminFlag = (String)this.redisUtil.get("sys:token:role:" + token);
        AdminFlagUtil.setAdminFlag((String)adminFlag);
        PermissionFlagUtil.clear();
        PermissionDataUtil.clear();
        LoginUser user = new LoginUser();
        BeanUtils.copyProperties((Object)loginUser, (Object)user);
        return user;
    }

    private boolean jwtTokenRefresh(String token, String account, String passWord, LoginUserDTO loginUser) {
        String repeatLoginToken = (String)this.redisUtil.get("sys:token:repeat:" + token);
        if (StrUtil.isNotBlank((CharSequence)repeatLoginToken)) {
            throw new ELSBootSignOutException(I18nUtil.translate((String)"i18n_alert_jDVBEHVVVEH_5c9782d1", (String)"\u7528\u6237\u91cd\u590d\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"));
        }
        String cacheToken = String.valueOf(this.redisUtil.get("sys:token:" + token));
        if (ConvertUtils.isNotEmpty((Object)cacheToken)) {
            if (!JwtUtil.verify((String)cacheToken, (String)account, (String)passWord)) {
                String newAuthorization = JwtUtil.sign((String)account, (String)passWord);
                this.redisUtil.set("sys:token:" + token, (Object)newAuthorization);
                this.redisUtil.expire("sys:token:" + token, 3600000L * (long)SysUtil.getExpireTimeBase() / 1000L);
                this.redisUtil.set("sys:token:" + account, (Object)newAuthorization);
                this.redisUtil.expire("sys:token:" + account, 3600000L * (long)SysUtil.getExpireTimeBase() / 1000L);
                log.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u7528\u6237\u5728\u7ebf\u64cd\u4f5c\uff0c\u66f4\u65b0token\u4fdd\u8bc1\u4e0d\u6389\u7ebf\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014jwtTokenRefresh\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
            }
            return true;
        }
        return false;
    }
}

