/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.contractlock.enumerate.CLBusTypeEnum;
import com.els.modules.electronsign.contractlock.enumerate.ClContractSignStatusEmun;
import com.els.modules.electronsign.esign.rpc.service.EsignInvokeFinanceRpcService;
import com.els.modules.electronsign.esign.service.EsignOperationService;
import com.els.modules.electronsign.fadada.dto.FadadaDocDTO;
import com.els.modules.electronsign.fadada.dto.FadadaFileSignTaskCreateDTO;
import com.els.modules.electronsign.fadada.dto.FadadaSignTaskActorDTO;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignAttachmenSale;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskPurchase;
import com.els.modules.electronsign.fadada.entity.FadadaSignTaskSale;
import com.els.modules.electronsign.fadada.entity.FadadaTaskActorPurchase;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaSeal;
import com.els.modules.electronsign.fadada.enums.FadadaJudgeEnum;
import com.els.modules.electronsign.fadada.enums.FadadaSealFieldTypeEnum;
import com.els.modules.electronsign.fadada.enums.FadadaSignTaskStatusEnum;
import com.els.modules.electronsign.fadada.mapper.FadadaSignTaskPurchaseMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaSealMapper;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaSealMapper;
import com.els.modules.electronsign.fadada.service.FadadaSignAttachmenPurchaseService;
import com.els.modules.electronsign.fadada.service.FadadaSignAttachmenSaleService;
import com.els.modules.electronsign.fadada.service.FadadaSignTaskPurchaseService;
import com.els.modules.electronsign.fadada.service.FadadaSignTaskSaleService;
import com.els.modules.electronsign.fadada.service.FadadaTaskActorPurchaseService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import com.els.modules.electronsign.fadada.vo.FadadaSignTaskPurchaseVO;
import com.els.modules.electronsign.util.ESignUtil;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FadadaSignTaskPurchaseServiceImpl
extends BaseServiceImpl<FadadaSignTaskPurchaseMapper, FadadaSignTaskPurchase>
implements FadadaSignTaskPurchaseService {
    private String FADADA = "fadada";
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    @Resource
    private FadadaTaskActorPurchaseService fadadaTaskActorPurchaseService;
    @Resource
    private FadadaSignAttachmenPurchaseService fadadaSignAttachmenPurchaseService;
    @Resource
    private FadadaSignTaskSaleService fadadaSignTaskSaleService;
    @Resource
    private FadadaSignAttachmenSaleService fadadaSignAttachmenSaleService;
    @Resource
    private PurchaseFadadaSealMapper purchaseFadadaSealMapper;
    @Resource
    private SaleFadadaSealMapper saleFadadaSealMapper;
    @Resource
    private EsignInvokeFinanceRpcService esignInvokeFinanceRpcService;
    @Resource
    private EsignOperationService esignOperationService;
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Resource
    private ESignUtil eSignUtil;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> fadadaTaskActorPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseBackList, HttpServletRequest request) {
        fadadaSignTaskPurchase.setElsAccount(TenantContext.getTenant());
        if (StringUtils.isNotBlank((CharSequence)fadadaSignTaskPurchase.getBusId()) && StringUtils.isBlank((CharSequence)fadadaSignTaskPurchase.getId())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"bus_id", (Object)fadadaSignTaskPurchase.getBusId());
            queryWrapper.eq((Object)"bus_type", (Object)fadadaSignTaskPurchase.getBusType());
            queryWrapper.eq((Object)"bus_number", (Object)fadadaSignTaskPurchase.getBusNumber());
            queryWrapper.and(o -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)o.eq((Object)"voucher_send_back_flag", (Object)"0")).or()).eq((Object)"voucher_send_back_flag", (Object)"")).or()).isNull((Object)"voucher_send_back_flag");
            });
            if (!this.list((Wrapper)queryWrapper).isEmpty()) {
                throw new ELSBootException("\u8be5\u4e1a\u52a1\u5355\u636e\u5df2\u53d1\u8d77\u8fc7\u7b7e\u7f72\uff0c\u53ef\u5728\u6cd5\u5927\u5927\u7b7e\u7f72\u4efb\u52a1\u4e2d\u6839\u636e\u4e1a\u52a1\u5355\u53f7\u67e5\u8be2");
            }
            String busNumber = fadadaSignTaskPurchase.getBusNumber();
            try {
                File file = this.esignOperationService.getFileById(fadadaSignTaskPurchase.getBusId(), fadadaSignTaskPurchase.getBusType(), busNumber, "", fadadaSignTaskPurchase.getReportUrl(), fadadaSignTaskPurchase.getToken(), request.getHeader("cookie"));
                if (!CollectionUtils.isEmpty(fadadaSignAttachmenPurchaseList)) {
                    fadadaSignAttachmenPurchaseList.add(this.fadadaCallUtil.getFile(file, fadadaSignTaskPurchase));
                } else {
                    fadadaSignAttachmenPurchaseList = new ArrayList<FadadaSignAttachmenPurchase>();
                    fadadaSignAttachmenPurchaseList.add(this.fadadaCallUtil.getFile(file, fadadaSignTaskPurchase));
                }
            }
            catch (Exception e) {
                this.log.error("\u4e1a\u52a1\u5355\u636e\u53d1\u8d77\uff0c\u4e1a\u52a1\u5355\u636e\u5173\u8054\u6587\u6863\u5904\u7406\u5931\u8d25(\u4e0d\u505a\u5904\u7406\uff0c\u540e\u7eed\u6d41\u7a0b\u4e2d\u53ef\u4ee5\u4e0a\u4f20\u6587\u6863)\uff1a", (Throwable)e);
            }
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        fadadaSignTaskPurchase.setBusAccount(loginUser.getElsAccount());
        fadadaSignTaskPurchase.setPurchaseName(loginUser.getEnterpriseName());
        fadadaSignTaskPurchase.setSignTaskStatus(FadadaSignTaskStatusEnum.task_created.getValue());
        fadadaSignTaskPurchase.setAutoStart(FadadaJudgeEnum.TRUE.getValue());
        fadadaSignTaskPurchase.setAutoFinish(FadadaJudgeEnum.TRUE.getValue());
        fadadaSignTaskPurchase.setSendStatus("0");
        fadadaSignTaskPurchase.setSignInOrder(FadadaJudgeEnum.TRUE.getValue());
        fadadaSignTaskPurchase.setSignFileUploaded("0");
        fadadaSignTaskPurchase.setSignDocType("contract");
        if (StringUtils.isBlank((CharSequence)fadadaSignTaskPurchase.getOnlineSealed())) {
            fadadaSignTaskPurchase.setOnlineSealed(this.eSignUtil.getOnlineSealed(fadadaSignTaskPurchase.getBusType(), fadadaSignTaskPurchase.getToElsAccount()));
        }
        ((FadadaSignTaskPurchaseMapper)this.baseMapper).insert((Object)fadadaSignTaskPurchase);
        super.setHeadDefaultValue((BaseEntity)fadadaSignTaskPurchase);
        this.insertData(fadadaSignTaskPurchase, fadadaTaskActorPurchaseList, null, fadadaSignAttachmenPurchaseList, fadadaSignAttachmenPurchaseBackList);
        if (StringUtils.isNotBlank((CharSequence)fadadaSignTaskPurchase.getBusId())) {
            this.handleBusType(fadadaSignTaskPurchase.getBusType(), fadadaSignTaskPurchase.getBusId(), ClContractSignStatusEmun.UNFINISHED.getValue(), CLBusTypeEnum.ADD);
        }
    }

    @Override
    public void handleBusType(String busType, String relationId, String signStatus, CLBusTypeEnum type) {
        if (StringUtils.isNotBlank((CharSequence)busType) && StringUtils.isNotBlank((CharSequence)relationId)) {
            this.eSignUtil.handleBusType(busType, relationId, signStatus, type, this.FADADA);
        }
    }

    @Override
    public void cancel(String id, String reason) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        JSONObject requestObject = new JSONObject();
        requestObject.put("signTaskId", (Object)signTaskPurchase.getSignTaskId());
        requestObject.put("terminationNote", (Object)reason);
        requestObject.put("currentAccount", (Object)signTaskPurchase.getElsAccount());
        this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_sign_task_cancel");
        signTaskPurchase.setSignTaskStatus(FadadaSignTaskStatusEnum.task_terminated.getValue());
        signTaskPurchase.setReason(reason);
        this.updateById((Object)signTaskPurchase);
        FadadaSignTaskSale signTaskSale = (FadadaSignTaskSale)((Object)this.fadadaSignTaskSaleService.getById((Serializable)((Object)signTaskPurchase.getRelationId())));
        if (signTaskSale != null) {
            signTaskSale.setSignTaskStatus(FadadaSignTaskStatusEnum.task_terminated.getValue());
            signTaskSale.setReason(reason);
            this.fadadaSignTaskSaleService.updateById((Object)signTaskSale);
        }
        this.handleBusType(signTaskPurchase.getBusType(), signTaskPurchase.getBusId(), FadadaSignTaskStatusEnum.task_terminated.getValue(), CLBusTypeEnum.REVOKE);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> fadadaTaskActorPurchaseList, List<FadadaTaskActorPurchase> fadadaTaskActorSaleList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseBackList) {
        int count = ((FadadaSignTaskPurchaseMapper)this.baseMapper).updateById((Object)fadadaSignTaskPurchase);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.fadadaTaskActorPurchaseService.deleteByMainId(fadadaSignTaskPurchase.getId());
        this.fadadaSignAttachmenPurchaseService.deleteByMainId(fadadaSignTaskPurchase.getId());
        this.insertData(fadadaSignTaskPurchase, fadadaTaskActorPurchaseList, fadadaTaskActorSaleList, fadadaSignAttachmenPurchaseList, fadadaSignAttachmenPurchaseBackList);
    }

    private void insertData(FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> fadadaTaskActorPurchaseList, List<FadadaTaskActorPurchase> fadadaTaskActorSaleList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseBackList) {
        if (!CollectionUtils.isEmpty(fadadaTaskActorPurchaseList)) {
            for (FadadaTaskActorPurchase fadadaTaskActorPurchase : fadadaTaskActorPurchaseList) {
                fadadaTaskActorPurchase.setHeadId(fadadaSignTaskPurchase.getId());
                SysUtil.setSysParam((BaseEntity)fadadaTaskActorPurchase, (BaseEntity)fadadaSignTaskPurchase);
                fadadaTaskActorPurchase.setOwning("purchase");
                if ("mobile".equals(fadadaTaskActorPurchase.getNotifyWay())) {
                    fadadaTaskActorPurchase.setNotifyAddress(fadadaTaskActorPurchase.getMobile());
                } else {
                    fadadaTaskActorPurchase.setNotifyAddress(fadadaTaskActorPurchase.getEmail());
                }
                if ("corp".equals(fadadaTaskActorPurchase.getActorType())) {
                    fadadaTaskActorPurchase.setActorName(fadadaTaskActorPurchase.getCorpName());
                    fadadaTaskActorPurchase.setActorOpenId(fadadaTaskActorPurchase.getOpenCorpId());
                    continue;
                }
                fadadaTaskActorPurchase.setActorName(fadadaTaskActorPurchase.getUseName());
                fadadaTaskActorPurchase.setActorOpenId(fadadaTaskActorPurchase.getOpenUserId());
            }
            this.fadadaTaskActorPurchaseService.saveBatch(fadadaTaskActorPurchaseList, 2000);
            fadadaSignTaskPurchase.setSignerVindicateStatus("1");
        }
        if (!CollectionUtils.isEmpty(fadadaTaskActorSaleList)) {
            this.fadadaTaskActorPurchaseService.saveBatch(fadadaTaskActorSaleList, 2000);
            fadadaSignTaskPurchase.setSaleSignerSubmintStatus("1");
        }
        if (!CollectionUtils.isEmpty(fadadaSignAttachmenPurchaseList)) {
            for (FadadaSignAttachmenPurchase fadadaSignAttachmenPurchase : fadadaSignAttachmenPurchaseList) {
                fadadaSignAttachmenPurchase.setHeadId(fadadaSignTaskPurchase.getId());
                SysUtil.setSysParam((BaseEntity)fadadaSignAttachmenPurchase, (BaseEntity)fadadaSignTaskPurchase);
            }
            this.fadadaSignAttachmenPurchaseService.saveBatch(fadadaSignAttachmenPurchaseList, 2000);
        }
        if (!CollectionUtils.isEmpty(fadadaSignAttachmenPurchaseBackList)) {
            for (FadadaSignAttachmenPurchase fadadaSignAttachmenPurchase : fadadaSignAttachmenPurchaseBackList) {
                fadadaSignAttachmenPurchase.setHeadId(fadadaSignTaskPurchase.getId());
                SysUtil.setSysParam((BaseEntity)fadadaSignAttachmenPurchase, (BaseEntity)fadadaSignTaskPurchase);
            }
            this.fadadaSignAttachmenPurchaseService.saveBatch(fadadaSignAttachmenPurchaseBackList, 2000);
        }
        this.updateById((Object)fadadaSignTaskPurchase);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        FadadaSignTaskPurchase fadadaSignTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isNotBlank((CharSequence)fadadaSignTaskPurchase.getBusId())) {
            this.voucherSendBackFlag(id);
        }
        this.fadadaTaskActorPurchaseService.deleteByMainId(id);
        this.fadadaSignAttachmenPurchaseService.deleteByMainId(id);
        ((FadadaSignTaskPurchaseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.deleteMain(serializable.toString());
        }
    }

    @Override
    public void send(FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> fadadaTaskActorPurchaseList, List<FadadaSignAttachmenPurchase> fadadaSignAttachmenPurchaseList) {
        if (CollectionUtils.isEmpty(fadadaSignAttachmenPurchaseList)) {
            throw new ELSBootException("\u7b7e\u7f72\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FadadaSignTaskSale fadadaSignTaskSale = (FadadaSignTaskSale)((Object)SysUtil.copyProperties((Object)((Object)fadadaSignTaskPurchase), FadadaSignTaskSale.class));
        fadadaSignTaskSale.setId(null);
        fadadaSignTaskSale.setElsAccount(fadadaSignTaskPurchase.getToElsAccount());
        fadadaSignTaskSale.setToElsAccount(fadadaSignTaskPurchase.getElsAccount());
        fadadaSignTaskSale.setRelationId(fadadaSignTaskPurchase.getId());
        ArrayList<FadadaSignAttachmenSale> fadadaSignAttachmenSales = new ArrayList<FadadaSignAttachmenSale>();
        for (FadadaSignAttachmenPurchase entity : fadadaSignAttachmenPurchaseList) {
            FadadaSignAttachmenSale fadadaSignAttachmenSale = (FadadaSignAttachmenSale)((Object)SysUtil.copyProperties((Object)((Object)entity), FadadaSignAttachmenSale.class));
            fadadaSignAttachmenSale.setElsAccount(fadadaSignTaskSale.getElsAccount());
            fadadaSignAttachmenSale.setReceiveStatus("1");
            fadadaSignAttachmenSale.setRelationId(entity.getId());
            fadadaSignAttachmenSales.add(fadadaSignAttachmenSale);
            entity.setSendStatus("1");
        }
        this.fadadaSignTaskSaleService.saveMain(fadadaSignTaskSale, null, fadadaSignAttachmenSales);
        this.fadadaTaskActorPurchaseService.deleteByMainId(fadadaSignTaskPurchase.getId());
        this.fadadaSignAttachmenPurchaseService.deleteByMainId(fadadaSignTaskPurchase.getId());
        fadadaSignTaskPurchase.setSendStatus("1");
        fadadaSignTaskPurchase.setRelationId(fadadaSignTaskSale.getId());
        this.insertData(fadadaSignTaskPurchase, fadadaTaskActorPurchaseList, null, fadadaSignAttachmenPurchaseList, null);
    }

    @Override
    public void signHandle(FadadaSignTaskPurchaseVO fadadaSignTaskPurchasePage) {
        FadadaSignTaskPurchase fadadaSignTaskPurchase = new FadadaSignTaskPurchase();
        BeanUtils.copyProperties((Object)((Object)fadadaSignTaskPurchasePage), (Object)((Object)fadadaSignTaskPurchase));
        List<Object> taskActorPurchaseList = new ArrayList();
        if ("1".equals(fadadaSignTaskPurchase.getOnlineSealed())) {
            if (CollectionUtils.isEmpty(fadadaSignTaskPurchasePage.getFadadaTaskActorPurchaseList()) || CollectionUtils.isEmpty(fadadaSignTaskPurchasePage.getFadadaTaskActorSaleList())) {
                throw new ELSBootException("\u7b7e\u7f72\u4eba\u672a\u5b8c\u5168\u7ef4\u62a4\u5b8c\u6210");
            }
            if ("purchase".equals(fadadaSignTaskPurchase.getFirstSeal())) {
                taskActorPurchaseList.addAll(fadadaSignTaskPurchasePage.getFadadaTaskActorPurchaseList());
                taskActorPurchaseList.addAll(fadadaSignTaskPurchasePage.getFadadaTaskActorSaleList());
            } else {
                taskActorPurchaseList.addAll(fadadaSignTaskPurchasePage.getFadadaTaskActorSaleList());
                taskActorPurchaseList.addAll(fadadaSignTaskPurchasePage.getFadadaTaskActorPurchaseList());
            }
        } else {
            if (CollectionUtils.isEmpty(fadadaSignTaskPurchasePage.getFadadaTaskActorPurchaseList())) {
                throw new ELSBootException("\u7b7e\u7f72\u4eba\u672a\u5b8c\u5168\u7ef4\u62a4\u5b8c\u6210");
            }
            taskActorPurchaseList = fadadaSignTaskPurchasePage.getFadadaTaskActorPurchaseList();
        }
        boolean corpSeal = false;
        boolean corp_seal_cross_page = false;
        String idType = null;
        String openId = null;
        boolean freeVisaSign = false;
        HashMap<String, List<FadadaTaskActorPurchase>> docFiledMap = new HashMap<String, List<FadadaTaskActorPurchase>>();
        for (FadadaTaskActorPurchase fadadaTaskActorPurchase : taskActorPurchaseList) {
            List<FadadaTaskActorPurchase> actorPurchases;
            if (FadadaSealFieldTypeEnum.corp_seal_cross_page.getValue().equals(fadadaTaskActorPurchase.getFieldType())) {
                corp_seal_cross_page = true;
            }
            if (FadadaSealFieldTypeEnum.corp_seal.getValue().equals(fadadaTaskActorPurchase.getFieldType())) {
                corpSeal = true;
            }
            if ("1".equals(fadadaTaskActorPurchase.getFbk1())) {
                idType = fadadaTaskActorPurchase.getActorType();
                openId = "corp".equals(idType) ? fadadaTaskActorPurchase.getOpenCorpId() : fadadaTaskActorPurchase.getOpenUserId();
            }
            if (docFiledMap.get(fadadaTaskActorPurchase.getFieldDocId()) != null) {
                actorPurchases = (List)docFiledMap.get(fadadaTaskActorPurchase.getFieldDocId());
                actorPurchases.add(fadadaTaskActorPurchase);
                docFiledMap.put(fadadaTaskActorPurchase.getFieldDocId(), actorPurchases);
            } else {
                actorPurchases = new ArrayList<FadadaTaskActorPurchase>();
                actorPurchases.add(fadadaTaskActorPurchase);
                docFiledMap.put(fadadaTaskActorPurchase.getFieldDocId(), actorPurchases);
            }
            if (!FadadaJudgeEnum.TRUE.getValue().equals(fadadaTaskActorPurchase.getRequestVerifyFree())) continue;
            freeVisaSign = true;
            if (!"purchase".equals(fadadaTaskActorPurchase.getOwning())) continue;
            QueryWrapper purchaseFadadaSealQueryWrapper = new QueryWrapper();
            purchaseFadadaSealQueryWrapper.eq((Object)"els_account", (Object)fadadaSignTaskPurchase.getElsAccount());
            purchaseFadadaSealQueryWrapper.eq((Object)"visa_free", (Object)"1");
            purchaseFadadaSealQueryWrapper.eq((Object)"seal_id", (Object)fadadaTaskActorPurchase.getSealId());
            if (this.purchaseFadadaSealMapper.selectCount((Wrapper)purchaseFadadaSealQueryWrapper) < 1) {
                throw new ELSBootException("\u673a\u6784\u3010" + fadadaTaskActorPurchase.getCorpName() + "\u3011\u7684\u5370\u7ae0\u3010" + fadadaTaskActorPurchase.getSealName() + "\u3011\u672a\u8bbe\u7f6e\u514d\u7b7e");
            }
            List seals = this.purchaseFadadaSealMapper.selectList((Wrapper)purchaseFadadaSealQueryWrapper);
            String today = this.simpleDateFormat.format(new Date());
            Date date = null;
            try {
                date = this.simpleDateFormat.parse(today);
            }
            catch (Exception e) {
                date = new Date();
            }
            for (PurchaseFadadaSeal seal : seals) {
                if (seal.getExpiresTime().compareTo(date) >= 0) continue;
                throw new ELSBootException("\u673a\u6784\u3010" + fadadaTaskActorPurchase.getCorpName() + "\u3011\u7684\u5370\u7ae0\u3010" + fadadaTaskActorPurchase.getSealName() + "\u3011\u514d\u7b7e\u5df2\u5230\u671f");
            }
        }
        if (freeVisaSign && StringUtils.isBlank((CharSequence)fadadaSignTaskPurchase.getBusinessId())) {
            throw new ELSBootException("\u7b7e\u7f72\u4eba\u4e2d\u5b58\u5728\u81ea\u52a8\u843d\u7ae0\u573a\u666f\uff0c\u514d\u7b7e\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (corp_seal_cross_page && !corpSeal) {
            throw new ELSBootException("\u7b7e\u7f72\u5b58\u5728\u9a91\u7f1d\u7ae0\u5219\u5fc5\u987b\u540c\u65f6\u5b58\u5728\u4f01\u4e1a\u516c\u7ae0");
        }
        ArrayList<FadadaSignAttachmenPurchase> docAttachment = new ArrayList<FadadaSignAttachmenPurchase>();
        ArrayList<FadadaSignAttachmenPurchase> arrayList = new ArrayList<FadadaSignAttachmenPurchase>();
        if (!"1".equals(fadadaSignTaskPurchase.getOnlineSealed()) && "sale".equals(fadadaSignTaskPurchase.getFirstSeal())) {
            for (FadadaSignAttachmenPurchase entity : fadadaSignTaskPurchasePage.getFadadaSignAttachmenPurchaseBackList()) {
                if (!"1".equals(entity.getUploaded())) continue;
                if ("doc".equals(entity.getSignType())) {
                    docAttachment.add(entity);
                    continue;
                }
                arrayList.add(entity);
            }
        } else {
            for (FadadaSignAttachmenPurchase entity : fadadaSignTaskPurchasePage.getFadadaSignAttachmenPurchaseList()) {
                if (!"1".equals(entity.getUploaded())) continue;
                if ("doc".equals(entity.getSignType())) {
                    docAttachment.add(entity);
                    continue;
                }
                arrayList.add(entity);
            }
        }
        fadadaSignTaskPurchase.setIdType(idType);
        fadadaSignTaskPurchase.setOpenId(openId);
        FadadaFileSignTaskCreateDTO fileSignTaskCreateDTO = this.signData(idType, openId, fadadaSignTaskPurchase, taskActorPurchaseList, docAttachment, arrayList, docFiledMap);
        String requestStr = JSONObject.toJSONString((Object)fileSignTaskCreateDTO);
        JSONObject response = this.fadadaCallUtil.call(requestStr, "fadada_sign");
        fadadaSignTaskPurchase.setSignTaskId(response.getString("signTaskId"));
        fadadaSignTaskPurchase.setIsAutoStart("1");
        this.updateById((Object)fadadaSignTaskPurchase);
        this.fadadaTaskActorPurchaseService.updateBatchById(taskActorPurchaseList);
    }

    @Override
    public void refresh(String id) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        if (signTaskPurchase != null) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("signTaskId", (Object)signTaskPurchase.getSignTaskId());
            requestObject.put("currentAccount", (Object)signTaskPurchase.getElsAccount());
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_sign_detail");
            signTaskPurchase.setSignTaskStatus(response.getString("signTaskStatus"));
            FadadaSignTaskSale signTaskSale = null;
            if (("1".equals(signTaskPurchase.getOnlineSealed()) || !"1".equals(signTaskPurchase.getOnlineSealed()) && "sale".equals(signTaskPurchase.getFirstSeal())) && StringUtils.isNotBlank((CharSequence)signTaskPurchase.getRelationId())) {
                signTaskSale = (FadadaSignTaskSale)((Object)this.fadadaSignTaskSaleService.getById((Serializable)((Object)signTaskPurchase.getRelationId())));
                signTaskSale.setSignTaskStatus(signTaskPurchase.getSignTaskStatus());
                if (FadadaSignTaskStatusEnum.task_finished.getValue().equals(response.getString("signTaskStatus"))) {
                    signTaskPurchase.setIsAutoFinish("1");
                    signTaskSale.setIsAutoFinish(signTaskPurchase.getIsAutoFinish());
                }
                this.fadadaSignTaskSaleService.updateById((Object)signTaskSale);
            }
            this.updateById((Object)signTaskPurchase);
            if (FadadaSignTaskStatusEnum.task_finished.getValue().equals(response.getString("signTaskStatus"))) {
                this.saveSignFile(signTaskPurchase, signTaskSale);
                this.handleBusType(signTaskPurchase.getBusType(), signTaskPurchase.getBusId(), ClContractSignStatusEmun.FINISHED.getValue(), CLBusTypeEnum.FINISH);
            } else if (FadadaSignTaskStatusEnum.task_terminated.getValue().equals(response.getString("signTaskStatus"))) {
                this.handleBusType(signTaskPurchase.getBusType(), signTaskPurchase.getBusId(), ClContractSignStatusEmun.UNDONE.getValue(), CLBusTypeEnum.REVOKE);
            }
        }
    }

    @Override
    public void saveSignFile(FadadaSignTaskPurchase taskPurchase, FadadaSignTaskSale signTaskSale) {
        QueryWrapper signAttachmenPurchaseQueryWrapper = new QueryWrapper();
        if (!"1".equals(taskPurchase.getOnlineSealed()) && "sale".equals(taskPurchase.getFirstSeal())) {
            signAttachmenPurchaseQueryWrapper.eq((Object)"head_id", (Object)taskPurchase.getId());
            signAttachmenPurchaseQueryWrapper.eq((Object)"receive_status", (Object)"1");
            signAttachmenPurchaseQueryWrapper.isNotNull((Object)"file_id");
        } else {
            signAttachmenPurchaseQueryWrapper.eq((Object)"head_id", (Object)taskPurchase.getId());
            signAttachmenPurchaseQueryWrapper.and(o -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)o.isNotNull((Object)"receive_status")).or()).eq((Object)"receive_status", (Object)"")).or()).eq((Object)"receive_status", (Object)"0");
            });
            signAttachmenPurchaseQueryWrapper.isNotNull((Object)"file_id");
        }
        List signAttachmenPurchases = this.fadadaSignAttachmenPurchaseService.list((Wrapper)signAttachmenPurchaseQueryWrapper);
        if (!signAttachmenPurchases.isEmpty()) {
            ArrayList<FadadaSignAttachmenSale> signAttachmenSales = new ArrayList<FadadaSignAttachmenSale>();
            for (FadadaSignAttachmenPurchase entity : signAttachmenPurchases) {
                entity.setExistSignFile("1");
                if (signTaskSale == null) continue;
                FadadaSignAttachmenSale signAttachmenSale = (FadadaSignAttachmenSale)((Object)this.fadadaSignAttachmenSaleService.getById((Serializable)((Object)entity.getRelationId())));
                if (signAttachmenSale != null) {
                    signAttachmenSale.setExistSignFile("1");
                    signAttachmenSales.add(signAttachmenSale);
                    continue;
                }
                QueryWrapper signAttachmenSaleQueryWrapper = new QueryWrapper();
                signAttachmenSaleQueryWrapper.eq((Object)"head_id", (Object)signTaskSale.getId());
                signAttachmenSaleQueryWrapper.eq((Object)"els_account", (Object)taskPurchase.getToElsAccount());
                signAttachmenSaleQueryWrapper.eq((Object)"relation_id", (Object)entity.getId());
                signAttachmenSale = (FadadaSignAttachmenSale)((Object)this.fadadaSignAttachmenSaleService.getOne((Wrapper)signAttachmenSaleQueryWrapper));
                if (signAttachmenSale == null) continue;
                signAttachmenSale.setExistSignFile("1");
                signAttachmenSales.add(signAttachmenSale);
            }
            this.fadadaSignAttachmenPurchaseService.updateBatchById(signAttachmenPurchases);
            if (!CollectionUtils.isEmpty(signAttachmenSales)) {
                this.fadadaSignAttachmenSaleService.updateBatchById(signAttachmenSales);
            }
        }
    }

    @Override
    public void listSend(String id) {
        FadadaSignTaskPurchase fadadaSignTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        List<FadadaTaskActorPurchase> signTaskPurchases = this.fadadaTaskActorPurchaseService.selectByMainId(id);
        List<FadadaSignAttachmenPurchase> signAttachmenPurchases = this.fadadaSignAttachmenPurchaseService.selectByMainId(id);
        this.send(fadadaSignTaskPurchase, signTaskPurchases, signAttachmenPurchases);
    }

    @Override
    public void voucherSendBackFlag(String id) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isBlank((CharSequence)signTaskPurchase.getBusId())) {
            throw new ELSBootException("\u8be5\u5355\u636e\u672a\u57fa\u4e8e\u4e1a\u52a1\u5355\u636e\u751f\u6210\uff0c\u65e0\u9000\u56de\u64cd\u4f5c");
        }
        if (!FadadaSignTaskStatusEnum.task_created.getValue().equals(signTaskPurchase.getSignTaskStatus()) && !FadadaSignTaskStatusEnum.task_terminated.getValue().equals(signTaskPurchase.getSignTaskStatus())) {
            throw new ELSBootException("\u8be5\u7b7e\u7f72\u72b6\u6001\u4e0b\u4e0d\u80fd\u9000\u56de");
        }
        signTaskPurchase.setVoucherSendBackFlag("1");
        this.updateById((Object)signTaskPurchase);
        FadadaSignTaskSale signTaskSale = (FadadaSignTaskSale)((Object)this.fadadaSignTaskSaleService.getById((Serializable)((Object)signTaskPurchase.getRelationId())));
        if (signTaskSale != null) {
            signTaskSale.setVoucherSendBackFlag("1");
            this.fadadaSignTaskSaleService.updateById((Object)signTaskSale);
        }
        this.handleBusType(signTaskPurchase.getBusType(), signTaskPurchase.getBusId(), null, CLBusTypeEnum.RETURN);
    }

    @Override
    public void back(String id, String sendBackReason) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        signTaskPurchase.setSendBack("1");
        signTaskPurchase.setSendBackReson(sendBackReason);
        signTaskPurchase.setSaleFileUploaded("0");
        FadadaSignTaskSale signTaskSale = (FadadaSignTaskSale)((Object)this.fadadaSignTaskSaleService.getById((Serializable)((Object)signTaskPurchase.getRelationId())));
        signTaskSale.setSendBack("1");
        signTaskSale.setSendBackReson(sendBackReason);
        signTaskSale.setSaleFileUploaded("0");
        this.fadadaSignTaskSaleService.updateById((Object)signTaskSale);
        this.updateById((Object)signTaskPurchase);
        this.fadadaSignAttachmenPurchaseService.deleteSaleFileByMainId(id);
    }

    @Override
    public String signFileDownload(String id, String fileId) {
        FadadaSignTaskPurchase signTaskPurchase = (FadadaSignTaskPurchase)((Object)this.getById((Serializable)((Object)id)));
        JSONObject requestObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)fileId)) {
            FadadaSignAttachmenPurchase signAttachmenPurchase = (FadadaSignAttachmenPurchase)((Object)this.fadadaSignAttachmenPurchaseService.getById((Serializable)((Object)fileId)));
            requestObject.put("fileType", (Object)signAttachmenPurchase.getSignType());
            requestObject.put("id", (Object)signAttachmenPurchase.getFileId());
        }
        requestObject.put("signTaskId", (Object)signTaskPurchase.getSignTaskId());
        requestObject.put("currentAccount", (Object)signTaskPurchase.getElsAccount());
        JSONObject ownerId = new JSONObject();
        ownerId.put("idType", (Object)signTaskPurchase.getIdType());
        ownerId.put("openId", (Object)signTaskPurchase.getOpenId());
        requestObject.put("ownerId", (Object)ownerId);
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_sign_file");
        return response.getString("downloadUrl");
    }

    public FadadaFileSignTaskCreateDTO signData(String idType, String openId, FadadaSignTaskPurchase fadadaSignTaskPurchase, List<FadadaTaskActorPurchase> taskActorPurchaseList, List<FadadaSignAttachmenPurchase> docAttachment, List<FadadaSignAttachmenPurchase> attachsAttachment, Map<String, List<FadadaTaskActorPurchase>> docFiledMap) {
        FadadaFileSignTaskCreateDTO signTaskCreateDTO = new FadadaFileSignTaskCreateDTO(idType, openId, fadadaSignTaskPurchase.getBusinessId(), fadadaSignTaskPurchase, attachsAttachment);
        ArrayList<FadadaDocDTO> docs = new ArrayList<FadadaDocDTO>();
        for (FadadaSignAttachmenPurchase entity : docAttachment) {
            FadadaDocDTO docDTO = new FadadaDocDTO(entity, docFiledMap.get(entity.getFileId()));
            docs.add(docDTO);
        }
        signTaskCreateDTO.setDocs(docs);
        ArrayList<FadadaSignTaskActorDTO> actors = new ArrayList<FadadaSignTaskActorDTO>();
        int orderNo = 1;
        for (FadadaTaskActorPurchase entity : taskActorPurchaseList) {
            FadadaSignTaskActorDTO taskActorDTO = new FadadaSignTaskActorDTO(entity, orderNo);
            actors.add(taskActorDTO);
            ++orderNo;
        }
        signTaskCreateDTO.setActors(actors);
        return signTaskCreateDTO;
    }
}

