/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.listener.schedule;

import com.els.modules.system.listener.schedule.model.DynamicScheduledTask;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

@Component(value="dynamicCronTaskRegistrar")
public class DynamicCronTaskRegistrar
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DynamicCronTaskRegistrar.class);
    private final Map<Runnable, DynamicScheduledTask> scheduledTasks = new ConcurrentHashMap<Runnable, DynamicScheduledTask>(16);
    @Resource(name="methodTaskScheduler")
    private TaskScheduler methodTaskScheduler;

    public TaskScheduler methodTaskScheduler() {
        return this.methodTaskScheduler;
    }

    public void addCronTaskFixedRate(Runnable task, long taskSchedulerFixedRate) {
        if (task != null) {
            if (this.scheduledTasks.containsKey(task)) {
                this.removeCronTask(task);
            }
            this.scheduledTasks.put(task, this.dynamicScheduledTaskOfFixedRate(task, taskSchedulerFixedRate));
        }
    }

    public void addCronTaskDate(Runnable task, Date time) {
        if (task != null) {
            if (this.scheduledTasks.containsKey(task)) {
                this.removeCronTask(task);
            }
            this.scheduledTasks.put(task, this.dynamicScheduledTaskOfDate(task, time));
        }
    }

    public void removeCronTask(Runnable task) {
        DynamicScheduledTask scheduledTask = this.scheduledTasks.remove(task);
        if (scheduledTask != null) {
            log.info("### \u4e00\u5904\u5b9a\u65f6\u4efb\u52a1...");
            scheduledTask.cancel();
        } else {
            log.info("### \u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728 ...");
        }
    }

    private DynamicScheduledTask dynamicScheduledTaskOfDate(Runnable task, Date time) {
        DynamicScheduledTask scheduledTask = new DynamicScheduledTask();
        scheduledTask.future = this.methodTaskScheduler.schedule(task, time);
        return scheduledTask;
    }

    private DynamicScheduledTask dynamicScheduledTaskOfFixedRate(Runnable task, long taskSchedulerFixedRate) {
        DynamicScheduledTask scheduledTask = new DynamicScheduledTask();
        scheduledTask.future = this.methodTaskScheduler.scheduleAtFixedRate(task, taskSchedulerFixedRate);
        return scheduledTask;
    }

    public void destroy() {
        for (DynamicScheduledTask task : this.scheduledTasks.values()) {
            task.cancel();
        }
        this.scheduledTasks.clear();
    }
}

