/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.api.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsSubAccountCreateOpenServiceImpl
implements SimpleOpenApiRpcService {
    @Autowired
    private ElsSubAccountService elsSubAccountService;

    public JSONObject invoke(JSONObject param) {
        if (!param.containsKey((Object)"headList")) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"headList \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List list = JSONObject.parseArray((String)param.getString("headList"), ElsSubAccount.class);
        this.checkRepeat(list);
        Date date = new Date();
        JSONArray headArray = new JSONArray();
        for (ElsSubAccount user : list) {
            ElsSubAccount sysUser = this.elsSubAccountService.getUserBySubAccount(user.getSubAccount());
            if (sysUser != null) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u5b50\u8d26\u53f7subAccount:" + user.getSubAccount() + "\u5728SRM\u5df2\u7ecf\u5b58\u5728\uff01")));
            }
            String salt = ConvertUtils.randomGen((int)8);
            user.setSalt(salt);
            String passwordEncode = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + user.getSubAccount()), (String)"123456", (String)salt);
            user.setPassword(passwordEncode);
            if (user.getStatus() == null) {
                user.setStatus(1);
            }
            user.setDeleted(CommonConstant.DEL_FLAG_0);
            user.setId(IdWorker.getIdStr());
            user.setCreateTime(date);
            user.setElsAccount(TenantContext.getTenant());
            JSONObject headObj = SysUtil.objectToJSON((Object)((Object)user));
            headObj.remove((Object)"salt");
            headObj.remove((Object)"password");
            headArray.add((Object)headObj);
        }
        this.elsSubAccountService.saveBatch(list);
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", (Object)headArray);
        return resultObj;
    }

    private void checkRepeat(List<ElsSubAccount> list) {
        Map<String, List<ElsSubAccount>> map = list.stream().collect(Collectors.groupingBy(ElsSubAccount::getSubAccount));
        for (String key : map.keySet()) {
            if (map.get(key).size() <= 1) continue;
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"subAccount\u91cd\u590d\uff01"));
        }
    }
}

