/*
 * Decompiled with CFR 0.152.
 */
package com.els;

import com.els.modules.db.TableEntityScanner;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.swagger.web.ApiResourceController;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
import springfox.documentation.swagger2.web.Swagger2ControllerWebMvc;

@SpringBootApplication(exclude={SecurityAutoConfiguration.class, ManagementWebSecurityAutoConfiguration.class})
@EnableDiscoveryClient
@EnableAsync
@EnableSwagger2
@ComponentScan(excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, value={TableEntityScanner.class})}, basePackages={"com.els"})
public class AiApplication {
    private static final Logger log = LoggerFactory.getLogger(AiApplication.class);
    private static final String projectPath = "/ai";

    public static void main(String[] args) throws UnknownHostException {
        System.setProperty("spring.devtools.restart.enabled", "true");
        ConfigurableApplicationContext application = SpringApplication.run(AiApplication.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        System.out.println("2323112321");
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n-----------------------------------------------------------------\n\tApplication-ai is running! Swagger URLs:\n\tLocal: \t\thttp://localhost:" + port + path + "/doc.html\n----------------------------------------------------------");
    }

    @Controller
    @ApiIgnore
    @RequestMapping(value={"/ai"})
    public static class SwaggerResourceController {
        @Autowired
        private ApiResourceController apiResourceController;
        @Autowired
        private Swagger2ControllerWebMvc swagger2ControllerWebMvc;

        @GetMapping
        public ModelAndView index() {
            return new ModelAndView("redirect:/ai/doc.html");
        }

        @GetMapping(value={"/swagger-resources/configuration/security"})
        @ResponseBody
        public ResponseEntity<SecurityConfiguration> securityConfiguration() {
            return this.apiResourceController.securityConfiguration();
        }

        @GetMapping(value={"/swagger-resources/configuration/ui"})
        @ResponseBody
        public ResponseEntity<UiConfiguration> uiConfiguration() {
            return this.apiResourceController.uiConfiguration();
        }

        @GetMapping(value={"/swagger-resources"})
        @ResponseBody
        public ResponseEntity<List<SwaggerResource>> swaggerResources() {
            return this.apiResourceController.swaggerResources();
        }

        @RequestMapping(value={"/v2/api-docs"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
        @ResponseBody
        public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
            return this.swagger2ControllerWebMvc.getDocumentation(swaggerGroup, servletRequest);
        }
    }
}

