/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.nlp;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AiOrderCreationModelProperties {
    @Value(value="${model.similarity.threshold}")
    private double similarityThreshold = 0.2;
    @Value(value="${model.word2vec.path}")
    private String word2VecPath;
    @Value(value="${model.score.weight.keyword}")
    private Double keyWordWeight;
    @Value(value="${model.score.weight.semantic}")
    private Double semanticWeight;
    @Value(value="${model.score.weight.completeness}")
    private Double completenessWeight;
    @Value(value="${model.score.weight.context}")
    private Double contextWeight;

    public double getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public String getWord2VecPath() {
        return this.word2VecPath;
    }

    public Double getKeyWordWeight() {
        return this.keyWordWeight;
    }

    public Double getSemanticWeight() {
        return this.semanticWeight;
    }

    public Double getCompletenessWeight() {
        return this.completenessWeight;
    }

    public Double getContextWeight() {
        return this.contextWeight;
    }

    public void setSimilarityThreshold(double similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }

    public void setWord2VecPath(String word2VecPath) {
        this.word2VecPath = word2VecPath;
    }

    public void setKeyWordWeight(Double keyWordWeight) {
        this.keyWordWeight = keyWordWeight;
    }

    public void setSemanticWeight(Double semanticWeight) {
        this.semanticWeight = semanticWeight;
    }

    public void setCompletenessWeight(Double completenessWeight) {
        this.completenessWeight = completenessWeight;
    }

    public void setContextWeight(Double contextWeight) {
        this.contextWeight = contextWeight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AiOrderCreationModelProperties)) {
            return false;
        }
        AiOrderCreationModelProperties other = (AiOrderCreationModelProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getSimilarityThreshold(), other.getSimilarityThreshold()) != 0) {
            return false;
        }
        Double this$keyWordWeight = this.getKeyWordWeight();
        Double other$keyWordWeight = other.getKeyWordWeight();
        if (this$keyWordWeight == null ? other$keyWordWeight != null : !((Object)this$keyWordWeight).equals(other$keyWordWeight)) {
            return false;
        }
        Double this$semanticWeight = this.getSemanticWeight();
        Double other$semanticWeight = other.getSemanticWeight();
        if (this$semanticWeight == null ? other$semanticWeight != null : !((Object)this$semanticWeight).equals(other$semanticWeight)) {
            return false;
        }
        Double this$completenessWeight = this.getCompletenessWeight();
        Double other$completenessWeight = other.getCompletenessWeight();
        if (this$completenessWeight == null ? other$completenessWeight != null : !((Object)this$completenessWeight).equals(other$completenessWeight)) {
            return false;
        }
        Double this$contextWeight = this.getContextWeight();
        Double other$contextWeight = other.getContextWeight();
        if (this$contextWeight == null ? other$contextWeight != null : !((Object)this$contextWeight).equals(other$contextWeight)) {
            return false;
        }
        String this$word2VecPath = this.getWord2VecPath();
        String other$word2VecPath = other.getWord2VecPath();
        return !(this$word2VecPath == null ? other$word2VecPath != null : !this$word2VecPath.equals(other$word2VecPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AiOrderCreationModelProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $similarityThreshold = Double.doubleToLongBits(this.getSimilarityThreshold());
        result = result * 59 + (int)($similarityThreshold >>> 32 ^ $similarityThreshold);
        Double $keyWordWeight = this.getKeyWordWeight();
        result = result * 59 + ($keyWordWeight == null ? 43 : ((Object)$keyWordWeight).hashCode());
        Double $semanticWeight = this.getSemanticWeight();
        result = result * 59 + ($semanticWeight == null ? 43 : ((Object)$semanticWeight).hashCode());
        Double $completenessWeight = this.getCompletenessWeight();
        result = result * 59 + ($completenessWeight == null ? 43 : ((Object)$completenessWeight).hashCode());
        Double $contextWeight = this.getContextWeight();
        result = result * 59 + ($contextWeight == null ? 43 : ((Object)$contextWeight).hashCode());
        String $word2VecPath = this.getWord2VecPath();
        result = result * 59 + ($word2VecPath == null ? 43 : $word2VecPath.hashCode());
        return result;
    }

    public String toString() {
        return "AiOrderCreationModelProperties(similarityThreshold=" + this.getSimilarityThreshold() + ", word2VecPath=" + this.getWord2VecPath() + ", keyWordWeight=" + this.getKeyWordWeight() + ", semanticWeight=" + this.getSemanticWeight() + ", completenessWeight=" + this.getCompletenessWeight() + ", contextWeight=" + this.getContextWeight() + ")";
    }

    public AiOrderCreationModelProperties(double similarityThreshold, String word2VecPath, Double keyWordWeight, Double semanticWeight, Double completenessWeight, Double contextWeight) {
        this.similarityThreshold = similarityThreshold;
        this.word2VecPath = word2VecPath;
        this.keyWordWeight = keyWordWeight;
        this.semanticWeight = semanticWeight;
        this.completenessWeight = completenessWeight;
        this.contextWeight = contextWeight;
    }

    public AiOrderCreationModelProperties() {
    }
}

