/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.flowAgent.core.AgentStrategyFactory;
import com.els.modules.ai.flowAgent.core.clean.CleanStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentDataCleanConfigItem;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCleanRunner {
    private static final Logger log = LoggerFactory.getLogger(DataCleanRunner.class);

    public static Map<String, String> clean(AgentLlmRequestDto llmRequest, JSONObject collectDataMap, List<AiAgentDataCleanConfigItem> aiAgentDataCleanConfigItemList) {
        List configItems = aiAgentDataCleanConfigItemList.stream().filter(x -> "1".equals(x.getEnable())).sorted(Comparator.comparing(AiAgentDataCleanConfigItem::getOrderSort)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(configItems)) {
            JSONObject inputMap = JSONObject.parseObject((String)collectDataMap.toString());
            for (AiAgentDataCleanConfigItem item : configItems) {
                CleanStrategy cleanStrategy = AgentStrategyFactory.getCleanStrategy(item.getItemType());
                inputMap = cleanStrategy.execute(llmRequest, item, inputMap);
            }
            collectDataMap = inputMap;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : collectDataMap.keySet()) {
            if (collectDataMap.get((Object)key) instanceof String) {
                result.put(key, collectDataMap.getString(key));
                continue;
            }
            result.put(key, JSON.toJSONString((Object)collectDataMap.get((Object)key)));
        }
        return result;
    }
}

