/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core.collect;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.flowAgent.core.AgentStrategyFactory;
import com.els.modules.ai.flowAgent.core.collect.CollectStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentDataCollectConfigItem;
import com.els.modules.ai.flowAgent.enums.AgentStepType;
import com.els.modules.ai.orderCreation.listener.AgentMqUtil;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractCollectStrategy
implements CollectStrategy,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        AgentStrategyFactory.register(this.type(), this);
    }

    public abstract String doExecute(AgentLlmRequestDto var1, AiAgentDataCollectConfigItem var2, JSONObject var3);

    @Override
    public String execute(AgentLlmRequestDto llmRequest, AiAgentDataCollectConfigItem config, JSONObject input) {
        try {
            String result = this.doExecute(llmRequest, config, input);
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.COLLECT_DATA.getType(), config.getName(), config.getOrderSort(), result, "");
            return result;
        }
        catch (Exception e) {
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.COLLECT_DATA.getType(), config.getName(), config.getOrderSort(), null == input.getString("responseBody") ? "" : input.getString("responseBody"), e.getMessage());
            throw e;
        }
    }
}

