/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core.collect;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceGroovyFactory;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.flowAgent.core.collect.AbstractCollectStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentDataCollectConfigItem;
import com.els.modules.ai.service.AiFlowAgentEnhanceRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceContentEngineCollectStrategy
extends AbstractCollectStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceContentEngineCollectStrategy.class);

    @Override
    public String type() {
        return "SERVICE_CONTENT";
    }

    @Override
    public String doExecute(AgentLlmRequestDto llmRequest, AiAgentDataCollectConfigItem item, JSONObject input) {
        AiFlowAgentEnhanceRpcService service;
        String aiInnerEnhanceServiceBean = item.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiInnerEnhanceServiceBean) && (service = AiEnhanceGroovyFactory.getInstance().getEnhanceService(aiInnerEnhanceServiceBean, AiFlowAgentEnhanceRpcService.class)) != null) {
            return service.runCollect(llmRequest, input, new String[0]);
        }
        return "";
    }
}

