/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SysUtil;
import com.els.modules.ai.core.modelStrategy.AiLogicRunStrategy;
import com.els.modules.ai.core.nlp.QuestionAnalysisService;
import com.els.modules.ai.core.nlp.service.ModelInfoMatchingService;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.dto.AiChatAppDto;
import com.els.modules.ai.dto.AiChatDto;
import com.els.modules.ai.dto.AiChatExamplarDto;
import com.els.modules.ai.dto.AiChatModelConfigDto;
import com.els.modules.ai.dto.AiOrderCreationDto;
import com.els.modules.ai.dto.AiOrderCreationFiledSchemaDto;
import com.els.modules.ai.dto.LlmRequestDto;
import com.els.modules.ai.dto.LlmResponseDto;
import com.els.modules.ai.dto.QuestionInfoDto;
import com.els.modules.ai.modelConfig.entity.AiChatResultLog;
import com.els.modules.ai.modelConfig.service.AiChatAppService;
import com.els.modules.ai.modelConfig.service.AiChatExamplarService;
import com.els.modules.ai.modelConfig.service.AiChatModelConfigService;
import com.els.modules.ai.modelConfig.service.AiChatResultLogService;
import com.els.modules.ai.orderCreation.core.CorrectConditionMapping;
import com.els.modules.ai.orderCreation.core.DictConditionMapping;
import com.els.modules.ai.orderCreation.core.FiledConditionMapping;
import com.els.modules.ai.orderCreation.core.FiledRequiredConditionMapping;
import com.els.modules.ai.orderCreation.core.SessionBuilder;
import com.els.modules.ai.orderCreation.dto.AiOrderCreationCurrentSessionDto;
import com.els.modules.ai.orderCreation.dto.AiOrderCreationRequestDto;
import com.els.modules.ai.orderCreation.dto.AiOrderCreationRunDto;
import com.els.modules.ai.orderCreation.dto.AiOrderCreationSessionDto;
import com.els.modules.ai.orderCreation.dto.AiOrderCreationUnCompletedSessionDto;
import com.els.modules.ai.orderCreation.entity.AiOrderCreationDialogAiSession;
import com.els.modules.ai.orderCreation.entity.AiOrderCreationModelHead;
import com.els.modules.ai.orderCreation.entity.AiOrderCreationModelItem;
import com.els.modules.ai.orderCreation.enums.AiOrderCreationSessionStatus;
import com.els.modules.ai.orderCreation.service.AiOrderCreationDialogAiSessionService;
import com.els.modules.ai.orderCreation.service.AiOrderCreationModelHeadService;
import com.els.modules.ai.orderCreation.service.AiOrderCreationModelItemService;
import com.els.modules.ai.rpc.service.InvokeAiChatRpcService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AiRequestService {
    private static final Logger log = LoggerFactory.getLogger(AiRequestService.class);
    @Resource
    private AiChatAppService aiChatAppService;
    @Resource
    private AiChatExamplarService aiChatExamplarService;
    @Resource
    private AiChatResultLogService aiChatResultLogService;
    @Resource
    private AiChatModelConfigService aiChatModelConfigService;
    @Autowired
    private SessionBuilder sessionBuilder;
    @Autowired
    private InvokeAiChatRpcService invokeAiChatRpcService;
    @Autowired
    private AiOrderCreationModelHeadService aiOrderCreationModelHeadService;
    @Autowired
    private AiOrderCreationDialogAiSessionService aiOrderCreationDialogAiSessionService;
    @Autowired
    private AiOrderCreationModelItemService aiOrderCreationModelItemService;
    @Autowired
    private QuestionAnalysisService questionAnalysisService;
    @Autowired
    private ModelInfoMatchingService modelInfoMatchingService;

    @Transactional(rollbackFor={Exception.class})
    public LlmResponseDto runChat(LlmRequestDto llmRequest) {
        AiChatDto chatDto = llmRequest.getAiChatPojo();
        if (null == chatDto) {
            throw new ELSBootException("\u8c03\u7528\u7684APP\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        AiChatAppDto chatAppConfig = this.aiChatAppService.loadAiChatAppByCode(chatDto.getAppCode(), SysUtil.getLoginUser().getElsAccount());
        chatDto.setLanguage("zh");
        chatDto.setCurrentDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        QuestionInfoDto questionInfo = chatDto.getQuestion();
        if (CharSequenceUtil.isEmpty((CharSequence)questionInfo.getQuestion())) {
            questionInfo.setQuestion(chatAppConfig.getQuestion());
        }
        List<AiChatExamplarDto> chatExamplers = this.aiChatExamplarService.loadExamplersByCode(chatDto.getAppCode(), chatAppConfig.getElsAccount());
        llmRequest.setAiChatPojo(chatDto);
        llmRequest.setAiChatAppPojo(chatAppConfig);
        llmRequest.setChatExamplers(chatExamplers);
        AiChatModelConfigDto aiChatModelConfigDto = this.aiChatModelConfigService.loadModelConfigByProvider(chatAppConfig.getModelProvider(), chatAppConfig.getModelName(), chatAppConfig.getElsAccount());
        chatAppConfig.setAiChatModelConfigPojo(aiChatModelConfigDto);
        AiLogicRunStrategy runStrategy = AiBeanFactory.getAiLogicRunStrategy(chatAppConfig.getModelRunStrategy());
        LlmResponseDto result = runStrategy.generate(llmRequest);
        result.setQuestion(questionInfo.getQuestion());
        AiChatResultLog log = new AiChatResultLog();
        log.setElsAccount(SysUtil.getLoginUser().getElsAccount());
        log.setBusinessId(questionInfo.getBusinessId());
        log.setBusinessNumber(questionInfo.getBusinessNumber());
        log.setBusinessType(questionInfo.getBusinessType());
        log.setBusinessName(questionInfo.getBusinessName());
        log.setQuestionInput(result.getQuestionInput());
        log.setQuestionResult(result.getResultText());
        log.setAppCode(chatDto.getAppCode());
        this.aiChatResultLogService.add(log);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public AiOrderCreationSessionDto runAiOrderCreationChat(AiOrderCreationRequestDto requestDTO) {
        requestDTO.setUserId(SysUtil.getLoginUser().getId());
        if (CharSequenceUtil.isEmpty((CharSequence)requestDTO.getSessionId())) {
            throw new ELSBootException("\u4f1a\u8bddID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            AiOrderCreationDto creationCheckPojo;
            String resultText;
            this.sessionBuilder.getOrSaveOrUpdateSession(requestDTO);
            if (CharSequenceUtil.isEmpty((CharSequence)requestDTO.getDataModelId())) {
                String matchModelId = this.modelInfoMatchingService.matchModel(requestDTO.getQueryText());
                requestDTO.setDataModelId(matchModelId);
            }
            if (CharSequenceUtil.isEmpty((CharSequence)requestDTO.getDataModelId())) {
                throw new ELSBootException("\u672a\u8bc6\u522b\u5230\u6570\u636e\u6a21\u578b\uff0c\u8bf7\u66f4\u6362\u9700\u6c42\u95ee\u9898\u6216\u8005\u624b\u52a8\u9009\u62e9\u6a21\u578b");
            }
            this.sessionBuilder.permissionCheck(requestDTO.getDataModelId());
            AiOrderCreationUnCompletedSessionDto unCompletedSession = this.sessionBuilder.findUnCompletedSessionByRequest(requestDTO);
            AiOrderCreationCurrentSessionDto currentSession = this.sessionBuilder.buildNewSessionByRequest(requestDTO, unCompletedSession);
            LlmRequestDto llmRequest = new LlmRequestDto();
            QuestionInfoDto questionInfo = new QuestionInfoDto();
            questionInfo.setQuestion(currentSession.getQueryText());
            HashMap<String, String> questionSchemaMap = new HashMap<String, String>();
            this.sessionBuilder.buildQuestionSchema(currentSession, unCompletedSession, questionSchemaMap);
            questionInfo.setQuestionSchema((String)questionSchemaMap.remove("questionSchema"));
            questionInfo.setQuestionSchemaMap(questionSchemaMap);
            questionInfo.setBusinessType(currentSession.getBusinessType());
            AiChatDto chatChatConfig = new AiChatDto();
            chatChatConfig.setAppCode("AiOrderCreation");
            chatChatConfig.setQuestion(questionInfo);
            llmRequest.setAiChatPojo(chatChatConfig);
            List<AiOrderCreationFiledSchemaDto> schemaList = currentSession.getSchemaList();
            boolean relevant = this.questionAnalysisService.isQuestionRelevant(schemaList, currentSession.getModelExtendItems(), questionInfo.getQuestion());
            if (!relevant) {
                return this.buildInvalidAiSession(currentSession, unCompletedSession);
            }
            String thought = "\u5f53\u524d\u4f1a\u8bdd\u65e0\u9700AI\u5206\u6790\uff0c\u4e0d\u5b58\u5728\u601d\u8003\u8fc7\u7a0b";
            if ("0".equals(currentSession.getConditionStatus())) {
                resultText = currentSession.getDefaultConditionJson();
            } else {
                LlmResponseDto llmResponsePojo = this.runChat(llmRequest);
                resultText = llmResponsePojo.getResultText();
                thought = llmResponsePojo.getThought();
            }
            CorrectConditionMapping conditionMapping = new CorrectConditionMapping();
            JSONObject correctCondition = conditionMapping.mapping(JSON.parseObject((String)resultText), currentSession.getSchemaList());
            JSONObject modelBindJson = currentSession.getModelBindJson();
            if (null != modelBindJson && !modelBindJson.isEmpty()) {
                for (String flied : modelBindJson.keySet()) {
                    correctCondition.put(flied, modelBindJson.get((Object)flied));
                }
            }
            currentSession.setQueryResult(thought);
            currentSession.setFinalCondition(correctCondition.toString());
            FiledConditionMapping filedConditionMapping = new FiledConditionMapping();
            JSONObject mappingConditionText = filedConditionMapping.mapping(correctCondition, currentSession.getSchemaList());
            currentSession.setFinalConditionText(mappingConditionText.toString());
            this.sessionBuilder.saveUserSession(currentSession, unCompletedSession);
            try {
                DictConditionMapping dictConditionMapping = new DictConditionMapping();
                JSONObject condition = dictConditionMapping.mapping(correctCondition, currentSession.getSchemaList());
                currentSession.setLastFinalCondition(condition.toString());
                FiledRequiredConditionMapping requiredMapper = new FiledRequiredConditionMapping();
                Object requiredList = requiredMapper.mapping(condition, (List)currentSession.getSchemaList());
                if (CollectionUtil.isNotEmpty((Collection)requiredList)) {
                    throw new ELSBootException(requiredList.stream().collect(Collectors.joining(",")) + "\u5fc5\u586b");
                }
                AiOrderCreationDto checkRequestDTO = new AiOrderCreationDto();
                checkRequestDTO.setBusinessType(currentSession.getBusinessType());
                checkRequestDTO.setElsAccount(SysUtil.getLoginUser().getElsAccount());
                checkRequestDTO.setCondition(condition);
                checkRequestDTO.setSchemaList(currentSession.getSchemaList());
                creationCheckPojo = this.invokeAiChatRpcService.getAiOrderCreationRpcService(currentSession.getBeanImpl()).check(checkRequestDTO, new String[]{currentSession.getBeanImpl()});
            }
            catch (Exception e) {
                log.error("AI\u521b\u5efa\u5355\u636e\u6570\u636e\u68c0\u6d4b\u62a5\u9519:{}", (Object)e.getMessage());
                String message = e.getMessage();
                creationCheckPojo = new AiOrderCreationDto();
                creationCheckPojo.setCheckPass(false);
                creationCheckPojo.setCount(0);
                creationCheckPojo.setCheckMessage(message);
            }
            AiOrderCreationDialogAiSession aiSession = this.sessionBuilder.saveAiSession(currentSession, creationCheckPojo);
            AiOrderCreationSessionDto result = new AiOrderCreationSessionDto();
            BeanUtils.copyProperties((Object)((Object)aiSession), (Object)result);
            result.setSchemaList(currentSession.getSchemaList());
            return result;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    private AiOrderCreationSessionDto buildInvalidAiSession(AiOrderCreationCurrentSessionDto currentSession, AiOrderCreationUnCompletedSessionDto unCompletedSession) {
        String resultText = "\u7528\u6237\u8f93\u5165\u7684\u95ee\u9898\u5728[" + currentSession.getDataModelName() + "]\u4e2d\u6ca1\u5339\u914d\u5230\u6709\u6548\u7684\u6a21\u578b\u5b57\u6bb5\uff0c\u5982\u679c\u81ea\u52a8\u8bc6\u522b\u6a21\u578b\u6709\u8bef\uff0c\u8bf7\u624b\u52a8\u66f4\u6362\u6a21\u578b\u518d\u8fdb\u884c\u8be2\u95ee\uff01";
        String thought = "\u5f53\u524d\u4f1a\u8bdd\u5185\u5bb9\u7531\u5206\u8bcd\u5f15\u64ce\u8fdb\u884c\u5224\u65ad\uff0c\u4e0d\u5b58\u5728AI\u601d\u8003\u8fc7\u7a0b\uff0c\u5982\u679c\u5206\u8bcd\u8bc6\u522b\u6709\u8bef\uff0c\u8bf7\u4f7f\u7528\u4e3b\u8c13\u5bbe\u7684\u8bed\u6cd5\u5b8c\u5584\u53e5\u5f0f";
        currentSession.setQueryResult(thought);
        currentSession.setFinalCondition(resultText);
        currentSession.setFinalConditionText(resultText);
        this.sessionBuilder.saveUserSession(currentSession, unCompletedSession);
        currentSession.setLastFinalCondition(resultText);
        AiOrderCreationDto creationCheckPojo = new AiOrderCreationDto();
        creationCheckPojo.setCheckPass(false);
        creationCheckPojo.setCount(0);
        creationCheckPojo.setCheckMessage("\u65e0\u6548\u4f1a\u8bdd\uff0c\u672a\u5339\u914d\u5230\u6709\u6548\u7684\u6a21\u578b\u5b57\u6bb5\uff0c\u5982\u679c\u5339\u914d\u6709\u8bef\uff0c\u8bf7\u4f7f\u7528\u4e3b\u8c13\u5bbe\u7684\u8bed\u6cd5\u5b8c\u5584\u53e5\u5f0f");
        currentSession.setStatus(AiOrderCreationSessionStatus.INVALID.getCode());
        AiOrderCreationDialogAiSession aiSession = this.sessionBuilder.saveAiSession(currentSession, creationCheckPojo);
        AiOrderCreationSessionDto result = new AiOrderCreationSessionDto();
        BeanUtils.copyProperties((Object)((Object)aiSession), (Object)result);
        return result;
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public AiOrderCreationRunDto execAiOrderCreation(AiOrderCreationRunDto runDTO) {
        AiOrderCreationRunDto returnData = new AiOrderCreationRunDto();
        this.sessionBuilder.permissionCheck(runDTO.getDataModelId());
        AiOrderCreationModelHead modelHead = (AiOrderCreationModelHead)((Object)this.aiOrderCreationModelHeadService.getById((Serializable)((Object)runDTO.getDataModelId())));
        if (null == modelHead) {
            throw new ELSBootException("\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        AiOrderCreationDialogAiSession aiSession = (AiOrderCreationDialogAiSession)((Object)this.aiOrderCreationDialogAiSessionService.getById((Serializable)((Object)runDTO.getAiSessionId())));
        if (null == aiSession) {
            throw new ELSBootException("AI\u5206\u6790\u7ed3\u679c\u4e0d\u5b58\u5728");
        }
        List<AiOrderCreationModelItem> modelItems = this.aiOrderCreationModelItemService.selectByMainId(runDTO.getDataModelId());
        if (CollectionUtil.isEmpty(modelItems)) {
            throw new ELSBootException("\u6570\u636e\u6a21\u578b\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        if ("1".equals(runDTO.getOperate()) || "1".equals(runDTO.getPreView())) {
            List schemaList;
            FiledRequiredConditionMapping requiredMapper = new FiledRequiredConditionMapping();
            JSONObject condition = JSON.parseObject((String)aiSession.getLastFinalCondition());
            Object requiredList = requiredMapper.mapping(condition, schemaList = modelItems.stream().map(x -> {
                AiOrderCreationFiledSchemaDto schemaDTO = new AiOrderCreationFiledSchemaDto();
                schemaDTO.setFieldName(x.getModelFieldName());
                schemaDTO.setFieldCode(x.getModelFieldCode());
                schemaDTO.setFieldType(x.getModelFieldType());
                schemaDTO.setFieldRequired(x.getFieldRequired());
                return schemaDTO;
            }).collect(Collectors.toList()));
            if (CollectionUtil.isNotEmpty((Collection)requiredList)) {
                throw new ELSBootException(requiredList.stream().collect(Collectors.joining(",")) + "\u5fc5\u586b");
            }
            AiOrderCreationDto requestDTO = new AiOrderCreationDto();
            requestDTO.setBusinessType(modelHead.getBusinessType());
            requestDTO.setElsAccount(SysUtil.getLoginUser().getElsAccount());
            requestDTO.setCondition(condition);
            requestDTO.setSchemaList(schemaList);
            requestDTO.setPreView("1".equals(runDTO.getPreView()));
            AiOrderCreationDto creationPojo = this.invokeAiChatRpcService.getAiOrderCreationRpcService(modelHead.getBeanImpl()).run(requestDTO, new String[]{modelHead.getBeanImpl()});
            if ("1".equals(runDTO.getPreView())) {
                returnData.setDataModelId(runDTO.getDataModelId());
                returnData.setBusinessType(modelHead.getBusinessType());
                returnData.setPreViewPath(modelHead.getPreViewPath());
                returnData.setPreViewMax(modelHead.getPreViewMax());
                returnData.setDataList(creationPojo.getDataList());
            } else {
                aiSession.setStatus(AiOrderCreationSessionStatus.COMPLETED.getCode());
                this.sessionBuilder.saveOrderLog(aiSession, creationPojo.getNumberList());
                this.aiOrderCreationDialogAiSessionService.updateById((Object)aiSession);
            }
        } else {
            aiSession.setStatus(AiOrderCreationSessionStatus.CLOSE.getCode());
            this.aiOrderCreationDialogAiSessionService.updateById((Object)aiSession);
        }
        return returnData;
    }
}

