/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.core.AiChatExtractor;
import com.els.modules.ai.core.AiQuestion;
import com.els.modules.ai.core.helper.AiChatResponseHelper;
import com.els.modules.ai.core.modelStrategy.SimpleAiLogicRunStrategy;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceGroovyFactory;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceService;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.dto.AiChatAppDto;
import com.els.modules.ai.dto.AiChatDto;
import com.els.modules.ai.dto.AiChatExamplarDto;
import com.els.modules.ai.dto.LlmRequestDto;
import com.els.modules.ai.dto.LlmResponseDto;
import com.els.modules.ai.dto.QuestionInfoDto;
import com.google.common.collect.Lists;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.service.AiServices;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class Langchain4jConfigAiLogicRunStrategy
extends SimpleAiLogicRunStrategy
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Langchain4jConfigAiLogicRunStrategy.class);

    @Override
    public String modelRunStrategy() {
        return "langchain4jConfigAiLogicRunStrategy";
    }

    protected LlmResponseDto runAiSelfConsistencyVoteBuilder(AiChatDto aiChatPojo, AiChatAppDto aiChatAppPojo, LlmResponseDto llmResponse, Map<String, Prompt> output2Prompt) {
        String aiInnerEnhanceServiceBeanName = aiChatAppPojo.getAiInnerEnhanceServiceBeanName();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiInnerEnhanceServiceBeanName)) {
            try {
                AiEnhanceService bean = (AiEnhanceService)SpringContextUtils.getBean((String)aiInnerEnhanceServiceBeanName, AiEnhanceService.class);
                return bean.runAiSelfConsistencyVoteBuilder(aiChatPojo, aiChatAppPojo, llmResponse, output2Prompt);
            }
            catch (Exception e) {
                throw new ELSBootException(aiInnerEnhanceServiceBeanName + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        String aiEnhanceServiceBean = aiChatAppPojo.getAiEnhanceServiceBean();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiEnhanceServiceBean)) {
            AiEnhanceService service = AiEnhanceGroovyFactory.getInstance().getEnhanceServiceFromCode(aiEnhanceServiceBean);
            if (service != null) {
                return service.runAiSelfConsistencyVoteBuilder(aiChatPojo, aiChatAppPojo, llmResponse, output2Prompt);
            }
        } else {
            AiChatResponseHelper responseHelper = AiBeanFactory.getAiChatResponseHelper(aiChatAppPojo.getModelRunResponseHelper());
            Pair<String, Map<String, Double>> sqlMapPair = responseHelper.selfConsistencyVote(Lists.newArrayList(output2Prompt.keySet()));
            llmResponse.setResultText((String)sqlMapPair.getLeft());
        }
        return llmResponse;
    }

    @Override
    public LlmResponseDto generate(LlmRequestDto llmRequest) {
        LlmResponseDto llmResponse = new LlmResponseDto();
        AiChatDto chatChatConfig = llmRequest.getAiChatPojo();
        AiChatAppDto chatAppConfig = llmRequest.getAiChatAppPojo();
        QuestionInfoDto question = chatChatConfig.getQuestion();
        String questionText = CharSequenceUtil.isEmpty((CharSequence)question.getQuestion()) ? chatAppConfig.getQuestion() : question.getQuestion();
        llmResponse.setQuestion(questionText);
        List<List<AiChatExamplarDto>> exemplarsList = this.promptHelper.getFewShotExemplars(llmRequest);
        AiChatAppDto chatApp = llmRequest.getAiChatAppPojo();
        if (StringUtils.isEmpty((CharSequence)chatApp.getPromptTemplate())) {
            throw new ELSBootException("\u5e94\u7528\u95ee\u9898\u6a21\u677f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        ChatLanguageModel chatLanguageModel = this.getChatLanguageModel(chatApp.getAiChatModelConfigPojo());
        AiChatExtractor extractor = (AiChatExtractor)AiServices.create(AiChatExtractor.class, (ChatLanguageModel)chatLanguageModel);
        HashMap<Prompt, List<AiChatExamplarDto>> prompt2Exemplar = new HashMap<Prompt, List<AiChatExamplarDto>>();
        for (List<AiChatExamplarDto> exemplars : exemplarsList) {
            llmRequest.setChatExamplers(exemplars);
            Prompt prompt2 = this.generatePrompt(llmRequest, llmResponse, chatApp);
            prompt2Exemplar.put(prompt2, exemplars);
        }
        ConcurrentHashMap<String, Prompt> output2Prompt = new ConcurrentHashMap<String, Prompt>();
        ConcurrentHashMap thoughtMap = new ConcurrentHashMap();
        prompt2Exemplar.keySet().parallelStream().forEach(prompt -> {
            llmResponse.setQuestionInput(prompt.toUserMessage().singleText());
            AiQuestion answer = extractor.generateResult(prompt.toUserMessage().singleText());
            output2Prompt.put(answer.getResultText(), (Prompt)prompt);
            thoughtMap.put(answer.getResultText(), answer.getThought());
        });
        LlmResponseDto llmResponsePojo = this.runAiSelfConsistencyVoteBuilder(chatChatConfig, chatApp, llmResponse, output2Prompt);
        llmResponsePojo.setThought((String)thoughtMap.get(llmResponsePojo.getResultText()));
        return llmResponsePojo;
    }
}

