/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.nlp;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimilarityCalculator {
    public static double cosineSimilarity(List<String> questionTokens, List<String> specTokens) {
        Set union = Stream.concat(questionTokens.stream(), specTokens.stream()).collect(Collectors.toSet());
        int[] questionVector = new int[union.size()];
        int[] specVector = new int[union.size()];
        int i = 0;
        for (String term : union) {
            questionVector[i] = (int)questionTokens.stream().filter(t -> t.equals(term)).count();
            specVector[i] = (int)specTokens.stream().filter(t -> t.equals(term)).count();
            ++i;
        }
        return SimilarityCalculator.dotProduct(questionVector, specVector) / (SimilarityCalculator.magnitude(questionVector) * SimilarityCalculator.magnitude(specVector));
    }

    private static double dotProduct(int[] a, int[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += (double)(a[i] * b[i]);
        }
        return sum;
    }

    private static double magnitude(int[] a) {
        double sum = 0.0;
        for (int j : a) {
            sum += Math.pow(j, 2.0);
        }
        return Math.sqrt(sum);
    }
}

