/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core.clean;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.flowAgent.core.clean.AbstractCleanStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentDataCleanConfigItem;
import com.els.modules.ai.rpc.service.InvokeAiChatRpcService;
import com.els.modules.ai.service.AiFlowAgentEnhanceRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceBeanEngineCleanStrategy
extends AbstractCleanStrategy {
    private static final Logger log = LoggerFactory.getLogger(ServiceBeanEngineCleanStrategy.class);

    @Override
    public String type() {
        return "SERVICE_BEAN";
    }

    @Override
    public JSONObject doExecute(AgentLlmRequestDto llmRequest, AiAgentDataCleanConfigItem config, JSONObject input) {
        String cleanConfig = config.getItemConfig();
        if (CharSequenceUtil.isNotEmpty((CharSequence)cleanConfig)) {
            try {
                AiFlowAgentEnhanceRpcService bean = ((InvokeAiChatRpcService)SpringContextUtils.getBean(InvokeAiChatRpcService.class)).getAiAgentEnhanceRpcService(cleanConfig.trim());
                return bean.runClean(llmRequest, input, new String[0]);
            }
            catch (Exception e) {
                throw new ELSBootException(cleanConfig + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        return input;
    }
}

