/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core.run;

import com.els.modules.ai.dto.LlmRequestDto;
import com.els.modules.ai.dto.LlmResponseDto;
import com.els.modules.ai.flowAgent.core.AgentStrategyFactory;
import com.els.modules.ai.flowAgent.core.run.RunStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentAppConfigItem;
import com.els.modules.ai.flowAgent.enums.AgentStepType;
import com.els.modules.ai.orderCreation.listener.AgentMqUtil;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractRunStrategy
implements RunStrategy,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        AgentStrategyFactory.register(this.type(), this);
    }

    public abstract LlmResponseDto doExecute(LlmRequestDto var1, AiAgentAppConfigItem var2);

    @Override
    public LlmResponseDto execute(LlmRequestDto llmRequest, AiAgentAppConfigItem config) {
        try {
            LlmResponseDto result = this.doExecute(llmRequest, config);
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.APP_CONFIG.getType(), config.getName(), config.getOrderSort(), result.getResultText(), "");
            return result;
        }
        catch (Exception e) {
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.APP_CONFIG.getType(), config.getName(), config.getOrderSort(), "", e.getMessage());
            throw e;
        }
    }
}

