/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.flowAgent.core.vote;

import com.alibaba.fastjson.JSON;
import com.els.modules.ai.dto.AgentLlmRequestDto;
import com.els.modules.ai.dto.LlmResponseDto;
import com.els.modules.ai.flowAgent.core.AgentStrategyFactory;
import com.els.modules.ai.flowAgent.core.vote.VoteStrategy;
import com.els.modules.ai.flowAgent.entity.AiAgentResultConfigItem;
import com.els.modules.ai.flowAgent.enums.AgentStepType;
import com.els.modules.ai.orderCreation.listener.AgentMqUtil;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractVoteStrategy
implements VoteStrategy,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        AgentStrategyFactory.register(this.type(), this);
    }

    public abstract Map<String, LlmResponseDto> doExecute(AgentLlmRequestDto var1, Map<String, LlmResponseDto> var2, AiAgentResultConfigItem var3);

    @Override
    public Map<String, LlmResponseDto> execute(AgentLlmRequestDto llmRequest, Map<String, LlmResponseDto> responsePojoMap, AiAgentResultConfigItem item) {
        try {
            Map<String, LlmResponseDto> result = this.doExecute(llmRequest, responsePojoMap, item);
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.RESULT_VOTE.getType(), item.getName(), item.getOrderSort(), JSON.toJSONString(result), "");
            return result;
        }
        catch (Exception e) {
            AgentMqUtil.sendItem(llmRequest.getLogHeadId(), llmRequest.getElsAccount(), AgentStepType.RESULT_VOTE.getType(), item.getName(), item.getOrderSort(), JSON.toJSONString(responsePojoMap), e.getMessage());
            throw e;
        }
    }
}

