/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.orderCreation.controller;

import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.ai.core.AiRequestService;
import com.els.modules.ai.orderCreation.dto.AiOrderCreationRequestDto;
import com.els.modules.ai.orderCreation.dto.AiOrderCreationRunDto;
import com.els.modules.ai.orderCreation.dto.AiOrderCreationSessionDto;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"AI\u5927\u6a21\u578b\u5bf9\u8bdd"})
@RestController
@RequestMapping(value={"/ai/aiOrderCreation"})
public class AiOrderCreationChatController {
    private static final Logger log = LoggerFactory.getLogger(AiOrderCreationChatController.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AiRequestService aiRequestService;
    private static final String AI_ORDER_CREATION_EXEC = "srm:ai_order_creation:exec";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @PostMapping(value={"/chat"})
    public Result<?> query(@RequestBody AiOrderCreationRequestDto requestDTO) throws Exception {
        AiOrderCreationSessionDto aiSession = this.aiRequestService.runAiOrderCreationChat(requestDTO);
        return Result.ok((Object)aiSession);
    }

    @PostMapping(value={"/runOrView"})
    public Result<?> runOrView(@RequestBody AiOrderCreationRunDto runDTO) throws Exception {
        String redisKey = runDTO.getAiSessionId();
        if (!this.redisUtil.tryGetDistributedLock(AI_ORDER_CREATION_EXEC, redisKey, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFiKRcsSTVBtk_2ef68e36", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            AiOrderCreationRunDto aiOrderCreationRunDTO = this.aiRequestService.execAiOrderCreation(runDTO);
            Result result = Result.ok((Object)aiOrderCreationRunDTO);
            return result;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(AI_ORDER_CREATION_EXEC, redisKey);
        }
    }
}

