/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.orderCreation.modelStrategy;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.ai.core.AiChatExtractor;
import com.els.modules.ai.core.AiQuestion;
import com.els.modules.ai.core.helper.AiChatResponseHelper;
import com.els.modules.ai.core.modelStrategy.SimpleAiLogicRunStrategy;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.dto.AiChatAppDto;
import com.els.modules.ai.dto.AiChatDto;
import com.els.modules.ai.dto.AiChatExamplarDto;
import com.els.modules.ai.dto.LlmRequestDto;
import com.els.modules.ai.dto.LlmResponseDto;
import com.els.modules.ai.dto.QuestionInfoDto;
import com.google.common.collect.Lists;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.service.AiServices;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class OrderCreationAiLogicRunStrategy
extends SimpleAiLogicRunStrategy
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(OrderCreationAiLogicRunStrategy.class);
    public static final String INSTRUCTION = "#\u89d2\u8272: \u8bf7\u4f5c\u4e3a\u81ea\u7136\u8bed\u8a00\u5206\u6790\u4e13\u5bb6\uff0c\u6309\u4ee5\u4e0b\u6b65\u9aa4\u5904\u7406\u5904\u7406\u5206\u6790\u6211\u8f93\u5165\u7684\u95ee\u9898\uff0c\u8fd4\u56de\u89e3\u6790\u7ed3\u679c\u3002\n1. \u6570\u636e\u6a21\u578b\u5bf9\u7167\uff1a\u4f7f\u7528\u63d0\u4f9b\u7684 questionSchema\uff08\u5b57\u6bb5\u89c4\u8303\uff09\uff0c\u7f16\u7801\uff08fieldCode\uff09\u3001\u540d\u79f0\uff08fieldName\uff09\u3001\u522b\u540d\uff08fieldAlias\uff09\u7b49\u3002\n2. \u751f\u6210JSON\uff1a\u6839\u636e\u5f53\u524d\u95ee\u9898\uff0c\u6309 questionSchema \u8fd4\u56de JSON\uff0ckey \u5fc5\u987b\u4e3afieldCode\uff08\u5339\u914d\u5230fieldName\u6216fieldAlias\uff0c\u6700\u7ec8\u7528\u7f16\u7801\uff09\u3002\n3. \u591a\u503c\u5904\u7406\uff1a\u540c\u4e00\u6761\u4ef6\u591a\u4e2a\u503c\u65f6\u7528\u9017\u53f7\uff08,\uff09\u62fc\u63a5\uff08\u5982 value1,value2\uff09\u3002\n4. \u65e5\u671f\u683c\u5f0f\uff1a\u65e5\u671f\u5b57\u6bb5\u6309 YYYY-MM-DD \u683c\u5f0f\u586b\u5145\uff08\u5982 2025-05-12\uff09\u3002\n5. \u5b57\u6bb5\u7ea6\u675f\uff1aJSON \u7684 key \u5fc5\u987b\u5168\u90e8\u5b58\u5728\u4e8e questionSchema \u7684 fieldCode \u4e2d\uff0c\u7981\u6b62\u65b0\u589e\u672a\u5b9a\u4e49\u5b57\u6bb5\u3002\uff1b\n6. \u5339\u914d\u7ea6\u675f\uff1a\u5982\u679c\u7528\u6237\u8f93\u5165\u7684\u95ee\u9898\u5b57\u6bb5\u5728questionSchema\u4e2d\u6ca1\u80fd\u7b49\u503c\u5339\u914d\uff0c\u76f4\u63a5\u5ffd\u7565\u8be5\u5b57\u6bb5\uff0c\u7981\u6b62\u5728JSON\u7ed3\u679c\u4e2d(\u4f8b\u5b50:\u6bd4\u5982\u5b57\u6bb5\u548c\u522b\u540d\u90fd\u4e0d\u5339\u914d\u7684\u524d\u63d0\u4e0b\uff0c[\u5355\u53f7]\u4e0d\u80fd\u5339\u914d\u4e3a[\u8ba2\u5355\u53f7])\u3002\n7. \u5386\u53f2\u4fe1\u606f\uff1a\u82e5\u63d0\u4f9b lastQuestion \u548c lastQueryResult\uff0c\u9700\u7ed3\u5408\u4e24\u8005\u5206\u6790\uff0c\u66f4\u65b0\u5f53\u524d\u89e3\u6790\u7ed3\u679c\uff0c\u5bf9\u8bdd\u4e2d\u6839\u636e\u5386\u53f2\u7684\u8bb0\u5f55\u5bf9\u6bd4\uff0c\u5982\u679c\u6ca1\u63d0\u5230\u8981\u4f60\u53d8\u66f4\u7684\u5b57\u6bb5\uff0c\u9700\u8981\u4fdd\u7559\u4e0a\u4e00\u6b21\u4f1a\u8bdd\u7684\u7ed3\u679c\u3002\n8. \u8f85\u52a9\u4fe1\u606f\uff1a\u53c2\u8003 questionSchemaSideInfo\uff08\u5b57\u6bb5\u989d\u5916\u8bf4\u660e\uff09\u3001SideInfo\uff08\u62d3\u5c55\u4fe1\u606f\uff09\u53ca\u6837\u4f8b\uff08Exemplars\uff09\u8f85\u52a9\u8f6c\u6362\u3002\n9. \u7981\u6b62\uff1a\u7981\u6b62\u8fd4\u56de\u4efb\u4f55\u95ee\u9898\u4e2d\u6ca1\u63d0\u5230\u6216\u8005\u65e0\u5173\u7684\u5185\u5bb9\uff0c\u4e25\u683c\u5339\u914d\u5b57\u6bb5\u540d\u6216\u522b\u540d\u3001\u6ca1\u5339\u914d\u5230\u7684\u5b57\u6bb5\u76f4\u63a5\u4e22\u5f03\uff0c\u7981\u6b62\u51ed\u7a7a\u634f\u9020\u5185\u5bb9\uff0c\u5982\u679c\u6ca1\u6709\u9644\u52a0\u8bf4\u660e\u7684\uff0c\u7981\u6b62\u81ea\u52a8\u586b\u5145\u503c\u3002\n\n#Exemplars: {{exemplar}}\n\n#Query:\nQuestion: {{question}} \nquestionSchema: {{questionSchema}} \n \n#lastQuery:\nlastQuestion:{{lastQuestion}}\nlastQueryResult:{{lastQueryResult}}\n\n#additional\nquestionSchemaSideInfo:{{questionSchemaSideInfo}}\nSideInfo: {{information}} ";

    @Override
    public String modelRunStrategy() {
        return "orderCreationAiLogicRunStrategy";
    }

    @Override
    public LlmResponseDto generate(LlmRequestDto llmRequest) {
        LlmResponseDto llmResponse = new LlmResponseDto();
        AiChatDto chatChatConfig = llmRequest.getAiChatPojo();
        AiChatAppDto chatAppConfig = llmRequest.getAiChatAppPojo();
        QuestionInfoDto question = chatChatConfig.getQuestion();
        String questionText = CharSequenceUtil.isEmpty((CharSequence)question.getQuestion()) ? chatAppConfig.getQuestion() : question.getQuestion();
        llmResponse.setQuestion(questionText);
        List<List<AiChatExamplarDto>> exemplarsList = this.promptHelper.getFewShotExemplars(llmRequest);
        AiChatAppDto chatApp = llmRequest.getAiChatAppPojo();
        if (StringUtils.isEmpty((CharSequence)chatApp.getPromptTemplate())) {
            chatApp.setPromptTemplate(this.getInstruction());
        }
        ChatLanguageModel chatLanguageModel = this.getChatLanguageModel(chatApp.getAiChatModelConfigPojo());
        AiChatExtractor extractor = (AiChatExtractor)AiServices.create(AiChatExtractor.class, (ChatLanguageModel)chatLanguageModel);
        HashMap<Prompt, List<AiChatExamplarDto>> prompt2Exemplar = new HashMap<Prompt, List<AiChatExamplarDto>>();
        for (List<AiChatExamplarDto> exemplars : exemplarsList) {
            llmRequest.setChatExamplers(exemplars);
            Prompt prompt2 = this.generatePrompt(llmRequest, llmResponse, chatApp);
            prompt2Exemplar.put(prompt2, exemplars);
        }
        ConcurrentHashMap output2Prompt = new ConcurrentHashMap();
        ConcurrentHashMap thoughtMap = new ConcurrentHashMap();
        prompt2Exemplar.keySet().parallelStream().forEach(prompt -> {
            llmResponse.setQuestionInput(prompt.toUserMessage().singleText());
            AiQuestion answer = extractor.generateResult(prompt.toUserMessage().singleText());
            output2Prompt.put(answer.getResultText(), prompt);
            thoughtMap.put(answer.getResultText(), answer.getThought());
        });
        AiChatResponseHelper responseHelper = AiBeanFactory.getAiChatResponseHelper(chatAppConfig.getModelRunResponseHelper());
        Pair<String, Map<String, Double>> sqlMapPair = responseHelper.selfConsistencyVote(Lists.newArrayList(output2Prompt.keySet()));
        llmResponse.setResultText((String)sqlMapPair.getLeft());
        llmResponse.setThought((String)thoughtMap.get(sqlMapPair.getLeft()));
        return llmResponse;
    }

    @Override
    public String getInstruction() {
        return INSTRUCTION;
    }
}

