/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.auth.authorization.service;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.service.UserService;
import com.tencent.supersonic.auth.api.authorization.pojo.AuthGroup;
import com.tencent.supersonic.auth.api.authorization.pojo.AuthRes;
import com.tencent.supersonic.auth.api.authorization.pojo.AuthResGrp;
import com.tencent.supersonic.auth.api.authorization.pojo.DimensionFilter;
import com.tencent.supersonic.auth.api.authorization.request.QueryAuthResReq;
import com.tencent.supersonic.auth.api.authorization.response.AuthorizedResourceResp;
import com.tencent.supersonic.auth.api.authorization.service.AuthService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private JdbcTemplate jdbcTemplate;
    private UserService userService;

    public AuthServiceImpl(JdbcTemplate jdbcTemplate, UserService userService) {
        this.jdbcTemplate = jdbcTemplate;
        this.userService = userService;
    }

    private List<AuthGroup> load() {
        List rows = this.jdbcTemplate.queryForList("select config from s2_auth_groups", String.class);
        Gson g = new Gson();
        return rows.stream().map(row -> (AuthGroup)g.fromJson(row, AuthGroup.class)).collect(Collectors.toList());
    }

    public List<AuthGroup> queryAuthGroups(String modelId, Integer groupId) {
        return this.load().stream().filter(group -> (Objects.isNull(groupId) || groupId.equals(group.getGroupId())) && modelId.equals(group.getModelId().toString())).collect(Collectors.toList());
    }

    public void addOrUpdateAuthGroup(AuthGroup group) {
        Gson g = new Gson();
        if (group.getGroupId() == null) {
            int nextGroupId = 1;
            String sql = "select max(group_id) as group_id from s2_auth_groups";
            Integer obj = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
            if (obj != null) {
                nextGroupId = obj + 1;
            }
            group.setGroupId(Integer.valueOf(nextGroupId));
            this.jdbcTemplate.update("insert into s2_auth_groups (group_id, config) values (?, ?);", new Object[]{nextGroupId, g.toJson((Object)group)});
        } else {
            this.jdbcTemplate.update("update s2_auth_groups set config = ? where group_id = ?;", new Object[]{g.toJson((Object)group), group.getGroupId()});
        }
    }

    public void removeAuthGroup(AuthGroup group) {
        this.jdbcTemplate.update("delete from s2_auth_groups where group_id = ?", new Object[]{group.getGroupId()});
    }

    public AuthorizedResourceResp queryAuthorizedResources(QueryAuthResReq req, User user) {
        Set userOrgIds = this.userService.getUserAllOrgId(user.getName());
        List<AuthGroup> groups = this.getAuthGroups(req.getModelIds(), user.getName(), new ArrayList<String>(userOrgIds));
        AuthorizedResourceResp resource = new AuthorizedResourceResp();
        Map<Long, List<AuthGroup>> authGroupsByModelId = groups.stream().collect(Collectors.groupingBy(AuthGroup::getModelId));
        Map<Long, List<AuthRes>> reqAuthRes = req.getResources().stream().collect(Collectors.groupingBy(AuthRes::getModelId));
        for (Long modelId : reqAuthRes.keySet()) {
            List<AuthRes> reqResourcesList = reqAuthRes.get(modelId);
            AuthResGrp rg = new AuthResGrp();
            if (authGroupsByModelId.containsKey(modelId)) {
                List<AuthGroup> authGroups = authGroupsByModelId.get(modelId);
                for (AuthRes reqRes : reqResourcesList) {
                    for (AuthGroup authRuleGroup : authGroups) {
                        List authRules = authRuleGroup.getAuthRules();
                        ArrayList allAuthItems = new ArrayList();
                        authRules.forEach(authRule -> allAuthItems.addAll(authRule.resourceNames()));
                        if (!allAuthItems.contains(reqRes.getName())) continue;
                        rg.getGroup().add(reqRes);
                    }
                }
            }
            if (CollectionUtils.isEmpty((Collection)rg.getGroup())) continue;
            resource.getResources().add(rg);
        }
        if (!CollectionUtils.isEmpty((Collection)req.getModelIds())) {
            ArrayList authGroups = Lists.newArrayList();
            for (Long modelId : authGroupsByModelId.keySet()) {
                authGroups.addAll((Collection)authGroupsByModelId.getOrDefault(modelId, Lists.newArrayList()));
            }
            if (!CollectionUtils.isEmpty((Collection)authGroups)) {
                for (AuthGroup group : authGroups) {
                    if (group.getDimensionFilters() == null || !group.getDimensionFilters().stream().anyMatch(expr -> !StringUtils.isEmpty((CharSequence)expr))) continue;
                    DimensionFilter df = new DimensionFilter();
                    df.setDescription(group.getDimensionFilterDescription());
                    df.setExpressions(group.getDimensionFilters());
                    resource.getFilters().add(df);
                }
            }
        }
        return resource;
    }

    private List<AuthGroup> getAuthGroups(List<Long> modelIds, String userName, List<String> departmentIds) {
        List<AuthGroup> groups = this.load().stream().filter(group -> {
            if (CollectionUtils.isEmpty((Collection)modelIds) || !modelIds.contains(group.getModelId())) {
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)group.getAuthorizedUsers()) && group.getAuthorizedUsers().contains(userName)) {
                return true;
            }
            for (String departmentId : departmentIds) {
                if (CollectionUtils.isEmpty((Collection)group.getAuthorizedDepartmentIds()) || !group.getAuthorizedDepartmentIds().contains(departmentId)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        log.info("user:{} department:{} authGroups:{}", new Object[]{userName, departmentIds, groups});
        return groups;
    }
}

