/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.auth.authorization.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.auth.api.authorization.pojo.AuthGroup;
import com.tencent.supersonic.auth.api.authorization.request.QueryAuthResReq;
import com.tencent.supersonic.auth.api.authorization.response.AuthorizedResourceResp;
import com.tencent.supersonic.auth.api.authorization.service.AuthService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    private final AuthService authService;

    public AuthController(AuthService authService) {
        this.authService = authService;
    }

    @GetMapping(value={"/queryGroup"})
    public List<AuthGroup> queryAuthGroup(@RequestParam(value="modelId") String modelId, @RequestParam(value="groupId", required=false) Integer groupId) {
        return this.authService.queryAuthGroups(modelId, groupId);
    }

    @PostMapping(value={"/createGroup"})
    public void newAuthGroup(@RequestBody AuthGroup group) {
        group.setGroupId(null);
        this.authService.addOrUpdateAuthGroup(group);
    }

    @PostMapping(value={"/removeGroup"})
    public void removeAuthGroup(@RequestBody AuthGroup group) {
        this.authService.removeAuthGroup(group);
    }

    @PostMapping(value={"/updateGroup"})
    public void updateAuthGroup(@RequestBody AuthGroup group) {
        if (group.getGroupId() == null || group.getGroupId() == 0) {
            throw new RuntimeException("groupId is empty");
        }
        this.authService.addOrUpdateAuthGroup(group);
    }

    @PostMapping(value={"/queryAuthorizedRes"})
    public AuthorizedResourceResp queryAuthorizedResources(@RequestBody QueryAuthResReq req, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.authService.queryAuthorizedResources(req, user);
    }
}

