/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.auth.authorization.service;

import com.google.gson.Gson;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.service.UserService;
import com.tencent.supersonic.auth.api.authorization.pojo.AuthGroup;
import com.tencent.supersonic.auth.api.authorization.pojo.AuthRes;
import com.tencent.supersonic.auth.api.authorization.pojo.AuthRule;
import com.tencent.supersonic.auth.api.authorization.pojo.DimensionFilter;
import com.tencent.supersonic.auth.api.authorization.request.QueryAuthResReq;
import com.tencent.supersonic.auth.api.authorization.response.AuthorizedResourceResp;
import com.tencent.supersonic.auth.api.authorization.service.AuthService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private JdbcTemplate jdbcTemplate;
    private UserService userService;

    public AuthServiceImpl(JdbcTemplate jdbcTemplate, UserService userService) {
        this.jdbcTemplate = jdbcTemplate;
        this.userService = userService;
    }

    private List<AuthGroup> load() {
        List rows = this.jdbcTemplate.queryForList("select config from s2_auth_groups", String.class);
        Gson g = new Gson();
        return rows.stream().map(row -> (AuthGroup)g.fromJson(row, AuthGroup.class)).collect(Collectors.toList());
    }

    public List<AuthGroup> queryAuthGroups(String modelId, Integer groupId) {
        return this.load().stream().filter(group -> (Objects.isNull(groupId) || groupId.equals(group.getGroupId())) && modelId.equals(group.getModelId().toString())).collect(Collectors.toList());
    }

    public void addOrUpdateAuthGroup(AuthGroup group) {
        Gson g = new Gson();
        if (group.getGroupId() == null) {
            int nextGroupId = 1;
            String sql = "select max(group_id) as group_id from s2_auth_groups";
            Integer obj = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
            if (obj != null) {
                nextGroupId = obj + 1;
            }
            group.setGroupId(Integer.valueOf(nextGroupId));
            this.jdbcTemplate.update("insert into s2_auth_groups (group_id, config) values (?, ?);", new Object[]{nextGroupId, g.toJson((Object)group)});
        } else {
            this.jdbcTemplate.update("update s2_auth_groups set config = ? where group_id = ?;", new Object[]{g.toJson((Object)group), group.getGroupId()});
        }
    }

    public void removeAuthGroup(AuthGroup group) {
        this.jdbcTemplate.update("delete from s2_auth_groups where group_id = ?", new Object[]{group.getGroupId()});
    }

    public AuthorizedResourceResp queryAuthorizedResources(QueryAuthResReq req, User user) {
        if (CollectionUtils.isEmpty((Collection)req.getModelIds())) {
            return new AuthorizedResourceResp();
        }
        Set userOrgIds = this.userService.getUserAllOrgId(user.getName());
        List<AuthGroup> groups = this.getAuthGroups(req.getModelIds(), user.getName(), new ArrayList<String>(userOrgIds));
        AuthorizedResourceResp resource = new AuthorizedResourceResp();
        Map<Long, List<AuthGroup>> authGroupsByModelId = groups.stream().collect(Collectors.groupingBy(AuthGroup::getModelId));
        for (Long modelId : req.getModelIds()) {
            if (!authGroupsByModelId.containsKey(modelId)) continue;
            List<AuthGroup> authGroups = authGroupsByModelId.get(modelId);
            for (AuthGroup authRuleGroup : authGroups) {
                List authRules = authRuleGroup.getAuthRules();
                for (AuthRule authRule : authRules) {
                    for (String resBizName : authRule.resourceNames()) {
                        resource.getAuthResList().add(new AuthRes(modelId, resBizName));
                    }
                }
            }
        }
        Set<Map.Entry<Long, List<AuthGroup>>> entries = authGroupsByModelId.entrySet();
        for (Map.Entry<Long, List<AuthGroup>> entry : entries) {
            List<AuthGroup> authGroups = entry.getValue();
            for (AuthGroup authGroup : authGroups) {
                DimensionFilter df = new DimensionFilter();
                df.setDescription(authGroup.getDimensionFilterDescription());
                df.setExpressions(authGroup.getDimensionFilters());
                resource.getFilters().add(df);
            }
        }
        return resource;
    }

    private List<AuthGroup> getAuthGroups(List<Long> modelIds, String userName, List<String> departmentIds) {
        List<AuthGroup> groups = this.load().stream().filter(group -> {
            if (!modelIds.contains(group.getModelId())) {
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)group.getAuthorizedUsers()) && group.getAuthorizedUsers().contains(userName)) {
                return true;
            }
            for (String departmentId : departmentIds) {
                if (CollectionUtils.isEmpty((Collection)group.getAuthorizedDepartmentIds()) || !group.getAuthorizedDepartmentIds().contains(departmentId)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        log.info("user:{} department:{} authGroups:{}", new Object[]{userName, departmentIds, groups});
        return groups;
    }
}

