/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.aop.interceptor;

import cn.hutool.core.util.ObjectUtil;
import com.qqt.platform.common.dto.DataOperateLogDTO;
import com.qqt.platform.common.security.SecurityUtils;
import com.qqt.platform.common.service.SessionService;
import java.io.Serializable;
import java.util.Optional;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteInterceptor
extends EmptyInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DeleteInterceptor.class);
    @Autowired
    private SessionService sessionService;

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        log.debug("\u8fdb\u5165\u62e6\u622a\u5668:{},{},{},{},{}", new Object[]{entity.getClass().getName(), id, state, propertyNames, types});
        this.sendLogMessage("delete", id, entity);
    }

    public void onCollectionRemove(Object collection, Serializable key) throws CallbackException {
        log.debug("\u8fdb\u5165\u62e6\u622a\u5668:{},{}", collection, (Object)key);
        this.sendLogMessage("delete", key, collection);
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        log.debug("\u8fdb\u5165\u62e6\u622a\u5668:{},{},{},{},{}", new Object[]{entity.getClass().getName(), id, state, propertyNames, types});
        String operateType = null == id ? "save" : "update";
        this.sendLogMessage(operateType, id, entity);
        return false;
    }

    private void sendLogMessage(String operateType, Serializable id, Object entity) {
        try {
            DataOperateLogDTO logDTO = new DataOperateLogDTO();
            if (null != entity) {
                logDTO.setEntityName(entity.getClass().getSimpleName());
            }
            logDTO.setEntityId(id);
            logDTO.setOperateType(operateType);
            if (ObjectUtil.isNotEmpty((Object)this.sessionService)) {
                Long userId = this.sessionService.getCurrentUserId();
                String login = this.sessionService.getCurrentUserName();
                Optional<String> loginOptional = SecurityUtils.getCurrentUserLogin();
                if (loginOptional.isPresent()) {
                    login = loginOptional.get();
                }
                String elsAccount = this.sessionService.getElsAccount();
                String companyName = this.sessionService.getCurrentCompanyName();
                Long companyId = this.sessionService.getCompanyId();
                String siteCode = this.sessionService.getCurrentSiteCode();
                logDTO.setLogin(login);
                logDTO.setUserId(userId);
                logDTO.setSiteCode(siteCode);
                logDTO.setElsAccount(elsAccount);
                logDTO.setCompanyName(companyName);
                logDTO.setCompanyId(companyId);
            }
        }
        catch (Exception e) {
            log.error("Save dataOperationLog error:{}", (Throwable)e);
        }
    }
}

