/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.aop.interceptor;

import com.qqt.platform.common.dto.DataPermissionConfigDO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.service.SessionService;
import com.qqt.platform.common.utils.ThreadLocalUtil;
import io.github.jhipster.service.Criteria;
import io.github.jhipster.service.filter.LongFilter;
import io.github.jhipster.service.filter.StringFilter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;

public class SpecificationAspect {
    private final Logger log = LoggerFactory.getLogger(SpecificationAspect.class);
    @Autowired
    private SessionService sessionService;
    @Autowired
    private AdminFeignService adminFeignService;

    @Pointcut(value="within(@org.springframework.web.bind.annotation.RestController *)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object doAroundAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        Field[] fields;
        Class[] par;
        String methodName = joinPoint.getSignature().getName();
        this.log.info("\u76ee\u6807\u65b9\u6cd5\u540d\uff1a{}", (Object)methodName);
        MethodInvocationProceedingJoinPoint pjp = (MethodInvocationProceedingJoinPoint)joinPoint;
        Object[] args = pjp.getArgs();
        if ("getDataPermissionByUser".equals(methodName)) {
            return pjp.proceed(args);
        }
        if (args.length == 0) {
            return pjp.proceed(args);
        }
        Long userId = this.sessionService.getCurrentUserId();
        if (null == userId) {
            return pjp.proceed(args);
        }
        boolean isAnonymous = this.sessionService.getAnonymous();
        if (isAnonymous) {
            return pjp.proceed(args);
        }
        Class<?> classTarget = joinPoint.getTarget().getClass();
        Method objMethod = classTarget.getDeclaredMethod(methodName, par = ((MethodSignature)pjp.getSignature()).getParameterTypes());
        GetMapping annotation = objMethod.getAnnotation(GetMapping.class);
        if (null == annotation) {
            return pjp.proceed(args);
        }
        Criteria criteria = null;
        Class<?> clazz = null;
        int idx = 0;
        for (Object arg : args) {
            if (arg instanceof Criteria) {
                criteria = (Criteria)arg;
                clazz = arg.getClass();
                break;
            }
            ++idx;
        }
        if (null == criteria) {
            return pjp.proceed(args);
        }
        ResponseEntity<List<DataPermissionConfigDO>> responseEntity = this.adminFeignService.getDataPermissionByUser(userId, clazz.getSimpleName());
        if (!responseEntity.hasBody() || CollectionUtils.isEmpty((Collection)((Collection)responseEntity.getBody()))) {
            return pjp.proceed(args);
        }
        List permissions = (List)responseEntity.getBody();
        Map<String, String> stringMap = permissions.stream().collect(Collectors.toMap(DataPermissionConfigDO::getFilter, DataPermissionConfigDO::getTarget));
        ThreadLocalUtil.put("dataPermission", stringMap);
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name = field.getName();
            if (!stringMap.containsKey(name)) continue;
            String m = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
            Class<?> type = field.getType();
            String target = stringMap.get(name);
            try {
                Object[] params;
                Object var;
                Method method = clazz.getMethod(m, type);
                if (type.getSimpleName().equals("LongFilter")) {
                    var = userId;
                    if (target.equals("companyId")) {
                        boolean isPlatform = this.sessionService.isPlatform();
                        var = !isPlatform ? this.sessionService.getCompanyId() : null;
                    } else if (target.equals("userId")) {
                        var = this.sessionService.getCurrentUserId();
                    } else if (target.equals("subCompanyId")) {
                        var = this.sessionService.getSubCompanyId();
                    }
                    if (null == var) continue;
                    LongFilter longFilter = new LongFilter();
                    longFilter.setEquals(var);
                    params = new Object[]{longFilter};
                    method.invoke((Object)criteria, params);
                    continue;
                }
                if (!type.getSimpleName().equals("StringFilter")) continue;
                var = this.sessionService.getElsAccount();
                if (target.equals("subCompanyCode")) {
                    var = this.sessionService.getSubCompanyCode();
                } else if (target.equals("createdBy")) {
                    var = this.sessionService.getCurrentUserId() + "";
                } else {
                    boolean isPlatform = this.sessionService.isPlatform();
                    if (isPlatform) {
                        var = null;
                    }
                }
                if (null == var) continue;
                StringFilter stringFilter = new StringFilter();
                stringFilter.setEquals(var);
                params = new Object[]{stringFilter};
                method.invoke((Object)criteria, params);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        args[idx] = criteria;
        return pjp.proceed(args);
    }
}

