/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.client;

import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.common.context.TenantElsAccountContextHolder;
import com.qqt.platform.common.multitenant.enums.PlatformDataSourceKeyword;
import com.qqt.platform.common.multitenant.enums.TenantDataSourceKeyword;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import com.qqt.platform.common.security.SecurityUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class CommonFeignClientInterceptor
implements RequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(CommonFeignClientInterceptor.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";

    public void apply(RequestTemplate template) {
        block15: {
            String url = template.path();
            String elsAccount = TenantElsAccountContextHolder.getElsAccount();
            if (!StringUtils.isEmpty((Object)elsAccount)) {
                template.header("Tenant-Els-Account", new String[]{elsAccount});
            } else {
                String datasourceKey = DynamicDataSourceContextHolder.getDataSourceKey();
                elsAccount = TenantDataSourceKeyword.TENANT.parseEls(datasourceKey);
                if (elsAccount != null && !elsAccount.equalsIgnoreCase(PlatformDataSourceKeyword.PLATFORM.getKey())) {
                    template.header("Tenant-Els-Account", new String[]{elsAccount});
                }
            }
            Optional<String> optional = SecurityUtils.getCurrentUserJWT();
            if (optional.isPresent()) {
                template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER, optional.get())});
                if (this.log.isDebugEnabled()) {
                    this.log.debug("feign url : {}, session token: {}", (Object)url, (Object)true);
                }
            } else {
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (attributes != null) {
                    HttpServletRequest request = attributes.getRequest();
                    String token = request.getHeader(AUTHORIZATION_HEADER);
                    template.header(AUTHORIZATION_HEADER, new String[]{token});
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("feign url : {}, header token: {}", (Object)url, (Object)true);
                    }
                } else {
                    String requestBody = template.requestBody().asString();
                    if (!StringUtils.isEmpty((Object)requestBody)) {
                        try {
                            JSONObject json;
                            String token;
                            Object object = JSONObject.parse((String)requestBody);
                            if (!(object instanceof JSONObject) || StringUtils.isEmpty((Object)(token = (json = (JSONObject)object).getString("token")))) break block15;
                            template.header(AUTHORIZATION_HEADER, new String[]{token});
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("feign url : {}, body token: {}", (Object)url, (Object)true);
                            }
                        }
                        catch (Exception exception) {}
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("feign url : {}, no token", (Object)url);
                    }
                }
            }
        }
    }
}

