/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.qqt.platform.common.config.InstantDeserializer;
import com.qqt.platform.common.utils.DateUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public class JacksonConfiguration_copy {
    @Value(value="${spring.jackson.date-format}")
    private String formatValue;

    @Bean(name={"format"})
    DateTimeFormatter format() {
        return DateTimeFormatter.ofPattern(this.formatValue);
    }

    @Bean
    public ObjectMapper serializingObjectMapper(@Qualifier(value="format") DateTimeFormatter format) {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(format));
        javaTimeModule.addSerializer(Instant.class, (JsonSerializer)new InstantCustomSerializer(format));
        javaTimeModule.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer(DateUtil.DATETIME_FORMAT.withZone(ZoneId.systemDefault())));
        javaTimeModule.addSerializer(Date.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(false), (DateFormat)new SimpleDateFormat(this.formatValue)));
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).setLocale(Locale.CHINA).setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault())).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA)).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)javaTimeModule);
        return mapper;
    }

    class InstantCustomSerializer
    extends JsonSerializer<Instant> {
        private DateTimeFormatter format;

        private InstantCustomSerializer(DateTimeFormatter formatter) {
            this.format = formatter;
        }

        public void serialize(Instant instant, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (instant == null) {
                return;
            }
            String jsonValue = this.format.format(instant.atZone(ZoneId.systemDefault()));
            jsonGenerator.writeString(jsonValue);
        }
    }
}

