/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.domain;

import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.utils.ThreadLocalUtil;
import java.lang.reflect.Field;
import java.time.Instant;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataBaseAuditListener {
    private static final Logger log = LoggerFactory.getLogger(DataBaseAuditListener.class);
    @Autowired
    private AdminFeignService adminFeignService;

    @PrePersist
    public void prePersist(Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> aClass = object.getClass().getSuperclass();
        try {
            Object userId;
            Field createdBy = aClass.getDeclaredField("createdBy");
            createdBy.setAccessible(true);
            Object createdByValue = createdBy.get(object);
            if (createdByValue == null && (userId = ThreadLocalUtil.get("userId")) != null) {
                createdBy.set(object, (String)userId);
            }
            Field createdDate = aClass.getDeclaredField("createdDate");
            createdDate.setAccessible(true);
            Object createdDateValue = createdDate.get(object);
            if (createdDateValue == null) {
                createdDate.set(object, Instant.now());
            }
        }
        catch (NoSuchFieldException e) {
            log.error("\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @PreUpdate
    public void PreUpdate(Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> aClass = object.getClass().getSuperclass();
        try {
            Object userId;
            Field lastModifiedBy = aClass.getDeclaredField("lastModifiedBy");
            lastModifiedBy.setAccessible(true);
            Object lastModifiedByValue = lastModifiedBy.get(object);
            if (lastModifiedByValue == null && (userId = ThreadLocalUtil.get("userId")) != null) {
                lastModifiedBy.set(object, (String)userId);
            }
            Field lastModifiedDate = aClass.getDeclaredField("lastModifiedDate");
            lastModifiedDate.setAccessible(true);
            Object lastModifiedDateValue = lastModifiedDate.get(object);
            if (lastModifiedDateValue == null) {
                lastModifiedDate.set(object, Instant.now());
            }
        }
        catch (NoSuchFieldException e) {
            log.error("\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @PostPersist
    public void postPersist(Object object) throws IllegalArgumentException, IllegalAccessException {
    }

    @PostUpdate
    public void postUpdate(Object object) throws IllegalArgumentException, IllegalAccessException {
    }
}

