/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.dto;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProductGroupVisibleDO
implements Serializable {
    public static final String NOT_CHECK = "NOT_CHECK";
    public static final String NO_RELATION = "NO_RELATION";
    public static final String NO_SALEORG = "NO_SALEORG";
    public static final String SPECIFIED_PRODUCTGROUP = "SPECIFIED_PRODUCTGROUP";
    private Long storeId;
    private String status;
    private Map<Long, Set<Long>> saleOrgProductGroupMap;

    public static ProductGroupVisibleDO of(String status) {
        ProductGroupVisibleDO productGroupVisibleDO = new ProductGroupVisibleDO();
        productGroupVisibleDO.setStatus(status);
        return productGroupVisibleDO;
    }

    public static ProductGroupVisibleDO of(String status, Map<Long, Set<Long>> saleOrgProductGroupMap) {
        ProductGroupVisibleDO productGroupVisibleDO = new ProductGroupVisibleDO();
        productGroupVisibleDO.setStatus(status);
        productGroupVisibleDO.setSaleOrgProductGroupMap(saleOrgProductGroupMap);
        return productGroupVisibleDO;
    }

    private ProductGroupVisibleDO() {
    }

    public Long getStoreId() {
        return this.storeId;
    }

    public ProductGroupVisibleDO setStoreId(Long storeId) {
        this.storeId = storeId;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Map<Long, Set<Long>> getSaleOrgProductGroupMap() {
        return this.saleOrgProductGroupMap;
    }

    public void setSaleOrgProductGroupMap(Map<Long, Set<Long>> saleOrgProductGroupMap) {
        this.saleOrgProductGroupMap = saleOrgProductGroupMap;
    }

    public boolean canBuy(Long productGroupId) {
        if (NO_RELATION.equals(this.status) || NO_SALEORG.equals(this.status)) {
            return false;
        }
        if (NOT_CHECK.equals(this.status)) {
            return true;
        }
        if (SPECIFIED_PRODUCTGROUP.equals(this.status) && productGroupId != null) {
            return this.saleOrgProductGroupMap.values().stream().flatMap(v -> v.stream()).filter(v -> productGroupId.equals(v)).findAny().isPresent();
        }
        return true;
    }

    public List<Long> getCanBuyProductGroupIds() {
        if (NO_RELATION.equals(this.status) || NO_SALEORG.equals(this.status)) {
            return null;
        }
        if (NOT_CHECK.equals(this.status)) {
            return Collections.emptyList();
        }
        if (SPECIFIED_PRODUCTGROUP.equals(this.status)) {
            return this.saleOrgProductGroupMap.values().stream().flatMap(v -> v.stream()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "ProductGroupVisibleDO{status='" + this.status + '\'' + ", saleOrgProductGroupMap=" + this.saleOrgProductGroupMap + '}';
    }
}

