/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.dto.pingan.wrap;

import com.qqt.platform.common.dto.pingan.ApntTransferRequest;
import com.qqt.platform.common.dto.pingan.ApntTransferResponse;
import com.qqt.platform.common.dto.pingan.PingAnResponseBody;
import com.qqt.platform.common.dto.pingan.wrap.AbstractWrapper;
import com.qqt.platform.common.utils.GsonUtils;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ApntTransferRequestWrapper
extends AbstractWrapper {
    private static final String INTERFACE_ID = "KFEJZB6211";
    private static final String SERVICE_CODE = "/V1.0/ApntTransfer";
    private ApntTransferRequest apntTransferRequest;

    public ApntTransferRequestWrapper(ApntTransferRequest apntTransferRequest) {
        this.apntTransferRequest = apntTransferRequest;
        this.apntTransferRequest.setServiceCode(SERVICE_CODE);
        this.apntTransferRequest.setTxnCode(INTERFACE_ID);
        super.setPingAnRequestBody(apntTransferRequest);
    }

    @Override
    protected AbstractWrapper.BuildResult buildBusinessBody() {
        if (StringUtils.isEmpty((Object)this.apntTransferRequest.getRecvAcctNo())) {
            return new AbstractWrapper.BuildResult(false, "\u53c2\u6570\u975e\u6cd5\uff1arecvAcctNo");
        }
        if (StringUtils.isEmpty((Object)this.apntTransferRequest.getApplyTakeCashAmt())) {
            return new AbstractWrapper.BuildResult(false, "\u53c2\u6570\u975e\u6cd5\uff1aapplyTakeCashAmt");
        }
        if (StringUtils.isEmpty((Object)this.apntTransferRequest.getMarketChargeCommission())) {
            return new AbstractWrapper.BuildResult(false, "\u53c2\u6570\u975e\u6cd5\uff1amarketChargeCommission");
        }
        String jsonData = GsonUtils.toJson(this.apntTransferRequest);
        return new AbstractWrapper.BuildResult(true, jsonData);
    }

    @Override
    public <T> PingAnResponseBody parse(T data) {
        Map resp = (Map)Map.class.cast(data);
        String txnReturnCode = String.format("%s", resp.get("TxnReturnCode"));
        String txnReturnMsg = String.format("%s", resp.get("TxnReturnMsg"));
        ApntTransferResponse result = new ApntTransferResponse();
        result.setTxnReturnCode(txnReturnCode);
        result.setTxnReturnMsg(txnReturnMsg);
        if ("000000".equals(txnReturnCode)) {
            result.setWitnessSysSeqNo(String.format("%s", resp.get("WitnessSysSeqNo")));
            result.setCnsmrSeqNo(String.format("%s", resp.get("CnsmrSeqNo")));
            result.setReservedMsg(String.format("%s", resp.get("ReservedMsg")));
        }
        return result;
    }
}

