/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.mapper;

import com.qqt.platform.common.domain.AbstractCompanyEntity;
import com.qqt.platform.common.domain.IAuditingEntity;
import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.multitenant.redis.template.QQTRedisTemplate;
import com.qqt.platform.common.security.SecurityUtils;
import com.qqt.platform.common.service.dto.AbstractAuditingDTO;
import com.qqt.platform.common.utils.AdminEntityCacheUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.BeforeMapping;
import org.mapstruct.MappingTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AuditingDTOMapper<DTO extends AbstractAuditingDTO, Entity extends IAuditingEntity> {
    private static final Logger logger = LoggerFactory.getLogger(AuditingDTOMapper.class);
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    private AdminEntityCacheUtils adminEntityCacheUtils;
    @Autowired
    private QQTRedisTemplate qqtRedisTemplate;
    private List<String> defaultFields = new ArrayList<String>();

    public abstract Entity toEntity(DTO var1);

    @AfterMapping
    protected void fillAuditing(Entity auditingEntity, @MappingTarget DTO auditingDTO) {
        UserDetailDO userDetailDO;
        String createdBy = auditingEntity.getCreatedBy();
        ((AbstractAuditingDTO)auditingDTO).setCreatedName(createdBy);
        String lastModifiedBy = auditingEntity.getLastModifiedBy();
        ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(lastModifiedBy);
        Boolean lastModifiedSetted = Boolean.FALSE;
        try {
            if (StringUtils.isNumeric((CharSequence)createdBy) && (userDetailDO = this.adminEntityCacheUtils.getUserDO(Long.parseLong(createdBy))) != null) {
                ((AbstractAuditingDTO)auditingDTO).setCreatedName(userDetailDO.getNameCn());
                if (StringUtils.isNumeric((CharSequence)lastModifiedBy) && lastModifiedBy.equals(createdBy)) {
                    ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(userDetailDO.getNameCn());
                    lastModifiedSetted = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            logger.error("getUserDetailByCode CreatedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
        }
        if (!lastModifiedSetted.booleanValue()) {
            try {
                if (StringUtils.isNumeric((CharSequence)lastModifiedBy) && (userDetailDO = this.adminEntityCacheUtils.getUserDO(Long.parseLong(lastModifiedBy))) != null) {
                    ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(userDetailDO.getNameCn());
                }
            }
            catch (Exception e) {
                logger.error("getUserDetailByCode LastModifiedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
            }
        }
        Long companyId = null;
        if (auditingEntity instanceof AbstractCompanyEntity) {
            AbstractCompanyEntity companyEntity = (AbstractCompanyEntity)auditingEntity;
            if (companyEntity.getCompanyId() != null && companyEntity.getCompanyId() > 0L) {
                companyId = companyEntity.getCompanyId();
            }
        } else if (null != ((AbstractAuditingDTO)auditingDTO).getCompanyId()) {
            companyId = ((AbstractAuditingDTO)auditingDTO).getCompanyId();
        }
        if (null != companyId) {
            try {
                CompanyDO companyDO = this.adminEntityCacheUtils.getCompanyDO(companyId);
                if (companyDO != null) {
                    ((AbstractAuditingDTO)auditingDTO).setCompanyId(companyDO.getId());
                    ((AbstractAuditingDTO)auditingDTO).setCompanyCode(companyDO.getCode());
                    ((AbstractAuditingDTO)auditingDTO).setCompanyName(companyDO.getName());
                }
            }
            catch (Exception e) {
                logger.error("getCompanyById error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
            }
        }
    }

    public abstract DTO toDto(Entity var1);

    public abstract List<Entity> toEntity(List<DTO> var1);

    public abstract List<DTO> toDto(List<Entity> var1);

    public abstract List<DTO> toDto(Set<Entity> var1);

    @PostConstruct
    public void init() {
        Field[] fields;
        this.defaultFields.clear();
        for (Field field : fields = AbstractAuditingDTO.class.getDeclaredFields()) {
            this.defaultFields.add(field.getName());
        }
    }

    @BeforeMapping
    public void before(Entity entity) {
        Field[] fields;
        Object object = this.qqtRedisTemplate.opsForValueGet("systemConfig:dataPermission");
        logger.debug("\u662f\u5426\u5f00\u542f\u6570\u636e\u6743\u9650:{}", object);
        if (null == object || !((Boolean)object).booleanValue()) {
            return;
        }
        Optional<String> login = SecurityUtils.getCurrentUserLogin();
        if (!login.isPresent()) {
            return;
        }
        Class<?> clazz = entity.getClass();
        ResultDTO<List<String>> resultDTO = this.adminFeignService.getByEntity(clazz.getSimpleName());
        List<String> accessList = null;
        if (resultDTO != null) {
            accessList = resultDTO.getData();
        }
        if (CollectionUtils.isEmpty(accessList)) {
            return;
        }
        for (Field field : fields = entity.getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            if (this.defaultFields.contains(fieldName) || accessList.contains(fieldName)) continue;
            String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                Class[] types = new Class[]{field.getType()};
                Method method = clazz.getMethod(methodName, types);
                Object[] args = new Object[]{null};
                method.invoke(entity, args);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

