/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.multitenant.async.task;

import com.qqt.platform.common.context.TenantElsAccountContextHolder;
import com.qqt.platform.common.exception.BusinessException;
import com.qqt.platform.common.multitenant.async.task.AsyncTaskCallback;
import com.qqt.platform.common.multitenant.enums.PlatformDataSourceKeyword;
import com.qqt.platform.common.multitenant.enums.TenantDataSourceKeyword;
import com.qqt.platform.common.multitenant.holder.DynamicDataSourceContextHolder;
import java.util.Map;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class AbstractTransactionalAsyncTask
implements AsyncTaskCallback {
    private final Logger log = LoggerFactory.getLogger(AbstractTransactionalAsyncTask.class);
    private final PlatformTransactionManager transactionManager;
    private final String datasourceKey;
    private final EntityManager entityManager;
    private String elsAccount;
    private Map<String, String> mdcMap;

    public AbstractTransactionalAsyncTask(PlatformTransactionManager transactionManager, String datasourceKey, EntityManager entityManager) {
        this(transactionManager, datasourceKey, entityManager, null);
    }

    public AbstractTransactionalAsyncTask(PlatformTransactionManager transactionManager, String datasourceKey, EntityManager entityManager, String elsAccount) {
        this.transactionManager = transactionManager;
        this.datasourceKey = datasourceKey;
        this.entityManager = entityManager;
        this.elsAccount = elsAccount == null ? this.initElsAccount(datasourceKey) : elsAccount;
        this.log.info("\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316els\u4e3a:" + elsAccount);
        try {
            this.mdcMap = MDC.getCopyOfContextMap();
        }
        catch (Exception e) {
            this.log.error("mdc copy error", (Throwable)e);
        }
    }

    protected String initElsAccount(String datasourceKey) {
        String els = TenantElsAccountContextHolder.getElsAccount();
        if (els != null) {
            return els;
        }
        els = TenantDataSourceKeyword.TENANT.parseEls(datasourceKey);
        return els;
    }

    public abstract void doRun() throws Throwable;

    @Override
    public void run() {
        TransactionStatus transactionStatus = this.beginTransaction();
        try {
            this.doRun();
            this.commit(transactionStatus);
        }
        catch (Exception e) {
            this.log.error("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u5931\u8d25, \u56de\u6eda\u4e8b\u52a1", (Throwable)e);
            this.rollback(transactionStatus);
        }
        catch (Throwable throwable) {
            this.log.error("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u4e1a\u52a1\u5931\u8d25, \u56de\u6eda\u4e8b\u52a1", throwable);
            this.rollback(transactionStatus);
        }
        finally {
            this.postTransaction();
        }
    }

    private TransactionStatus beginTransaction() {
        this.switchDataSource();
        if (this.elsAccount != null && !this.elsAccount.equalsIgnoreCase(PlatformDataSourceKeyword.PLATFORM.getKey())) {
            TenantElsAccountContextHolder.setElsAccount(this.elsAccount);
        }
        if (this.mdcMap != null) {
            MDC.setContextMap(this.mdcMap);
        }
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(3);
        definition.setReadOnly(false);
        TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)definition);
        if (Objects.nonNull(this.entityManager)) {
            this.entityManager.joinTransaction();
        }
        return transactionStatus;
    }

    private void commit(TransactionStatus transactionStatus) {
        this.transactionManager.commit(transactionStatus);
    }

    private void rollback(TransactionStatus transactionStatus) {
        this.transactionManager.rollback(transactionStatus);
    }

    private void switchDataSource() {
        if (StringUtils.isBlank((CharSequence)this.datasourceKey)) {
            throw new BusinessException("async task execute fail", "async task execute fail datasourceKey is null");
        }
        DynamicDataSourceContextHolder.clearDataSourceKey();
        DynamicDataSourceContextHolder.setDataSourceKey(this.datasourceKey);
    }

    private void postTransaction() {
        DynamicDataSourceContextHolder.clearDataSourceKey();
        TenantElsAccountContextHolder.removeElsAccount();
    }
}

